/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.util.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScrollableListDialog
extends JDialog {
    private static final int DEFAULT_WIDTH = 400;
    private static final int DEFAULT_HEIGHT = 450;
    private static final double WIDTH_RATIO = 0.75;
    private static final double HEIGHT_RATIO = 0.5;
    protected final JList list;
    static final /* synthetic */ boolean $assertionsDisabled;
    private static final /* synthetic */ Class class$edu$rice$cs$util$swing$ScrollableListDialog;

    public ScrollableListDialog(Frame owner, String dialogTitle, String leaderText, Collection<?> listItems) {
        this(owner, dialogTitle, leaderText, listItems, -1);
    }

    public ScrollableListDialog(Frame owner, String dialogTitle, String leaderText, Collection<?> listItems, int messageType) {
        this(owner, dialogTitle, leaderText, listItems, messageType, 400, 450, null, true);
    }

    public ScrollableListDialog(Frame owner, String dialogTitle, String leaderText, Collection<?> listItems, int messageType, int width, int height, Icon icon) {
        this(owner, dialogTitle, leaderText, listItems, messageType, width, height, icon, false);
    }

    private ScrollableListDialog(Frame owner, String dialogTitle, String leaderText, Collection<?> listItems, int messageType, int width, int height, Icon icon, boolean fitToScreen) {
        super(owner, dialogTitle, true);
        if (!this._isknownMessageType(messageType)) {
            throw new IllegalArgumentException(new StringBuffer().append("The message type \"").append(messageType).append("\" is unknown").toString());
        }
        if (listItems == null) {
            throw new IllegalArgumentException("listItems cannot be null");
        }
        JLabel dialogIconLabel = null;
        if (icon != null) {
            dialogIconLabel = new JLabel(icon);
        } else {
            Icon messageIcon = this._getIcon(messageType);
            if (messageIcon != null) {
                dialogIconLabel = new JLabel(messageIcon);
            }
        }
        JLabel leaderLabel = new JLabel(leaderText);
        JPanel leaderPanel = new JPanel();
        leaderPanel.setLayout(new FlowLayout(0));
        if (dialogIconLabel != null) {
            leaderPanel.add(dialogIconLabel);
        }
        leaderPanel.add(leaderLabel);
        Vector<String> dataAsStrings = new Vector<String>(listItems.size());
        String longestString = "";
        for (Object obj : listItems) {
            if (obj == null) continue;
            String objAsString = obj.toString();
            if (objAsString.length() > longestString.length()) {
                longestString = objAsString;
            }
            dataAsStrings.add(objAsString);
        }
        this.list = new JList(dataAsStrings);
        this.list.setSelectionMode(1);
        this.list.setPrototypeCellValue(longestString);
        JScrollPane scrollPane = new JScrollPane(this.list);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(1));
        this._addButtons(buttonPanel);
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new BorderLayout(10, 5));
        contentPanel.setBorder(BorderFactory.createEmptyBorder(5, 10, 0, 10));
        contentPanel.add((Component)leaderPanel, "North");
        contentPanel.add((Component)scrollPane, "Center");
        contentPanel.add((Component)buttonPanel, "South");
        this.getContentPane().add(contentPanel);
        Dimension dialogSize = new Dimension();
        if (fitToScreen) {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            int screenBasedWidth = (int)(0.75 * screenSize.getWidth());
            int screenBasedHeight = (int)(0.5 * screenSize.getHeight());
            dialogSize.setSize(Math.max(400, screenBasedWidth), Math.max(450, screenBasedHeight));
        } else {
            dialogSize.setSize(width, height);
        }
        this.setSize(dialogSize);
    }

    private boolean _isknownMessageType(int messageType) {
        return messageType == 0 || messageType == 1 || messageType == 2 || messageType == 3 || messageType == -1;
    }

    private Icon _getIcon(int messageType) {
        if (!$assertionsDisabled && !this._isknownMessageType(messageType)) {
            throw new AssertionError();
        }
        if (messageType == 0) {
            return UIManager.getIcon("OptionPane.errorIcon");
        }
        if (messageType == 1) {
            return UIManager.getIcon("OptionPane.informationIcon");
        }
        if (messageType == 2) {
            return UIManager.getIcon("OptionPane.warningIcon");
        }
        if (messageType == 3) {
            return UIManager.getIcon("OptionPane.questionIcon");
        }
        if (messageType == -1) {
            return null;
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return null;
    }

    protected void _addButtons(JPanel buttonPanel) {
        JButton okButton = new JButton("OK");
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent notUsed) {
                ScrollableListDialog.this.closeDialog();
            }
        });
        buttonPanel.add(okButton);
        this.getRootPane().setDefaultButton(okButton);
    }

    public void showDialog() {
        this.pack();
        this.setVisible(true);
    }

    protected void closeDialog() {
        this.setVisible(false);
    }

    public static void main(String[] args) {
        final ArrayList<String> data = new ArrayList<String>();
        data.add("how");
        data.add("now");
        data.add("brown");
        data.add("cow");
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ScrollableListDialog ld = new ScrollableListDialog(null, "TITLE", "LEADER", data, 0);
                ld.pack();
                ld.setVisible(true);
            }
        });
    }

    static {
        $assertionsDisabled = !(class$edu$rice$cs$util$swing$ScrollableListDialog == null ? (class$edu$rice$cs$util$swing$ScrollableListDialog = ScrollableListDialog.class$("edu.rice.cs.util.swing.ScrollableListDialog")) : class$edu$rice$cs$util$swing$ScrollableListDialog).desiredAssertionStatus();
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }
}

