/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.util.swing;

import edu.rice.cs.util.swing.FileChooser;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class FileSelectorStringComponent
extends JPanel {
    public static final int DEFAULT_NUM_COLS = 30;
    public static final float DEFAULT_FONT_SIZE = 10.0f;
    protected final Component _parent;
    protected final JTextField _textField;
    protected final JButton _chooserButton;
    protected final FileChooser _chooser;
    protected volatile File _file;

    public FileSelectorStringComponent(Component parent, FileChooser chooser) {
        this(parent, chooser, 30, 10.0f);
    }

    public FileSelectorStringComponent(Component parent, FileChooser chooser, int numCols, float fontSize) {
        this._parent = parent;
        this._chooser = chooser;
        this._file = null;
        this._textField = new JTextField(numCols){

            public Dimension getMaximumSize() {
                return new Dimension(Short.MAX_VALUE, super.getPreferredSize().height);
            }
        };
        this._textField.setFont(this._textField.getFont().deriveFont(fontSize));
        this._textField.setPreferredSize(new Dimension(22, 22));
        this._chooserButton = new JButton("...");
        this._chooserButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileSelectorStringComponent.access$000(FileSelectorStringComponent.this);
            }
        });
        this._chooserButton.setMaximumSize(new Dimension(22, 22));
        this._chooserButton.setMargin(new Insets(0, 5, 0, 5));
        this.setLayout(new BoxLayout(this, 0));
        this.add(this._textField);
        this.add(this._chooserButton);
    }

    public void setEnabled(boolean isEnabled) {
        this._textField.setEnabled(isEnabled);
        this._chooserButton.setEnabled(isEnabled);
        super.setEnabled(isEnabled);
    }

    public JTextField getTextField() {
        return this._textField;
    }

    public FileChooser getFileChooser() {
        return this._chooser;
    }

    public File convertStringToFile(String s) {
        if ((s = s.trim()).equals("")) {
            return null;
        }
        return new File(s);
    }

    public String convertFileToString(File f) {
        if (f == null) {
            return "";
        }
        return f.toString();
    }

    public File getFileFromField() {
        String newValue = this._textField.getText();
        File newFile = null;
        if (!(newValue.equals("") || (newFile = this.convertStringToFile(newValue)).isDirectory() || this._chooser.isFileSelectionEnabled())) {
            newFile = newFile.getParentFile();
        }
        if (newFile != null && !newFile.exists()) {
            newFile = this._file;
        }
        return newFile;
    }

    public String getText() {
        return this._textField.getText();
    }

    public void setText(String s) {
        this._textField.setText(s);
    }

    public void setFileField(File file) {
        this._file = file;
        if (file != null && !file.getPath().equals("")) {
            try {
                this._file = file.getCanonicalFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.resetFileField();
    }

    public void resetFileField() {
        this._textField.setText(this.convertFileToString(this._file));
        this._textField.setCaretPosition(this._textField.getText().length());
    }

    public void setToolTipText(String text) {
        super.setToolTipText(text);
        this._textField.setToolTipText(text);
        this._chooserButton.setToolTipText(text);
    }

    public void addChoosableFileFilter(FileFilter filter) {
        this._chooser.addChoosableFileFilter(filter);
    }

    public void removeChoosableFileFilter(FileFilter filter) {
        this._chooser.removeChoosableFileFilter(filter);
    }

    public void clearChoosableFileFilters() {
        this._chooser.resetChoosableFileFilters();
    }

    private void _chooseFile() {
        File chosen;
        int returnValue;
        File f = this.getFileFromField();
        if (f != null && f.exists()) {
            this._chooser.setCurrentDirectory(f);
            this._chooser.setSelectedFile(f);
        }
        if ((returnValue = this._chooser.showDialog(this._parent, null)) == 0 && (chosen = this._chooser.getSelectedFile()) != null) {
            this.setFileField(chosen);
        }
    }

    static void access$000(FileSelectorStringComponent x0) {
        x0._chooseFile();
    }
}

