/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.text;

import edu.rice.cs.plt.iter.AbstractIterable;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.iter.SizedIterable;
import edu.rice.cs.plt.recur.RecurUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Arrays;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TextUtil {
    public static final String NEWLINE = System.getProperty("line.separator", "\n");

    private TextUtil() {
    }

    public static String toString(Object o) {
        return RecurUtil.safeToString(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SizedIterable<String> getLines(String s) {
        AbstractIterable result = IterUtil.empty();
        BufferedReader r = new BufferedReader(new StringReader(s));
        try {
            String line = r.readLine();
            while (line != null) {
                result = IterUtil.compose(result, line);
                line = r.readLine();
            }
        }
        catch (IOException e) {
        }
        finally {
            try {
                r.close();
            }
            catch (IOException e) {}
        }
        return result;
    }

    public static String repeat(String s, int copies) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < copies; ++i) {
            result.append(s);
        }
        return result.toString();
    }

    public static String repeat(char c, int copies) {
        char[] result = new char[copies];
        Arrays.fill(result, c);
        return String.valueOf(result);
    }

    public static boolean contains(String s, int character) {
        return s.indexOf(character) >= 0;
    }

    public static boolean contains(String s, String piece) {
        return s.indexOf(piece) >= 0;
    }

    public static boolean containsAny(String s, int ... characters) {
        for (int c : characters) {
            if (!TextUtil.contains(s, c)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAny(String s, String ... pieces) {
        for (String piece : pieces) {
            if (!TextUtil.contains(s, piece)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAll(String s, int ... characters) {
        for (int c : characters) {
            if (TextUtil.contains(s, c)) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAll(String s, String ... pieces) {
        for (String piece : pieces) {
            if (TextUtil.contains(s, piece)) continue;
            return false;
        }
        return true;
    }

    public static boolean containsIgnoreCase(String s, String piece) {
        return s.toLowerCase().indexOf(piece.toLowerCase()) >= 0;
    }

    public static boolean containsAnyIgnoreCase(String s, String ... pieces) {
        for (String piece : pieces) {
            if (!TextUtil.contains(s, piece)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAllIgnoreCase(String s, String ... pieces) {
        for (String piece : pieces) {
            if (TextUtil.contains(s, piece)) continue;
            return false;
        }
        return true;
    }

    public static int indexOfFirst(String s, int ... characters) {
        int result = -1;
        for (int c : characters) {
            int index = s.indexOf(c);
            if (index < 0 || result >= 0 && index >= result) continue;
            result = index;
        }
        return result;
    }

    public static int indexOfFirst(String s, String ... pieces) {
        int result = -1;
        for (String piece : pieces) {
            int index = s.indexOf(piece);
            if (index < 0 || result >= 0 && index >= result) continue;
            result = index;
        }
        return result;
    }
}

