/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.swing;

import edu.rice.cs.plt.debug.DebugUtil;
import edu.rice.cs.plt.io.IOUtil;
import edu.rice.cs.plt.lambda.LambdaUtil;
import edu.rice.cs.plt.lambda.Predicate;
import edu.rice.cs.plt.lambda.Runnable1;
import edu.rice.cs.plt.lambda.WrappedException;
import edu.rice.cs.plt.swing.TextAreaMessageDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwingUtil {
    public static void invokeLater(Runnable task) {
        if (EventQueue.isDispatchThread()) {
            task.run();
        } else {
            EventQueue.invokeLater(task);
        }
    }

    public static void invokeAndWait(Runnable task) {
        if (EventQueue.isDispatchThread()) {
            task.run();
        } else {
            try {
                EventQueue.invokeAndWait(task);
            }
            catch (InterruptedException e) {
                throw new WrappedException(e);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                if (cause instanceof Error) {
                    throw (Error)cause;
                }
                DebugUtil.error.log("Unexpected InvocationTargetException caused by invokeAndWait", cause);
            }
        }
    }

    public static void clearEventQueue() {
        SwingUtil.invokeAndWait(LambdaUtil.NO_OP);
    }

    public static ActionListener asActionListener(final Runnable r) {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                r.run();
            }
        };
    }

    public static ActionListener asActionListener(final Runnable1<? super ActionEvent> r) {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                r.run(e);
            }
        };
    }

    public static Runnable1<ActionEvent> asRunnable(final ActionListener l) {
        return new Runnable1<ActionEvent>(){

            @Override
            public void run(ActionEvent e) {
                l.actionPerformed(e);
            }

            @Override
            public void run(Object x0) {
                this.run((ActionEvent)x0);
            }
        };
    }

    public static javax.swing.filechooser.FileFilter asSwingFileFilter(final FileFilter filter, final String description) {
        return new javax.swing.filechooser.FileFilter(){

            public boolean accept(File f) {
                return filter.accept(f);
            }

            public String getDescription() {
                return description;
            }
        };
    }

    public static javax.swing.filechooser.FileFilter asSwingFileFilter(Predicate<? super File> p, String description) {
        return SwingUtil.asSwingFileFilter(IOUtil.asFileFilter(p), description);
    }

    public static ActionListener disposeAction(final Window w) {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                w.dispose();
            }
        };
    }

    public static void showDebug(String msg) {
        SwingUtil.showPopup("Debug Message", msg);
    }

    public static void showPopup(final String title, final String msg) {
        SwingUtil.invokeAndWait(new Runnable(){

            public void run() {
                TextAreaMessageDialog.showDialog(null, title, msg);
            }
        });
    }

    public static String getClipboardSelection(Component c) {
        Clipboard cb = c.getToolkit().getSystemClipboard();
        if (cb == null) {
            return null;
        }
        Transferable t = cb.getContents(null);
        if (t == null) {
            return null;
        }
        String s = null;
        try {
            Reader r = DataFlavor.stringFlavor.getReaderForText(t);
            s = IOUtil.toString(r);
        }
        catch (UnsupportedFlavorException ufe) {
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return s;
    }

    public static void setPopupLoc(Window popup) {
        SwingUtil.setPopupLoc(popup, popup.getOwner());
    }

    public static void setPopupLoc(Window popup, Component owner) {
        GraphicsDevice[] gs;
        Rectangle frameRect = popup.getBounds();
        Point ownerLoc = null;
        Dimension ownerSize = null;
        if (owner != null) {
            ownerLoc = owner.getLocation();
            ownerSize = owner.getSize();
        } else {
            GraphicsDevice[] dev = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
            Rectangle rec = dev[0].getDefaultConfiguration().getBounds();
            ownerLoc = rec.getLocation();
            ownerSize = rec.getSize();
        }
        Point loc = new Point(ownerLoc.x + (ownerSize.width - frameRect.width) / 2, ownerLoc.y + (ownerSize.height - frameRect.height) / 2);
        frameRect.setLocation(loc);
        GraphicsConfiguration gcBest = null;
        int gcBestArea = -1;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (GraphicsDevice gd : gs = ge.getScreenDevices()) {
            GraphicsConfiguration gc = gd.getDefaultConfiguration();
            Rectangle isect = frameRect.intersection(gc.getBounds());
            int gcArea = isect.width * isect.height;
            if (gcArea <= gcBestArea) continue;
            gcBest = gc;
            gcBestArea = gcArea;
        }
        Rectangle screenRect = gcBest.getBounds();
        Dimension screenSize = screenRect.getSize();
        Dimension frameSize = popup.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        frameRect.setSize(frameSize);
        loc = new Point(ownerLoc.x + (ownerSize.width - frameRect.width) / 2, ownerLoc.y + (ownerSize.height - frameRect.height) / 2);
        frameRect.setLocation(loc);
        if (frameRect.x < screenRect.x) {
            frameRect.x = screenRect.x;
        }
        if (frameRect.x + frameRect.width > screenRect.x + screenRect.width) {
            frameRect.x = screenRect.x + screenRect.width - frameRect.width;
        }
        if (frameRect.y < screenRect.y) {
            frameRect.y = screenRect.y;
        }
        if (frameRect.y + frameRect.height > screenRect.y + screenRect.height) {
            frameRect.y = screenRect.y + screenRect.height - frameRect.height;
        }
        popup.setSize(frameRect.getSize());
        popup.setLocation(frameRect.getLocation());
    }
}

