/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.iter;

import edu.rice.cs.plt.lambda.Lambda3;
import java.util.Iterator;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TernaryMappedIterator<T1, T2, T3, R>
implements Iterator<R> {
    private final Iterator<? extends T1> _source1;
    private final Iterator<? extends T2> _source2;
    private final Iterator<? extends T3> _source3;
    private final Lambda3<? super T1, ? super T2, ? super T3, ? extends R> _map;

    public TernaryMappedIterator(Iterator<? extends T1> source1, Iterator<? extends T2> source2, Iterator<? extends T3> source3, Lambda3<? super T1, ? super T2, ? super T3, ? extends R> map) {
        this._source1 = source1;
        this._source2 = source2;
        this._source3 = source3;
        this._map = map;
    }

    @Override
    public boolean hasNext() {
        return this._source1.hasNext();
    }

    @Override
    public R next() {
        return this._map.value(this._source1.next(), this._source2.next(), this._source3.next());
    }

    @Override
    public void remove() {
        this._source1.remove();
        this._source2.remove();
        this._source3.remove();
    }

    public static <T1, T2, T3, R> TernaryMappedIterator<T1, T2, T3, R> make(Iterator<? extends T1> source1, Iterator<? extends T2> source2, Iterator<? extends T3> source3, Lambda3<? super T1, ? super T2, ? super T3, ? extends R> map) {
        return new TernaryMappedIterator<T1, T2, T3, R>(source1, source2, source3, map);
    }
}

