/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.javalanglevels.tree;

import edu.rice.cs.javalanglevels.SourceInfo;
import edu.rice.cs.javalanglevels.tree.JExpressionIFVisitor;
import edu.rice.cs.javalanglevels.tree.JExpressionIFVisitor_void;
import edu.rice.cs.javalanglevels.tree.Statement;
import edu.rice.cs.javalanglevels.tree.TabPrintWriter;
import edu.rice.cs.javalanglevels.tree.Word;
import java.io.StringWriter;
import java.io.Writer;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LabeledStatement
extends Statement {
    private final Word _label;
    private final Statement _statement;

    public LabeledStatement(SourceInfo in_sourceInfo, Word in_label, Statement in_statement) {
        super(in_sourceInfo);
        if (in_label == null) {
            throw new IllegalArgumentException("Parameter 'label' to the LabeledStatement constructor was null. This class may not have null field values.");
        }
        this._label = in_label;
        if (in_statement == null) {
            throw new IllegalArgumentException("Parameter 'statement' to the LabeledStatement constructor was null. This class may not have null field values.");
        }
        this._statement = in_statement;
    }

    public final Word getLabel() {
        return this._label;
    }

    public final Statement getStatement() {
        return this._statement;
    }

    @Override
    public <RetType> RetType visit(JExpressionIFVisitor<RetType> visitor) {
        return visitor.forLabeledStatement(this);
    }

    @Override
    public void visit(JExpressionIFVisitor_void visitor) {
        visitor.forLabeledStatement(this);
    }

    public String toString() {
        StringWriter w = new StringWriter();
        this.output(w);
        return w.toString();
    }

    public void output(Writer writer) {
        this.outputHelp(new TabPrintWriter(writer, 2));
    }

    @Override
    public void outputHelp(TabPrintWriter writer) {
        writer.print("LabeledStatement:");
        writer.indent();
        writer.startLine("");
        writer.print("sourceInfo = ");
        SourceInfo temp_sourceInfo = this.getSourceInfo();
        if (temp_sourceInfo == null) {
            writer.print("null");
        } else {
            writer.print(temp_sourceInfo);
        }
        writer.startLine("");
        writer.print("label = ");
        Word temp_label = this.getLabel();
        if (temp_label == null) {
            writer.print("null");
        } else {
            temp_label.outputHelp(writer);
        }
        writer.startLine("");
        writer.print("statement = ");
        Statement temp_statement = this.getStatement();
        if (temp_statement == null) {
            writer.print("null");
        } else {
            temp_statement.outputHelp(writer);
        }
        writer.unindent();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass() || obj.hashCode() != this.hashCode()) {
            return false;
        }
        LabeledStatement casted = (LabeledStatement)obj;
        if (!this.getLabel().equals(casted.getLabel())) {
            return false;
        }
        return this.getStatement().equals(casted.getStatement());
    }

    @Override
    protected int generateHashCode() {
        int code = this.getClass().hashCode();
        code ^= 0;
        code ^= this.getLabel().hashCode();
        return code ^= this.getStatement().hashCode();
    }
}

