/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.javalanglevels.tree;

import edu.rice.cs.javalanglevels.SourceInfo;
import edu.rice.cs.javalanglevels.tree.Expression;
import edu.rice.cs.javalanglevels.tree.JExpressionIFVisitor;
import edu.rice.cs.javalanglevels.tree.JExpressionIFVisitor_void;
import edu.rice.cs.javalanglevels.tree.Primary;
import edu.rice.cs.javalanglevels.tree.TabPrintWriter;
import java.io.StringWriter;
import java.io.Writer;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayAccess
extends Primary {
    private final Expression _array;
    private final Expression _index;

    public ArrayAccess(SourceInfo in_sourceInfo, Expression in_array, Expression in_index) {
        super(in_sourceInfo);
        if (in_array == null) {
            throw new IllegalArgumentException("Parameter 'array' to the ArrayAccess constructor was null. This class may not have null field values.");
        }
        this._array = in_array;
        if (in_index == null) {
            throw new IllegalArgumentException("Parameter 'index' to the ArrayAccess constructor was null. This class may not have null field values.");
        }
        this._index = in_index;
    }

    public final Expression getArray() {
        return this._array;
    }

    public final Expression getIndex() {
        return this._index;
    }

    @Override
    public <RetType> RetType visit(JExpressionIFVisitor<RetType> visitor) {
        return visitor.forArrayAccess(this);
    }

    @Override
    public void visit(JExpressionIFVisitor_void visitor) {
        visitor.forArrayAccess(this);
    }

    public String toString() {
        StringWriter w = new StringWriter();
        this.output(w);
        return w.toString();
    }

    public void output(Writer writer) {
        this.outputHelp(new TabPrintWriter(writer, 2));
    }

    @Override
    public void outputHelp(TabPrintWriter writer) {
        writer.print("ArrayAccess:");
        writer.indent();
        writer.startLine("");
        writer.print("sourceInfo = ");
        SourceInfo temp_sourceInfo = this.getSourceInfo();
        if (temp_sourceInfo == null) {
            writer.print("null");
        } else {
            writer.print(temp_sourceInfo);
        }
        writer.startLine("");
        writer.print("array = ");
        Expression temp_array = this.getArray();
        if (temp_array == null) {
            writer.print("null");
        } else {
            temp_array.outputHelp(writer);
        }
        writer.startLine("");
        writer.print("index = ");
        Expression temp_index = this.getIndex();
        if (temp_index == null) {
            writer.print("null");
        } else {
            temp_index.outputHelp(writer);
        }
        writer.unindent();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass() || obj.hashCode() != this.hashCode()) {
            return false;
        }
        ArrayAccess casted = (ArrayAccess)obj;
        if (!this.getArray().equals(casted.getArray())) {
            return false;
        }
        return this.getIndex().equals(casted.getIndex());
    }

    @Override
    protected int generateHashCode() {
        int code = this.getClass().hashCode();
        code ^= 0;
        code ^= this.getArray().hashCode();
        return code ^= this.getIndex().hashCode();
    }
}

