/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.javalanglevels;

public abstract class CharConverter {
    public static String escapeChar(char c) {
        StringBuffer buf = new StringBuffer();
        CharConverter.escapeChar(c, buf);
        return buf.toString();
    }

    public static void escapeChar(char c, StringBuffer buf) {
        switch (c) {
            case '\n': {
                buf.append("\\n");
                break;
            }
            case '\t': {
                buf.append("\\t");
                break;
            }
            case '\b': {
                buf.append("\\b");
                break;
            }
            case '\r': {
                buf.append("\\r");
                break;
            }
            case '\f': {
                buf.append("\\f");
                break;
            }
            case '\\': {
                buf.append("\\\\");
                break;
            }
            case '\'': {
                buf.append("\\'");
                break;
            }
            case '\"': {
                buf.append("\\\"");
                break;
            }
            default: {
                if (c < ' ' || c > '\u007f') {
                    String hex = Integer.toHexString(c);
                    buf.append("\\u");
                    for (int i = hex.length(); i < 4; ++i) {
                        buf.append('0');
                    }
                    buf.append(hex);
                    break;
                }
                buf.append(c);
            }
        }
    }

    public static String escapeString(String s) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            CharConverter.escapeChar(s.charAt(i), buf);
        }
        return buf.toString();
    }

    public static char unescapeChar(String in) {
        StringBuffer buf = new StringBuffer();
        int endPos = CharConverter.unescapeString(in, 0, buf);
        if (endPos < in.length()) {
            throw new IllegalArgumentException(in.length() - endPos + " trailing" + " characters at the end of character" + " literal '" + in + "'");
        }
        return buf.charAt(0);
    }

    public static String unescapeString(String in) {
        if (in.length() == 0) {
            return in;
        }
        StringBuffer buf = new StringBuffer();
        int nextStart = 0;
        while (nextStart < in.length()) {
            nextStart = CharConverter.unescapeString(in, nextStart, buf);
        }
        return buf.toString();
    }

    public static int unescapeString(String in, int startPos, StringBuffer out) {
        char first = in.charAt(startPos);
        if (first != '\\') {
            out.append(first);
            return startPos + 1;
        }
        char second = in.charAt(startPos + 1);
        switch (second) {
            case 'n': {
                out.append('\n');
                return startPos + 2;
            }
            case 't': {
                out.append('\t');
                return startPos + 2;
            }
            case 'b': {
                out.append('\b');
                return startPos + 2;
            }
            case 'r': {
                out.append('\r');
                return startPos + 2;
            }
            case 'f': {
                out.append('\f');
                return startPos + 2;
            }
            case '\\': {
                out.append('\\');
                return startPos + 2;
            }
            case '\'': {
                out.append('\'');
                return startPos + 2;
            }
            case '\"': {
                out.append('\"');
                return startPos + 2;
            }
        }
        if (CharConverter._isOctalDigit(second)) {
            char nextChar;
            int nextDigitPos;
            int maxDigits = second < '4' ? 3 : 2;
            StringBuffer octal = new StringBuffer(maxDigits);
            octal.append(second);
            for (nextDigitPos = startPos + 2; octal.length() < maxDigits && nextDigitPos < in.length() && CharConverter._isOctalDigit(nextChar = in.charAt(nextDigitPos)); ++nextDigitPos) {
                octal.append(nextChar);
            }
            try {
                int charValue = Integer.parseInt(octal.toString(), 8);
                if (charValue > 65535 || charValue < 0) {
                    throw new IllegalArgumentException("Octal escape beginning at position " + startPos + " out of range: " + in);
                }
                out.append((char)charValue);
                return nextDigitPos;
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Impossible to occur, but number format exception in octal escape!");
            }
        }
        throw new IllegalArgumentException("Invalid escape sequence at position " + startPos + ": " + in);
    }

    private static boolean _isOctalDigit(char c) {
        return c >= '0' && c <= '7';
    }
}

