/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.javalanglevels;

import edu.rice.cs.javalanglevels.BlockData;
import edu.rice.cs.javalanglevels.BodyData;
import edu.rice.cs.javalanglevels.Data;
import edu.rice.cs.javalanglevels.ElementaryVisitor;
import edu.rice.cs.javalanglevels.LanguageLevelVisitor;
import edu.rice.cs.javalanglevels.Pair;
import edu.rice.cs.javalanglevels.SourceInfo;
import edu.rice.cs.javalanglevels.VariableData;
import edu.rice.cs.javalanglevels.tree.Block;
import edu.rice.cs.javalanglevels.tree.InstanceInitializer;
import edu.rice.cs.javalanglevels.tree.MethodDef;
import edu.rice.cs.javalanglevels.tree.VariableDeclaration;
import java.io.File;
import java.util.Hashtable;
import java.util.LinkedList;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BodyBodyElementaryVisitor
extends ElementaryVisitor {
    private BodyData _bodyData;

    public BodyBodyElementaryVisitor(BodyData bodyData, File file, String packageName, LinkedList<String> importedFiles, LinkedList<String> importedPackages, LinkedList<String> classDefsInThisFile, Hashtable<String, Pair<SourceInfo, LanguageLevelVisitor>> continuations) {
        super(file, packageName, importedFiles, importedPackages, classDefsInThisFile, continuations);
        this._bodyData = bodyData;
    }

    @Override
    public void forMethodDefDoFirst(MethodDef that) {
        BodyBodyElementaryVisitor._addError("Methods definitions cannot appear within the body of another method or block.", that);
    }

    @Override
    public void forInstanceInitializer(InstanceInitializer that) {
        this.forBlock(that.getCode());
    }

    @Override
    public void forBlock(Block that) {
        this.forBlockDoFirst(that);
        if (BodyBodyElementaryVisitor._checkError()) {
            return;
        }
        BlockData bd = new BlockData(this._bodyData);
        this._bodyData.addBlock(bd);
        that.getStatements().visit(new BodyBodyElementaryVisitor(bd, this._file, this._package, (LinkedList<String>)this._importedFiles, (LinkedList<String>)this._importedPackages, this._classNamesInThisFile, (Hashtable<String, Pair<SourceInfo, LanguageLevelVisitor>>)continuations));
    }

    @Override
    public void forVariableDeclarationOnly(VariableDeclaration that) {
        if (!this._bodyData.addFinalVars(this._variableDeclaration2VariableData(that, this._bodyData))) {
            BodyBodyElementaryVisitor._addAndIgnoreError("You cannot have two variables with the same name.", that);
        }
    }

    @Override
    protected VariableData[] _variableDeclaration2VariableData(VariableDeclaration vd, Data enclosingData) {
        VariableData[] vds = this.llVariableDeclaration2VariableData(vd, enclosingData);
        for (int i = 0; i < vds.length; ++i) {
            if (vds[i].getMav().getModifiers().length > 0) {
                StringBuffer s = new StringBuffer("the keyword(s) ");
                String[] modifiers = vds[i].getMav().getModifiers();
                for (int j = 0; j < modifiers.length; ++j) {
                    s.append(new StringBuffer().append("\"").append(modifiers[j]).append("\" ").toString());
                }
                BodyBodyElementaryVisitor._addAndIgnoreError(new StringBuffer().append("You cannot use ").append(s.toString()).append("to declare a local variable at the Elementary level").toString(), vd);
            }
            vds[i].setFinal();
        }
        return vds;
    }

    static BodyData access$000(BodyBodyElementaryVisitor x0) {
        return x0._bodyData;
    }
}

