/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.javalanglevels;

import edu.rice.cs.javalanglevels.AdvancedVisitor;
import edu.rice.cs.javalanglevels.BlockData;
import edu.rice.cs.javalanglevels.BodyBodyIntermediateVisitor;
import edu.rice.cs.javalanglevels.BodyData;
import edu.rice.cs.javalanglevels.Data;
import edu.rice.cs.javalanglevels.LanguageLevelVisitor;
import edu.rice.cs.javalanglevels.Pair;
import edu.rice.cs.javalanglevels.SourceInfo;
import edu.rice.cs.javalanglevels.VariableData;
import edu.rice.cs.javalanglevels.tree.Block;
import edu.rice.cs.javalanglevels.tree.CatchBlock;
import edu.rice.cs.javalanglevels.tree.ComplexAnonymousClassInstantiation;
import edu.rice.cs.javalanglevels.tree.FormalParameter;
import edu.rice.cs.javalanglevels.tree.InnerClassDef;
import edu.rice.cs.javalanglevels.tree.InnerInterfaceDef;
import edu.rice.cs.javalanglevels.tree.InstanceInitializer;
import edu.rice.cs.javalanglevels.tree.MethodDef;
import edu.rice.cs.javalanglevels.tree.SimpleAnonymousClassInstantiation;
import edu.rice.cs.javalanglevels.tree.TryCatchStatement;
import edu.rice.cs.javalanglevels.tree.VariableDeclaration;
import java.io.File;
import java.util.Hashtable;
import java.util.LinkedList;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BodyBodyAdvancedVisitor
extends AdvancedVisitor {
    private BodyData _bodyData;

    public BodyBodyAdvancedVisitor(BodyData bodyData, File file, String packageName, LinkedList<String> importedFiles, LinkedList<String> importedPackages, LinkedList<String> classDefsInThisFile, Hashtable<String, Pair<SourceInfo, LanguageLevelVisitor>> continuations) {
        super(file, packageName, importedFiles, importedPackages, classDefsInThisFile, continuations);
        this._bodyData = bodyData;
    }

    @Override
    public void forMethodDefDoFirst(MethodDef that) {
        BodyBodyAdvancedVisitor._addError("Methods definitions cannot appear within the body of another method or block.", that);
    }

    @Override
    public void forInstanceInitializer(InstanceInitializer that) {
        this.forBlock(that.getCode());
    }

    @Override
    public void forBlock(Block that) {
        this.forBlockDoFirst(that);
        if (this.prune(that)) {
            return;
        }
        BlockData bd = new BlockData(this._bodyData);
        this._bodyData.addBlock(bd);
        that.getStatements().visit(new BodyBodyAdvancedVisitor(bd, this._file, this._package, (LinkedList<String>)this._importedFiles, (LinkedList<String>)this._importedPackages, this._classNamesInThisFile, (Hashtable<String, Pair<SourceInfo, LanguageLevelVisitor>>)continuations));
        this.forBlockOnly(that);
    }

    @Override
    public void forCatchBlock(CatchBlock that) {
        this.forCatchBlockDoFirst(that);
        if (this.prune(that)) {
            return;
        }
        Block b = that.getBlock();
        this.forBlockDoFirst(b);
        if (this.prune(b)) {
            return;
        }
        BlockData bd = new BlockData(this._bodyData);
        this._bodyData.addBlock(bd);
        VariableData exceptionVar = this.formalParameters2VariableData(new FormalParameter[]{that.getException()}, bd)[0];
        if (this.prune(that.getException())) {
            return;
        }
        bd.addVar(exceptionVar);
        b.getStatements().visit(new BodyBodyIntermediateVisitor(bd, this._file, this._package, (LinkedList<String>)this._importedFiles, (LinkedList<String>)this._importedPackages, this._classNamesInThisFile, (Hashtable<String, Pair<SourceInfo, LanguageLevelVisitor>>)continuations));
        this.forBlockOnly(b);
        this.forCatchBlockOnly(that);
    }

    @Override
    public void forVariableDeclarationOnly(VariableDeclaration that) {
        if (!this._bodyData.addVars(this._variableDeclaration2VariableData(that, this._bodyData))) {
            BodyBodyAdvancedVisitor._addAndIgnoreError("You cannot have two variables with the same name.", that);
        }
    }

    @Override
    protected VariableData[] _variableDeclaration2VariableData(VariableDeclaration vd, Data enclosingData) {
        VariableData[] vds = super._variableDeclaration2VariableData(vd, enclosingData);
        for (int i = 0; i < vds.length; ++i) {
            if ((!vds[i].hasModifier("final") || vds[i].getMav().getModifiers().length <= 1) && (vds[i].hasModifier("final") || vds[i].getMav().getModifiers().length <= 0)) continue;
            StringBuffer sbuff = new StringBuffer("the keyword(s) ");
            String[] modifiers = vds[i].getMav().getModifiers();
            for (int j = 0; j < modifiers.length; ++j) {
                if (modifiers[j].equals("final")) continue;
                sbuff.append(new StringBuffer().append("\"").append(modifiers[j]).append("\" ").toString());
            }
            BodyBodyAdvancedVisitor._addAndIgnoreError(new StringBuffer().append("You cannot use ").append(sbuff.toString()).append("to declare a local variable").toString(), vd);
        }
        return vds;
    }

    @Override
    public void forTryCatchStatementDoFirst(TryCatchStatement that) {
    }

    @Override
    public void forInnerClassDef(InnerClassDef that) {
        if (that.getMav().getModifiers().length > 0) {
            BodyBodyAdvancedVisitor._addAndIgnoreError("No modifiers may appear before a class declaration here", that.getMav());
        }
        this.handleInnerClassDef(that, this._bodyData, new StringBuffer().append(this.getQualifiedClassName(this._bodyData.getSymbolData().getName())).append("$").append(this._bodyData.getSymbolData().preincrementLocalClassNum()).append(that.getName().getText()).toString());
    }

    @Override
    public void forInnerInterfaceDef(InnerInterfaceDef that) {
        BodyBodyAdvancedVisitor._addError("Inner interface declarations cannot appear here", that);
    }

    @Override
    public void forComplexAnonymousClassInstantiation(ComplexAnonymousClassInstantiation that) {
        this.complexAnonymousClassInstantiationHelper(that, this._bodyData);
    }

    @Override
    public void forSimpleAnonymousClassInstantiation(SimpleAnonymousClassInstantiation that) {
        this.simpleAnonymousClassInstantiationHelper(that, this._bodyData);
    }

    static BodyData access$000(BodyBodyAdvancedVisitor x0) {
        return x0._bodyData;
    }
}

