/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.model.DocumentRegion;
import edu.rice.cs.drjava.model.OpenDefinitionsDocument;
import edu.rice.cs.drjava.model.SingleDisplayModel;
import edu.rice.cs.drjava.model.definitions.ClassNameNotFoundException;
import edu.rice.cs.drjava.ui.BackgroundColorListener;
import edu.rice.cs.drjava.ui.ForegroundColorListener;
import edu.rice.cs.drjava.ui.MainFrame;
import edu.rice.cs.drjava.ui.TabbedPanel;
import edu.rice.cs.util.StringOps;
import edu.rice.cs.util.swing.RightClickMouseAdapter;
import edu.rice.cs.util.swing.Utilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RegionsListPanel<R extends DocumentRegion>
extends TabbedPanel {
    protected JPanel _leftPane;
    protected JList _list;
    protected DefaultListModel _listModel;
    protected String _title;
    protected final SingleDisplayModel _model;
    protected final MainFrame _frame;
    protected JPanel _buttonPanel;

    public RegionsListPanel(MainFrame frame, String title) {
        super(frame, title);
        this._title = title;
        this.setLayout(new BorderLayout());
        this._frame = frame;
        this._model = frame.getModel();
        this.removeAll();
        this._closePanel = new JPanel(new BorderLayout());
        this._closePanel.add((Component)this._closeButton, "North");
        this._leftPane = new JPanel(new BorderLayout());
        this._setupRegionList();
        this.add((Component)this._leftPane, "Center");
        this._buttonPanel = new JPanel(new BorderLayout());
        this._setupButtonPanel();
        this.add((Component)this._buttonPanel, "East");
        this.updateButtons();
        RegionsListPanel._setColors(this._list);
        this._list.addMouseListener(new RegionMouseAdapter());
    }

    private static void _setColors(Component c) {
        new ForegroundColorListener(c);
        new BackgroundColorListener(c);
    }

    @Override
    protected void _close() {
        super._close();
        this.updateButtons();
    }

    private void _setupRegionList() {
        this._listModel = new DefaultListModel();
        this._list = new JList(this._listModel){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public String getToolTipText(MouseEvent evt) {
                int index = this.locationToIndex(evt.getPoint());
                RegionListUserObj node = (RegionListUserObj)this.getModel().getElementAt(index);
                Object r = node.region();
                String tooltip = null;
                OpenDefinitionsDocument doc = r.getDocument();
                doc.acquireReadLock();
                try {
                    int rEnd;
                    int endOffset;
                    int lnr = doc.getLineOfOffset(r.getStartOffset()) + 1;
                    int startOffset = doc.getOffset(lnr - 3);
                    if (startOffset < 0) {
                        startOffset = 0;
                    }
                    if ((endOffset = doc.getOffset(lnr + 3)) < 0) {
                        endOffset = doc.getLength() - 1;
                    }
                    String s = doc.getText(startOffset, endOffset - startOffset);
                    int rStart = r.getStartOffset() - startOffset;
                    if (rStart < 0) {
                        rStart = 0;
                    }
                    if ((rEnd = r.getEndOffset() - startOffset) > s.length()) {
                        rEnd = s.length();
                    }
                    if (rStart <= s.length() && rEnd >= rStart) {
                        String t1 = StringOps.encodeHTML(s.substring(0, rStart));
                        String t2 = StringOps.encodeHTML(s.substring(rStart, rEnd));
                        String t3 = StringOps.encodeHTML(s.substring(rEnd));
                        s = t1 + "<font color=#ff0000>" + t2 + "</font>" + t3;
                    } else {
                        s = StringOps.encodeHTML(s);
                    }
                    tooltip = "<html><pre>" + s + "</pre></html>";
                }
                catch (BadLocationException ble) {
                    tooltip = null;
                }
                finally {
                    doc.releaseReadLock();
                }
                return tooltip;
            }
        };
        this._list.getSelectionModel().setSelectionMode(2);
        this._list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                RegionsListPanel.this.updateButtons();
            }
        });
        this._list.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    RegionsListPanel.this.performDefaultAction();
                }
            }
        });
        this._list.setFont(DrJava.getConfig().getSetting(OptionConstants.FONT_DOCLIST));
        this._leftPane.add(new JScrollPane(this._list));
        ToolTipManager.sharedInstance().registerComponent(this._list);
    }

    protected void updateButtons() {
    }

    protected void performDefaultAction() {
    }

    protected JComponent[] makeButtons() {
        return new JComponent[0];
    }

    private void _setupButtonPanel() {
        JPanel mainButtons = new JPanel();
        JPanel emptyPanel = new JPanel();
        JPanel closeButtonPanel = new JPanel(new BorderLayout());
        GridBagLayout gbLayout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        mainButtons.setLayout(gbLayout);
        JComponent[] buts = this.makeButtons();
        closeButtonPanel.add((Component)this._closeButton, "North");
        for (JComponent b : buts) {
            mainButtons.add(b);
        }
        mainButtons.add(emptyPanel);
        c.fill = 2;
        c.anchor = 11;
        c.gridwidth = 0;
        c.weightx = 1.0;
        for (JComponent b : buts) {
            gbLayout.setConstraints(b, c);
        }
        c.fill = 1;
        c.anchor = 15;
        c.gridheight = 0;
        c.weighty = 1.0;
        gbLayout.setConstraints(emptyPanel, c);
        this._buttonPanel.add((Component)mainButtons, "Center");
        this._buttonPanel.add((Component)closeButtonPanel, "East");
    }

    protected ArrayList<R> getSelectedRegions() {
        ArrayList regs = new ArrayList();
        int[] indices = this._list.getSelectedIndices();
        if (indices != null) {
            for (int index : indices) {
                RegionListUserObj userObj = (RegionListUserObj)this._listModel.elementAt(index);
                Object r = userObj.region();
                regs.add(r);
            }
        }
        return regs;
    }

    protected void goToRegion() {
        ArrayList<R> r = this.getSelectedRegions();
        if (r.size() == 1) {
            RegionListUserObj<DocumentRegion> userObj = this.getUserObjForRegion((DocumentRegion)r.get(0));
            if (userObj != null) {
                this._list.ensureIndexIsVisible(this._listModel.indexOf(userObj));
            }
            this._frame.scrollToDocumentAndOffset(((DocumentRegion)r.get(0)).getDocument(), ((DocumentRegion)r.get(0)).getStartOffset(), false);
        }
    }

    protected RegionListUserObj<R> getUserObjForRegion(R r) {
        for (int i = 0; i < this._listModel.size(); ++i) {
            RegionListUserObj userObj = (RegionListUserObj)this._listModel.get(i);
            if (userObj.region().getStartOffset() != r.getStartOffset() || userObj.region().getEndOffset() != r.getEndOffset() || !userObj.region().getDocument().equals(r.getDocument())) continue;
            return userObj;
        }
        return null;
    }

    public void addRegion(R r, int index) {
        Runnable doCommand = new Runnable((DocumentRegion)r, index){
            final /* synthetic */ DocumentRegion val$r;
            final /* synthetic */ int val$index;
            {
                this.val$r = documentRegion;
                this.val$index = n;
            }

            public void run() {
                String name = "";
                try {
                    name = this.val$r.getDocument().getQualifiedClassName();
                }
                catch (ClassNameNotFoundException cnnfe) {
                    name = this.val$r.getDocument().toString();
                }
                RegionListUserObj<DocumentRegion> userObj = RegionsListPanel.this.makeRegionListUserObj(this.val$r);
                RegionsListPanel.this._listModel.add(this.val$index, userObj);
                RegionsListPanel.this._list.ensureIndexIsVisible(RegionsListPanel.this._listModel.indexOf(userObj));
                RegionsListPanel.this.updateButtons();
            }
        };
        Utilities.invokeLater(doCommand);
    }

    public void removeRegion(R r) {
        Runnable doCommand = new Runnable((DocumentRegion)r){
            final /* synthetic */ DocumentRegion val$r;
            {
                this.val$r = documentRegion;
            }

            public void run() {
                String name = "";
                try {
                    name = this.val$r.getDocument().getQualifiedClassName();
                }
                catch (ClassNameNotFoundException cnnfe) {
                    name = this.val$r.getDocument().toString();
                }
                for (int i = 0; i < RegionsListPanel.this._listModel.size(); ++i) {
                    RegionListUserObj userObj = (RegionListUserObj)RegionsListPanel.this._listModel.get(i);
                    if (userObj.region() != this.val$r) continue;
                    RegionsListPanel.this._listModel.removeElementAt(i);
                    break;
                }
                RegionsListPanel.this.updateButtons();
            }
        };
        Utilities.invokeLater(doCommand);
    }

    public void removeRegions(final OpenDefinitionsDocument odd) {
        Runnable doCommand = new Runnable(){

            public void run() {
                String name = "";
                try {
                    name = odd.getQualifiedClassName();
                }
                catch (ClassNameNotFoundException cnnfe) {
                    name = odd.toString();
                }
                for (int i = 0; i < RegionsListPanel.this._listModel.size(); ++i) {
                    RegionListUserObj userObj = (RegionListUserObj)RegionsListPanel.this._listModel.get(i);
                    if (!userObj.region().getDocument().equals(odd)) continue;
                    RegionsListPanel.this._listModel.removeElementAt(i);
                }
                RegionsListPanel.this.updateButtons();
            }
        };
        Utilities.invokeLater(doCommand);
    }

    protected RegionListUserObj<R> makeRegionListUserObj(R r) {
        return new RegionListUserObj<R>(r);
    }

    protected class RegionMouseAdapter
    extends RightClickMouseAdapter {
        protected RegionMouseAdapter() {
        }

        protected void _popupAction(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            super.mousePressed(e);
            if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
                RegionsListPanel.this.performDefaultAction();
            }
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class RegionListUserObj<R extends DocumentRegion> {
        protected R _region;

        public int lineNumber() {
            return this._region.getDocument().getLineOfOffset(this._region.getStartOffset()) + 1;
        }

        public R region() {
            return this._region;
        }

        public RegionListUserObj(R r) {
            this._region = r;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            StringBuffer sb = new StringBuffer();
            this._region.getDocument().acquireReadLock();
            try {
                sb.append(this._region.getDocument().toString());
                sb.append(':');
                sb.append(this.lineNumber());
                try {
                    sb.append(": ");
                    int length = Math.min(120, this._region.getEndOffset() - this._region.getStartOffset());
                    sb.append(this._region.getDocument().getText(this._region.getStartOffset(), length).trim());
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            finally {
                this._region.getDocument().releaseReadLock();
            }
            return sb.toString();
        }

        public boolean equals(Object other) {
            RegionListUserObj o = (RegionListUserObj)other;
            return o.region().getDocument().equals(this.region().getDocument()) && o.region().getStartOffset() == this.region().getStartOffset() && o.region().getEndOffset() == this.region().getEndOffset();
        }
    }
}

