/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui;

import edu.rice.cs.drjava.model.DocumentRegion;
import edu.rice.cs.drjava.model.RegionManager;
import edu.rice.cs.drjava.model.RegionManagerListener;
import edu.rice.cs.drjava.ui.MainFrame;
import edu.rice.cs.drjava.ui.RegionsListPanel;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.text.BadLocationException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrowserHistoryPanel
extends RegionsListPanel<DocumentRegion> {
    protected JButton _backButton;
    protected JButton _forwardButton;
    protected JButton _goToButton;
    protected JButton _removeButton;
    protected JButton _removeAllButton;
    protected AbstractAction _backAction;
    protected AbstractAction _forwardAction;

    public BrowserHistoryPanel(MainFrame frame) {
        super(frame, "Browser History");
        this._model.getBrowserHistoryManager().addListener(new RegionManagerListener<DocumentRegion>(){

            @Override
            public void regionAdded(DocumentRegion r, int index) {
                BrowserHistoryPanel.this.addRegion(r, index);
                BrowserHistoryPanel.this._list.ensureIndexIsVisible(index);
            }

            @Override
            public void regionChanged(DocumentRegion r, int index) {
                this.regionRemoved(r);
                this.regionAdded(r, index);
            }

            @Override
            public void regionRemoved(DocumentRegion r) {
                BrowserHistoryPanel.this.removeRegion(r);
            }
        });
    }

    @Override
    protected void performDefaultAction() {
        this.goToRegion();
    }

    @Override
    protected void goToRegion() {
        ArrayList r = this.getSelectedRegions();
        if (r.size() == 1) {
            this._model.getBrowserHistoryManager().setCurrentRegion((DocumentRegion)r.get(0));
            this.updateButtons();
            RegionsListPanel.RegionListUserObj<DocumentRegion> userObj = this.getUserObjForRegion((DocumentRegion)r.get(0));
            if (userObj != null) {
                this._list.ensureIndexIsVisible(this._listModel.indexOf(userObj));
            }
            this._frame.scrollToDocumentAndOffset(((DocumentRegion)r.get(0)).getDocument(), ((DocumentRegion)r.get(0)).getStartOffset(), false, false);
        }
    }

    protected void backRegion() {
        RegionManager<DocumentRegion> rm = this._model.getBrowserHistoryManager();
        this._frame.addToBrowserHistory();
        DocumentRegion r = rm.prevCurrentRegion();
        this.updateButtons();
        RegionsListPanel.RegionListUserObj<DocumentRegion> userObj = this.getUserObjForRegion(r);
        if (userObj != null) {
            this._list.ensureIndexIsVisible(this._listModel.indexOf(userObj));
        }
        this._frame.scrollToDocumentAndOffset(r.getDocument(), r.getStartOffset(), false, false);
    }

    protected void forwardRegion() {
        RegionManager<DocumentRegion> rm = this._model.getBrowserHistoryManager();
        this._frame.addToBrowserHistory();
        DocumentRegion r = rm.nextCurrentRegion();
        this.updateButtons();
        RegionsListPanel.RegionListUserObj<DocumentRegion> userObj = this.getUserObjForRegion(r);
        if (userObj != null) {
            this._list.ensureIndexIsVisible(this._listModel.indexOf(userObj));
        }
        this._frame.scrollToDocumentAndOffset(r.getDocument(), r.getStartOffset(), false, false);
    }

    AbstractAction getBackAction() {
        return this._backAction;
    }

    AbstractAction getForwardAction() {
        return this._forwardAction;
    }

    @Override
    protected JComponent[] makeButtons() {
        this._backAction = new AbstractAction("Back"){

            public void actionPerformed(ActionEvent ae) {
                BrowserHistoryPanel.this.backRegion();
            }
        };
        this._backButton = new JButton(this._backAction);
        this._forwardAction = new AbstractAction("Forward"){

            public void actionPerformed(ActionEvent ae) {
                BrowserHistoryPanel.this.forwardRegion();
            }
        };
        this._forwardButton = new JButton(this._forwardAction);
        AbstractAction goToAction = new AbstractAction("Go to"){

            public void actionPerformed(ActionEvent ae) {
                BrowserHistoryPanel.this.goToRegion();
            }
        };
        this._goToButton = new JButton(goToAction);
        AbstractAction removeAction = new AbstractAction("Remove"){

            public void actionPerformed(ActionEvent ae) {
                Iterator i$ = BrowserHistoryPanel.this.getSelectedRegions().iterator();
                while (i$.hasNext()) {
                    DocumentRegion r = (DocumentRegion)i$.next();
                    BrowserHistoryPanel.this._model.getBrowserHistoryManager().removeRegion(r);
                }
            }
        };
        this._removeButton = new JButton(removeAction);
        AbstractAction removeAllAction = new AbstractAction("Remove All"){

            public void actionPerformed(ActionEvent ae) {
                BrowserHistoryPanel.this._model.getBrowserHistoryManager().clearRegions();
            }
        };
        this._removeAllButton = new JButton(removeAllAction);
        JComponent[] buts = new JComponent[]{this._backButton, this._forwardButton, this._goToButton, this._removeButton, this._removeAllButton};
        return buts;
    }

    @Override
    protected void updateButtons() {
        ArrayList regs = this.getSelectedRegions();
        this._goToButton.setEnabled(regs.size() == 1);
        this._removeButton.setEnabled(regs.size() > 0);
        this._removeAllButton.setEnabled(this._listModel.size() > 0);
        this._backAction.setEnabled(this._listModel.size() > 0 && !this._model.getBrowserHistoryManager().isCurrentRegionFirst());
        this._forwardAction.setEnabled(this._listModel.size() > 0 && !this._model.getBrowserHistoryManager().isCurrentRegionLast());
    }

    protected AbstractAction[] makePopupMenuActions() {
        AbstractAction[] acts = new AbstractAction[]{new AbstractAction("Go to"){

            public void actionPerformed(ActionEvent e) {
                BrowserHistoryPanel.this.goToRegion();
            }
        }, new AbstractAction("Remove"){

            public void actionPerformed(ActionEvent e) {
                Iterator i$ = BrowserHistoryPanel.this.getSelectedRegions().iterator();
                while (i$.hasNext()) {
                    DocumentRegion r = (DocumentRegion)i$.next();
                    BrowserHistoryPanel.this._model.getBrowserHistoryManager().removeRegion(r);
                }
            }
        }};
        return acts;
    }

    @Override
    protected RegionsListPanel.RegionListUserObj<DocumentRegion> getUserObjForRegion(DocumentRegion r) {
        for (int i = 0; i < this._listModel.size(); ++i) {
            RegionsListPanel.RegionListUserObj userObj = (RegionsListPanel.RegionListUserObj)this._listModel.get(i);
            if (userObj.region() != r) continue;
            return userObj;
        }
        return null;
    }

    @Override
    protected RegionsListPanel.RegionListUserObj<DocumentRegion> makeRegionListUserObj(DocumentRegion r) {
        return new BrowserHistoryListUserObj(r);
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class BrowserHistoryListUserObj
    extends RegionsListPanel.RegionListUserObj<DocumentRegion> {
        public BrowserHistoryListUserObj(DocumentRegion r) {
            super(r);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer();
            this._region.getDocument().acquireReadLock();
            try {
                sb.append("<html>");
                if (this._region == BrowserHistoryPanel.this._model.getBrowserHistoryManager().getCurrentRegion()) {
                    sb.append("<font color=\"red\">");
                }
                sb.append(this._region.getDocument().toString());
                sb.append(':');
                sb.append(this.lineNumber());
                try {
                    sb.append(": ");
                    int length = Math.min(120, this._region.getEndOffset() - this._region.getStartOffset());
                    sb.append(this._region.getDocument().getText(this._region.getStartOffset(), length).trim());
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
                if (this._region.equals(BrowserHistoryPanel.this._model.getBrowserHistoryManager().getCurrentRegion())) {
                    sb.append("</font>");
                }
                sb.append("</html>");
            }
            finally {
                this._region.getDocument().releaseReadLock();
            }
            return sb.toString();
        }

        @Override
        public boolean equals(Object other) {
            BrowserHistoryListUserObj o = (BrowserHistoryListUserObj)other;
            return o.region().getDocument().equals(this.region().getDocument()) && o.region().getStartOffset() == this.region().getStartOffset() && o.region().getEndOffset() == this.region().getEndOffset();
        }
    }
}

