/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.repl;

import edu.rice.cs.drjava.model.repl.History;
import edu.rice.cs.drjava.model.repl.InputListener;
import edu.rice.cs.drjava.model.repl.InteractionsDocument;
import edu.rice.cs.drjava.model.repl.InteractionsEventNotifier;
import edu.rice.cs.drjava.model.repl.InteractionsListener;
import edu.rice.cs.drjava.model.repl.InteractionsModelCallback;
import edu.rice.cs.drjava.model.repl.InteractionsScriptModel;
import edu.rice.cs.plt.tuple.Pair;
import edu.rice.cs.util.ArgumentTokenizer;
import edu.rice.cs.util.FileOpenSelector;
import edu.rice.cs.util.OperationCanceledException;
import edu.rice.cs.util.StringOps;
import edu.rice.cs.util.UnexpectedException;
import edu.rice.cs.util.text.ConsoleDocument;
import edu.rice.cs.util.text.ConsoleDocumentInterface;
import edu.rice.cs.util.text.EditDocumentException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class InteractionsModel
implements InteractionsModelCallback {
    public static final String BANNER_PREFIX = "Welcome to DrJava.";
    public static final String _newLine = "\n";
    protected final InteractionsEventNotifier _notifier = new InteractionsEventNotifier();
    protected final InteractionsDocument _document;
    protected volatile boolean _waitingForFirstInterpreter;
    protected volatile File _workingDirectory;
    private final Object _interpreterLock;
    public final Object _writerLock;
    private final int _writeDelay;
    private volatile int _debugPort;
    private volatile boolean _debugPortSet;
    private volatile String _toAddToHistory = "";
    protected volatile InputListener _inputListener;
    protected final ConsoleDocumentInterface _adapter;
    private volatile String _banner;
    protected volatile Pair<String, String> _lastError = null;
    protected volatile Pair<String, String> _secondToLastError = null;

    public InteractionsModel(ConsoleDocumentInterface adapter, File wd, int historySize, int writeDelay) {
        this._writeDelay = writeDelay;
        this._document = new InteractionsDocument(adapter, historySize, InteractionsModel.getBanner(wd));
        this._adapter = adapter;
        this._waitingForFirstInterpreter = true;
        this._workingDirectory = wd;
        this._interpreterLock = new Object();
        this._writerLock = new Object();
        this._debugPort = -1;
        this._debugPortSet = false;
        this._inputListener = NoInputListener.ONLY;
    }

    public void addListener(InteractionsListener listener) {
        this._notifier.addListener(listener);
    }

    public void removeListener(InteractionsListener listener) {
        this._notifier.removeListener(listener);
    }

    public void removeAllInteractionListeners() {
        this._notifier.removeAllListeners();
    }

    public InteractionsDocument getDocument() {
        return this._document;
    }

    public void interactionContinues() {
        this._document.setInProgress(false);
        this._notifyInteractionEnded();
        this._notifyInteractionIncomplete();
    }

    public void setWaitingForFirstInterpreter(boolean waiting) {
        this._waitingForFirstInterpreter = waiting;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interpretCurrentInteraction() {
        Object object = this._interpreterLock;
        synchronized (object) {
            if (this._document.inProgress()) {
                return;
            }
            String text = this._document.getCurrentInteraction();
            String toEval = text.trim();
            if (toEval.startsWith("java ")) {
                toEval = InteractionsModel._testClassCall(toEval);
            }
            this._prepareToInterpret(text);
            this.interpret(toEval);
        }
    }

    private void _prepareToInterpret(String text) {
        this.addNewLine();
        this._notifyInteractionStarted();
        this._document.setInProgress(true);
        this._toAddToHistory = text;
    }

    public void addNewLine() {
        this.append(_newLine, "default");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void interpret(String toEval) {
        Object object = this._interpreterLock;
        synchronized (object) {
            this._interpret(toEval);
        }
    }

    protected abstract void _interpret(String var1);

    protected abstract void _notifyInteractionIncomplete();

    protected abstract void _notifyInteractionStarted();

    public abstract String getVariableToString(String var1);

    public abstract String getVariableClassName(String var1);

    public final void resetInterpreter(File wd) {
        this._workingDirectory = wd;
        this._resetInterpreter(wd);
    }

    protected abstract void _resetInterpreter(File var1);

    public File getWorkingDirectory() {
        return this._workingDirectory;
    }

    public abstract void addProjectClassPath(File var1);

    public abstract void addBuildDirectoryClassPath(File var1);

    public abstract void addProjectFilesClassPath(File var1);

    public abstract void addExternalFilesClassPath(File var1);

    public abstract void addExtraClassPath(File var1);

    protected abstract void _notifySyntaxErrorOccurred(int var1, int var2);

    protected ArrayList<String> _getHistoryText(FileOpenSelector selector) throws IOException, OperationCanceledException {
        File[] files = selector.getFiles();
        if (files == null) {
            throw new IOException("No Files returned from FileSelector");
        }
        ArrayList<String> histories = new ArrayList<String>();
        ArrayList<String> strings = new ArrayList<String>();
        for (File f : files) {
            if (f == null) {
                throw new IOException("File name returned from FileSelector is null");
            }
            try {
                String line;
                FileInputStream fis = new FileInputStream(f);
                InputStreamReader isr = new InputStreamReader(fis);
                BufferedReader br = new BufferedReader(isr);
                while ((line = br.readLine()) != null) {
                    strings.add(line);
                }
                br.close();
            }
            catch (IOException ioe) {
                throw new IOException("File name returned from FileSelector is null");
            }
            StringBuffer text = new StringBuffer();
            boolean firstLine = true;
            int formatVersion = 1;
            for (String s : strings) {
                int sl = s.length();
                if (sl <= 0) continue;
                if (firstLine && s.trim().equals(History.HISTORY_FORMAT_VERSION_2.trim())) {
                    formatVersion = 2;
                }
                switch (formatVersion) {
                    case 1: {
                        text.append(s);
                        if (s.charAt(sl - 1) != ';') {
                            text.append(';');
                        }
                        text.append(StringOps.EOL);
                        break;
                    }
                    case 2: {
                        if (firstLine) break;
                        text.append(s).append(StringOps.EOL);
                    }
                }
                firstLine = false;
            }
            histories.add(text.toString());
        }
        return histories;
    }

    protected ArrayList<String> _removeSeparators(String text) {
        String sep = "//End of Interaction//";
        int len = sep.length();
        ArrayList<String> interactions = new ArrayList<String>();
        int index = text.indexOf(sep);
        int lastIndex = 0;
        while (index != -1) {
            interactions.add(text.substring(lastIndex, index).trim());
            lastIndex = index + len;
            index = text.indexOf(sep, lastIndex);
        }
        String last = text.substring(lastIndex, text.length()).trim();
        if (!"".equals(last)) {
            interactions.add(last);
        }
        return interactions;
    }

    public void loadHistory(FileOpenSelector selector) throws IOException {
        ArrayList<String> histories;
        try {
            histories = this._getHistoryText(selector);
        }
        catch (OperationCanceledException oce) {
            return;
        }
        this._document.clearCurrentInteraction();
        StringBuffer buf = new StringBuffer();
        for (String hist : histories) {
            ArrayList<String> interactions = this._removeSeparators(hist);
            for (String curr : interactions) {
                int len = curr.length();
                buf.append(curr);
                if (len > 0 && curr.charAt(len - 1) != ';') {
                    buf.append(';');
                }
                buf.append(StringOps.EOL);
            }
        }
        this.append(buf.toString().trim(), "default");
        this.interpretCurrentInteraction();
    }

    public InteractionsScriptModel loadHistoryAsScript(FileOpenSelector selector) throws IOException, OperationCanceledException {
        ArrayList<String> histories = this._getHistoryText(selector);
        ArrayList<String> interactions = new ArrayList<String>();
        for (String hist : histories) {
            interactions.addAll(this._removeSeparators(hist));
        }
        return new InteractionsScriptModel(this, interactions);
    }

    @Override
    public int getDebugPort() throws IOException {
        if (!this._debugPortSet) {
            this._createNewDebugPort();
        }
        return this._debugPort;
    }

    protected void _createNewDebugPort() throws IOException {
        try {
            ServerSocket socket = new ServerSocket(0);
            this._debugPort = socket.getLocalPort();
            socket.close();
        }
        catch (SocketException se) {
            this._debugPort = -1;
        }
        this._debugPortSet = true;
        System.setProperty("drjava.debug.port", String.valueOf(this._debugPort));
    }

    public void setDebugPort(int port) {
        this._debugPort = port;
        this._debugPortSet = true;
    }

    @Override
    public void replSystemOutPrint(String s) {
        this._document.insertBeforeLastPrompt(s, "System.out");
        this._writerDelay();
    }

    @Override
    public void replSystemErrPrint(String s) {
        this._document.insertBeforeLastPrompt(s, "System.err");
        this._writerDelay();
    }

    @Override
    public String getConsoleInput() {
        return this._inputListener.getConsoleInput();
    }

    @Override
    public void setInputListener(InputListener listener) {
        if (this._inputListener != NoInputListener.ONLY) {
            throw new IllegalStateException("Cannot change the input listener until it is released.");
        }
        this._inputListener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changeInputListener(InputListener oldListener, InputListener newListener) {
        NoInputListener noInputListener = NoInputListener.ONLY;
        synchronized (noInputListener) {
            if (this._inputListener != oldListener) {
                throw new IllegalArgumentException("The given old listener is not installed!");
            }
            this._inputListener = newListener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _interactionIsOver() {
        this._document.acquireWriteLock();
        try {
            this._document.addToHistory(this._toAddToHistory);
            this._document.setInProgress(false);
            this._document.insertPrompt();
        }
        finally {
            this._document.releaseWriteLock();
        }
        this._notifyInteractionEnded();
    }

    protected abstract void _notifyInteractionEnded();

    public void append(String s, String styleName) {
        this._document.append(s, styleName);
        this._writerDelay();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _writerDelay() {
        Object object = this._writerLock;
        synchronized (object) {
            try {
                this._writerLock.wait(this._writeDelay);
            }
            catch (EditDocumentException e) {
                throw new UnexpectedException(e);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @Override
    public void replReturnedVoid() {
        this._secondToLastError = this._lastError;
        this._lastError = null;
        this._interactionIsOver();
    }

    @Override
    public void replReturnedResult(String result, String style) {
        this._secondToLastError = this._lastError;
        this._lastError = null;
        this.append(new StringBuffer().append(result).append(_newLine).toString(), style);
        this._interactionIsOver();
    }

    @Override
    public void replThrewException(String exceptionClass, String message, String stackTrace, String shortMessage) {
        if (shortMessage != null && shortMessage.endsWith("<EOF>\"")) {
            this.interactionContinues();
            return;
        }
        this._document.appendExceptionResult(exceptionClass, message, stackTrace, "error");
        this._secondToLastError = this._lastError;
        this._lastError = new Pair<String, String>(exceptionClass, message);
        this._interactionIsOver();
    }

    @Override
    public void replReturnedSyntaxError(String errorMessage, String interaction, int startRow, int startCol, int endRow, int endCol) {
        this._secondToLastError = this._lastError;
        this._lastError = new Pair<String, String>("koala.dynamicjava.parser.ParserException", errorMessage);
        if (errorMessage != null && errorMessage.endsWith("<EOF>\"")) {
            this.interactionContinues();
            return;
        }
        Pair<Integer, Integer> oAndL = StringOps.getOffsetAndLength(interaction, startRow, startCol, endRow, endCol);
        this._notifySyntaxErrorOccurred(this._document.getPromptPos() + oAndL.first(), oAndL.second());
        this._document.appendSyntaxErrorResult(errorMessage, interaction, startRow, startCol, endRow, endCol, "error");
        this._interactionIsOver();
    }

    @Override
    public void replCalledSystemExit(int status) {
        this._notifyInterpreterExited(status);
    }

    protected abstract void _notifyInterpreterExited(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void interpreterResetting() {
        if (!this._waitingForFirstInterpreter) {
            this._document.acquireWriteLock();
            try {
                this._document.insertBeforeLastPrompt("Resetting Interactions ...\n", "error");
                this._document.setInProgress(true);
            }
            finally {
                this._document.releaseWriteLock();
            }
            try {
                this._createNewDebugPort();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this._notifyInterpreterResetting();
        }
    }

    protected abstract void _notifyInterpreterResetting();

    @Override
    public void interpreterResetFailed(Throwable t) {
        this._interpreterResetFailed(t);
        this._document.setInProgress(false);
        this._notifyInterpreterResetFailed(t);
    }

    protected abstract void _interpreterResetFailed(Throwable var1);

    protected abstract void _notifyInterpreterResetFailed(Throwable var1);

    public String getBanner() {
        return this._banner;
    }

    public String getStartUpBanner() {
        return InteractionsModel.getBanner(this._workingDirectory);
    }

    public static String getBanner(File wd) {
        return new StringBuffer().append("Welcome to DrJava.  Working directory is ").append(wd).append('\n').toString();
    }

    private String generateBanner(File wd) {
        this._banner = InteractionsModel.getBanner(wd);
        return this._banner;
    }

    @Override
    public void interpreterReady(File wd) {
        if (!this._waitingForFirstInterpreter) {
            this._document.reset(this.generateBanner(wd));
            this._document.setInProgress(false);
            this._notifyInterpreterReady(wd);
        }
        this._waitingForFirstInterpreter = false;
    }

    public abstract void _notifyInterpreterReady(File var1);

    @Override
    public void slaveJVMUsed() {
        this._notifySlaveJVMUsed();
    }

    protected abstract void _notifySlaveJVMUsed();

    protected static String _testClassCall(String s) {
        if (s.endsWith(";")) {
            s = InteractionsModel._deleteSemiColon(s);
        }
        List<String> args = ArgumentTokenizer.tokenize(s, true);
        boolean seenArg = false;
        String className = args.get(1);
        StringBuffer mainCall = new StringBuffer();
        mainCall.append(className.substring(1, className.length() - 1));
        mainCall.append(".main(new String[]{");
        for (int i = 2; i < args.size(); ++i) {
            if (seenArg) {
                mainCall.append(",");
            } else {
                seenArg = true;
            }
            mainCall.append(args.get(i));
        }
        mainCall.append("});");
        return mainCall.toString();
    }

    protected static String _deleteSemiColon(String s) {
        return s.substring(0, s.length() - 1);
    }

    public abstract ConsoleDocument getConsoleDocument();

    public Pair<String, String> getLastError() {
        return this._lastError;
    }

    public Pair<String, String> getSecondToLastError() {
        return this._secondToLastError;
    }

    public void resetLastErrors() {
        this._secondToLastError = null;
        this._lastError = null;
    }

    public String removeLastFromHistory() {
        return this._document.removeLastFromHistory();
    }

    private static class NoInputListener
    implements InputListener {
        public static final NoInputListener ONLY = new NoInputListener();

        private NoInputListener() {
        }

        public String getConsoleInput() {
            throw new IllegalStateException("No input listener installed!");
        }
    }
}

