/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.debug.jpda;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.request.BreakpointRequest;
import edu.rice.cs.drjava.model.OpenDefinitionsDocument;
import edu.rice.cs.drjava.model.debug.Breakpoint;
import edu.rice.cs.drjava.model.debug.DebugException;
import edu.rice.cs.drjava.model.debug.jpda.DocumentDebugAction;
import edu.rice.cs.drjava.model.debug.jpda.JPDADebugger;
import edu.rice.cs.util.UnexpectedException;
import java.util.List;
import java.util.Vector;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPDABreakpoint
extends DocumentDebugAction<BreakpointRequest>
implements Breakpoint {
    private volatile Position _startPos;
    private volatile Position _endPos;

    public JPDABreakpoint(OpenDefinitionsDocument doc, int offset, int lineNumber, boolean isEnabled, JPDADebugger manager) throws DebugException {
        super(manager, doc, offset);
        this._suspendPolicy = 1;
        this._lineNumber = lineNumber;
        this._isEnabled = isEnabled;
        try {
            this._startPos = doc.createPosition(doc.getLineStartPos(offset));
            this._endPos = doc.createPosition(doc.getLineEndPos(offset));
        }
        catch (BadLocationException ble) {
            throw new UnexpectedException(ble);
        }
        if (this._manager != null && this._manager.isReady()) {
            Vector<ReferenceType> refTypes = this._manager.getReferenceTypes(this._className, this._lineNumber);
            this._initializeRequests(refTypes);
            this.setEnabled(isEnabled);
        }
    }

    @Override
    protected void _createRequests(Vector<ReferenceType> refTypes) throws DebugException {
        try {
            for (int i = 0; i < refTypes.size(); ++i) {
                ReferenceType rt = refTypes.get(i);
                if (!rt.isPrepared()) continue;
                List<Location> lines = rt.locationsOfLine(this._lineNumber);
                if (lines.size() == 0) {
                    this.setEnabled(false);
                    throw new DebugException(new StringBuffer().append("Could not find line number: ").append(this._lineNumber).toString());
                }
                Location loc = lines.get(0);
                BreakpointRequest request = this._manager.getEventRequestManager().createBreakpointRequest(loc);
                request.setEnabled(this._isEnabled);
                this._requests.add(request);
            }
        }
        catch (AbsentInformationException aie) {
            throw new DebugException(new StringBuffer().append("Could not find line number: ").append(aie).toString());
        }
    }

    @Override
    public int getStartOffset() {
        return this._startPos.getOffset();
    }

    @Override
    public int getEndOffset() {
        return this._endPos.getOffset();
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        boolean old = this._isEnabled;
        super.setEnabled(isEnabled);
        try {
            for (BreakpointRequest bpr : this._requests) {
                bpr.setEnabled(isEnabled);
            }
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            // empty catch block
        }
        if (this._isEnabled != old) {
            this._manager.notifyBreakpointChange(this);
        }
    }

    public String toString() {
        String cn = this.getClassName();
        if (this._exactClassName != null) {
            cn = this._exactClassName.replace('$', '.');
        }
        if (this._requests.size() > 0) {
            return new StringBuffer().append("Breakpoint[class: ").append(cn).append(", lineNumber: ").append(this.getLineNumber()).append(", method: ").append(((BreakpointRequest)this._requests.get(0)).location().method()).append(", codeIndex: ").append(((BreakpointRequest)this._requests.get(0)).location().codeIndex()).append(", numRefTypes: ").append(this._requests.size()).append("]").toString();
        }
        return new StringBuffer().append("Breakpoint[class: ").append(cn).append(", lineNumber: ").append(this.getLineNumber()).append("]").toString();
    }
}

