/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.debug.jpda;

import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.EventIterator;
import com.sun.jdi.event.EventQueue;
import com.sun.jdi.event.EventSet;
import com.sun.jdi.event.StepEvent;
import com.sun.jdi.event.ThreadDeathEvent;
import com.sun.jdi.event.ThreadStartEvent;
import com.sun.jdi.event.VMDeathEvent;
import com.sun.jdi.event.VMDisconnectEvent;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.StepRequest;
import edu.rice.cs.drjava.model.debug.DebugException;
import edu.rice.cs.drjava.model.debug.jpda.JPDADebugger;
import edu.rice.cs.util.Log;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.List;

public class EventHandlerThread
extends Thread {
    private final JPDADebugger _debugger;
    private final VirtualMachine _vm;
    private volatile boolean _connected;
    private static final Log _log = new Log("EventTest", false);

    EventHandlerThread(JPDADebugger debugger, VirtualMachine vm) {
        super("DrJava Debug Event Handler");
        this._debugger = debugger;
        this._vm = vm;
        this._connected = true;
    }

    private void _log(String message) {
        _log.log(message);
    }

    private void _log(String message, Throwable t) {
        _log.log(message, t);
    }

    public void run() {
        this._debugger.notifyDebuggerStarted();
        EventQueue queue = this._vm.eventQueue();
        while (this._connected) {
            try {
                try {
                    EventSet eventSet = queue.remove();
                    EventIterator it = eventSet.eventIterator();
                    while (it.hasNext()) {
                        this.handleEvent(it.nextEvent());
                    }
                }
                catch (InterruptedException ie) {
                    this._log("InterruptedException in main loop: " + ie);
                }
                catch (VMDisconnectedException de) {
                    this.handleDisconnectedException();
                    break;
                }
            }
            catch (Exception e) {
                this._log("Exception in main event handler loop.", e);
                this._debugger.eventHandlerError(e);
                this._debugger.printMessage("An exception occurred in the event handler:\n" + e);
                this._debugger.printMessage("The debugger may have become unstable as a result.");
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                e.printStackTrace(new PrintWriter(baos, true));
                this._debugger.printMessage("Stack trace: " + baos.toString());
            }
        }
        this._debugger.notifyDebuggerShutdown();
    }

    private void handleEvent(Event e) throws DebugException {
        this._log("handling event: " + e);
        if (e instanceof BreakpointEvent) {
            this._handleBreakpointEvent((BreakpointEvent)e);
        } else if (e instanceof StepEvent) {
            this._handleStepEvent((StepEvent)e);
        } else if (e instanceof ClassPrepareEvent) {
            this._handleClassPrepareEvent((ClassPrepareEvent)e);
        } else if (e instanceof ThreadStartEvent) {
            this._handleThreadStartEvent((ThreadStartEvent)e);
        } else if (e instanceof ThreadDeathEvent) {
            this._handleThreadDeathEvent((ThreadDeathEvent)e);
        } else if (e instanceof VMDeathEvent) {
            this._handleVMDeathEvent((VMDeathEvent)e);
        } else if (e instanceof VMDisconnectEvent) {
            this._handleVMDisconnectEvent((VMDisconnectEvent)e);
        } else {
            throw new DebugException("Unexpected event type: " + e);
        }
    }

    private boolean _isSuspendedWithFrames(ThreadReference thread) throws DebugException {
        try {
            return thread.isSuspended() && thread.frameCount() > 0;
        }
        catch (IncompatibleThreadStateException itse) {
            throw new DebugException("Could not count frames on a suspended thread: " + itse);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _handleBreakpointEvent(BreakpointEvent e) throws DebugException {
        JPDADebugger jPDADebugger = this._debugger;
        synchronized (jPDADebugger) {
            if (this._isSuspendedWithFrames(e.thread()) && this._debugger.setCurrentThread(e.thread())) {
                this._debugger.currThreadSuspended();
                this._debugger.reachedBreakpoint((BreakpointRequest)e.request());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _handleStepEvent(StepEvent e) throws DebugException {
        this._debugger.preloadDocument(e.location());
        JPDADebugger jPDADebugger = this._debugger;
        synchronized (jPDADebugger) {
            if (this._isSuspendedWithFrames(e.thread()) && this._debugger.setCurrentThread(e.thread())) {
                this._debugger.printMessage("Stepped to " + e.location().declaringType().name() + "." + e.location().method().name() + "(...)  [line " + e.location().lineNumber() + "]");
                this._debugger.currThreadSuspended();
            }
            this._debugger.getEventRequestManager().deleteEventRequest(e.request());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _handleClassPrepareEvent(ClassPrepareEvent e) throws DebugException {
        JPDADebugger jPDADebugger = this._debugger;
        synchronized (jPDADebugger) {
            this._debugger.getPendingRequestManager().classPrepared(e);
            e.thread().resume();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _handleThreadStartEvent(ThreadStartEvent e) {
        JPDADebugger jPDADebugger = this._debugger;
        synchronized (jPDADebugger) {
            this._debugger.threadStarted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _handleThreadDeathEvent(ThreadDeathEvent e) throws DebugException {
        JPDADebugger jPDADebugger = this._debugger;
        synchronized (jPDADebugger) {
            ThreadReference running = this._debugger.getCurrentRunningThread();
            if (e.thread().equals(running)) {
                EventRequestManager erm = this._vm.eventRequestManager();
                List<StepRequest> steps = erm.stepRequests();
                for (int i = 0; i < steps.size(); ++i) {
                    StepRequest step = steps.get(i);
                    if (!step.thread().equals(e.thread())) continue;
                    erm.deleteEventRequest(step);
                    break;
                }
                this._debugger.currThreadDied();
            } else {
                this._debugger.nonCurrThreadDied();
            }
        }
        e.thread().resume();
    }

    private void _handleVMDeathEvent(VMDeathEvent e) throws DebugException {
        this._cleanUp(e);
    }

    private void _handleVMDisconnectEvent(VMDisconnectEvent e) throws DebugException {
        this._cleanUp(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _cleanUp(Event e) throws DebugException {
        JPDADebugger jPDADebugger = this._debugger;
        synchronized (jPDADebugger) {
            this._connected = false;
            if (this._debugger.isReady()) {
                this._debugger.shutdown();
            }
        }
    }

    private void handleDisconnectedException() throws DebugException {
        EventQueue queue = this._vm.eventQueue();
        while (this._connected) {
            try {
                EventSet eventSet = queue.remove();
                EventIterator iter = eventSet.eventIterator();
                while (iter.hasNext()) {
                    Event event = iter.nextEvent();
                    if (event instanceof VMDeathEvent) {
                        this._handleVMDeathEvent((VMDeathEvent)event);
                        continue;
                    }
                    if (!(event instanceof VMDisconnectEvent)) continue;
                    this._handleVMDisconnectEvent((VMDisconnectEvent)event);
                }
                eventSet.resume();
            }
            catch (InterruptedException ie) {
                this._log("InterruptedException after a disconnected exception.", ie);
            }
            catch (VMDisconnectedException de) {
                this._log("A second VMDisconnectedException.", de);
            }
        }
    }
}

