/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.config;

import edu.rice.cs.drjava.config.Option;
import edu.rice.cs.drjava.config.OptionParseException;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public class FileOption
extends Option<File> {
    public static final File NULL_FILE = new File(""){

        public boolean canRead() {
            return false;
        }

        public boolean canWrite() {
            return false;
        }

        public int compareTo(File f) {
            return f == this ? 0 : -1;
        }

        public boolean createNewFile() {
            return false;
        }

        public boolean delete() {
            return false;
        }

        public void deleteOnExit() {
        }

        public boolean equals(Object o) {
            return o == this;
        }

        public boolean exists() {
            return true;
        }

        public File getAbsoluteFile() {
            return this;
        }

        public String getAbsolutePath() {
            return "";
        }

        public File getCanonicalFile() {
            return this;
        }

        public String getCanonicalPath() {
            return "";
        }

        public String getName() {
            return "";
        }

        public String getParent() {
            return null;
        }

        public File getParentFile() {
            return null;
        }

        public String getPath() {
            return "";
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }

        public boolean isAbsolute() {
            return false;
        }

        public boolean isDirectory() {
            return false;
        }

        public boolean isFile() {
            return false;
        }

        public boolean isHidden() {
            return false;
        }

        public long lastModified() {
            return 0L;
        }

        public long length() {
            return 0L;
        }

        public String[] list() {
            return null;
        }

        public String[] list(FilenameFilter filter) {
            return null;
        }

        public File[] listFiles() {
            return null;
        }

        public File[] listFiles(FileFilter filter) {
            return null;
        }

        public File[] listFiles(FilenameFilter filter) {
            return null;
        }

        public boolean mkdir() {
            return false;
        }

        public boolean mkdirs() {
            return false;
        }

        public boolean renameTo(File dest) {
            return false;
        }

        public boolean setLastModified(long time) {
            return false;
        }

        public boolean setReadOnly() {
            return false;
        }

        public String toString() {
            return "";
        }

        public int compareTo(Object x0) {
            return this.compareTo((File)x0);
        }
    };

    public FileOption(String key, File def) {
        super(key, def);
    }

    @Override
    public File parse(String s) {
        if (s.trim().equals("")) {
            return NULL_FILE;
        }
        try {
            return new File(s).getAbsoluteFile();
        }
        catch (NullPointerException e) {
            throw new OptionParseException(this.name, s, "Must have a legal filename.");
        }
    }

    @Override
    public String format(File f) {
        return f.getAbsolutePath();
    }

    @Override
    public String format(Object x0) {
        return this.format((File)x0);
    }

    @Override
    public Object parse(String x0) {
        return this.parse(x0);
    }
}

