/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.config;

import edu.rice.cs.drjava.config.Option;
import edu.rice.cs.drjava.config.OptionParseException;
import java.awt.Color;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public class ColorOption
extends Option<Color> {
    public ColorOption(String key, Color def) {
        super(key, def);
    }

    @Override
    public Color parse(String s) {
        try {
            return Color.decode(s);
        }
        catch (NumberFormatException nfe) {
            throw new OptionParseException(this.name, s, "Must be a string that represents an opaque color as a 24-bit integer.");
        }
    }

    @Override
    public String format(Color c) {
        int len = 6;
        String str = Integer.toHexString(c.getRGB() & 0xFFFFFF);
        StringBuffer buff = new StringBuffer(str);
        for (int i = 0; i < len - str.length(); ++i) {
            buff.insert(0, '0');
        }
        buff.insert(0, '#');
        return buff.toString();
    }

    @Override
    public String format(Object x0) {
        return this.format((Color)x0);
    }

    @Override
    public Object parse(String x0) {
        return this.parse(x0);
    }
}

