/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.model.AlreadyOpenException;
import edu.rice.cs.drjava.model.FileMovedException;
import edu.rice.cs.drjava.platform.PlatformFactory;
import edu.rice.cs.drjava.ui.DrJavaErrorHandler;
import edu.rice.cs.drjava.ui.DrJavaErrorWindow;
import edu.rice.cs.drjava.ui.MainFrame;
import edu.rice.cs.drjava.ui.SimpleInteractionsWindow;
import edu.rice.cs.util.FileOpenSelector;
import edu.rice.cs.util.OutputStreamRedirector;
import edu.rice.cs.util.UnexpectedException;
import edu.rice.cs.util.swing.Utilities;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class DrJavaRoot {
    public static final int FULL_JAVA = 0;
    public static final int ELEMENTARY_LEVEL = 1;
    public static final int INTERMEDIATE_LEVEL = 2;
    public static final int ADVANCED_LEVEL = 3;
    public static final String[] LANGUAGE_LEVEL_EXTENSIONS = new String[]{"java", "dj0", "dj1", "dj2"};
    public static final String TEST_DEBUGGER_CLASS = "com.sun.jdi.Bootstrap";
    private static final PrintStream _consoleOut = System.out;
    private static final PrintStream _consoleErr = System.err;
    private static boolean _attemptingAugmentedClassPath = false;
    private static SimpleInteractionsWindow _debugConsole = null;
    private static boolean anyLineNumbersSpecified = false;
    private static MainFrame _mainFrame = null;

    public static void main(String[] args) {
        PlatformFactory.ONLY.beforeUISetup();
        if (!DrJava.handleCommandLineArgs(args)) {
            System.exit(0);
        }
        final String[] filesToOpen = DrJava.getFilesToOpen();
        final int numFiles = filesToOpen.length;
        try {
            String configLAFName = DrJava.getConfig().getSetting(OptionConstants.LOOK_AND_FEEL);
            String currLAFName = UIManager.getLookAndFeel().getClass().getName();
            if (!configLAFName.equals(currLAFName)) {
                UIManager.setLookAndFeel(configLAFName);
            }
            _mainFrame = new MainFrame();
            DrJavaErrorWindow.setFrame(_mainFrame);
            System.setProperty("sun.awt.exception.handler", "edu.rice.cs.drjava.ui.DrJavaErrorHandler");
            DrJavaRoot._openCommandLineFiles(_mainFrame, filesToOpen, numFiles, false);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DrJavaRoot.access$000().start();
                    if (DrJavaRoot.access$100()) {
                        DrJavaRoot.access$200(DrJavaRoot.access$000(), filesToOpen, numFiles, true);
                    }
                }
            });
            System.setOut(new PrintStream(new OutputStreamRedirector(){

                public void print(String s) {
                    DrJavaRoot.access$000().getModel().systemOutPrint(s);
                }
            }));
            System.setErr(new PrintStream(new OutputStreamRedirector(){

                public void print(String s) {
                    DrJavaRoot.access$000().getModel().systemErrPrint(s);
                }
            }));
            if (DrJava.getShowDebugConsole()) {
                DrJavaRoot.showDrJavaDebugConsole(_mainFrame);
            }
        }
        catch (Throwable t) {
            _consoleErr.println(t.getClass().getName() + ": " + t.getMessage());
            t.printStackTrace(_consoleErr);
            System.out.println("error thrown");
            new DrJavaErrorHandler().handle(t);
        }
    }

    static void openCommandLineFiles(MainFrame mf, String[] filesToOpen, boolean jump) {
        DrJavaRoot.openCommandLineFiles(mf, filesToOpen, filesToOpen.length, jump);
    }

    static void openCommandLineFiles(final MainFrame mf, final String[] filesToOpen, final int len, final boolean jump) {
        Utilities.invokeAndWait(new Runnable(){

            public void run() {
                DrJavaRoot.access$200(mf, filesToOpen, len, jump);
            }
        });
    }

    private static void _openCommandLineFiles(final MainFrame mf, String[] filesToOpen, int len, boolean jump) {
        anyLineNumbersSpecified = false;
        for (int i = 0; i < len; ++i) {
            String currFileName = filesToOpen[i];
            int lineNo = -1;
            int pathSepIndex = currFileName.indexOf(File.pathSeparatorChar);
            if (pathSepIndex >= 0) {
                try {
                    lineNo = new Integer(currFileName.substring(pathSepIndex + 1));
                    anyLineNumbersSpecified = true;
                }
                catch (NumberFormatException nfe) {
                    lineNo = -1;
                }
                currFileName = currFileName.substring(0, pathSepIndex);
            }
            boolean isProjectFile = currFileName.endsWith(".pjt");
            final File file = new File(currFileName).getAbsoluteFile();
            FileOpenSelector command = new FileOpenSelector(){

                public File[] getFiles() {
                    return new File[]{file};
                }
            };
            try {
                if (isProjectFile) {
                    mf.openProject(command);
                    continue;
                }
                if (jump && lineNo >= 0) {
                    mf.open(command);
                    final int l = lineNo;
                    Utilities.invokeLater(new Runnable(){

                        public void run() {
                            mf._jumpToLine(l);
                        }
                    });
                    continue;
                }
                mf.getModel().openFile(command);
                continue;
            }
            catch (FileNotFoundException ex) {
                continue;
            }
            catch (SecurityException se) {
                continue;
            }
            catch (AlreadyOpenException aoe) {
                continue;
            }
            catch (FileMovedException aoe) {
                continue;
            }
            catch (IOException ex) {
                continue;
            }
            catch (Exception ex) {
                throw new UnexpectedException(ex);
            }
        }
    }

    public static void showDrJavaDebugConsole(MainFrame mf) {
        if (_debugConsole == null) {
            _debugConsole = new SimpleInteractionsWindow("DrJava Debug Console"){

                protected void close() {
                    this.dispose();
                    DrJavaRoot.access$302(null);
                }
            };
            _debugConsole.defineConstant("mainFrame", mf);
            _debugConsole.defineConstant("model", mf.getModel());
            _debugConsole.defineConstant("config", DrJava.getConfig());
            _debugConsole.setInterpreterPrivateAccessible(true);
            _debugConsole.setVisible(true);
        } else {
            _debugConsole.toFront();
        }
    }

    public static PrintStream consoleErr() {
        return _consoleErr;
    }

    public static PrintStream consoleOut() {
        return _consoleOut;
    }

    public static void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        _mainFrame.dragEnter(dropTargetDragEvent);
    }

    public static void drop(DropTargetDropEvent dropTargetDropEvent) {
        _mainFrame.drop(dropTargetDropEvent);
    }

    static MainFrame access$000() {
        return _mainFrame;
    }

    static boolean access$100() {
        return anyLineNumbersSpecified;
    }

    static void access$200(MainFrame x0, String[] x1, int x2, boolean x3) {
        DrJavaRoot._openCommandLineFiles(x0, x1, x2, x3);
    }

    static SimpleInteractionsWindow access$302(SimpleInteractionsWindow x0) {
        _debugConsole = x0;
        return _debugConsole;
    }
}

