/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.tree;

import koala.dynamicjava.tree.Literal;

public class IntegerLiteral
extends Literal {
    public IntegerLiteral(String rep) {
        this(rep, null, 0, 0, 0, 0);
    }

    public IntegerLiteral(String rep, String fn, int bl, int bc, int el, int ec) {
        super(rep, IntegerLiteral.parse(rep), Integer.TYPE, fn, bl, bc, el, ec);
    }

    private static Integer parse(String s) {
        if (s.startsWith("0x")) {
            return IntegerLiteral.parseHexadecimal(s.substring(2, s.length()));
        }
        if (s.startsWith("0")) {
            return IntegerLiteral.parseOctal(s);
        }
        return Integer.valueOf(s);
    }

    private static Integer parseHexadecimal(String s) {
        int value = 0;
        for (int i = 0; i < s.length(); ++i) {
            char c = Character.toLowerCase(s.charAt(i));
            if (value >>> 28 != 0) {
                throw new NumberFormatException(s);
            }
            value = (value << 4) + c + (c >= 'a' && c <= 'f' ? -87 : -48);
        }
        return new Integer(value);
    }

    private static Integer parseOctal(String s) {
        int value = 0;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (value >>> 29 != 0) {
                throw new NumberFormatException(s);
            }
            value = (value << 3) + c - 48;
        }
        return new Integer(value);
    }
}

