/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.interpreter;

import java.lang.constant.Constable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import koala.dynamicjava.interpreter.InterpreterUtilities;
import koala.dynamicjava.interpreter.NodeProperties;
import koala.dynamicjava.interpreter.TypeChecker14;
import koala.dynamicjava.interpreter.TypeChecker15;
import koala.dynamicjava.interpreter.context.Context;
import koala.dynamicjava.interpreter.context.MethodModificationError;
import koala.dynamicjava.interpreter.context.NoSuchFunctionException;
import koala.dynamicjava.interpreter.error.CatchedExceptionError;
import koala.dynamicjava.interpreter.error.ExecutionError;
import koala.dynamicjava.interpreter.modifier.ArrayModifier;
import koala.dynamicjava.interpreter.modifier.InvalidModifier;
import koala.dynamicjava.tree.AddAssignExpression;
import koala.dynamicjava.tree.AddExpression;
import koala.dynamicjava.tree.AndExpression;
import koala.dynamicjava.tree.ArrayAccess;
import koala.dynamicjava.tree.ArrayAllocation;
import koala.dynamicjava.tree.ArrayInitializer;
import koala.dynamicjava.tree.ArrayType;
import koala.dynamicjava.tree.AssertStatement;
import koala.dynamicjava.tree.BinaryExpression;
import koala.dynamicjava.tree.BitAndAssignExpression;
import koala.dynamicjava.tree.BitAndExpression;
import koala.dynamicjava.tree.BitOrAssignExpression;
import koala.dynamicjava.tree.BitOrExpression;
import koala.dynamicjava.tree.BlockStatement;
import koala.dynamicjava.tree.BooleanType;
import koala.dynamicjava.tree.BreakStatement;
import koala.dynamicjava.tree.ByteType;
import koala.dynamicjava.tree.CastExpression;
import koala.dynamicjava.tree.CatchStatement;
import koala.dynamicjava.tree.CharType;
import koala.dynamicjava.tree.ClassAllocation;
import koala.dynamicjava.tree.ClassDeclaration;
import koala.dynamicjava.tree.ClassInitializer;
import koala.dynamicjava.tree.ComplementExpression;
import koala.dynamicjava.tree.ConditionalExpression;
import koala.dynamicjava.tree.ConstructorDeclaration;
import koala.dynamicjava.tree.ConstructorInvocation;
import koala.dynamicjava.tree.ContinueStatement;
import koala.dynamicjava.tree.DivideAssignExpression;
import koala.dynamicjava.tree.DivideExpression;
import koala.dynamicjava.tree.DoStatement;
import koala.dynamicjava.tree.DoubleType;
import koala.dynamicjava.tree.EmptyStatement;
import koala.dynamicjava.tree.EqualExpression;
import koala.dynamicjava.tree.ExclusiveOrAssignExpression;
import koala.dynamicjava.tree.ExclusiveOrExpression;
import koala.dynamicjava.tree.Expression;
import koala.dynamicjava.tree.FieldDeclaration;
import koala.dynamicjava.tree.FloatType;
import koala.dynamicjava.tree.ForEachStatement;
import koala.dynamicjava.tree.ForStatement;
import koala.dynamicjava.tree.FormalParameter;
import koala.dynamicjava.tree.FunctionCall;
import koala.dynamicjava.tree.GreaterExpression;
import koala.dynamicjava.tree.GreaterOrEqualExpression;
import koala.dynamicjava.tree.IfThenElseStatement;
import koala.dynamicjava.tree.IfThenStatement;
import koala.dynamicjava.tree.ImportDeclaration;
import koala.dynamicjava.tree.InnerAllocation;
import koala.dynamicjava.tree.InnerClassAllocation;
import koala.dynamicjava.tree.InstanceInitializer;
import koala.dynamicjava.tree.InstanceOfExpression;
import koala.dynamicjava.tree.IntType;
import koala.dynamicjava.tree.InterfaceDeclaration;
import koala.dynamicjava.tree.LabeledStatement;
import koala.dynamicjava.tree.LessExpression;
import koala.dynamicjava.tree.LessOrEqualExpression;
import koala.dynamicjava.tree.Literal;
import koala.dynamicjava.tree.LongType;
import koala.dynamicjava.tree.MethodDeclaration;
import koala.dynamicjava.tree.MinusExpression;
import koala.dynamicjava.tree.MultiplyAssignExpression;
import koala.dynamicjava.tree.MultiplyExpression;
import koala.dynamicjava.tree.Node;
import koala.dynamicjava.tree.NotEqualExpression;
import koala.dynamicjava.tree.NotExpression;
import koala.dynamicjava.tree.ObjectFieldAccess;
import koala.dynamicjava.tree.ObjectMethodCall;
import koala.dynamicjava.tree.OrExpression;
import koala.dynamicjava.tree.PackageDeclaration;
import koala.dynamicjava.tree.PlusExpression;
import koala.dynamicjava.tree.PostDecrement;
import koala.dynamicjava.tree.PostIncrement;
import koala.dynamicjava.tree.PreDecrement;
import koala.dynamicjava.tree.PreIncrement;
import koala.dynamicjava.tree.PrimitiveType;
import koala.dynamicjava.tree.QualifiedName;
import koala.dynamicjava.tree.ReferenceType;
import koala.dynamicjava.tree.RemainderAssignExpression;
import koala.dynamicjava.tree.RemainderExpression;
import koala.dynamicjava.tree.ReturnStatement;
import koala.dynamicjava.tree.ShiftLeftAssignExpression;
import koala.dynamicjava.tree.ShiftLeftExpression;
import koala.dynamicjava.tree.ShiftRightAssignExpression;
import koala.dynamicjava.tree.ShiftRightExpression;
import koala.dynamicjava.tree.ShortType;
import koala.dynamicjava.tree.SimpleAllocation;
import koala.dynamicjava.tree.SimpleAssignExpression;
import koala.dynamicjava.tree.StaticFieldAccess;
import koala.dynamicjava.tree.StaticMethodCall;
import koala.dynamicjava.tree.SubtractAssignExpression;
import koala.dynamicjava.tree.SubtractExpression;
import koala.dynamicjava.tree.SuperFieldAccess;
import koala.dynamicjava.tree.SuperMethodCall;
import koala.dynamicjava.tree.SwitchBlock;
import koala.dynamicjava.tree.SwitchStatement;
import koala.dynamicjava.tree.SynchronizedStatement;
import koala.dynamicjava.tree.ThisExpression;
import koala.dynamicjava.tree.ThrowStatement;
import koala.dynamicjava.tree.TryStatement;
import koala.dynamicjava.tree.Type;
import koala.dynamicjava.tree.TypeExpression;
import koala.dynamicjava.tree.UnaryExpression;
import koala.dynamicjava.tree.UnsignedShiftRightAssignExpression;
import koala.dynamicjava.tree.UnsignedShiftRightExpression;
import koala.dynamicjava.tree.VariableDeclaration;
import koala.dynamicjava.tree.WhileStatement;
import koala.dynamicjava.tree.visitor.VisitorObject;
import koala.dynamicjava.util.Constants;
import koala.dynamicjava.util.TigerUtilities;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTypeChecker
extends VisitorObject<Class<?>> {
    protected Context context;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Throwable;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Cloneable;

    public AbstractTypeChecker(Context ctx) {
        this.context = ctx;
    }

    public static AbstractTypeChecker makeTypeChecker(Context ctx) {
        if (!TigerUtilities.isTigerEnabled()) {
            return new TypeChecker14(ctx);
        }
        return new TypeChecker15(ctx);
    }

    @Override
    public Class<?> visit(PackageDeclaration node) {
        this.context.setCurrentPackage(node.getName());
        return null;
    }

    @Override
    public Class<?> visit(ImportDeclaration node) {
        if (node.isStatic()) {
            this.staticImportHandler(node);
        } else if (node.isPackage()) {
            this.context.declarePackageImport(node.getName());
        } else {
            try {
                this.context.declareClassImport(node.getName());
            }
            catch (ClassNotFoundException e) {
                throw new CatchedExceptionError(e, (Node)node);
            }
        }
        return null;
    }

    protected abstract void staticImportHandler(ImportDeclaration var1);

    @Override
    public Class<?> visit(WhileStatement whileStmt) {
        Expression exp = whileStmt.getCondition();
        Class type = (Class)exp.acceptVisitor(this);
        if (type != Boolean.TYPE && type != (class$java$lang$Boolean == null ? (class$java$lang$Boolean = AbstractTypeChecker.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            throw new ExecutionError("condition.type", whileStmt);
        }
        if (type == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = AbstractTypeChecker.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            whileStmt.setCondition(this._unbox(exp, type));
        }
        whileStmt.getBody().acceptVisitor(this);
        return null;
    }

    @Override
    public abstract Class<?> visit(ForEachStatement var1);

    @Override
    public Class<?> visit(ForStatement node) {
        Expression cond;
        this.context.enterScope();
        List<Node> l = node.getInitialization();
        if (l != null) {
            this.checkList(l);
        }
        if ((cond = node.getCondition()) != null) {
            Class type = (Class)cond.acceptVisitor(this);
            if (type != Boolean.TYPE && type != (class$java$lang$Boolean == null ? (class$java$lang$Boolean = AbstractTypeChecker.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
                throw new ExecutionError("condition.type", node);
            }
            if (type == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = AbstractTypeChecker.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
                node.setCondition(this._unbox(cond, type));
            }
        }
        if ((l = node.getUpdate()) != null) {
            this.checkList(l);
        }
        node.getBody().acceptVisitor(this);
        node.setProperty("variables", this.context.leaveScope());
        return null;
    }

    @Override
    public Class<?> visit(DoStatement node) {
        node.getBody().acceptVisitor(this);
        Expression exp = node.getCondition();
        Class type = (Class)exp.acceptVisitor(this);
        if (type != Boolean.TYPE && type != (class$java$lang$Boolean == null ? (class$java$lang$Boolean = AbstractTypeChecker.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            throw new ExecutionError("condition.type", node);
        }
        if (type == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = AbstractTypeChecker.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            node.setCondition(this._unbox(exp, type));
        }
        return null;
    }

    @Override
    public Class<?> visit(SwitchStatement node) {
        Expression exp = node.getSelector();
        Class c = (Class)exp.acceptVisitor(this);
        if (c != Character.TYPE && c != Byte.TYPE && c != Short.TYPE && c != Integer.TYPE && c != (class$java$lang$Character == null ? (class$java$lang$Character = AbstractTypeChecker.class$("java.lang.Character")) : class$java$lang$Character) && c != (class$java$lang$Byte == null ? (class$java$lang$Byte = AbstractTypeChecker.class$("java.lang.Byte")) : class$java$lang$Byte) && c != (class$java$lang$Short == null ? (class$java$lang$Short = AbstractTypeChecker.class$("java.lang.Short")) : class$java$lang$Short) && c != (class$java$lang$Integer == null ? (class$java$lang$Integer = AbstractTypeChecker.class$("java.lang.Integer")) : class$java$lang$Integer) && !TigerUtilities.isEnum(c)) {
            node.setProperty("errorStrings", new String[]{c.getName()});
            throw new ExecutionError("selector.type", node);
        }
        if (c == (class$java$lang$Character == null ? (class$java$lang$Character = AbstractTypeChecker.class$("java.lang.Character")) : class$java$lang$Character) || c == (class$java$lang$Byte == null ? (class$java$lang$Byte = AbstractTypeChecker.class$("java.lang.Byte")) : class$java$lang$Byte) || c == (class$java$lang$Short == null ? (class$java$lang$Short = AbstractTypeChecker.class$("java.lang.Short")) : class$java$lang$Short) || c == (class$java$lang$Integer == null ? (class$java$lang$Integer = AbstractTypeChecker.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            node.setSelector(this._unbox(exp, c));
        }
        for (SwitchBlock sb : node.getBindings()) {
            sb.acceptVisitor(this);
            exp = sb.getExpression();
            if (exp == null) continue;
            Class<?> lc = NodeProperties.getType(exp);
            if (lc != Character.TYPE && lc != Byte.TYPE && lc != Short.TYPE && lc != Integer.TYPE && TigerUtilities.isTigerEnabled() && !TigerUtilities.isEnum(lc)) {
                node.setProperty("errorStrings", new String[]{lc.getName()});
                throw new ExecutionError("switch.label.type", node);
            }
            if (c == lc) continue;
            Number n = null;
            if (exp.hasProperty("value")) {
                Object cst = exp.getProperty("value");
                n = lc == Character.TYPE ? (Number)new Integer(((Character)cst).charValue()) : (Number)((Number)cst);
            }
            if (c == Byte.TYPE) {
                if (exp.hasProperty("value")) {
                    if (n.byteValue() == n.intValue()) continue;
                    node.setProperty("errorStrings", new String[]{c.getName()});
                    throw new ExecutionError("switch.label.type", node);
                }
                throw new ExecutionError("switch.label.type", node);
            }
            if (c != Short.TYPE && c != Character.TYPE) continue;
            if (exp.hasProperty("value")) {
                if (n.shortValue() == n.intValue()) continue;
                node.setProperty("errorStrings", new String[]{c.getName()});
                throw new ExecutionError("switch.label.type", node);
            }
            if (lc != Integer.TYPE) continue;
            node.setProperty("errorStrings", new String[]{c.getName()});
            throw new ExecutionError("switch.label.type", node);
        }
        return null;
    }

    @Override
    public Class<?> visit(SwitchBlock node) {
        List<Node> l;
        Expression exp = node.getExpression();
        if (exp != null) {
            exp.acceptVisitor(this);
        }
        if ((l = node.getStatements()) != null) {
            this.checkList(l);
        }
        return null;
    }

    @Override
    public Class<?> visit(LabeledStatement node) {
        node.getStatement().acceptVisitor(this);
        return null;
    }

    @Override
    public Class<?> visit(TryStatement node) {
        node.getTryBlock().acceptVisitor(this);
        Iterator<CatchStatement> it = node.getCatchStatements().iterator();
        while (it.hasNext()) {
            it.next().acceptVisitor(this);
        }
        Node n = node.getFinallyBlock();
        if (n != null) {
            n.acceptVisitor(this);
        }
        return null;
    }

    @Override
    public Class<?> visit(CatchStatement node) {
        this.context.enterScope();
        Class c = (Class)node.getException().acceptVisitor(this);
        if (!(class$java$lang$Throwable == null ? (class$java$lang$Throwable = AbstractTypeChecker.class$("java.lang.Throwable")) : class$java$lang$Throwable).isAssignableFrom(c)) {
            node.setProperty("errorStrings", new String[]{c.getName()});
            throw new ExecutionError("catch.type", node);
        }
        node.getBlock().acceptVisitor(this);
        this.context.leaveScope();
        node.setProperty("type", c);
        return null;
    }

    @Override
    public Class<?> visit(ThrowStatement node) {
        Class c;
        if (!(class$java$lang$Throwable == null ? (class$java$lang$Throwable = AbstractTypeChecker.class$("java.lang.Throwable")) : class$java$lang$Throwable).isAssignableFrom(c = (Class)node.getExpression().acceptVisitor(this))) {
            node.setProperty("errorStrings", new String[]{c.getName()});
            throw new ExecutionError("throw.type", node);
        }
        return null;
    }

    @Override
    public Class<?> visit(ReturnStatement node) {
        Expression e = node.getExpression();
        if (e != null) {
            e.acceptVisitor(this);
        }
        return null;
    }

    @Override
    public Class<?> visit(IfThenStatement node) {
        Expression cond = node.getCondition();
        Class type = (Class)cond.acceptVisitor(this);
        if (type != Boolean.TYPE && type != (class$java$lang$Boolean == null ? (class$java$lang$Boolean = AbstractTypeChecker.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            throw new ExecutionError("condition.type", node);
        }
        if (type == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = AbstractTypeChecker.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            node.setCondition(this._unbox(cond, type));
        }
        node.getThenStatement().acceptVisitor(this);
        return null;
    }

    @Override
    public Class<?> visit(IfThenElseStatement node) {
        Expression cond = node.getCondition();
        Class type = (Class)cond.acceptVisitor(this);
        if (type != Boolean.TYPE && type != (class$java$lang$Boolean == null ? (class$java$lang$Boolean = AbstractTypeChecker.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            throw new ExecutionError("condition.type", node);
        }
        if (type == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = AbstractTypeChecker.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            node.setCondition(this._unbox(cond, type));
        }
        node.getThenStatement().acceptVisitor(this);
        node.getElseStatement().acceptVisitor(this);
        return null;
    }

    @Override
    public Class<?> visit(AssertStatement node) {
        Expression failString;
        Expression cond = node.getCondition();
        Class type = (Class)cond.acceptVisitor(this);
        if (type != Boolean.TYPE && type != (class$java$lang$Boolean == null ? (class$java$lang$Boolean = AbstractTypeChecker.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            throw new ExecutionError("condition.type", node);
        }
        if (type == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = AbstractTypeChecker.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            node.setCondition(this._unbox(cond, type));
        }
        if ((failString = node.getFailString()) != null) {
            Class type2 = (Class)failString.acceptVisitor(this);
        }
        return null;
    }

    @Override
    public Class<?> visit(SynchronizedStatement node) {
        if (((Class)node.getLock().acceptVisitor(this)).isPrimitive()) {
            throw new ExecutionError("lock.type", node);
        }
        node.getBody().acceptVisitor(this);
        return null;
    }

    @Override
    public Class<?> visit(Literal node) {
        Class<?> c = node.getType();
        node.setProperty("value", node.getValue());
        node.setProperty("type", c);
        return c;
    }

    @Override
    public Class<?> visit(VariableDeclaration node) {
        Class lc = (Class)node.getType().acceptVisitor(this);
        if (node.isFinal()) {
            this.context.defineConstant(node.getName(), lc);
        } else {
            this.context.define(node.getName(), lc);
        }
        Expression init = node.getInitializer();
        if (init != null) {
            Class rc = (Class)init.acceptVisitor(this);
            Expression exp = this.checkAssignmentStaticRules(lc, rc, node, init);
            node.setInitializer(exp);
        }
        return null;
    }

    @Override
    public Class<?> visit(BlockStatement node) {
        this.context.enterScope();
        this.checkList(node.getStatements());
        node.setProperty("variables", this.context.leaveScope());
        return null;
    }

    @Override
    public Class<?> visit(ObjectFieldAccess node) {
        Class<?> c = (Class<?>)node.getExpression().acceptVisitor(this);
        if (!c.isArray()) {
            Field f = null;
            try {
                f = this.context.getField(c, node.getFieldName());
            }
            catch (Exception e) {
                throw new CatchedExceptionError(e, (Node)node);
            }
            c = f.getType();
            node.setProperty("field", f);
            node.setProperty("type", c);
            node.setProperty("modifier", this.context.getModifier(node));
            return c;
        }
        if (!node.getFieldName().equals("length")) {
            String s0 = "length";
            String s1 = new StringBuffer().append(c.getComponentType().getName()).append(" array").toString();
            node.setProperty("errorStrings", new String[]{s0, s1});
            throw new ExecutionError("no.such.field", node);
        }
        node.setProperty("type", Integer.TYPE);
        node.setProperty("modifier", new InvalidModifier(node));
        return Integer.TYPE;
    }

    @Override
    public Class<?> visit(SuperFieldAccess node) {
        Field f = null;
        try {
            f = this.context.getSuperField(node, node.getFieldName());
        }
        catch (Exception e) {
            throw new CatchedExceptionError(e, (Node)node);
        }
        node.setProperty("field", f);
        Class<?> c = f.getType();
        node.setProperty("type", c);
        node.setProperty("modifier", this.context.getModifier(node));
        return c;
    }

    @Override
    public Class<?> visit(StaticFieldAccess node) {
        Class<?> c = (Class<?>)node.getFieldType().acceptVisitor(this);
        Field f = null;
        try {
            f = this.context.getField(c, node.getFieldName());
        }
        catch (Exception e) {
            throw new CatchedExceptionError(e, (Node)node);
        }
        node.setProperty("field", f);
        c = f.getType();
        node.setProperty("type", c);
        node.setProperty("modifier", this.context.getModifier(node));
        return c;
    }

    @Override
    public Class<?> visit(ObjectMethodCall node) {
        Expression exp = node.getExpression();
        Class<?> c = (Class<?>)exp.acceptVisitor(this);
        String mn = node.getMethodName();
        if (!c.isArray() || c.isArray() && !mn.equals("clone")) {
            List<Expression> args = node.getArguments();
            Class<?>[] cargs = Constants.EMPTY_CLASS_ARRAY;
            if (args != null) {
                cargs = new Class[args.size()];
                Iterator<Expression> it = args.iterator();
                int i = 0;
                while (it.hasNext()) {
                    cargs[i++] = (Class)it.next().acceptVisitor(this);
                }
            }
            Method m = null;
            try {
                m = this.context.lookupMethod(exp, mn, cargs);
            }
            catch (NoSuchMethodException e) {
                String s = c.getName();
                String sargs = "";
                for (int i = 0; i < cargs.length - 1; ++i) {
                    sargs = new StringBuffer().append(sargs).append(cargs[i].getName()).append(", ").toString();
                }
                if (cargs.length > 0) {
                    sargs = new StringBuffer().append(sargs).append(cargs[cargs.length - 1].getName()).toString();
                }
                node.setProperty("errorStrings", new String[]{mn, s, sargs});
                throw new ExecutionError("no.such.method.with.args", node);
            }
            catch (MethodModificationError e) {
                Expression expr = e.getExpression();
                expr.acceptVisitor(this);
                node.setExpression(expr);
                m = e.getMethod();
            }
            node.setProperty("method", m);
            c = m.getReturnType();
            node.setProperty("type", c);
            return c;
        }
        if (!mn.equals("clone") || node.getArguments() != null) {
            String s0 = "clone";
            String s1 = new StringBuffer().append(c.getComponentType().getName()).append(" array").toString();
            node.setProperty("errorStrings", new String[]{s0, s1});
            throw new ExecutionError("no.such.method", node);
        }
        c = class$java$lang$Object == null ? (class$java$lang$Object = AbstractTypeChecker.class$("java.lang.Object")) : class$java$lang$Object;
        node.setProperty("type", c);
        return c;
    }

    @Override
    public Class<?> visit(MethodDeclaration node) {
        this.checkVarArgs(node);
        this.context.defineFunction(node);
        node.setProperty("type", node.getReturnType().acceptVisitor(this));
        node.setProperty("functions", this.context.getFunctions());
        node.setProperty("importationManager", this.context.getImportationManager().clone());
        this.context.enterScope();
        this.checkList(node.getParameters());
        this.context.leaveScope();
        return null;
    }

    protected abstract void checkVarArgs(MethodDeclaration var1);

    @Override
    public Class<?> visit(FunctionCall node) {
        List<Expression> args = node.getArguments();
        Class<?>[] cargs = Constants.EMPTY_CLASS_ARRAY;
        if (args != null) {
            cargs = new Class[args.size()];
            Iterator<Expression> it = args.iterator();
            int i = 0;
            while (it.hasNext()) {
                cargs[i++] = (Class)it.next().acceptVisitor(this);
            }
        }
        MethodDeclaration f = null;
        try {
            f = this.context.lookupFunction(node.getMethodName(), cargs);
        }
        catch (NoSuchFunctionException e) {
            String s = node.getMethodName();
            node.setProperty("errorStrings", new String[]{s});
            throw new ExecutionError("no.such.function", node);
        }
        node.setProperty("function", f);
        Class<?> c = NodeProperties.getType(f);
        node.setProperty("type", c);
        return c;
    }

    @Override
    public Class<?> visit(SuperMethodCall node) {
        List<Expression> args = node.getArguments();
        Class<?>[] pt = Constants.EMPTY_CLASS_ARRAY;
        if (args != null) {
            pt = new Class[args.size()];
            Iterator<Expression> it = args.iterator();
            int i = 0;
            while (it.hasNext()) {
                pt[i++] = (Class)it.next().acceptVisitor(this);
            }
        }
        Method m = null;
        try {
            m = this.context.lookupSuperMethod(node, node.getMethodName(), pt);
        }
        catch (Exception e) {
            throw new CatchedExceptionError(e, (Node)node);
        }
        node.setProperty("method", m);
        Class<?> c = m.getReturnType();
        node.setProperty("type", c);
        return c;
    }

    @Override
    public Class<?> visit(StaticMethodCall node) {
        List<Expression> args = node.getArguments();
        Class<?>[] cargs = Constants.EMPTY_CLASS_ARRAY;
        if (args != null) {
            cargs = new Class[args.size()];
            Iterator<Expression> it = args.iterator();
            int i = 0;
            while (it.hasNext()) {
                cargs[i++] = (Class)it.next().acceptVisitor(this);
            }
        }
        Method m = null;
        Type n = node.getMethodType();
        Class<?> c = (Class<?>)n.acceptVisitor(this);
        try {
            m = this.context.lookupMethod(n, node.getMethodName(), cargs);
        }
        catch (NoSuchMethodException e) {
            String s0 = node.getMethodName();
            String s1 = c.getName();
            String sargs = "";
            for (int i = 0; i < cargs.length - 1; ++i) {
                sargs = new StringBuffer().append(sargs).append(cargs[i].getName()).append(", ").toString();
            }
            if (cargs.length > 0) {
                sargs = new StringBuffer().append(sargs).append(cargs[cargs.length - 1].getName()).toString();
            }
            node.setProperty("errorStrings", new String[]{s0, s1, sargs});
            throw new ExecutionError("no.such.method.with.args", node);
        }
        node.setProperty("method", m);
        c = m.getReturnType();
        node.setProperty("type", c);
        return c;
    }

    @Override
    public Class<?> visit(SimpleAssignExpression node) {
        String var;
        Expression left = node.getLeftExpression();
        Expression right = node.getRightExpression();
        Class rc = (Class)right.acceptVisitor(this);
        if (left instanceof QualifiedName && !this.context.exists(var = ((QualifiedName)left).getRepresentation())) {
            Class clazz = rc == null ? (class$java$lang$Object == null ? (class$java$lang$Object = AbstractTypeChecker.class$("java.lang.Object")) : class$java$lang$Object) : rc;
            this.context.define(var, clazz);
        }
        Class lc = (Class)left.acceptVisitor(this);
        if (!left.hasProperty("modifier")) {
            throw new ExecutionError("left.expression", node);
        }
        Expression exp = this.checkAssignmentStaticRules(lc, rc, node, right);
        node.setRightExpression(exp);
        node.setProperty("type", lc);
        return lc;
    }

    @Override
    public Class<?> visit(QualifiedName node) {
        String var = node.getRepresentation();
        Class c = (Class)this.context.get(var);
        node.setProperty("type", c);
        node.setProperty("modifier", this.context.getModifier(node));
        return c;
    }

    @Override
    public Class<?> visit(SimpleAllocation node) {
        Type type = node.getCreationType();
        Class c = (Class)type.acceptVisitor(this);
        List<Expression> args = node.getArguments();
        Class<?>[] cargs = Constants.EMPTY_CLASS_ARRAY;
        if (args != null) {
            cargs = new Class[args.size()];
            ListIterator<Expression> it = args.listIterator();
            int i = 0;
            while (it.hasNext()) {
                cargs[i++] = (Class)it.next().acceptVisitor(this);
            }
        }
        return this.context.setProperties(node, c, cargs);
    }

    @Override
    public Class<?> visit(InnerAllocation node) {
        Class ec = (Class)node.getExpression().acceptVisitor(this);
        Type type = node.getCreationType();
        if (!(type instanceof ReferenceType)) {
            throw new ExecutionError("allocation.type", node);
        }
        ReferenceType rt = (ReferenceType)type;
        rt.setRepresentation(new StringBuffer().append(ec.getName()).append("$").append(rt.getRepresentation()).toString());
        Class c = (Class)type.acceptVisitor(this);
        Class<?> dc = InterpreterUtilities.getDeclaringClass(c);
        List<Expression> args = node.getArguments();
        Class[] cargs = null;
        if (dc != null && dc.isAssignableFrom(ec)) {
            if (args != null) {
                cargs = new Class[args.size() + 1];
                cargs[0] = ec;
                ListIterator<Expression> it = args.listIterator();
                int i = 1;
                while (it.hasNext()) {
                    cargs[i++] = (Class)it.next().acceptVisitor(this);
                }
            } else {
                cargs = new Class[]{ec};
            }
        } else {
            throw new ExecutionError("allocation.type", node);
        }
        Constructor cons = null;
        try {
            cons = this.context.lookupConstructor(c, cargs);
        }
        catch (Exception e) {
            throw new CatchedExceptionError(e, (Node)node);
        }
        node.setProperty("type", c);
        node.setProperty("constructor", cons);
        return c;
    }

    @Override
    public Class<?> visit(ClassAllocation node) {
        if (node.hasProperty("type")) {
            return NodeProperties.getType(node);
        }
        Type ctn = node.getCreationType();
        Class ct = (Class)ctn.acceptVisitor(this);
        List<Expression> largs = node.getArguments();
        Class<?>[] args = Constants.EMPTY_CLASS_ARRAY;
        if (largs != null) {
            args = new Class[largs.size()];
            Iterator<Expression> it = largs.iterator();
            int i = 0;
            while (it.hasNext()) {
                args[i++] = (Class)it.next().acceptVisitor(this);
            }
        }
        return this.context.setProperties(node, ct, args, node.getMembers());
    }

    @Override
    public Class<?> visit(ArrayAllocation node) {
        ListIterator<Expression> it = node.getSizes().listIterator();
        while (it.hasNext()) {
            Expression exp = it.next();
            Class c = (Class)exp.acceptVisitor(this);
            if (c != Character.TYPE && c != Byte.TYPE && c != Short.TYPE && c != Integer.TYPE && c != (class$java$lang$Character == null ? AbstractTypeChecker.class$("java.lang.Character") : class$java$lang$Character) && c != (class$java$lang$Byte == null ? AbstractTypeChecker.class$("java.lang.Byte") : class$java$lang$Byte) && c != (class$java$lang$Short == null ? AbstractTypeChecker.class$("java.lang.Short") : class$java$lang$Short) && c != (class$java$lang$Integer == null ? AbstractTypeChecker.class$("java.lang.Integer") : class$java$lang$Integer)) {
                throw new ExecutionError("array.dimension.type", node);
            }
            if (!TigerUtilities.isBoxingType(c)) continue;
            it.set(this._unbox(exp, c));
        }
        Class c = (Class)node.getCreationType().acceptVisitor(this);
        if (node.getInitialization() != null) {
            node.getInitialization().acceptVisitor(this);
        }
        Class<?> ac = Array.newInstance(c, new int[node.getDimension()]).getClass();
        node.setProperty("type", ac);
        node.setProperty("componentType", c);
        return ac;
    }

    @Override
    public Class<?> visit(ArrayInitializer node) {
        node.getElementType().acceptVisitor(this);
        this.checkList(node.getCells());
        return null;
    }

    @Override
    public Class<?> visit(ArrayAccess node) {
        Class c = (Class)node.getExpression().acceptVisitor(this);
        if (!c.isArray()) {
            node.setProperty("errorStrings", new String[]{c.getName()});
            throw new ExecutionError("array.required", node);
        }
        Class<?> result = c.getComponentType();
        node.setProperty("type", result);
        node.setProperty("modifier", new ArrayModifier(node));
        c = (Class)node.getCellNumber().acceptVisitor(this);
        if (c != Character.TYPE && c != Byte.TYPE && c != Short.TYPE && c != Integer.TYPE && c != (class$java$lang$Character == null ? (class$java$lang$Character = AbstractTypeChecker.class$("java.lang.Character")) : class$java$lang$Character) && c != (class$java$lang$Byte == null ? (class$java$lang$Byte = AbstractTypeChecker.class$("java.lang.Byte")) : class$java$lang$Byte) && c != (class$java$lang$Short == null ? (class$java$lang$Short = AbstractTypeChecker.class$("java.lang.Short")) : class$java$lang$Short) && c != (class$java$lang$Integer == null ? (class$java$lang$Integer = AbstractTypeChecker.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            throw new ExecutionError("array.index.type", node);
        }
        if (TigerUtilities.isBoxingType(c)) {
            node.setCellNumber(this._unbox(node.getCellNumber(), c));
        }
        return result;
    }

    @Override
    public Class<?> visit(PrimitiveType node) {
        Class<?> c = node.getValue();
        node.setProperty("type", c);
        return c;
    }

    @Override
    public Class<?> visit(ReferenceType node) {
        this.checkGenericReferenceType(node);
        Class<?> c = null;
        try {
            c = this.context.lookupClass(node.getRepresentation());
        }
        catch (ClassNotFoundException e) {
            node.setProperty("errorStrings", new String[]{node.getRepresentation()});
            throw new ExecutionError("undefined.class", node);
        }
        node.setProperty("type", c);
        return c;
    }

    protected abstract void checkGenericReferenceType(ReferenceType var1);

    @Override
    public Class<?> visit(ArrayType node) {
        Type eType = node.getElementType();
        Class c = (Class)eType.acceptVisitor(this);
        Class<?> ac = Array.newInstance(c, 0).getClass();
        node.setProperty("type", ac);
        return ac;
    }

    @Override
    public Class<?> visit(TypeExpression node) {
        Class c = (Class)node.getType().acceptVisitor(this);
        node.setProperty("type", class$java$lang$Class == null ? (class$java$lang$Class = AbstractTypeChecker.class$("java.lang.Class")) : class$java$lang$Class);
        node.setProperty("value", c);
        return class$java$lang$Class == null ? (class$java$lang$Class = AbstractTypeChecker.class$("java.lang.Class")) : class$java$lang$Class;
    }

    @Override
    public Class<?> visit(NotExpression node) {
        Expression exp = node.getExpression();
        Class c = (Class)exp.acceptVisitor(this);
        if (c != Boolean.TYPE && c != (class$java$lang$Boolean == null ? (class$java$lang$Boolean = AbstractTypeChecker.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            throw new ExecutionError("not.expression.type", node);
        }
        node.setProperty("type", Boolean.TYPE);
        if (TigerUtilities.isBoxingType(c)) {
            node.setExpression(this._unbox(exp, c));
        }
        if (exp.hasProperty("value")) {
            if (((Boolean)exp.getProperty("value")).booleanValue()) {
                node.setProperty("value", Boolean.FALSE);
            } else {
                node.setProperty("value", Boolean.TRUE);
            }
        }
        return Boolean.TYPE;
    }

    @Override
    public Class<?> visit(ComplementExpression node) {
        Class<Integer> c;
        Expression e = node.getExpression();
        Class<Number> returnType = c = (Class<Integer>)e.acceptVisitor(this);
        if (c == Character.TYPE || c == Byte.TYPE || c == Short.TYPE || c == (class$java$lang$Character == null ? (class$java$lang$Character = AbstractTypeChecker.class$("java.lang.Character")) : class$java$lang$Character) || c == (class$java$lang$Byte == null ? (class$java$lang$Byte = AbstractTypeChecker.class$("java.lang.Byte")) : class$java$lang$Byte) || c == (class$java$lang$Short == null ? (class$java$lang$Short = AbstractTypeChecker.class$("java.lang.Short")) : class$java$lang$Short)) {
            node.setProperty("type", Integer.TYPE);
        } else if (c == Integer.TYPE || c == Long.TYPE || c == (class$java$lang$Integer == null ? (class$java$lang$Integer = AbstractTypeChecker.class$("java.lang.Integer")) : class$java$lang$Integer) || c == (class$java$lang$Long == null ? (class$java$lang$Long = AbstractTypeChecker.class$("java.lang.Long")) : class$java$lang$Long)) {
            if (c == (class$java$lang$Integer == null ? (class$java$lang$Integer = AbstractTypeChecker.class$("java.lang.Integer")) : class$java$lang$Integer)) {
                returnType = Integer.TYPE;
            } else if (c == (class$java$lang$Long == null ? (class$java$lang$Long = AbstractTypeChecker.class$("java.lang.Long")) : class$java$lang$Long)) {
                returnType = Long.TYPE;
            }
            node.setProperty("type", returnType);
        } else {
            throw new ExecutionError("complement.expression.type", node);
        }
        if (TigerUtilities.isBoxingType(c)) {
            node.setExpression(this._unbox(e, c));
        }
        if (e.hasProperty("value")) {
            Object o = e.getProperty("value");
            if (o instanceof Character) {
                o = new Integer(((Character)o).charValue());
            }
            o = c == Integer.TYPE ? (Number)new Integer(~((Number)o).intValue()) : (Number)new Long(((Number)o).longValue() ^ 0xFFFFFFFFFFFFFFFFL);
            node.setProperty("value", o);
        }
        return returnType;
    }

    @Override
    public Class<?> visit(PlusExpression node) {
        Class<?> c = this.visitUnaryOperation(node, "plus.expression.type");
        Expression n = node.getExpression();
        if (n.hasProperty("value")) {
            node.setProperty("value", InterpreterUtilities.plus(c, n.getProperty("value")));
        }
        return c;
    }

    @Override
    public Class<?> visit(MinusExpression node) {
        Class<?> c = this.visitUnaryOperation(node, "minus.expression.type");
        Expression n = node.getExpression();
        if (n.hasProperty("value")) {
            node.setProperty("value", InterpreterUtilities.minus(c, n.getProperty("value")));
        }
        return c;
    }

    @Override
    public Class<?> visit(AddExpression node) {
        Expression ln = node.getLeftExpression();
        Expression rn = node.getRightExpression();
        Class lc = (Class)ln.acceptVisitor(this);
        Class rc = (Class)rn.acceptVisitor(this);
        Class c = class$java$lang$String == null ? (class$java$lang$String = AbstractTypeChecker.class$("java.lang.String")) : class$java$lang$String;
        if (lc != (class$java$lang$String == null ? (class$java$lang$String = AbstractTypeChecker.class$("java.lang.String")) : class$java$lang$String) && rc != (class$java$lang$String == null ? (class$java$lang$String = AbstractTypeChecker.class$("java.lang.String")) : class$java$lang$String)) {
            c = this.visitNumericExpression(node, "addition.type");
        } else {
            node.setProperty("type", c);
        }
        if (ln.hasProperty("value") && rn.hasProperty("value")) {
            node.setProperty("value", InterpreterUtilities.add(c, ln.getProperty("value"), rn.getProperty("value")));
        }
        return c;
    }

    @Override
    public Class<?> visit(AddAssignExpression node) {
        Expression ln = node.getLeftExpression();
        Class lc = (Class)ln.acceptVisitor(this);
        Class rc = (Class)node.getRightExpression().acceptVisitor(this);
        if (lc != (class$java$lang$String == null ? (class$java$lang$String = AbstractTypeChecker.class$("java.lang.String")) : class$java$lang$String) && (lc == null || rc == null || lc == Void.TYPE || rc == Void.TYPE || lc == Boolean.TYPE || rc == Boolean.TYPE || lc == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = AbstractTypeChecker.class$("java.lang.Boolean")) : class$java$lang$Boolean) || rc == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = AbstractTypeChecker.class$("java.lang.Boolean")) : class$java$lang$Boolean) || !lc.isPrimitive() && !TigerUtilities.isBoxingType(lc) || !rc.isPrimitive() && !TigerUtilities.isBoxingType(rc))) {
            throw new ExecutionError("addition.type", node);
        }
        if (!ln.hasProperty("modifier")) {
            throw new ExecutionError("left.expression", node);
        }
        node.setProperty("type", lc);
        return lc;
    }

    @Override
    public Class<?> visit(SubtractExpression node) {
        Expression ln = node.getLeftExpression();
        Expression rn = node.getRightExpression();
        ln.acceptVisitor(this);
        rn.acceptVisitor(this);
        Class<?> c = this.visitNumericExpression(node, "subtraction.type");
        if (ln.hasProperty("value") && rn.hasProperty("value")) {
            node.setProperty("value", InterpreterUtilities.subtract(c, ln.getProperty("value"), rn.getProperty("value")));
        }
        return c;
    }

    @Override
    public Class<?> visit(SubtractAssignExpression node) {
        Expression ln = node.getLeftExpression();
        Class lc = (Class)ln.acceptVisitor(this);
        Class rc = (Class)node.getRightExpression().acceptVisitor(this);
        if (lc == null || rc == null || lc == Void.TYPE || rc == Void.TYPE || lc == Boolean.TYPE || rc == Boolean.TYPE || lc == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = AbstractTypeChecker.class$("java.lang.Boolean")) : class$java$lang$Boolean) || rc == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = AbstractTypeChecker.class$("java.lang.Boolean")) : class$java$lang$Boolean) || !lc.isPrimitive() && !TigerUtilities.isBoxingType(lc) || !rc.isPrimitive() && !TigerUtilities.isBoxingType(rc)) {
            throw new ExecutionError("subtraction.type", node);
        }
        if (!ln.hasProperty("modifier")) {
            throw new ExecutionError("left.expression", node);
        }
        node.setProperty("type", lc);
        return lc;
    }

    @Override
    public Class<?> visit(MultiplyExpression node) {
        Expression ln = node.getLeftExpression();
        Expression rn = node.getRightExpression();
        ln.acceptVisitor(this);
        rn.acceptVisitor(this);
        Class<?> c = this.visitNumericExpression(node, "multiplication.type");
        if (ln.hasProperty("value") && rn.hasProperty("value")) {
            node.setProperty("value", InterpreterUtilities.multiply(c, ln.getProperty("value"), rn.getProperty("value")));
        }
        return c;
    }

    @Override
    public Class<?> visit(MultiplyAssignExpression node) {
        Expression ln = node.getLeftExpression();
        Class lc = (Class)ln.acceptVisitor(this);
        Class rc = (Class)node.getRightExpression().acceptVisitor(this);
        if (lc == null || rc == null || lc == Void.TYPE || rc == Void.TYPE || lc == Boolean.TYPE || rc == Boolean.TYPE || lc == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = AbstractTypeChecker.class$("java.lang.Boolean")) : class$java$lang$Boolean) || rc == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = AbstractTypeChecker.class$("java.lang.Boolean")) : class$java$lang$Boolean) || !lc.isPrimitive() && !TigerUtilities.isBoxingType(lc) || !rc.isPrimitive() && !TigerUtilities.isBoxingType(rc)) {
            throw new ExecutionError("multiplication.type", node);
        }
        if (!ln.hasProperty("modifier")) {
            throw new ExecutionError("left.expression", node);
        }
        node.setProperty("type", lc);
        return lc;
    }

    @Override
    public Class<?> visit(DivideExpression node) {
        Expression ln = node.getLeftExpression();
        Expression rn = node.getRightExpression();
        ln.acceptVisitor(this);
        rn.acceptVisitor(this);
        Class<?> c = this.visitNumericExpression(node, "division.type");
        return c;
    }

    @Override
    public Class<?> visit(RemainderExpression node) {
        Expression ln = node.getLeftExpression();
        Expression rn = node.getRightExpression();
        ln.acceptVisitor(this);
        rn.acceptVisitor(this);
        Class<?> c = this.visitNumericExpression(node, "remainder.type");
        return c;
    }

    @Override
    public Class<?> visit(DivideAssignExpression node) {
        Expression ln = node.getLeftExpression();
        Class lc = (Class)ln.acceptVisitor(this);
        Class rc = (Class)node.getRightExpression().acceptVisitor(this);
        if (lc == null || rc == null || lc == Void.TYPE || rc == Void.TYPE || lc == Boolean.TYPE || rc == Boolean.TYPE || lc == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = AbstractTypeChecker.class$("java.lang.Boolean")) : class$java$lang$Boolean) || rc == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = AbstractTypeChecker.class$("java.lang.Boolean")) : class$java$lang$Boolean) || !lc.isPrimitive() && !TigerUtilities.isBoxingType(lc) || !rc.isPrimitive() && !TigerUtilities.isBoxingType(rc)) {
            throw new ExecutionError("division.type", node);
        }
        if (!ln.hasProperty("modifier")) {
            throw new ExecutionError("left.expression", node);
        }
        node.setProperty("type", lc);
        return lc;
    }

    @Override
    public Class<?> visit(RemainderAssignExpression node) {
        Expression ln = node.getLeftExpression();
        Class lc = (Class)ln.acceptVisitor(this);
        Class rc = (Class)node.getRightExpression().acceptVisitor(this);
        if (lc == null || rc == null || lc == Void.TYPE || rc == Void.TYPE || lc == Boolean.TYPE || rc == Boolean.TYPE || lc == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = AbstractTypeChecker.class$("java.lang.Boolean")) : class$java$lang$Boolean) || rc == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = AbstractTypeChecker.class$("java.lang.Boolean")) : class$java$lang$Boolean) || !lc.isPrimitive() && !TigerUtilities.isBoxingType(lc) || !rc.isPrimitive() && !TigerUtilities.isBoxingType(rc)) {
            throw new ExecutionError("remainder.type", node);
        }
        if (!ln.hasProperty("modifier")) {
            throw new ExecutionError("left.expression", node);
        }
        node.setProperty("type", lc);
        return lc;
    }

    @Override
    public Class<?> visit(EqualExpression node) {
        Expression ln = node.getLeftExpression();
        Expression rn = node.getRightExpression();
        Class lc = (Class)ln.acceptVisitor(this);
        Class rc = (Class)rn.acceptVisitor(this);
        this.checkEqualityStaticRules(lc, rc, node);
        if (ln.hasProperty("value") && rn.hasProperty("value")) {
            node.setProperty("value", InterpreterUtilities.equalTo(lc, rc, ln.getProperty("value"), rn.getProperty("value")));
        }
        node.setProperty("type", Boolean.TYPE);
        return Boolean.TYPE;
    }

    @Override
    public Class<?> visit(NotEqualExpression node) {
        Expression ln = node.getLeftExpression();
        Expression rn = node.getRightExpression();
        Class lc = (Class)ln.acceptVisitor(this);
        Class rc = (Class)rn.acceptVisitor(this);
        this.checkEqualityStaticRules(lc, rc, node);
        if (ln.hasProperty("value") && rn.hasProperty("value")) {
            node.setProperty("value", InterpreterUtilities.notEqualTo(lc, rc, ln.getProperty("value"), rn.getProperty("value")));
        }
        node.setProperty("type", Boolean.TYPE);
        return Boolean.TYPE;
    }

    @Override
    public Class<?> visit(LessExpression node) {
        Class<?> c = this.visitRelationalExpression(node);
        Expression ln = node.getLeftExpression();
        Expression rn = node.getRightExpression();
        if (ln.hasProperty("value") && rn.hasProperty("value")) {
            node.setProperty("value", InterpreterUtilities.lessThan(ln.getProperty("value"), rn.getProperty("value")));
        }
        return c;
    }

    @Override
    public Class<?> visit(LessOrEqualExpression node) {
        Class<?> c = this.visitRelationalExpression(node);
        Expression ln = node.getLeftExpression();
        Expression rn = node.getRightExpression();
        if (ln.hasProperty("value") && rn.hasProperty("value")) {
            node.setProperty("value", InterpreterUtilities.lessOrEqual(ln.getProperty("value"), rn.getProperty("value")));
        }
        return c;
    }

    @Override
    public Class<?> visit(GreaterExpression node) {
        Class<?> c = this.visitRelationalExpression(node);
        Expression ln = node.getLeftExpression();
        Expression rn = node.getRightExpression();
        if (ln.hasProperty("value") && rn.hasProperty("value")) {
            node.setProperty("value", InterpreterUtilities.greaterThan(ln.getProperty("value"), rn.getProperty("value")));
        }
        return c;
    }

    @Override
    public Class<?> visit(GreaterOrEqualExpression node) {
        Class<?> c = this.visitRelationalExpression(node);
        Expression ln = node.getLeftExpression();
        Expression rn = node.getRightExpression();
        if (ln.hasProperty("value") && rn.hasProperty("value")) {
            node.setProperty("value", InterpreterUtilities.greaterOrEqual(ln.getProperty("value"), rn.getProperty("value")));
        }
        return c;
    }

    @Override
    public Class<?> visit(BitAndExpression node) {
        Class<?> c = this.visitBitwiseExpression(node);
        Expression ln = node.getLeftExpression();
        Expression rn = node.getRightExpression();
        if (ln.hasProperty("value") && rn.hasProperty("value")) {
            node.setProperty("value", InterpreterUtilities.bitAnd(c, ln.getProperty("value"), rn.getProperty("value")));
        }
        return c;
    }

    @Override
    public Class<?> visit(BitAndAssignExpression node) {
        return this.visitBitwiseAssign(node);
    }

    @Override
    public Class<?> visit(BitOrExpression node) {
        Class<?> c = this.visitBitwiseExpression(node);
        Expression ln = node.getLeftExpression();
        Expression rn = node.getRightExpression();
        if (ln.hasProperty("value") && rn.hasProperty("value")) {
            node.setProperty("value", InterpreterUtilities.bitOr(c, ln.getProperty("value"), rn.getProperty("value")));
        }
        return c;
    }

    @Override
    public Class<?> visit(BitOrAssignExpression node) {
        return this.visitBitwiseAssign(node);
    }

    @Override
    public Class<?> visit(ExclusiveOrExpression node) {
        Class<?> c = this.visitBitwiseExpression(node);
        Expression ln = node.getLeftExpression();
        Expression rn = node.getRightExpression();
        if (ln.hasProperty("value") && rn.hasProperty("value")) {
            node.setProperty("value", InterpreterUtilities.xOr(c, ln.getProperty("value"), rn.getProperty("value")));
        }
        return c;
    }

    @Override
    public Class<?> visit(ExclusiveOrAssignExpression node) {
        return this.visitBitwiseAssign(node);
    }

    @Override
    public Class<?> visit(ShiftLeftExpression node) {
        Class<?> c = this.visitShiftExpression(node);
        Expression ln = node.getLeftExpression();
        Expression rn = node.getRightExpression();
        if (ln.hasProperty("value") && rn.hasProperty("value")) {
            node.setProperty("value", InterpreterUtilities.shiftLeft(NodeProperties.getType(node), ln.getProperty("value"), rn.getProperty("value")));
        }
        return c;
    }

    @Override
    public Class<?> visit(ShiftLeftAssignExpression node) {
        Class<?> c = this.visitShiftExpression(node);
        if (!node.getLeftExpression().hasProperty("modifier")) {
            throw new ExecutionError("shift.left.type", node);
        }
        return c;
    }

    @Override
    public Class<?> visit(ShiftRightExpression node) {
        Class<?> c = this.visitShiftExpression(node);
        Expression ln = node.getLeftExpression();
        Expression rn = node.getRightExpression();
        if (ln.hasProperty("value") && rn.hasProperty("value")) {
            node.setProperty("value", InterpreterUtilities.shiftRight(NodeProperties.getType(node), ln.getProperty("value"), rn.getProperty("value")));
        }
        return c;
    }

    @Override
    public Class<?> visit(ShiftRightAssignExpression node) {
        Class<?> c = this.visitShiftExpression(node);
        if (!node.getLeftExpression().hasProperty("modifier")) {
            throw new ExecutionError("shift.right.type", node);
        }
        return c;
    }

    @Override
    public Class<?> visit(UnsignedShiftRightExpression node) {
        Class<?> c = this.visitShiftExpression(node);
        Expression ln = node.getLeftExpression();
        Expression rn = node.getRightExpression();
        if (ln.hasProperty("value") && rn.hasProperty("value")) {
            node.setProperty("value", InterpreterUtilities.unsignedShiftRight(NodeProperties.getType(node), ln.getProperty("value"), rn.getProperty("value")));
        }
        return c;
    }

    @Override
    public Class<?> visit(UnsignedShiftRightAssignExpression node) {
        Class<?> c = this.visitShiftExpression(node);
        if (!node.getLeftExpression().hasProperty("modifier")) {
            throw new ExecutionError("unsigned.shift.right.type", node);
        }
        return c;
    }

    @Override
    public Class<?> visit(AndExpression node) {
        Expression le = node.getLeftExpression();
        Expression re = node.getRightExpression();
        Class lc = (Class)le.acceptVisitor(this);
        Class rc = (Class)re.acceptVisitor(this);
        if (lc != Boolean.TYPE && lc != (class$java$lang$Boolean == null ? (class$java$lang$Boolean = AbstractTypeChecker.class$("java.lang.Boolean")) : class$java$lang$Boolean) || rc != Boolean.TYPE && rc != (class$java$lang$Boolean == null ? (class$java$lang$Boolean = AbstractTypeChecker.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            throw new ExecutionError("and.type", node);
        }
        if (lc == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = AbstractTypeChecker.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            node.setLeftExpression(this._unbox(le, lc));
        }
        if (rc == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = AbstractTypeChecker.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            node.setRightExpression(this._unbox(re, rc));
        }
        if (le.hasProperty("value") && re.hasProperty("value")) {
            node.setProperty("value", (Boolean)le.getProperty("value") != false && (Boolean)re.getProperty("value") != false ? Boolean.TRUE : Boolean.FALSE);
        }
        node.setProperty("type", Boolean.TYPE);
        return Boolean.TYPE;
    }

    @Override
    public Class<?> visit(OrExpression node) {
        Expression ln = node.getLeftExpression();
        Expression rn = node.getRightExpression();
        Class lc = (Class)ln.acceptVisitor(this);
        Class rc = (Class)rn.acceptVisitor(this);
        if (lc != Boolean.TYPE && lc != (class$java$lang$Boolean == null ? (class$java$lang$Boolean = AbstractTypeChecker.class$("java.lang.Boolean")) : class$java$lang$Boolean) || rc != Boolean.TYPE && rc != (class$java$lang$Boolean == null ? (class$java$lang$Boolean = AbstractTypeChecker.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            throw new ExecutionError("or.type", node);
        }
        if (lc == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = AbstractTypeChecker.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            node.setLeftExpression(this._unbox(ln, lc));
        }
        if (rc == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = AbstractTypeChecker.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            node.setRightExpression(this._unbox(rn, rc));
        }
        if (ln.hasProperty("value") && rn.hasProperty("value")) {
            node.setProperty("value", (Boolean)ln.getProperty("value") != false || (Boolean)rn.getProperty("value") != false ? Boolean.TRUE : Boolean.FALSE);
        }
        node.setProperty("type", Boolean.TYPE);
        return Boolean.TYPE;
    }

    @Override
    public Class<?> visit(InstanceOfExpression node) {
        node.getReferenceType().acceptVisitor(this);
        Class c = (Class)node.getExpression().acceptVisitor(this);
        if (c != null && c.isPrimitive()) {
            throw new ExecutionError("left.expression", node);
        }
        node.setProperty("type", Boolean.TYPE);
        return Boolean.TYPE;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Class<?> visit(ConditionalExpression node) {
        void var8_35;
        Expression condExp = node.getConditionExpression();
        Class type = (Class)condExp.acceptVisitor(this);
        if (type != Boolean.TYPE && type != (class$java$lang$Boolean == null ? (class$java$lang$Boolean = AbstractTypeChecker.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            throw new ExecutionError("condition.type", node);
        }
        if (type == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = AbstractTypeChecker.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            node.setConditionExpression(this._unbox(condExp, type));
        }
        Expression exp1 = node.getIfTrueExpression();
        Expression exp2 = node.getIfFalseExpression();
        Class<?> c1 = (Class<?>)exp1.acceptVisitor(this);
        Class<?> c2 = (Class<?>)exp2.acceptVisitor(this);
        Object var8_8 = null;
        if (TigerUtilities.isBoxingType(c1) && c2.isPrimitive()) {
            if (c1 != (class$java$lang$Boolean == null ? (class$java$lang$Boolean = AbstractTypeChecker.class$("java.lang.Boolean")) : class$java$lang$Boolean) || c2 == Boolean.TYPE) {
                exp1 = this._unbox(exp1, c1);
                c1 = AbstractTypeChecker._correspondingPrimType(c1).getValue();
                node.setIfTrueExpression(exp1);
            }
        } else if (TigerUtilities.isBoxingType(c2) && c1.isPrimitive() && (c2 != (class$java$lang$Boolean == null ? (class$java$lang$Boolean = AbstractTypeChecker.class$("java.lang.Boolean")) : class$java$lang$Boolean) || c1 == Boolean.TYPE)) {
            exp2 = this._unbox(exp2, c2);
            c2 = AbstractTypeChecker._correspondingPrimType(c2).getValue();
            node.setIfFalseExpression(exp2);
        }
        if (c1 == c2) {
            Class<?> clazz = c1;
        } else if (c1 == null) {
            Class<?> clazz = c2;
        } else if (c2 == null) {
            Class<?> clazz = c1;
        } else if (!c1.isPrimitive() && !c2.isPrimitive()) {
            if (c1.isAssignableFrom(c2)) {
                Class<?> clazz = c1;
            } else if (c2.isAssignableFrom(c1)) {
                Class<?> clazz = c2;
            } else {
                Class clazz = class$java$lang$Object == null ? (class$java$lang$Object = AbstractTypeChecker.class$("java.lang.Object")) : class$java$lang$Object;
            }
        } else {
            if (c1 == Void.TYPE || c2 == Void.TYPE) {
                throw new ExecutionError("incompatible.types", node);
            }
            if (c1 == Boolean.TYPE || c2 == Boolean.TYPE || c1 == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = AbstractTypeChecker.class$("java.lang.Boolean")) : class$java$lang$Boolean) || c2 == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = AbstractTypeChecker.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
                if (c1 == Boolean.TYPE && c2.isPrimitive() || c2 == Boolean.TYPE && c1.isPrimitive()) {
                    node.setIfTrueExpression(this._box(exp1, TigerUtilities.correspondingBoxingType(c1)));
                    node.setIfFalseExpression(this._box(exp2, TigerUtilities.correspondingBoxingType(c2)));
                    Class clazz = class$java$lang$Object == null ? (class$java$lang$Object = AbstractTypeChecker.class$("java.lang.Object")) : class$java$lang$Object;
                } else if (c1 == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = AbstractTypeChecker.class$("java.lang.Boolean")) : class$java$lang$Boolean) && c2.isPrimitive()) {
                    node.setIfFalseExpression(this._box(exp2, TigerUtilities.correspondingBoxingType(c2)));
                    Class clazz = class$java$lang$Object == null ? (class$java$lang$Object = AbstractTypeChecker.class$("java.lang.Object")) : class$java$lang$Object;
                } else if (c2 == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = AbstractTypeChecker.class$("java.lang.Boolean")) : class$java$lang$Boolean) && c1.isPrimitive()) {
                    node.setIfTrueExpression(this._box(exp1, TigerUtilities.correspondingBoxingType(c1)));
                    Class clazz = class$java$lang$Object == null ? (class$java$lang$Object = AbstractTypeChecker.class$("java.lang.Object")) : class$java$lang$Object;
                } else if (c1 == Boolean.TYPE && TigerUtilities.isBoxingType(c2)) {
                    node.setIfTrueExpression(this._box(exp1, class$java$lang$Boolean == null ? (class$java$lang$Boolean = AbstractTypeChecker.class$("java.lang.Boolean")) : class$java$lang$Boolean));
                    Class clazz = class$java$lang$Object == null ? (class$java$lang$Object = AbstractTypeChecker.class$("java.lang.Object")) : class$java$lang$Object;
                } else {
                    if (c2 != Boolean.TYPE || !TigerUtilities.isBoxingType(c1)) throw new ExecutionError("incompatible.types", node);
                    node.setIfFalseExpression(this._box(exp2, class$java$lang$Boolean == null ? (class$java$lang$Boolean = AbstractTypeChecker.class$("java.lang.Boolean")) : class$java$lang$Boolean));
                    Class clazz = class$java$lang$Object == null ? (class$java$lang$Object = AbstractTypeChecker.class$("java.lang.Object")) : class$java$lang$Object;
                }
            } else if (c1 == Short.TYPE && c2 == Byte.TYPE || c1 == Byte.TYPE && c2 == Short.TYPE) {
                Class<Short> clazz = Short.TYPE;
            } else if ((c2 == Byte.TYPE || c2 == Short.TYPE || c2 == Character.TYPE) && exp1.hasProperty("value") && c1 == Integer.TYPE) {
                Number n = (Number)exp1.getProperty("value");
                if (c2 == Byte.TYPE) {
                    if (n.intValue() == n.byteValue()) {
                        Class<Byte> clazz = Byte.TYPE;
                    } else {
                        Class<Integer> clazz = Integer.TYPE;
                    }
                } else if (n.intValue() == n.shortValue()) {
                    Class<Comparable<Character>> clazz = c2 == Character.TYPE ? Character.TYPE : Short.TYPE;
                } else {
                    Class<Integer> clazz = Integer.TYPE;
                }
            } else if ((c1 == Byte.TYPE || c1 == Short.TYPE || c1 == Character.TYPE) && exp2.hasProperty("value") && c2 == Integer.TYPE) {
                Number n = (Number)exp2.getProperty("value");
                if (c1 == Byte.TYPE) {
                    if (n.intValue() == n.byteValue()) {
                        Class<Byte> clazz = Byte.TYPE;
                    } else {
                        Class<Integer> clazz = Integer.TYPE;
                    }
                } else if (n.intValue() == n.shortValue()) {
                    Class<Comparable<Character>> clazz = c1 == Character.TYPE ? Character.TYPE : Short.TYPE;
                } else {
                    Class<Integer> clazz = Integer.TYPE;
                }
            } else if (c1 == Double.TYPE || c2 == Double.TYPE) {
                Class<Double> clazz = Double.TYPE;
            } else if (c1 == Float.TYPE || c2 == Float.TYPE) {
                Class<Float> clazz = Float.TYPE;
            } else if (c1 == Long.TYPE || c2 == Long.TYPE) {
                Class<Long> clazz = Long.TYPE;
            } else {
                Class<Integer> clazz = Integer.TYPE;
            }
        }
        node.setProperty("type", var8_35);
        return var8_35;
    }

    @Override
    public Class<?> visit(FormalParameter node) {
        Class c = (Class)node.getType().acceptVisitor(this);
        if (node.isFinal()) {
            this.context.defineConstant(node.getName(), c);
        } else {
            this.context.define(node.getName(), c);
        }
        node.setProperty("type", c);
        return c;
    }

    @Override
    public Class<?> visit(PostIncrement node) {
        Expression exp = node.getExpression();
        Class c = (Class)exp.acceptVisitor(this);
        if (!c.isPrimitive() && !TigerUtilities.isBoxingType(c) || c == Void.TYPE || c == Boolean.TYPE || c == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = AbstractTypeChecker.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            throw new ExecutionError("post.increment.type", node);
        }
        if (!exp.hasProperty("modifier")) {
            throw new ExecutionError("post.increment.type", node);
        }
        node.setProperty("type", c);
        return c;
    }

    @Override
    public Class<?> visit(PreIncrement node) {
        Expression exp = node.getExpression();
        Class c = (Class)exp.acceptVisitor(this);
        if (!c.isPrimitive() && !TigerUtilities.isBoxingType(c) || c == Void.TYPE || c == Boolean.TYPE || c == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = AbstractTypeChecker.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            throw new ExecutionError("pre.increment.type", node);
        }
        if (!exp.hasProperty("modifier")) {
            throw new ExecutionError("pre.increment.type", node);
        }
        node.setProperty("type", c);
        return c;
    }

    @Override
    public Class<?> visit(PostDecrement node) {
        Expression exp = node.getExpression();
        Class c = (Class)exp.acceptVisitor(this);
        if (!c.isPrimitive() && !TigerUtilities.isBoxingType(c) || c == Void.TYPE || c == Boolean.TYPE || c == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = AbstractTypeChecker.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            throw new ExecutionError("post.decrement.type", node);
        }
        if (!exp.hasProperty("modifier")) {
            throw new ExecutionError("post.decrement.type", node);
        }
        node.setProperty("type", c);
        return c;
    }

    @Override
    public Class<?> visit(PreDecrement node) {
        Expression exp = node.getExpression();
        Class c = (Class)exp.acceptVisitor(this);
        if (!c.isPrimitive() && !TigerUtilities.isBoxingType(c) || c == Void.TYPE || c == Boolean.TYPE || c == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = AbstractTypeChecker.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            throw new ExecutionError("pre.decrement.type", node);
        }
        if (!exp.hasProperty("modifier")) {
            throw new ExecutionError("pre.decrement.type", node);
        }
        node.setProperty("type", c);
        return c;
    }

    @Override
    public Class<?> visit(CastExpression node) {
        Class c = (Class)node.getTargetType().acceptVisitor(this);
        this.checkCastStaticRules(c, (Class)node.getExpression().acceptVisitor(this), node);
        node.setProperty("type", c);
        return c;
    }

    private Class<?> visitUnaryOperation(UnaryExpression node, String s) {
        Class<Long> c;
        Expression exp = node.getExpression();
        Class<Number> returnType = c = (Class<Long>)exp.acceptVisitor(this);
        if (c == Character.TYPE || c == Byte.TYPE || c == Short.TYPE || c == Integer.TYPE || c == (class$java$lang$Character == null ? (class$java$lang$Character = AbstractTypeChecker.class$("java.lang.Character")) : class$java$lang$Character) || c == (class$java$lang$Byte == null ? (class$java$lang$Byte = AbstractTypeChecker.class$("java.lang.Byte")) : class$java$lang$Byte) || c == (class$java$lang$Short == null ? (class$java$lang$Short = AbstractTypeChecker.class$("java.lang.Short")) : class$java$lang$Short) || c == (class$java$lang$Integer == null ? (class$java$lang$Integer = AbstractTypeChecker.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            node.setProperty("type", Integer.TYPE);
        } else if (c == Long.TYPE || c == Float.TYPE || c == Double.TYPE || c == (class$java$lang$Long == null ? (class$java$lang$Long = AbstractTypeChecker.class$("java.lang.Long")) : class$java$lang$Long) || c == (class$java$lang$Float == null ? (class$java$lang$Float = AbstractTypeChecker.class$("java.lang.Float")) : class$java$lang$Float) || c == (class$java$lang$Double == null ? (class$java$lang$Double = AbstractTypeChecker.class$("java.lang.Double")) : class$java$lang$Double)) {
            if (c == (class$java$lang$Long == null ? (class$java$lang$Long = AbstractTypeChecker.class$("java.lang.Long")) : class$java$lang$Long)) {
                returnType = Long.TYPE;
            } else if (c == (class$java$lang$Float == null ? (class$java$lang$Float = AbstractTypeChecker.class$("java.lang.Float")) : class$java$lang$Float)) {
                returnType = Float.TYPE;
            } else if (c == (class$java$lang$Double == null ? (class$java$lang$Double = AbstractTypeChecker.class$("java.lang.Double")) : class$java$lang$Double)) {
                returnType = Double.TYPE;
            }
            node.setProperty("type", returnType);
        } else {
            throw new ExecutionError(s, node);
        }
        if (TigerUtilities.isBoxingType(c)) {
            node.setExpression(this._unbox(exp, c));
        }
        return returnType;
    }

    protected Class<?> visitNumericExpression(BinaryExpression node, String s) {
        Expression leftExp = node.getLeftExpression();
        Expression rightExp = node.getRightExpression();
        Class<?> lc = NodeProperties.getType(leftExp);
        Class<?> rc = NodeProperties.getType(rightExp);
        Class<Number> c = null;
        if (lc == null || rc == null || lc == Boolean.TYPE || rc == Boolean.TYPE || !lc.isPrimitive() && !TigerUtilities.isBoxingType(lc) || !rc.isPrimitive() && !TigerUtilities.isBoxingType(rc) || lc == Void.TYPE || rc == Void.TYPE) {
            throw new ExecutionError(s, node);
        }
        if (TigerUtilities.isBoxingType(lc)) {
            node.setLeftExpression(this._unbox(leftExp, lc));
        }
        if (TigerUtilities.isBoxingType(rc)) {
            node.setRightExpression(this._unbox(rightExp, rc));
        }
        if (lc == Double.TYPE || lc == (class$java$lang$Double == null ? (class$java$lang$Double = AbstractTypeChecker.class$("java.lang.Double")) : class$java$lang$Double) || rc == Double.TYPE || rc == (class$java$lang$Double == null ? (class$java$lang$Double = AbstractTypeChecker.class$("java.lang.Double")) : class$java$lang$Double)) {
            c = Double.TYPE;
            node.setProperty("type", c);
        } else if (lc == Float.TYPE || lc == (class$java$lang$Float == null ? (class$java$lang$Float = AbstractTypeChecker.class$("java.lang.Float")) : class$java$lang$Float) || rc == Float.TYPE || rc == (class$java$lang$Float == null ? (class$java$lang$Float = AbstractTypeChecker.class$("java.lang.Float")) : class$java$lang$Float)) {
            c = Float.TYPE;
            node.setProperty("type", c);
        } else if (lc == Long.TYPE || lc == (class$java$lang$Long == null ? (class$java$lang$Long = AbstractTypeChecker.class$("java.lang.Long")) : class$java$lang$Long) || rc == Long.TYPE || rc == (class$java$lang$Long == null ? (class$java$lang$Long = AbstractTypeChecker.class$("java.lang.Long")) : class$java$lang$Long)) {
            c = Long.TYPE;
            node.setProperty("type", c);
        } else {
            c = Integer.TYPE;
            node.setProperty("type", c);
        }
        return c;
    }

    public Expression checkAssignmentStaticRules(Class<?> lc, Class<?> rc, Node node, Expression v) {
        if (lc != null) {
            if (lc.isPrimitive()) {
                if (lc == Boolean.TYPE && rc != Boolean.TYPE) {
                    if (rc == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = AbstractTypeChecker.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
                        return this._unbox(v, class$java$lang$Boolean == null ? (class$java$lang$Boolean = AbstractTypeChecker.class$("java.lang.Boolean")) : class$java$lang$Boolean);
                    }
                    throw new ExecutionError("assignment.types", node);
                }
                if (lc == Byte.TYPE && rc != Byte.TYPE) {
                    Number n;
                    if (rc == (class$java$lang$Byte == null ? (class$java$lang$Byte = AbstractTypeChecker.class$("java.lang.Byte")) : class$java$lang$Byte)) {
                        return this._unbox(v, class$java$lang$Byte == null ? (class$java$lang$Byte = AbstractTypeChecker.class$("java.lang.Byte")) : class$java$lang$Byte);
                    }
                    if (rc == Integer.TYPE && v.hasProperty("value") && (n = (Number)v.getProperty("value")).intValue() == n.byteValue()) {
                        return v;
                    }
                    throw new ExecutionError("assignment.types", node);
                }
                if ((lc == Short.TYPE || lc == Character.TYPE) && rc != Byte.TYPE && rc != Short.TYPE && rc != Character.TYPE) {
                    Number n;
                    if (lc == Short.TYPE && rc == (class$java$lang$Short == null ? (class$java$lang$Short = AbstractTypeChecker.class$("java.lang.Short")) : class$java$lang$Short)) {
                        return this._unbox(v, class$java$lang$Short == null ? (class$java$lang$Short = AbstractTypeChecker.class$("java.lang.Short")) : class$java$lang$Short);
                    }
                    if (lc == Character.TYPE && rc == (class$java$lang$Character == null ? (class$java$lang$Character = AbstractTypeChecker.class$("java.lang.Character")) : class$java$lang$Character)) {
                        return this._unbox(v, class$java$lang$Character == null ? (class$java$lang$Character = AbstractTypeChecker.class$("java.lang.Character")) : class$java$lang$Character);
                    }
                    if (rc == Integer.TYPE && v.hasProperty("value") && (n = (Number)v.getProperty("value")).intValue() == n.shortValue()) {
                        return v;
                    }
                    throw new ExecutionError("assignment.types", node);
                }
                if (lc == Integer.TYPE && rc != Byte.TYPE && rc != Short.TYPE && rc != Character.TYPE && rc != Integer.TYPE) {
                    if (rc == (class$java$lang$Byte == null ? (class$java$lang$Byte = AbstractTypeChecker.class$("java.lang.Byte")) : class$java$lang$Byte) || rc == (class$java$lang$Short == null ? (class$java$lang$Short = AbstractTypeChecker.class$("java.lang.Short")) : class$java$lang$Short) || rc == (class$java$lang$Character == null ? (class$java$lang$Character = AbstractTypeChecker.class$("java.lang.Character")) : class$java$lang$Character) || rc == (class$java$lang$Integer == null ? (class$java$lang$Integer = AbstractTypeChecker.class$("java.lang.Integer")) : class$java$lang$Integer)) {
                        return this._unbox(v, rc);
                    }
                    throw new ExecutionError("assignment.types", node);
                }
                if (!(lc != Long.TYPE || rc != null && rc.isPrimitive() && rc != Void.TYPE && rc != Boolean.TYPE && rc != Float.TYPE && rc != Double.TYPE)) {
                    if (TigerUtilities.isBoxingType(rc) && TigerUtilities.isIntegralType(rc)) {
                        return this._unbox(v, rc);
                    }
                    throw new ExecutionError("assignment.types", node);
                }
                if (!(lc != Float.TYPE || rc != null && rc.isPrimitive() && rc != Void.TYPE && rc != Boolean.TYPE && rc != Double.TYPE)) {
                    if (TigerUtilities.isBoxingType(rc) && rc != (class$java$lang$Boolean == null ? (class$java$lang$Boolean = AbstractTypeChecker.class$("java.lang.Boolean")) : class$java$lang$Boolean) && rc != (class$java$lang$Double == null ? (class$java$lang$Double = AbstractTypeChecker.class$("java.lang.Double")) : class$java$lang$Double)) {
                        return this._unbox(v, rc);
                    }
                    throw new ExecutionError("assignment.types", node);
                }
                if (!(lc != Double.TYPE || rc != null && rc.isPrimitive() && rc != Void.TYPE && rc != Boolean.TYPE)) {
                    if (TigerUtilities.isBoxingType(rc) && rc != (class$java$lang$Boolean == null ? (class$java$lang$Boolean = AbstractTypeChecker.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
                        return this._unbox(v, rc);
                    }
                    throw new ExecutionError("assignment.types", node);
                }
            } else if (rc != null) {
                if (rc.isPrimitive()) {
                    Class<?> boxedRc = AbstractTypeChecker._correspondingRefClass(rc);
                    if (lc.isAssignableFrom(boxedRc)) {
                        return this._box(v, boxedRc);
                    }
                    if (TigerUtilities.boxesTo(rc, lc)) {
                        return this._box(v, lc);
                    }
                    throw new ExecutionError("assignment.types", node);
                }
                if (!lc.isAssignableFrom(rc) && !rc.isAssignableFrom(lc)) {
                    throw new ExecutionError("assignment.types", node);
                }
            }
        }
        return v;
    }

    private void checkEqualityStaticRules(Class<?> lc, Class<?> rc, BinaryExpression n) {
        Expression leftExp = n.getLeftExpression();
        Expression rightExp = n.getRightExpression();
        if (lc != null && rc != null) {
            ObjectMethodCall methodCall;
            if (TigerUtilities.isBoxingType(lc) && rc.isPrimitive()) {
                methodCall = this._unbox(leftExp, lc);
                n.setLeftExpression(methodCall);
                lc = (Class)methodCall.getProperty("type");
            }
            if (TigerUtilities.isBoxingType(rc) && lc.isPrimitive()) {
                methodCall = this._unbox(rightExp, rc);
                n.setRightExpression(methodCall);
                rc = (Class)methodCall.getProperty("type");
            }
        }
        if (lc != rc || lc == Void.TYPE) {
            if (lc == Void.TYPE || rc == Void.TYPE || lc == Boolean.TYPE || rc == Boolean.TYPE) {
                throw new ExecutionError("compare.type", n);
            }
            if (lc == null && rc.isPrimitive() || rc == null && lc.isPrimitive()) {
                throw new ExecutionError("compare.type", n);
            }
            if (lc != null && rc != null) {
                if (lc.isPrimitive() ^ rc.isPrimitive()) {
                    throw new ExecutionError("compare.type", n);
                }
                if (!(lc.isPrimitive() || rc.isPrimitive() || lc.isAssignableFrom(rc) || rc.isAssignableFrom(lc))) {
                    throw new ExecutionError("compare.type", n);
                }
            }
        }
    }

    private Class<?> visitRelationalExpression(BinaryExpression node) {
        Expression leftExp = node.getLeftExpression();
        Expression rightExp = node.getRightExpression();
        Class lc = (Class)leftExp.acceptVisitor(this);
        Class rc = (Class)rightExp.acceptVisitor(this);
        if (lc == null || rc == null || lc == Void.TYPE || rc == Void.TYPE || lc == Boolean.TYPE || rc == Boolean.TYPE || !lc.isPrimitive() && !TigerUtilities.isBoxingType(lc) || !rc.isPrimitive() && !TigerUtilities.isBoxingType(rc)) {
            throw new ExecutionError("relational.expression.type", node);
        }
        if (TigerUtilities.isBoxingType(lc)) {
            node.setLeftExpression(this._unbox(leftExp, lc));
        }
        if (TigerUtilities.isBoxingType(rc)) {
            node.setRightExpression(this._unbox(rightExp, rc));
        }
        node.setProperty("type", Boolean.TYPE);
        return Boolean.TYPE;
    }

    private Class<?> visitBitwiseExpression(BinaryExpression node) {
        boolean boolRight;
        boolean boolLeft;
        Expression leftExp = node.getLeftExpression();
        Expression rightExp = node.getRightExpression();
        Class lc = (Class)leftExp.acceptVisitor(this);
        Class rc = (Class)rightExp.acceptVisitor(this);
        Class<Constable> c = null;
        boolean intLeft = TigerUtilities.isIntegralType(lc);
        boolean intRight = TigerUtilities.isIntegralType(rc);
        boolean bl = lc == Boolean.TYPE || lc == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = AbstractTypeChecker.class$("java.lang.Boolean")) : class$java$lang$Boolean) ? true : (boolLeft = false);
        boolean bl2 = rc == Boolean.TYPE || rc == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = AbstractTypeChecker.class$("java.lang.Boolean")) : class$java$lang$Boolean) ? true : (boolRight = false);
        if (!(intLeft && intRight || boolLeft && boolRight)) {
            throw new ExecutionError("bitwise.expression.type", node);
        }
        if (TigerUtilities.isBoxingType(lc)) {
            node.setLeftExpression(this._unbox(leftExp, lc));
        }
        if (TigerUtilities.isBoxingType(rc)) {
            node.setRightExpression(this._unbox(rightExp, rc));
        }
        if (lc == Long.TYPE || rc == Long.TYPE || lc == (class$java$lang$Long == null ? (class$java$lang$Long = AbstractTypeChecker.class$("java.lang.Long")) : class$java$lang$Long) || rc == (class$java$lang$Long == null ? (class$java$lang$Long = AbstractTypeChecker.class$("java.lang.Long")) : class$java$lang$Long)) {
            c = Long.TYPE;
            node.setProperty("type", c);
        } else if (boolLeft) {
            c = Boolean.TYPE;
            node.setProperty("type", c);
        } else {
            c = Integer.TYPE;
            node.setProperty("type", c);
        }
        return c;
    }

    private Class<?> visitBitwiseAssign(BinaryExpression node) {
        Expression ln = node.getLeftExpression();
        Class lc = (Class)ln.acceptVisitor(this);
        Class rc = (Class)node.getRightExpression().acceptVisitor(this);
        if (lc == null || rc == null || lc == Void.TYPE || rc == Void.TYPE || lc == Float.TYPE || rc == Float.TYPE || lc == Double.TYPE || rc == Double.TYPE || (lc == Boolean.TYPE || lc == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = AbstractTypeChecker.class$("java.lang.Boolean")) : class$java$lang$Boolean)) ^ (rc == Boolean.TYPE || rc == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = AbstractTypeChecker.class$("java.lang.Boolean")) : class$java$lang$Boolean)) || !lc.isPrimitive() && !TigerUtilities.isBoxingType(lc) || !rc.isPrimitive() && !TigerUtilities.isBoxingType(rc)) {
            throw new ExecutionError("bitwise.expression.type", node);
        }
        if (!ln.hasProperty("modifier")) {
            throw new ExecutionError("left.expression", node);
        }
        node.setProperty("type", lc);
        return lc;
    }

    private Class<?> visitShiftExpression(BinaryExpression node) {
        Expression leftExp = node.getLeftExpression();
        Expression rightExp = node.getRightExpression();
        Class lc = (Class)leftExp.acceptVisitor(this);
        Class rc = (Class)rightExp.acceptVisitor(this);
        Class<Number> c = null;
        if (lc == null || rc == null || lc == Boolean.TYPE || rc == Boolean.TYPE || lc == Void.TYPE || rc == Void.TYPE || lc == Float.TYPE || rc == Float.TYPE || lc == (class$java$lang$Float == null ? (class$java$lang$Float = AbstractTypeChecker.class$("java.lang.Float")) : class$java$lang$Float) || rc == (class$java$lang$Float == null ? (class$java$lang$Float = AbstractTypeChecker.class$("java.lang.Float")) : class$java$lang$Float) || lc == Double.TYPE || rc == Double.TYPE || lc == (class$java$lang$Double == null ? (class$java$lang$Double = AbstractTypeChecker.class$("java.lang.Double")) : class$java$lang$Double) || rc == (class$java$lang$Double == null ? (class$java$lang$Double = AbstractTypeChecker.class$("java.lang.Double")) : class$java$lang$Double) || !lc.isPrimitive() && !TigerUtilities.isBoxingType(lc) || !rc.isPrimitive() && !TigerUtilities.isBoxingType(rc)) {
            throw new ExecutionError("shift.expression.type", node);
        }
        if (TigerUtilities.isBoxingType(lc) && !leftExp.hasProperty("modifier")) {
            node.setLeftExpression(this._unbox(leftExp, lc));
        }
        if (TigerUtilities.isBoxingType(rc)) {
            node.setRightExpression(this._unbox(rightExp, rc));
        }
        if (lc == Long.TYPE || lc == (class$java$lang$Long == null ? (class$java$lang$Long = AbstractTypeChecker.class$("java.lang.Long")) : class$java$lang$Long)) {
            c = Long.TYPE;
            node.setProperty("type", c);
        } else {
            c = Integer.TYPE;
            node.setProperty("type", c);
        }
        return c;
    }

    private void checkCastStaticRules(Class<?> tc, Class<?> ec, CastExpression castExp) {
        if (tc != ec) {
            if (tc.isPrimitive()) {
                boolean isBoxingType = TigerUtilities.isBoxingType(ec);
                if (ec == null || ec == Boolean.TYPE || tc == Boolean.TYPE && ec != (class$java$lang$Boolean == null ? (class$java$lang$Boolean = AbstractTypeChecker.class$("java.lang.Boolean")) : class$java$lang$Boolean) || !ec.isPrimitive() && !isBoxingType || ec == Void.TYPE) {
                    throw new ExecutionError("cast", castExp);
                }
                if (isBoxingType) {
                    castExp.setExpression(this._unbox(castExp.getExpression(), ec));
                }
            } else if (ec != null) {
                if (ec.isArray()) {
                    if (tc.isArray()) {
                        Class<?> tec = tc.getComponentType();
                        Class<?> eec = ec.getComponentType();
                        if (tec.isPrimitive() && eec.isPrimitive()) {
                            if (tec != eec) {
                                throw new ExecutionError("cast", castExp);
                            }
                        } else {
                            this.checkCastStaticRules(tec, eec, castExp);
                        }
                    } else {
                        if (tc.isInterface() && tc != (class$java$lang$Cloneable == null ? (class$java$lang$Cloneable = AbstractTypeChecker.class$("java.lang.Cloneable")) : class$java$lang$Cloneable)) {
                            throw new ExecutionError("cast", castExp);
                        }
                        if (tc != (class$java$lang$Object == null ? (class$java$lang$Object = AbstractTypeChecker.class$("java.lang.Object")) : class$java$lang$Object)) {
                            throw new ExecutionError("cast", castExp);
                        }
                    }
                } else if (ec.isInterface()) {
                    if (tc.isArray() ? !(class$java$lang$Cloneable == null ? (class$java$lang$Cloneable = AbstractTypeChecker.class$("java.lang.Cloneable")) : class$java$lang$Cloneable).isAssignableFrom(ec) : !tc.isInterface() && AbstractTypeChecker.isFinal(tc) && !ec.isAssignableFrom(tc)) {
                        throw new ExecutionError("cast", castExp);
                    }
                } else if (tc.isInterface()) {
                    if (AbstractTypeChecker.isFinal(ec) && !tc.isAssignableFrom(ec)) {
                        throw new ExecutionError("cast", castExp);
                    }
                } else if (ec.isPrimitive() && TigerUtilities.isBoxingType(tc) && ec != Boolean.TYPE) {
                    castExp.setExpression(this._box(castExp.getExpression(), tc));
                } else if (!ec.isAssignableFrom(tc) && !tc.isAssignableFrom(ec)) {
                    throw new ExecutionError("cast", castExp);
                }
            }
        }
    }

    private static boolean isFinal(Class<?> c) {
        return Modifier.isFinal(c.getModifiers());
    }

    private void checkList(List<? extends Node> l) {
        ListIterator<? extends Node> it = l.listIterator();
        while (it.hasNext()) {
            it.next().acceptVisitor(this);
        }
    }

    protected static PrimitiveType _correspondingPrimType(Class<?> refClass) {
        if (refClass == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = AbstractTypeChecker.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            return new BooleanType();
        }
        if (refClass == (class$java$lang$Byte == null ? (class$java$lang$Byte = AbstractTypeChecker.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            return new ByteType();
        }
        if (refClass == (class$java$lang$Character == null ? (class$java$lang$Character = AbstractTypeChecker.class$("java.lang.Character")) : class$java$lang$Character)) {
            return new CharType();
        }
        if (refClass == (class$java$lang$Short == null ? (class$java$lang$Short = AbstractTypeChecker.class$("java.lang.Short")) : class$java$lang$Short)) {
            return new ShortType();
        }
        if (refClass == (class$java$lang$Integer == null ? (class$java$lang$Integer = AbstractTypeChecker.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            return new IntType();
        }
        if (refClass == (class$java$lang$Long == null ? (class$java$lang$Long = AbstractTypeChecker.class$("java.lang.Long")) : class$java$lang$Long)) {
            return new LongType();
        }
        if (refClass == (class$java$lang$Float == null ? (class$java$lang$Float = AbstractTypeChecker.class$("java.lang.Float")) : class$java$lang$Float)) {
            return new FloatType();
        }
        if (refClass == (class$java$lang$Double == null ? (class$java$lang$Double = AbstractTypeChecker.class$("java.lang.Double")) : class$java$lang$Double)) {
            return new DoubleType();
        }
        throw new RuntimeException(new StringBuffer().append("No corresponding primitive type for reference class ").append(refClass).append(".").toString());
    }

    protected static Class<?> _correspondingRefClass(Class<?> primClass) {
        if (primClass == Boolean.TYPE) {
            return class$java$lang$Boolean == null ? (class$java$lang$Boolean = AbstractTypeChecker.class$("java.lang.Boolean")) : class$java$lang$Boolean;
        }
        if (primClass == Byte.TYPE) {
            return class$java$lang$Byte == null ? (class$java$lang$Byte = AbstractTypeChecker.class$("java.lang.Byte")) : class$java$lang$Byte;
        }
        if (primClass == Character.TYPE) {
            return class$java$lang$Character == null ? (class$java$lang$Character = AbstractTypeChecker.class$("java.lang.Character")) : class$java$lang$Character;
        }
        if (primClass == Short.TYPE) {
            return class$java$lang$Short == null ? (class$java$lang$Short = AbstractTypeChecker.class$("java.lang.Short")) : class$java$lang$Short;
        }
        if (primClass == Integer.TYPE) {
            return class$java$lang$Integer == null ? (class$java$lang$Integer = AbstractTypeChecker.class$("java.lang.Integer")) : class$java$lang$Integer;
        }
        if (primClass == Long.TYPE) {
            return class$java$lang$Long == null ? (class$java$lang$Long = AbstractTypeChecker.class$("java.lang.Long")) : class$java$lang$Long;
        }
        if (primClass == Float.TYPE) {
            return class$java$lang$Float == null ? (class$java$lang$Float = AbstractTypeChecker.class$("java.lang.Float")) : class$java$lang$Float;
        }
        if (primClass == Double.TYPE) {
            return class$java$lang$Double == null ? (class$java$lang$Double = AbstractTypeChecker.class$("java.lang.Double")) : class$java$lang$Double;
        }
        throw new RuntimeException(new StringBuffer().append("No corresponding reference class for primitive class (?) ").append(primClass).append(".").toString());
    }

    protected abstract SimpleAllocation _box(Expression var1, Class<?> var2);

    protected abstract ObjectMethodCall _unbox(Expression var1, Class<?> var2);

    @Override
    public /* synthetic */ Object visit(InstanceInitializer x0) {
        return super.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(ClassInitializer x0) {
        return super.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(VariableDeclaration x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(FieldDeclaration x0) {
        return super.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(FormalParameter x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(MethodDeclaration x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(ConstructorDeclaration x0) {
        return super.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(InterfaceDeclaration x0) {
        return super.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(ClassDeclaration x0) {
        return super.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(BlockStatement x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(BitOrAssignExpression x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(ExclusiveOrAssignExpression x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(BitAndAssignExpression x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(UnsignedShiftRightAssignExpression x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(ShiftRightAssignExpression x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(ShiftLeftAssignExpression x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(SubtractAssignExpression x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(AddAssignExpression x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(RemainderAssignExpression x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(DivideAssignExpression x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(MultiplyAssignExpression x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(SimpleAssignExpression x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(ConditionalExpression x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(OrExpression x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(AndExpression x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(BitOrExpression x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(ExclusiveOrExpression x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(BitAndExpression x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(NotEqualExpression x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(EqualExpression x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(InstanceOfExpression x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(GreaterOrEqualExpression x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(LessOrEqualExpression x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(GreaterExpression x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(LessExpression x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(UnsignedShiftRightExpression x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(ShiftRightExpression x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(ShiftLeftExpression x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(SubtractExpression x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(AddExpression x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(RemainderExpression x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(DivideExpression x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(MultiplyExpression x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(MinusExpression x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(PlusExpression x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(ComplementExpression x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(NotExpression x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(CastExpression x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(InnerClassAllocation x0) {
        return super.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(InnerAllocation x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(ClassAllocation x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(SimpleAllocation x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(ArrayAllocation x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(ArrayInitializer x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(PreDecrement x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(PreIncrement x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(PostDecrement x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(PostIncrement x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(TypeExpression x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(ArrayType x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(ReferenceType x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(PrimitiveType x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(SuperMethodCall x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(ConstructorInvocation x0) {
        return super.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(StaticMethodCall x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(FunctionCall x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(ObjectMethodCall x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(SuperFieldAccess x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(ArrayAccess x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(StaticFieldAccess x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(ObjectFieldAccess x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(QualifiedName x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(ThisExpression x0) {
        return super.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(Literal x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(AssertStatement x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(IfThenElseStatement x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(IfThenStatement x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(ContinueStatement x0) {
        return super.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(SynchronizedStatement x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(ReturnStatement x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(ThrowStatement x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(CatchStatement x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(TryStatement x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(BreakStatement x0) {
        return super.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(LabeledStatement x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(SwitchBlock x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(SwitchStatement x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(DoStatement x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(ForEachStatement x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(ForStatement x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(WhileStatement x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(EmptyStatement x0) {
        return super.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(ImportDeclaration x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(PackageDeclaration x0) {
        return this.visit(x0);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }
}

