/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.util.newjvm;

import edu.rice.cs.util.FileOps;
import edu.rice.cs.util.newjvm.IRemoteClassLoader;
import java.io.IOException;
import java.net.URL;
import java.rmi.RemoteException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomSystemClassLoader
extends ClassLoader {
    IRemoteClassLoader _master = null;

    public CustomSystemClassLoader(ClassLoader c) {
        super(c);
    }

    public void setMasterRemote(IRemoteClassLoader m) {
        this._master = m;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(name);
        if (c != null) {
            return c;
        }
        try {
            String fileName = new StringBuffer().append(name.replace('.', '/')).append(".class").toString();
            URL resource = this.getParent().getResource(fileName);
            if (resource == null) {
                throw new ClassNotFoundException(new StringBuffer().append("Resource not found: ").append(fileName).toString());
            }
            if (fileName.startsWith("edu/rice/cs/util/newjvm/SlaveJVMRunner.class")) {
                byte[] data = FileOps.readStreamAsBytes(resource.openStream());
                return this.defineClass(name, data, 0, data.length);
            }
            return this.getParent().loadClass(name);
        }
        catch (ClassNotFoundException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            if (this._master != null) {
                String fileName = new StringBuffer().append(name.replace('.', '/')).append(".class").toString();
                URL resource = this._master.getRemoteResource(fileName);
                if (resource == null) {
                    throw new ClassNotFoundException(new StringBuffer().append("Resource not found: ").append(fileName).toString());
                }
                byte[] data = FileOps.readStreamAsBytes(resource.openStream());
                return this.defineClass(name, data, 0, data.length);
            }
            throw new ClassNotFoundException();
        }
        catch (RemoteException e) {
            throw new ClassNotFoundException();
        }
        catch (IOException e) {
            throw new ClassNotFoundException();
        }
    }
}

