/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.util.docnavigation;

import edu.rice.cs.util.Pair;
import edu.rice.cs.util.docnavigation.IDocumentNavigator;
import edu.rice.cs.util.docnavigation.IDocumentNavigatorFactory;
import edu.rice.cs.util.docnavigation.INavigationListener;
import edu.rice.cs.util.docnavigation.INavigatorItem;
import edu.rice.cs.util.docnavigation.INavigatorItemFilter;
import edu.rice.cs.util.docnavigation.JListSortNavigator;
import edu.rice.cs.util.docnavigation.JTreeSortNavigator;
import edu.rice.cs.util.swing.Utilities;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AWTContainerNavigatorFactory<ItemT extends INavigatorItem>
implements IDocumentNavigatorFactory<ItemT> {
    @Override
    public IDocumentNavigator<ItemT> makeListNavigator() {
        return new JListSortNavigator();
    }

    @Override
    public IDocumentNavigator<ItemT> makeTreeNavigator(String name) {
        return new JTreeSortNavigator(name);
    }

    @Override
    public IDocumentNavigator<ItemT> makeListNavigator(final IDocumentNavigator<ItemT> parent) {
        final IDocumentNavigator<ItemT> tbr = this.makeListNavigator();
        Utilities.invokeAndWait(new Runnable(){

            public void run() {
                AWTContainerNavigatorFactory.access$000(AWTContainerNavigatorFactory.this, tbr, parent);
                AWTContainerNavigatorFactory.access$100(AWTContainerNavigatorFactory.this, tbr, parent);
            }
        });
        return tbr;
    }

    @Override
    public IDocumentNavigator<ItemT> makeTreeNavigator(String name, final IDocumentNavigator<ItemT> parent, final List<Pair<String, INavigatorItemFilter<ItemT>>> l) {
        final IDocumentNavigator<ItemT> tbr = this.makeTreeNavigator(name);
        Utilities.invokeAndWait(new Runnable(){

            public void run() {
                Iterator i$ = l.iterator();
                while (i$.hasNext()) {
                    Pair p = (Pair)i$.next();
                    tbr.addTopLevelGroup((String)p.getFirst(), (INavigatorItemFilter)p.getSecond());
                }
                AWTContainerNavigatorFactory.access$000(AWTContainerNavigatorFactory.this, tbr, parent);
                AWTContainerNavigatorFactory.access$100(AWTContainerNavigatorFactory.this, tbr, parent);
            }
        });
        return tbr;
    }

    private void migrateNavigatorItems(IDocumentNavigator<ItemT> child, IDocumentNavigator<ItemT> parent) {
        Enumeration<ItemT> enumerator = parent.getDocuments();
        while (enumerator.hasMoreElements()) {
            INavigatorItem navitem = (INavigatorItem)enumerator.nextElement();
            parent.removeDocument(navitem);
            child.addDocument(navitem);
            enumerator = parent.getDocuments();
        }
    }

    private void migrateListeners(IDocumentNavigator<ItemT> child, IDocumentNavigator<ItemT> parent) {
        Collection<INavigationListener<ItemT>> listeners = parent.getNavigatorListeners();
        Iterator<INavigationListener<ItemT>> it = listeners.iterator();
        while (it.hasNext()) {
            INavigationListener<ItemT> listener = it.next();
            child.addNavigationListener(listener);
            parent.removeNavigationListener(listener);
            it = listeners.iterator();
        }
    }

    static void access$000(AWTContainerNavigatorFactory x0, IDocumentNavigator x1, IDocumentNavigator x2) {
        x0.migrateNavigatorItems(x1, x2);
    }

    static void access$100(AWTContainerNavigatorFactory x0, IDocumentNavigator x1, IDocumentNavigator x2) {
        x0.migrateListeners(x1, x2);
    }
}

