/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClasspathVector
extends Vector<URL> {
    public ClasspathVector() {
    }

    public ClasspathVector(int capacity) {
        super(capacity);
    }

    @Override
    public String toString() {
        StringBuffer cp = new StringBuffer();
        for (URL u : this) {
            cp.append(this.formatURL(u));
            cp.append(File.pathSeparator);
        }
        return cp.toString();
    }

    public void add(String entry) {
        try {
            this.add(new URL(entry));
        }
        catch (MalformedURLException e) {
            IllegalArgumentException ee = new IllegalArgumentException(e.toString());
            ee.initCause(e);
            throw ee;
        }
    }

    public void add(File entry) {
        try {
            this.add(entry.toURL());
        }
        catch (MalformedURLException e) {
            IllegalArgumentException ee = new IllegalArgumentException(e.toString());
            ee.initCause(e);
            throw ee;
        }
    }

    public Vector<File> asFileVector() {
        Vector<File> v = new Vector<File>();
        for (URL url : this) {
            v.add(new File(url.getFile()));
        }
        return v;
    }

    private String formatURL(URL url) {
        return new File(url.getFile()).toString();
    }
}

