/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.javalanglevels.tree;

import edu.rice.cs.javalanglevels.SourceInfo;
import edu.rice.cs.javalanglevels.tree.Expression;
import edu.rice.cs.javalanglevels.tree.JExpressionIFVisitor;
import edu.rice.cs.javalanglevels.tree.JExpressionIFVisitor_void;
import edu.rice.cs.javalanglevels.tree.Statement;
import edu.rice.cs.javalanglevels.tree.SwitchCase;
import edu.rice.cs.javalanglevels.tree.TabPrintWriter;
import java.io.StringWriter;
import java.io.Writer;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwitchStatement
extends Statement {
    private final Expression _test;
    private final SwitchCase[] _cases;

    public SwitchStatement(SourceInfo in_sourceInfo, Expression in_test, SwitchCase[] in_cases) {
        super(in_sourceInfo);
        if (in_test == null) {
            throw new IllegalArgumentException("Parameter 'test' to the SwitchStatement constructor was null. This class may not have null field values.");
        }
        this._test = in_test;
        if (in_cases == null) {
            throw new IllegalArgumentException("Parameter 'cases' to the SwitchStatement constructor was null. This class may not have null field values.");
        }
        this._cases = in_cases;
    }

    public final Expression getTest() {
        return this._test;
    }

    public final SwitchCase[] getCases() {
        return this._cases;
    }

    @Override
    public <RetType> RetType visit(JExpressionIFVisitor<RetType> visitor) {
        return visitor.forSwitchStatement(this);
    }

    @Override
    public void visit(JExpressionIFVisitor_void visitor) {
        visitor.forSwitchStatement(this);
    }

    public String toString() {
        StringWriter w = new StringWriter();
        this.output(w);
        return w.toString();
    }

    public void output(Writer writer) {
        this.outputHelp(new TabPrintWriter(writer, 2));
    }

    @Override
    public void outputHelp(TabPrintWriter writer) {
        writer.print("SwitchStatement:");
        writer.indent();
        writer.startLine("");
        writer.print("sourceInfo = ");
        SourceInfo temp_sourceInfo = this.getSourceInfo();
        if (temp_sourceInfo == null) {
            writer.print("null");
        } else {
            writer.print(temp_sourceInfo);
        }
        writer.startLine("");
        writer.print("test = ");
        Expression temp_test = this.getTest();
        if (temp_test == null) {
            writer.print("null");
        } else {
            temp_test.outputHelp(writer);
        }
        writer.startLine("");
        writer.print("cases = ");
        writer.print("{");
        writer.indent();
        for (int i = 0; i < this.getCases().length; ++i) {
            SwitchCase temp_cases = this.getCases()[i];
            writer.startLine(new StringBuffer().append("#").append(i).append(": ").toString());
            if (temp_cases == null) {
                writer.print("null");
                continue;
            }
            temp_cases.outputHelp(writer);
        }
        writer.unindent();
        if (this.getCases().length > 0) {
            writer.startLine("");
        }
        writer.print("}");
        writer.unindent();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass() || obj.hashCode() != this.hashCode()) {
            return false;
        }
        SwitchStatement casted = (SwitchStatement)obj;
        if (!this.getTest().equals(casted.getTest())) {
            return false;
        }
        if (this.getCases().length != casted.getCases().length) {
            return false;
        }
        for (int i = 0; i < this.getCases().length; ++i) {
            if (this.getCases()[i].equals(casted.getCases()[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    protected int generateHashCode() {
        int code = this.getClass().hashCode();
        code ^= 0;
        code ^= this.getTest().hashCode();
        for (int i = 0; i < this.getCases().length; ++i) {
            code ^= this.getCases()[i].hashCode();
        }
        return code;
    }
}

