/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui;

import com.rc.retroweaver.runtime.Autobox;
import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.BooleanOption;
import edu.rice.cs.drjava.config.FileConfiguration;
import edu.rice.cs.drjava.config.FileOption;
import edu.rice.cs.drjava.config.KeyStrokeOption;
import edu.rice.cs.drjava.config.Option;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.config.OptionEvent;
import edu.rice.cs.drjava.config.OptionListener;
import edu.rice.cs.drjava.model.AlreadyOpenException;
import edu.rice.cs.drjava.model.DefaultGlobalModel;
import edu.rice.cs.drjava.model.DummyOpenDefDoc;
import edu.rice.cs.drjava.model.FileMovedException;
import edu.rice.cs.drjava.model.FileOpenSelector;
import edu.rice.cs.drjava.model.FileSaveSelector;
import edu.rice.cs.drjava.model.GlobalModelListener;
import edu.rice.cs.drjava.model.GlobalModelNaming;
import edu.rice.cs.drjava.model.JavadocModel;
import edu.rice.cs.drjava.model.OpenDefinitionsDocument;
import edu.rice.cs.drjava.model.OperationCanceledException;
import edu.rice.cs.drjava.model.SingleDisplayModel;
import edu.rice.cs.drjava.model.debug.Breakpoint;
import edu.rice.cs.drjava.model.debug.DebugException;
import edu.rice.cs.drjava.model.debug.DebugListener;
import edu.rice.cs.drjava.model.debug.DebugThreadData;
import edu.rice.cs.drjava.model.debug.Debugger;
import edu.rice.cs.drjava.model.definitions.ClassNameNotFoundException;
import edu.rice.cs.drjava.model.definitions.DocumentUIListener;
import edu.rice.cs.drjava.model.definitions.InvalidPackageException;
import edu.rice.cs.drjava.model.definitions.NoSuchDocumentException;
import edu.rice.cs.drjava.model.repl.InteractionsScriptModel;
import edu.rice.cs.drjava.platform.PlatformFactory;
import edu.rice.cs.drjava.project.DocumentInfoGetter;
import edu.rice.cs.drjava.project.MalformedProjectFileException;
import edu.rice.cs.drjava.ui.AboutDialog;
import edu.rice.cs.drjava.ui.BackgroundColorListener;
import edu.rice.cs.drjava.ui.CompilerErrorPanel;
import edu.rice.cs.drjava.ui.ConsoleController;
import edu.rice.cs.drjava.ui.DebugPanel;
import edu.rice.cs.drjava.ui.DefinitionsPane;
import edu.rice.cs.drjava.ui.DrJavaScrollableDialog;
import edu.rice.cs.drjava.ui.ErrorCaretListener;
import edu.rice.cs.drjava.ui.ErrorPanel;
import edu.rice.cs.drjava.ui.FindReplaceDialog;
import edu.rice.cs.drjava.ui.ForegroundColorListener;
import edu.rice.cs.drjava.ui.HelpFrame;
import edu.rice.cs.drjava.ui.HistorySaveDialog;
import edu.rice.cs.drjava.ui.InteractionsController;
import edu.rice.cs.drjava.ui.InteractionsHistoryFilter;
import edu.rice.cs.drjava.ui.InteractionsPane;
import edu.rice.cs.drjava.ui.InteractionsScriptController;
import edu.rice.cs.drjava.ui.InteractionsScriptPane;
import edu.rice.cs.drjava.ui.JUnitPanel;
import edu.rice.cs.drjava.ui.JarOptionsDialog;
import edu.rice.cs.drjava.ui.JavaSourceFilter;
import edu.rice.cs.drjava.ui.JavadocDialog;
import edu.rice.cs.drjava.ui.JavadocErrorPanel;
import edu.rice.cs.drjava.ui.JavadocFrame;
import edu.rice.cs.drjava.ui.KeyBindingManager;
import edu.rice.cs.drjava.ui.LineEnumRule;
import edu.rice.cs.drjava.ui.PreviewConsoleFrame;
import edu.rice.cs.drjava.ui.PreviewDefDocFrame;
import edu.rice.cs.drjava.ui.ProjectPropertiesFrame;
import edu.rice.cs.drjava.ui.QuickStartFrame;
import edu.rice.cs.drjava.ui.RecentDocFrame;
import edu.rice.cs.drjava.ui.RecentFileManager;
import edu.rice.cs.drjava.ui.RightClickMouseAdapter;
import edu.rice.cs.drjava.ui.TabbedPanel;
import edu.rice.cs.drjava.ui.config.ConfigFrame;
import edu.rice.cs.util.ClasspathVector;
import edu.rice.cs.util.ExitingNotAllowedException;
import edu.rice.cs.util.Pair;
import edu.rice.cs.util.UnexpectedException;
import edu.rice.cs.util.classloader.ClassFileError;
import edu.rice.cs.util.docnavigation.GroupNotSelectedException;
import edu.rice.cs.util.docnavigation.INavigatorItem;
import edu.rice.cs.util.docnavigation.JTreeSortNavigator;
import edu.rice.cs.util.swing.BorderlessScrollPane;
import edu.rice.cs.util.swing.BorderlessSplitPane;
import edu.rice.cs.util.swing.CenteredIcon;
import edu.rice.cs.util.swing.ConfirmCheckBoxDialog;
import edu.rice.cs.util.swing.DefaultFileDisplayManager;
import edu.rice.cs.util.swing.DelegatingAction;
import edu.rice.cs.util.swing.DirectoryChooser;
import edu.rice.cs.util.swing.DisplayManager;
import edu.rice.cs.util.swing.FileDisplayManager;
import edu.rice.cs.util.swing.HighlightManager;
import edu.rice.cs.util.swing.LayeredIcon;
import edu.rice.cs.util.swing.SwingWorker;
import edu.rice.cs.util.swing.UnfocusableButton;
import edu.rice.cs.util.swing.Utilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.Position;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MainFrame
extends JFrame
implements OptionConstants {
    private static final int INTERACTIONS_TAB = 0;
    private static final String ICON_PATH = "/edu/rice/cs/drjava/ui/icons/";
    private static final String DEBUGGER_OUT_OF_SYNC = " Current document is out of sync with the debugger and should be recompiled!";
    private static final int DEBUG_STEP_TIMER_VALUE = 2000;
    private final SingleDisplayModel _model;
    private Hashtable<OpenDefinitionsDocument, JScrollPane> _defScrollPanes;
    private DefinitionsPane _currentDefPane;
    private String _fileTitle = "";
    private JTabbedPane _tabbedPane;
    private CompilerErrorPanel _compilerErrorPanel;
    private InteractionsPane _consolePane;
    private JScrollPane _consoleScroll;
    private ConsoleController _consoleController;
    private InteractionsPane _interactionsPane;
    private JPanel _interactionsContainer;
    private InteractionsController _interactionsController;
    private InteractionsScriptController _interactionsScriptController;
    private InteractionsScriptPane _interactionsScriptPane;
    private DebugPanel _debugPanel;
    private JUnitPanel _junitErrorPanel;
    private JavadocErrorPanel _javadocErrorPanel;
    private FindReplaceDialog _findReplace;
    private LinkedList<TabbedPanel> _tabs;
    private Component _lastFocusOwner;
    private JPanel _statusBar;
    private JLabel _fileNameField;
    private JLabel _sbMessage;
    private JLabel _currLocationField;
    private PositionListener _posListener;
    private JSplitPane _docSplitPane;
    private JSplitPane _debugSplitPane;
    private JSplitPane _mainSplit;
    private JButton _compileButton;
    private JButton _closeButton;
    private JButton _undoButton;
    private JButton _redoButton;
    private JToolBar _toolBar;
    private JFileChooser _interactionsHistoryChooser;
    private JMenuBar _menuBar;
    private JMenu _fileMenu;
    private JMenu _editMenu;
    private JMenu _toolsMenu;
    private JMenu _projectMenu;
    private JMenu _debugMenu;
    private JMenu _languageLevelMenu;
    private JMenu _helpMenu;
    private JMenuItem _debuggerEnabledMenuItem;
    private JPopupMenu _navPanePopupMenu;
    private JPopupMenu _navPanePopupMenuForExternal;
    private JPopupMenu _navPanePopupMenuForAuxiliary;
    private JPopupMenu _navPanePopupMenuForRoot;
    private JPopupMenu _navPaneFolderPopupMenu;
    private JPopupMenu _interactionsPanePopupMenu;
    private JPopupMenu _consolePanePopupMenu;
    private ConfigFrame _configFrame;
    private HelpFrame _helpFrame;
    private QuickStartFrame _quickStartFrame;
    private AboutDialog _aboutDialog;
    private ProjectPropertiesFrame _projectPropertiesFrame;
    private RecentFileManager _recentFileManager;
    private RecentFileManager _recentProjectManager;
    private File _currentProjFile;
    private final Timer _debugStepTimer;
    private HighlightManager.HighlightInfo _currentThreadLocationHighlight = null;
    private Hashtable<Breakpoint, HighlightManager.HighlightInfo> _breakpointHighlights;
    private boolean _promptBeforeQuit;
    private JFileChooser _openChooser;
    private JFileChooser _openProjectChooser;
    private JFileChooser _saveChooser;
    private FileFilter _javaSourceFilter = new JavaSourceFilter();
    private FileFilter _projectFilter = new FileFilter(){

        public boolean accept(File f) {
            return f.isDirectory() || f.getPath().endsWith(".pjt");
        }

        public String getDescription() {
            return "DrJava Project Files (*.pjt)";
        }
    };
    private FileOpenSelector _openSelector = new FileOpenSelector(){

        public File[] getFiles() throws OperationCanceledException {
            MainFrame.access$000(MainFrame.this).resetChoosableFileFilters();
            MainFrame.access$000(MainFrame.this).setFileFilter(MainFrame.access$100(MainFrame.this));
            return MainFrame.this.getOpenFiles(MainFrame.access$000(MainFrame.this));
        }
    };
    private FileOpenSelector _openFileOrProjectSelector = new FileOpenSelector(){

        public File[] getFiles() throws OperationCanceledException {
            MainFrame.access$000(MainFrame.this).resetChoosableFileFilters();
            MainFrame.access$000(MainFrame.this).addChoosableFileFilter(MainFrame.access$200(MainFrame.this));
            MainFrame.access$000(MainFrame.this).setFileFilter(MainFrame.access$100(MainFrame.this));
            return MainFrame.this.getOpenFiles(MainFrame.access$000(MainFrame.this));
        }
    };
    private FileOpenSelector _openProjectSelector = new FileOpenSelector(){

        public File[] getFiles() throws OperationCanceledException {
            File[] retFiles = MainFrame.this.getOpenFiles(MainFrame.access$300(MainFrame.this));
            return retFiles;
        }
    };
    private FileSaveSelector _saveSelector = new FileSaveSelector(){

        public File getFile() throws OperationCanceledException {
            return MainFrame.this.getSaveFile(MainFrame.access$400(MainFrame.this));
        }

        public boolean warnFileOpen(File f) {
            return MainFrame.access$500(MainFrame.this, f);
        }

        public boolean verifyOverwrite() {
            return MainFrame.access$600(MainFrame.this);
        }

        public boolean shouldSaveAfterFileMoved(OpenDefinitionsDocument doc, File oldFile) {
            MainFrame.access$700(MainFrame.this).setActiveDocument(doc);
            String text = "File " + oldFile.getAbsolutePath() + "\ncould not be found on disk!  It was probably moved\n" + "or deleted.  Would you like to save it in a new file?";
            int rc = JOptionPane.showConfirmDialog(MainFrame.this, text, "File Moved or Deleted", 0);
            return rc == 0;
        }
    };
    private FileSaveSelector _saveAsSelector = new FileSaveSelector(){

        public File getFile() throws OperationCanceledException {
            return MainFrame.this.getSaveFile(MainFrame.access$400(MainFrame.this));
        }

        public boolean warnFileOpen(File f) {
            return MainFrame.access$500(MainFrame.this, f);
        }

        public boolean verifyOverwrite() {
            return MainFrame.access$600(MainFrame.this);
        }

        public boolean shouldSaveAfterFileMoved(OpenDefinitionsDocument doc, File oldFile) {
            return true;
        }
    };
    private JavadocDialog _javadocSelector = new JavadocDialog(this);
    DirectoryChooser _folderChooser;
    private JCheckBox _openRecursiveCheckBox;
    private Action _moveToAuxiliaryAction = new AbstractAction("Include With Project"){
        {
            String msg = "<html>Open this document each time this project is opened.<br>This file would then be compiled and tested with the<br>rest of the project.</html>";
            this.putValue("ShortDescription", msg);
        }

        public void actionPerformed(ActionEvent ae) {
            MainFrame.access$800(MainFrame.this);
        }
    };
    private Action _removeAuxiliaryAction = new AbstractAction("Convert to External"){
        {
            this.putValue("ShortDescription", "Do not open this document next time this project is opened.");
        }

        public void actionPerformed(ActionEvent ae) {
            MainFrame.access$900(MainFrame.this);
        }
    };
    private Action _newAction = new AbstractAction("New"){

        public void actionPerformed(ActionEvent ae) {
            MainFrame.access$1000(MainFrame.this);
        }
    };
    private Action _newProjectAction = new AbstractAction("New"){

        public void actionPerformed(ActionEvent ae) {
            MainFrame.access$1100(MainFrame.this);
        }
    };
    private Action _runProjectAction = new AbstractAction("Run Main Document"){

        public void actionPerformed(ActionEvent ae) {
            MainFrame.access$1200(MainFrame.this);
        }
    };
    private Action _jarProjectAction = new AbstractAction("Create Jar File from Project"){

        public void actionPerformed(ActionEvent ae) {
            new SwingWorker(){

                public Object construct() {
                    new JarOptionsDialog(MainFrame.this, MainFrame.this.getModel()).setVisible(true);
                    return null;
                }
            }.start();
        }
    };
    private Action _newJUnitTestAction = new AbstractAction("New JUnit Test Case..."){

        public void actionPerformed(ActionEvent ae) {
            String testName = JOptionPane.showInputDialog(MainFrame.this, "Please enter a name for the test class:", "New JUnit Test Case", 3);
            if (testName != null) {
                for (int i = 0; i < DrJava.LANGUAGE_LEVEL_EXTENSIONS.length; ++i) {
                    String ext = DrJava.LANGUAGE_LEVEL_EXTENSIONS[i];
                    if (!testName.endsWith(ext)) continue;
                    testName = testName.substring(0, testName.length() - ext.length());
                }
                MainFrame.access$700(MainFrame.this).newTestCase(testName, false, false);
            }
        }
    };
    private Action _openAction = new AbstractAction("Open..."){

        public void actionPerformed(ActionEvent ae) {
            MainFrame.access$1300(MainFrame.this);
            MainFrame.access$1400(MainFrame.this).updateFirstDocInSearch();
        }
    };
    private Action _openFolderAction = new AbstractAction("Open Folder..."){

        public void actionPerformed(ActionEvent ae) {
            MainFrame.access$1500(MainFrame.this);
            MainFrame.access$1400(MainFrame.this).updateFirstDocInSearch();
        }
    };
    private Action _openFileOrProjectAction = new AbstractAction("Open..."){

        public void actionPerformed(ActionEvent ae) {
            MainFrame.access$1600(MainFrame.this);
            MainFrame.access$1400(MainFrame.this).updateFirstDocInSearch();
        }
    };
    private Action _openProjectAction = new AbstractAction("Open"){

        public void actionPerformed(ActionEvent ae) {
            MainFrame.access$1700(MainFrame.this);
        }
    };
    private Action _closeProjectAction = new AbstractAction("Close"){

        public void actionPerformed(ActionEvent ae) {
            MainFrame.this._closeProject();
            MainFrame.access$1400(MainFrame.this).updateFirstDocInSearch();
        }
    };
    private Action _closeAction = new AbstractAction("Close"){

        public void actionPerformed(ActionEvent ae) {
            MainFrame.access$1800(MainFrame.this);
            MainFrame.access$1400(MainFrame.this).updateFirstDocInSearch();
        }
    };
    private Action _closeAllAction = new AbstractAction("Close All"){

        public void actionPerformed(ActionEvent ae) {
            MainFrame.access$1900(MainFrame.this);
            MainFrame.access$1400(MainFrame.this).updateFirstDocInSearch();
        }
    };
    private Action _closeFolderAction = new AbstractAction("Close Folder"){

        public void actionPerformed(ActionEvent ae) {
            MainFrame.access$2000(MainFrame.this);
            MainFrame.access$1400(MainFrame.this).updateFirstDocInSearch();
        }
    };
    private Action _openAllFolderAction = new AbstractAction("Open All Files"){

        public void actionPerformed(ActionEvent ae) {
            File dir = MainFrame.access$000(MainFrame.this).getCurrentDirectory();
            MainFrame.access$2100(MainFrame.this, dir, false);
            MainFrame.access$1400(MainFrame.this).updateFirstDocInSearch();
        }
    };
    private Action _openOneFolderAction = new AbstractAction("Open File in Folder"){

        public void actionPerformed(ActionEvent ae) {
            MainFrame.access$1300(MainFrame.this);
            MainFrame.access$1400(MainFrame.this).updateFirstDocInSearch();
        }
    };
    public Action _newFileFolderAction = new AbstractAction("Create New File in Folder"){

        public void actionPerformed(ActionEvent ae) {
            MainFrame.access$1000(MainFrame.this);
            MainFrame.access$1400(MainFrame.this).updateFirstDocInSearch();
        }
    };
    private Action _junitFolderAction = new AbstractAction("Test Folder"){

        public void actionPerformed(ActionEvent ae) {
            MainFrame.access$2200(MainFrame.this);
        }
    };
    private Action _saveAction = new AbstractAction("Save"){

        public void actionPerformed(ActionEvent ae) {
            MainFrame.access$2300(MainFrame.this);
        }
    };
    private Action _saveAsAction = new AbstractAction("Save As..."){

        public void actionPerformed(ActionEvent ae) {
            MainFrame.access$2500(MainFrame.this);
        }
    };
    private Action _saveProjectAction = new AbstractAction("Save"){

        public void actionPerformed(ActionEvent ae) {
            MainFrame.access$2600(MainFrame.this);
        }
    };
    private Action _revertAction = new AbstractAction("Revert to Saved"){

        public void actionPerformed(ActionEvent ae) {
            String message = "Are you sure you want to revert the current file to the version on disk?";
            String title = "Revert to Saved?";
            int rc = JOptionPane.showConfirmDialog(MainFrame.this, message, title, 0);
            if (rc == 0) {
                MainFrame.access$2700(MainFrame.this);
            }
        }
    };
    private Action _saveAllAction = new AbstractAction("Save All"){

        public void actionPerformed(ActionEvent ae) {
            MainFrame.access$2600(MainFrame.this);
        }
    };
    private Action _printDefDocAction = new AbstractAction("Print..."){

        public void actionPerformed(ActionEvent ae) {
            MainFrame.access$2800(MainFrame.this);
        }
    };
    private Action _printConsoleAction = new AbstractAction("Print Console..."){

        public void actionPerformed(ActionEvent ae) {
            MainFrame.access$2900(MainFrame.this);
        }
    };
    private Action _printInteractionsAction = new AbstractAction("Print Interactions..."){

        public void actionPerformed(ActionEvent ae) {
            MainFrame.access$3000(MainFrame.this);
        }
    };
    private Action _printDefDocPreviewAction = new AbstractAction("Print Preview..."){

        public void actionPerformed(ActionEvent ae) {
            MainFrame.access$3100(MainFrame.this);
        }
    };
    private Action _printConsolePreviewAction = new AbstractAction("Print Preview..."){

        public void actionPerformed(ActionEvent ae) {
            MainFrame.access$3200(MainFrame.this);
        }
    };
    private Action _printInteractionsPreviewAction = new AbstractAction("Print Preview..."){

        public void actionPerformed(ActionEvent ae) {
            MainFrame.access$3300(MainFrame.this);
        }
    };
    private Action _pageSetupAction = new AbstractAction("Page Setup..."){

        public void actionPerformed(ActionEvent ae) {
            MainFrame.access$3400(MainFrame.this);
        }
    };
    private Action _compileAction = new AbstractAction("Compile Current Document"){

        public void actionPerformed(ActionEvent ae) {
            if (MainFrame.access$3500(MainFrame.this).getDividerLocation() > MainFrame.access$3500(MainFrame.this).getMaximumDividerLocation()) {
                MainFrame.access$3500(MainFrame.this).resetToPreferredSizes();
            }
            MainFrame.access$3600(MainFrame.this);
        }
    };
    private Action _compileProjectAction = new AbstractAction("Compile Project"){

        public void actionPerformed(ActionEvent ae) {
            if (MainFrame.access$3500(MainFrame.this).getDividerLocation() > MainFrame.access$3500(MainFrame.this).getMaximumDividerLocation()) {
                MainFrame.access$3500(MainFrame.this).resetToPreferredSizes();
            }
            MainFrame.access$3700(MainFrame.this);
            MainFrame.access$1400(MainFrame.this).updateFirstDocInSearch();
        }
    };
    private Action _compileFolderAction = new AbstractAction("Compile Folder"){

        public void actionPerformed(ActionEvent ae) {
            if (MainFrame.access$3500(MainFrame.this).getDividerLocation() > MainFrame.access$3500(MainFrame.this).getMaximumDividerLocation()) {
                MainFrame.access$3500(MainFrame.this).resetToPreferredSizes();
            }
            MainFrame.access$3800(MainFrame.this);
            MainFrame.access$1400(MainFrame.this).updateFirstDocInSearch();
        }
    };
    private Action _compileAllAction = new AbstractAction("Compile All Documents"){

        public void actionPerformed(ActionEvent ae) {
            if (MainFrame.access$3500(MainFrame.this).getDividerLocation() > MainFrame.access$3500(MainFrame.this).getMaximumDividerLocation()) {
                MainFrame.access$3500(MainFrame.this).resetToPreferredSizes();
            }
            MainFrame.access$3900(MainFrame.this);
            MainFrame.access$1400(MainFrame.this).updateFirstDocInSearch();
        }
    };
    private Action _cleanAction = new AbstractAction("Clean Build Directory"){

        public void actionPerformed(ActionEvent ae) {
            MainFrame.access$4000(MainFrame.this);
        }
    };
    private Action _runAction = new AbstractAction("Run Document's Main Method"){

        public void actionPerformed(ActionEvent ae) {
            MainFrame.access$4100(MainFrame.this);
        }
    };
    private Action _junitAction = new AbstractAction("Test Current Document"){

        public void actionPerformed(ActionEvent ae) {
            if (MainFrame.access$3500(MainFrame.this).getDividerLocation() > MainFrame.access$3500(MainFrame.this).getMaximumDividerLocation()) {
                MainFrame.access$3500(MainFrame.this).resetToPreferredSizes();
            }
            MainFrame.access$4200(MainFrame.this);
        }
    };
    private Action _junitAllAction = new AbstractAction("Test All Documents"){

        public void actionPerformed(ActionEvent e) {
            if (MainFrame.access$3500(MainFrame.this).getDividerLocation() > MainFrame.access$3500(MainFrame.this).getMaximumDividerLocation()) {
                MainFrame.access$3500(MainFrame.this).resetToPreferredSizes();
            }
            MainFrame.access$4300(MainFrame.this);
            MainFrame.access$1400(MainFrame.this).updateFirstDocInSearch();
        }
    };
    private Action _junitOpenProjectFilesAction = new AbstractAction("Test Project"){

        public void actionPerformed(ActionEvent e) {
            if (MainFrame.access$3500(MainFrame.this).getDividerLocation() > MainFrame.access$3500(MainFrame.this).getMaximumDividerLocation()) {
                MainFrame.access$3500(MainFrame.this).resetToPreferredSizes();
            }
            MainFrame.access$4400(MainFrame.this);
            MainFrame.access$1400(MainFrame.this).updateFirstDocInSearch();
        }
    };
    private Action _javadocAllAction = new AbstractAction("Javadoc All Documents"){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent ae) {
            if (MainFrame.access$3500(MainFrame.this).getDividerLocation() > MainFrame.access$3500(MainFrame.this).getMaximumDividerLocation()) {
                MainFrame.access$3500(MainFrame.this).resetToPreferredSizes();
            }
            try {
                JavadocModel jm = MainFrame.access$700(MainFrame.this).getJavadocModel();
                File suggestedDir = jm.suggestJavadocDestination(MainFrame.access$700(MainFrame.this).getActiveDocument());
                MainFrame.access$4500(MainFrame.this).setSuggestedDir(suggestedDir);
                String cps = MainFrame.access$700(MainFrame.this).getClasspath().toString();
                jm.javadocAll(MainFrame.access$4500(MainFrame.this), MainFrame.access$4600(MainFrame.this), cps);
            }
            catch (IOException ioe) {
                MainFrame.this._showIOError(ioe);
            }
        }
    };
    private Action _javadocCurrentAction = new AbstractAction("Preview Javadoc for Current Document"){

        public void actionPerformed(ActionEvent ae) {
            if (MainFrame.access$3500(MainFrame.this).getDividerLocation() > MainFrame.access$3500(MainFrame.this).getMaximumDividerLocation()) {
                MainFrame.access$3500(MainFrame.this).resetToPreferredSizes();
            }
            try {
                MainFrame.access$700(MainFrame.this).getActiveDocument().generateJavadoc(MainFrame.access$4600(MainFrame.this));
            }
            catch (IOException ioe) {
                MainFrame.this._showIOError(ioe);
            }
        }
    };
    Action cutAction = new DefaultEditorKit.CutAction(){

        public void actionPerformed(ActionEvent e) {
            Component c = MainFrame.this.getFocusOwner();
            super.actionPerformed(e);
            if (c != null) {
                c.requestFocusInWindow();
            }
        }
    };
    Action copyAction = new DefaultEditorKit.CopyAction(){

        public void actionPerformed(ActionEvent e) {
            Component c = MainFrame.this.getFocusOwner();
            super.actionPerformed(e);
            if (c != null) {
                c.requestFocusInWindow();
            }
        }
    };
    Action pasteAction = new DefaultEditorKit.PasteAction(){

        public void actionPerformed(ActionEvent e) {
            Component c = MainFrame.this.getFocusOwner();
            if (MainFrame.access$4700(MainFrame.this).hasFocus()) {
                MainFrame.access$4700(MainFrame.this).endCompoundEdit();
                super.actionPerformed(e);
                MainFrame.access$4700(MainFrame.this).endCompoundEdit();
            } else {
                super.actionPerformed(e);
            }
            if (c != null) {
                c.requestFocusInWindow();
            }
        }
    };
    private Action _copyInteractionToDefinitionsAction = new AbstractAction("Lift Current Interaction to Definitions"){

        public void actionPerformed(ActionEvent a) {
            String text = MainFrame.access$4800(MainFrame.this).getDocument().getCurrentInput();
            if (!text.equals("")) {
                MainFrame.access$4900(MainFrame.this, text + "\n");
                return;
            }
            try {
                text = MainFrame.access$4800(MainFrame.this).getDocument().lastEntry();
            }
            catch (Exception e) {
                return;
            }
            MainFrame.access$4900(MainFrame.this, text + "\n");
        }
    };
    private DelegatingAction _undoAction = new DelegatingAction(){

        public void actionPerformed(ActionEvent e) {
            MainFrame.access$4700(MainFrame.this).endCompoundEdit();
            super.actionPerformed(e);
            MainFrame.access$4700(MainFrame.this).requestFocusInWindow();
            OpenDefinitionsDocument doc = MainFrame.access$700(MainFrame.this).getActiveDocument();
            MainFrame.access$5000(MainFrame.this).setEnabled(doc.isModifiedSinceSave() || doc.isUntitled());
        }
    };
    private DelegatingAction _redoAction = new DelegatingAction(){

        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            MainFrame.access$4700(MainFrame.this).requestFocusInWindow();
            OpenDefinitionsDocument doc = MainFrame.access$700(MainFrame.this).getActiveDocument();
            MainFrame.access$5000(MainFrame.this).setEnabled(doc.isModifiedSinceSave() || doc.isUntitled());
        }
    };
    private Action _quitAction = new AbstractAction("Quit"){

        public void actionPerformed(ActionEvent ae) {
            MainFrame.access$5100(MainFrame.this);
        }
    };
    private Action _selectAllAction = new AbstractAction("Select All"){

        public void actionPerformed(ActionEvent ae) {
            MainFrame.access$5200(MainFrame.this);
        }
    };
    private Action _findReplaceAction = new AbstractAction("Find/Replace..."){

        public void actionPerformed(ActionEvent ae) {
            if (MainFrame.access$3500(MainFrame.this).getDividerLocation() > MainFrame.access$3500(MainFrame.this).getMaximumDividerLocation()) {
                MainFrame.access$3500(MainFrame.this).resetToPreferredSizes();
            }
            if (!MainFrame.access$1400(MainFrame.this).isDisplayed()) {
                MainFrame.this.showTab(MainFrame.access$1400(MainFrame.this));
                MainFrame.access$1400(MainFrame.this).beginListeningTo(MainFrame.access$4700(MainFrame.this));
            }
            MainFrame.access$1400(MainFrame.this).setVisible(true);
            MainFrame.access$5300(MainFrame.this).setSelectedComponent(MainFrame.access$1400(MainFrame.this));
            try {
                Thread.sleep(100L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            MainFrame.access$1400(MainFrame.this).requestFocusInWindow();
        }
    };
    private Action _findNextAction = new AbstractAction("Find Next"){

        public void actionPerformed(ActionEvent ae) {
            MainFrame.access$5400(MainFrame.this).actionPerformed(ae);
            MainFrame.access$1400(MainFrame.this).findNext();
            MainFrame.access$4700(MainFrame.this).requestFocusInWindow();
        }
    };
    private Action _findPrevAction = new AbstractAction("Find Previous"){

        public void actionPerformed(ActionEvent ae) {
            MainFrame.access$1400(MainFrame.this).findPrevious();
            MainFrame.access$4700(MainFrame.this).requestFocusInWindow();
        }
    };
    private Action _gotoLineAction = new AbstractAction("Go to Line..."){

        public void actionPerformed(ActionEvent ae) {
            int pos = MainFrame.access$5500(MainFrame.this);
            MainFrame.access$4700(MainFrame.this).requestFocusInWindow();
            if (pos != -1) {
                MainFrame.access$4700(MainFrame.this).setCaretPosition(pos);
            }
        }
    };
    private Action _indentLinesAction = new AbstractAction("Indent Line(s)"){

        public void actionPerformed(ActionEvent ae) {
            MainFrame.access$4700(MainFrame.this).endCompoundEdit();
            MainFrame.access$4700(MainFrame.this).indent();
        }
    };
    private Action _commentLinesAction = new AbstractAction("Comment Line(s)"){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent ae) {
            MainFrame.this.hourglassOn();
            try {
                MainFrame.this.commentLines();
            }
            finally {
                MainFrame.this.hourglassOff();
            }
        }
    };
    private Action _uncommentLinesAction = new AbstractAction("Uncomment Line(s)"){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent ae) {
            MainFrame.this.hourglassOn();
            try {
                MainFrame.this.uncommentLines();
            }
            finally {
                MainFrame.this.hourglassOff();
            }
        }
    };
    private Action _clearConsoleAction = new AbstractAction("Clear Console"){

        public void actionPerformed(ActionEvent ae) {
            MainFrame.access$700(MainFrame.this).resetConsole();
        }
    };
    private Action _showDebugConsoleAction = new AbstractAction("Show DrJava Debug Console"){

        public void actionPerformed(ActionEvent e) {
            DrJava.showDrJavaDebugConsole(MainFrame.this);
        }
    };
    private Action _resetInteractionsAction = new AbstractAction("Reset Interactions"){

        public void actionPerformed(ActionEvent ae) {
            if (!DrJava.getConfig().getSetting(OptionConstants.INTERACTIONS_RESET_PROMPT).booleanValue()) {
                MainFrame.access$5600(MainFrame.this);
                return;
            }
            String title = "Confirm Reset Interactions";
            String message = "Are you sure you want to reset the Interactions Pane?";
            ConfirmCheckBoxDialog dialog = new ConfirmCheckBoxDialog(MainFrame.this, title, message);
            int rc = dialog.show();
            if (rc == 0) {
                MainFrame.access$5600(MainFrame.this);
                if (dialog.getCheckBoxValue()) {
                    DrJava.getConfig().setSetting(OptionConstants.INTERACTIONS_RESET_PROMPT, Boolean.FALSE);
                }
            }
        }
    };
    private Action _viewInteractionsClasspathAction = new AbstractAction("View Interactions Classpath"){

        public void actionPerformed(ActionEvent e) {
            MainFrame.this.viewInteractionsClasspath();
        }
    };
    private Action _helpAction = new AbstractAction("Help"){

        public void actionPerformed(ActionEvent ae) {
            if (MainFrame.access$5700(MainFrame.this) == null) {
                MainFrame.access$5702(MainFrame.this, new HelpFrame());
            }
            MainFrame.access$5700(MainFrame.this).setVisible(true);
        }
    };
    private Action _quickStartAction = new AbstractAction("QuickStart"){

        public void actionPerformed(ActionEvent ae) {
            if (MainFrame.access$5800(MainFrame.this) == null) {
                MainFrame.access$5802(MainFrame.this, new QuickStartFrame());
            }
            MainFrame.access$5800(MainFrame.this).setVisible(true);
        }
    };
    private Action _aboutAction = new AbstractAction("About"){

        public void actionPerformed(ActionEvent ae) {
            if (MainFrame.access$5900(MainFrame.this) == null) {
                MainFrame.access$5902(MainFrame.this, new AboutDialog(MainFrame.this));
            }
            MainFrame.access$5900(MainFrame.this).setVisible(true);
        }
    };
    private Action _switchToNextAction = new AbstractAction("Next Document"){

        public void actionPerformed(ActionEvent ae) {
            this.setEnabled(false);
            if (MainFrame.access$6000(MainFrame.this).getDividerLocation() < MainFrame.access$6000(MainFrame.this).getMinimumDividerLocation()) {
                MainFrame.access$6000(MainFrame.this).setDividerLocation(DrJava.getConfig().getSetting(OptionConstants.DOC_LIST_WIDTH));
            }
            MainFrame.access$700(MainFrame.this).setActiveNextDocument();
            MainFrame.access$1400(MainFrame.this).updateFirstDocInSearch();
            this.setEnabled(true);
        }
    };
    private Action _switchToPrevAction = new AbstractAction("Previous Document"){

        public void actionPerformed(ActionEvent ae) {
            this.setEnabled(false);
            if (MainFrame.access$6000(MainFrame.this).getDividerLocation() < MainFrame.access$6000(MainFrame.this).getMinimumDividerLocation()) {
                MainFrame.access$6000(MainFrame.this).setDividerLocation(DrJava.getConfig().getSetting(OptionConstants.DOC_LIST_WIDTH));
            }
            MainFrame.access$700(MainFrame.this).setActivePreviousDocument();
            MainFrame.access$1400(MainFrame.this).updateFirstDocInSearch();
            this.setEnabled(true);
        }
    };
    private Action _switchToNextPaneAction = new AbstractAction("Next Pane"){

        public void actionPerformed(ActionEvent ae) {
            if (MainFrame.access$3500(MainFrame.this).getDividerLocation() > MainFrame.access$3500(MainFrame.this).getMaximumDividerLocation()) {
                MainFrame.access$3500(MainFrame.this).resetToPreferredSizes();
            }
            this.setEnabled(false);
            MainFrame.access$6100(MainFrame.this, true);
            this.setEnabled(true);
        }
    };
    private Action _switchToPreviousPaneAction = new AbstractAction("Previous Pane"){

        public void actionPerformed(ActionEvent ae) {
            if (MainFrame.access$3500(MainFrame.this).getDividerLocation() > MainFrame.access$3500(MainFrame.this).getMaximumDividerLocation()) {
                MainFrame.access$3500(MainFrame.this).resetToPreferredSizes();
            }
            this.setEnabled(false);
            MainFrame.access$6100(MainFrame.this, false);
            this.setEnabled(true);
        }
    };
    private Action _editPreferencesAction = new AbstractAction("Preferences..."){

        public void actionPerformed(ActionEvent ae) {
            if (MainFrame.access$6200(MainFrame.this) == null) {
                MainFrame.access$6202(MainFrame.this, new ConfigFrame(MainFrame.this));
            }
            MainFrame.access$6200(MainFrame.this).setVisible(true);
            MainFrame.access$6200(MainFrame.this).toFront();
        }
    };
    private Action _projectPropertiesAction = new AbstractAction("Project Properties"){

        public void actionPerformed(ActionEvent ae) {
            if (MainFrame.access$6300(MainFrame.this) == null) {
                MainFrame.access$6302(MainFrame.this, new ProjectPropertiesFrame(MainFrame.this));
            }
            MainFrame.access$6300(MainFrame.this).setVisible(true);
            MainFrame.access$6300(MainFrame.this).toFront();
        }
    };
    private Action _toggleDebuggerAction = new AbstractAction("Debug Mode"){

        public void actionPerformed(ActionEvent ae) {
            this.setEnabled(false);
            MainFrame.this.debuggerToggle();
            this.setEnabled(true);
        }
    };
    private Action _resumeDebugAction = new AbstractAction("Resume Debugger"){

        public void actionPerformed(ActionEvent ae) {
            try {
                MainFrame.this.debuggerResume();
            }
            catch (DebugException de) {
                MainFrame.this._showDebugError(de);
            }
        }
    };
    private Action _stepIntoDebugAction = new AbstractAction("Step Into"){

        public void actionPerformed(ActionEvent ae) {
            MainFrame.this.debuggerStep(1);
        }
    };
    private Action _stepOverDebugAction = new AbstractAction("Step Over"){

        public void actionPerformed(ActionEvent ae) {
            MainFrame.this.debuggerStep(2);
        }
    };
    private Action _stepOutDebugAction = new AbstractAction("Step Out"){

        public void actionPerformed(ActionEvent ae) {
            MainFrame.this.debuggerStep(3);
        }
    };
    Action _toggleBreakpointAction = new AbstractAction("Toggle Breakpoint on Current Line"){

        public void actionPerformed(ActionEvent ae) {
            MainFrame.this.debuggerToggleBreakpoint();
        }
    };
    private Action _clearAllBreakpointsAction = new AbstractAction("Clear All Breakpoints"){

        public void actionPerformed(ActionEvent ae) {
            MainFrame.this.debuggerClearAllBreakpoints();
        }
    };
    protected Action _cutLineAction = new AbstractAction("Cut Line"){

        public void actionPerformed(ActionEvent ae) {
            ActionMap _actionMap = MainFrame.access$4700(MainFrame.this).getActionMap();
            int oldCol = MainFrame.access$700(MainFrame.this).getActiveDocument().getCurrentCol();
            _actionMap.get("selection-end-line").actionPerformed(ae);
            if (oldCol == MainFrame.access$700(MainFrame.this).getActiveDocument().getCurrentCol()) {
                _actionMap.get("selection-forward").actionPerformed(ae);
                MainFrame.this.cutAction.actionPerformed(ae);
            } else {
                MainFrame.this.cutAction.actionPerformed(ae);
            }
        }
    };
    protected Action _clearLineAction = new AbstractAction("Clear Line"){

        public void actionPerformed(ActionEvent ae) {
            ActionMap _actionMap = MainFrame.access$4700(MainFrame.this).getActionMap();
            _actionMap.get("selection-end-line").actionPerformed(ae);
            _actionMap.get("delete-next").actionPerformed(ae);
        }
    };
    private Action _beginLineAction = new AbstractAction("Begin Line"){

        public void actionPerformed(ActionEvent ae) {
            int beginLinePos = MainFrame.access$6400(MainFrame.this);
            MainFrame.access$4700(MainFrame.this).setCaretPosition(beginLinePos);
        }
    };
    private Action _selectionBeginLineAction = new AbstractAction("Select to Beginning of Line"){

        public void actionPerformed(ActionEvent ae) {
            int beginLinePos = MainFrame.access$6400(MainFrame.this);
            MainFrame.access$4700(MainFrame.this).moveCaretPosition(beginLinePos);
        }
    };
    private FileOpenSelector _interactionsHistoryFileSelector = new FileOpenSelector(){

        public File[] getFiles() throws OperationCanceledException {
            return MainFrame.this.getOpenFiles(MainFrame.access$6500(MainFrame.this));
        }
    };
    private Action _executeHistoryAction = new AbstractAction("Execute Interactions History..."){

        public void actionPerformed(ActionEvent ae) {
            MainFrame.access$5300(MainFrame.this).setSelectedIndex(0);
            MainFrame.access$6500(MainFrame.this).setDialogTitle("Execute Interactions History");
            try {
                MainFrame.access$700(MainFrame.this).loadHistory(MainFrame.access$6600(MainFrame.this));
            }
            catch (FileNotFoundException fnf) {
                MainFrame.this._showFileNotFoundError(fnf);
            }
            catch (IOException ioe) {
                MainFrame.this._showIOError(ioe);
            }
            MainFrame.access$6700(MainFrame.this).requestFocusInWindow();
        }
    };
    private Action _loadHistoryScriptAction = new AbstractAction("Load Interactions History as Script..."){

        public void actionPerformed(ActionEvent e) {
            try {
                MainFrame.access$6500(MainFrame.this).setDialogTitle("Load Interactions History");
                InteractionsScriptModel ism = MainFrame.access$700(MainFrame.this).loadHistoryAsScript(MainFrame.access$6600(MainFrame.this));
                MainFrame.access$6802(MainFrame.this, new InteractionsScriptController(ism, new AbstractAction("Close"){

                    public void actionPerformed(ActionEvent e) {
                        MainFrame.access$6900(MainFrame.this);
                        MainFrame.access$6700(MainFrame.this).requestFocusInWindow();
                    }
                }, MainFrame.access$6700(MainFrame.this)));
                MainFrame.access$7002(MainFrame.this, MainFrame.access$6800(MainFrame.this).getPane());
                MainFrame.access$7100(MainFrame.this).add((Component)MainFrame.access$7000(MainFrame.this), "East");
                MainFrame.access$5300(MainFrame.this).invalidate();
                MainFrame.access$5300(MainFrame.this).repaint();
            }
            catch (FileNotFoundException fnf) {
                MainFrame.this._showFileNotFoundError(fnf);
            }
            catch (IOException ioe) {
                MainFrame.this._showIOError(ioe);
            }
            catch (OperationCanceledException operationCanceledException) {
                // empty catch block
            }
        }
    };
    private Action _saveHistoryAction = new AbstractAction("Save Interactions History..."){

        public void actionPerformed(ActionEvent ae) {
            Object[] options = new String[]{"Yes", "No", "Cancel"};
            int resp = JOptionPane.showOptionDialog(MainFrame.this, "Edit interactions history before saving?", "Edit History?", 1, 3, null, options, options[1]);
            if (resp == 2 || resp == -1) {
                return;
            }
            String history = MainFrame.access$700(MainFrame.this).getHistoryAsStringWithSemicolons();
            if (resp == 0) {
                history = new HistorySaveDialog(MainFrame.this).editHistory(history);
            }
            if (history == null) {
                return;
            }
            MainFrame.access$6500(MainFrame.this).setDialogTitle("Save Interactions History");
            FileSaveSelector selector = new FileSaveSelector(){

                public File getFile() throws OperationCanceledException {
                    File selection = MainFrame.access$6500(MainFrame.this).getSelectedFile();
                    if (selection != null) {
                        MainFrame.access$6500(MainFrame.this).setSelectedFile(selection.getParentFile());
                        MainFrame.access$6500(MainFrame.this).setSelectedFile(selection);
                        MainFrame.access$6500(MainFrame.this).setSelectedFile(null);
                    }
                    int rc = MainFrame.access$6500(MainFrame.this).showSaveDialog(MainFrame.this);
                    File c = MainFrame.access$7200(MainFrame.this, MainFrame.access$6500(MainFrame.this), rc);
                    if (c.getName().indexOf(46) == -1) {
                        c = new File(c.getAbsolutePath() + "." + "hist");
                    }
                    MainFrame.access$6500(MainFrame.this).setSelectedFile(c);
                    return c;
                }

                public boolean warnFileOpen(File f) {
                    return true;
                }

                public boolean verifyOverwrite() {
                    return MainFrame.access$600(MainFrame.this);
                }

                public boolean shouldSaveAfterFileMoved(OpenDefinitionsDocument doc, File oldFile) {
                    return true;
                }
            };
            try {
                MainFrame.access$700(MainFrame.this).saveHistory(selector, history);
            }
            catch (IOException ioe) {
                MainFrame.this._showIOError(new IOException("An error occured writing the history to a file"));
            }
            MainFrame.access$6700(MainFrame.this).requestFocusInWindow();
        }
    };
    private Action _clearHistoryAction = new AbstractAction("Clear Interactions History"){

        public void actionPerformed(ActionEvent ae) {
            MainFrame.access$700(MainFrame.this).clearHistory();
            MainFrame.access$6700(MainFrame.this).requestFocusInWindow();
        }
    };
    private WindowListener _windowCloseListener = new WindowAdapter(){

        public void windowActivated(WindowEvent ev) {
        }

        public void windowClosed(WindowEvent ev) {
        }

        public void windowClosing(WindowEvent ev) {
            MainFrame.access$5100(MainFrame.this);
        }

        public void windowDeactivated(WindowEvent ev) {
        }

        public void windowDeiconified(WindowEvent ev) {
            try {
                MainFrame.access$700(MainFrame.this).getActiveDocument().revertIfModifiedOnDisk();
            }
            catch (FileMovedException fme) {
                MainFrame.this._showFileMovedError(fme);
            }
            catch (IOException e) {
                MainFrame.this._showIOError(e);
            }
        }

        public void windowIconified(WindowEvent ev) {
        }

        public void windowOpened(WindowEvent ev) {
            MainFrame.access$4700(MainFrame.this).requestFocusInWindow();
        }
    };
    private MouseListener _resetFindReplaceListener = new MouseListener(){

        public void mouseClicked(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
            MainFrame.access$1400(MainFrame.this).updateFirstDocInSearch();
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }
    };
    private static DJFileDisplayManager _djFileDisplayManager20;
    private static DJFileDisplayManager _djFileDisplayManager30;
    private static OddDisplayManager _oddDisplayManager20;
    private static OddDisplayManager _oddDisplayManager30;
    private static Icon _djProjectIcon;
    private DisplayManager<INavigatorItem> _navPaneDisplayManager = new DisplayManager<INavigatorItem>(){

        @Override
        public Icon getIcon(INavigatorItem item) {
            OpenDefinitionsDocument odd = (OpenDefinitionsDocument)item;
            return MainFrame.access$7300().getIcon(odd);
        }

        @Override
        public String getName(INavigatorItem name) {
            return name.getName();
        }

        @Override
        public String getName(Object x0) {
            return this.getName((INavigatorItem)x0);
        }

        @Override
        public Icon getIcon(Object x0) {
            return this.getIcon((INavigatorItem)x0);
        }
    };
    RecentDocFrame _recentDocFrame;
    private int hourglassNestLevel = 0;
    private boolean allow_key_events = true;
    private boolean _compileProjectActionEnabled;
    private boolean _compileAllActionEnabled;
    private boolean _compileFolderActionEnabled;
    private boolean _junitFolderActionEnabled;
    private boolean _junitAllActionEnabled;
    private boolean _junitActionEnabled;
    private boolean _junitOpenProjectFilesActionEnabled;
    private boolean _cleanActionEnabled;
    private boolean _projectPropertiesActionEnabled;
    private boolean _runProjectActionEnabled;
    private boolean _runActionEnabled;
    KeyListener _historyListener = new KeyListener(){

        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 192 && e.isControlDown() && !e.isShiftDown()) {
                MainFrame.access$10800(MainFrame.this);
            }
            if (e.getKeyCode() == 192 && e.isControlDown() && e.isShiftDown()) {
                MainFrame.access$10900(MainFrame.this);
            }
        }

        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == 17) {
                MainFrame.access$11000(MainFrame.this);
            }
        }

        public void keyTyped(KeyEvent e) {
        }
    };
    FocusListener _focusListenerForRecentDocs = new FocusListener(){

        public void focusLost(FocusEvent e) {
            MainFrame.access$11000(MainFrame.this);
        }

        public void focusGained(FocusEvent e) {
        }
    };
    private static final /* synthetic */ Class class$edu$rice$cs$drjava$ui$MainFrame;

    @Override
    public void pack() {
        Utilities.invokeAndWait(new Runnable(){

            public void run() {
                MainFrame.access$2400(MainFrame.this);
            }
        });
    }

    private void packHelp() {
        super.pack();
    }

    public boolean saveEnabledHuh() {
        return this._saveAction.isEnabled();
    }

    private void _doResetInteractions() {
        this._tabbedPane.setSelectedIndex(0);
        SwingWorker worker = new SwingWorker(){

            public Object construct() {
                MainFrame.access$700(MainFrame.this).resetInteractions();
                return null;
            }
        };
        worker.start();
    }

    public void viewInteractionsClasspath() {
        StringBuffer cpBuf = new StringBuffer();
        ClasspathVector classpathElements = this._model.getClasspath();
        for (int i = 0; i < classpathElements.size(); ++i) {
            cpBuf.append(((URL)classpathElements.get(i)).getPath());
            if (i + 1 >= classpathElements.size()) continue;
            cpBuf.append("\n");
        }
        String classpath = cpBuf.toString();
        new DrJavaScrollableDialog(this, "Interactions Classpath", "Current Interpreter Classpath", classpath).show();
    }

    private void _switchToPane(Component c) {
        Component newC = c;
        if (c == this._interactionsContainer) {
            newC = this._interactionsPane;
        }
        if (c == this._consoleScroll) {
            newC = this._consolePane;
        }
        this.showTab(newC);
    }

    private void _switchPaneFocus(boolean next) {
        int numTabs = this._tabbedPane.getTabCount();
        if (next) {
            this._switchToPane(this._tabbedPane.getComponentAt((numTabs + this._tabbedPane.getSelectedIndex() + 1) % numTabs));
        } else {
            this._switchToPane(this._tabbedPane.getComponentAt((numTabs + this._tabbedPane.getSelectedIndex() - 1) % numTabs));
        }
    }

    private int _getBeginLinePos() {
        try {
            int currPos = this._currentDefPane.getCaretPosition();
            OpenDefinitionsDocument openDoc = this._model.getActiveDocument();
            openDoc.setCurrentLocation(currPos);
            return openDoc.getIntelligentBeginLinePos(currPos);
        }
        catch (BadLocationException ble) {
            throw new UnexpectedException(ble);
        }
    }

    private void _closeInteractionsScript() {
        if (this._interactionsScriptController != null) {
            this._interactionsContainer.remove(this._interactionsScriptPane);
            this._interactionsScriptController = null;
            this._interactionsScriptPane = null;
            this._tabbedPane.invalidate();
            this._tabbedPane.repaint();
        }
    }

    public static DJFileDisplayManager getFileDisplayManager20() {
        return _djFileDisplayManager20;
    }

    public static DJFileDisplayManager getFileDisplayManager30() {
        return _djFileDisplayManager30;
    }

    public static OddDisplayManager getOddDisplayManager20() {
        return _oddDisplayManager20;
    }

    public static OddDisplayManager getOddDisplayManager30() {
        return _oddDisplayManager30;
    }

    public DisplayManager<INavigatorItem> getNavPaneDisplayManager() {
        return this._navPaneDisplayManager;
    }

    public MainFrame() {
        final FileConfiguration config = DrJava.getConfig();
        PlatformFactory.ONLY.beforeUISetup();
        this._posListener = new PositionListener(null);
        this._setUpStatusBar();
        this._model = new DefaultGlobalModel();
        this._model.getDocumentNavigator().asContainer().addKeyListener(this._historyListener);
        this._model.getDocumentNavigator().asContainer().addFocusListener(this._focusListenerForRecentDocs);
        this._model.getDocumentNavigator().asContainer().addMouseListener(this._resetFindReplaceListener);
        DefinitionsPane.setEditorKit(this._model.getEditorKit());
        if (this._model.getDebugger().isAvailable()) {
            this._model.getDebugger().addListener(new UIDebugListener(null));
        }
        this._debugStepTimer = new Timer(2000, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.access$700(MainFrame.this).printDebugMessage("Stepping...");
            }
        });
        this._debugStepTimer.setRepeats(false);
        File workDir = config.getSetting(WORKING_DIRECTORY);
        if (!(workDir != FileOption.NULL_FILE || (workDir = config.getSetting(LAST_DIRECTORY)) != FileOption.NULL_FILE && workDir.exists())) {
            workDir = new File(System.getProperty("user.dir"));
        }
        if (workDir.isFile() && workDir.getParent() != null) {
            workDir = workDir.getParentFile();
        }
        this._openChooser = new JFileChooser(){

            public void setCurrentDirectory(File dir) {
                super.setCurrentDirectory(dir);
                this.setDialogTitle("Open:  " + this.getCurrentDirectory());
            }
        };
        this._openChooser.setPreferredSize(new Dimension(650, 410));
        this._openChooser.setCurrentDirectory(workDir);
        this._openChooser.setFileFilter(this._javaSourceFilter);
        this._openChooser.setMultiSelectionEnabled(true);
        this._openRecursiveCheckBox = new JCheckBox("Open folders recursively");
        this._openRecursiveCheckBox.setSelected(config.getSetting(OptionConstants.OPEN_FOLDER_RECURSIVE));
        this._folderChooser = this.makeFolderChooser(workDir);
        Vector recentProjects = (Vector)config.getSetting(RECENT_PROJECTS);
        this._openProjectChooser = new JFileChooser();
        this._openProjectChooser.setPreferredSize(new Dimension(650, 410));
        if (recentProjects.size() > 0 && ((File)recentProjects.elementAt(0)).getParentFile() != null) {
            this._openProjectChooser.setCurrentDirectory(((File)recentProjects.elementAt(0)).getParentFile());
        } else {
            this._openProjectChooser.setCurrentDirectory(workDir);
        }
        this._openProjectChooser.setFileFilter(this._projectFilter);
        this._openProjectChooser.setMultiSelectionEnabled(false);
        this._saveChooser = new JFileChooser(){

            public void setCurrentDirectory(File dir) {
                super.setCurrentDirectory(dir);
                this.setDialogTitle("Save:  " + this.getCurrentDirectory());
            }
        };
        this._saveChooser.setPreferredSize(new Dimension(650, 410));
        this._saveChooser.setCurrentDirectory(workDir);
        this._saveChooser.setFileFilter(this._javaSourceFilter);
        this._interactionsHistoryChooser = new JFileChooser();
        this._interactionsHistoryChooser.setPreferredSize(new Dimension(650, 410));
        this._interactionsHistoryChooser.setCurrentDirectory(workDir);
        this._interactionsHistoryChooser.setFileFilter(new InteractionsHistoryFilter());
        this._interactionsHistoryChooser.setMultiSelectionEnabled(true);
        this.setGlassPane(new GlassPane());
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this._windowCloseListener);
        this._model.addListener(new ModelListener(null));
        this._defScrollPanes = new Hashtable();
        this._setUpTabs();
        JScrollPane defScroll = this._createDefScrollPane(this._model.getActiveDocument());
        this._recentDocFrame = new RecentDocFrame(this);
        this._recentDocFrame.pokeDocument(this._model.getActiveDocument());
        this._currentDefPane = (DefinitionsPane)defScroll.getViewport().getView();
        this._currentDefPane.notifyActive();
        KeyBindingManager.Singleton.setMainFrame(this);
        KeyBindingManager.Singleton.setActionMap(this._currentDefPane.getActionMap());
        this._setUpKeyBindingMaps();
        this._posListener.updateLocation();
        this._undoAction.setDelegatee(this._currentDefPane.getUndoAction());
        this._redoAction.setDelegatee(this._currentDefPane.getRedoAction());
        this._compilerErrorPanel.reset();
        this._junitErrorPanel.reset();
        this._javadocErrorPanel.reset();
        this._setUpActions();
        this._setUpMenuBar();
        this._setUpToolBar();
        this._setUpContextMenus();
        this._recentFileManager = new RecentFileManager(this._fileMenu.getItemCount() - 2, this._fileMenu, this, false);
        this._recentProjectManager = new RecentFileManager(this._projectMenu.getItemCount() - 2, this._projectMenu, this, true);
        this.setIconImage(MainFrame.getIcon("drjava64.png").getImage());
        int x = config.getSetting(WINDOW_X);
        int y = config.getSetting(WINDOW_Y);
        int width = config.getSetting(WINDOW_WIDTH);
        int height = config.getSetting(WINDOW_HEIGHT);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int menubarHeight = 24;
        if (height > screenSize.height - 24) {
            height = screenSize.height - 24;
        }
        if (width > screenSize.width) {
            width = screenSize.width;
        }
        Rectangle bounds = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getBounds();
        if (x == Integer.MAX_VALUE) {
            x = (bounds.width - width + bounds.x) / 2;
        }
        if (y == Integer.MAX_VALUE) {
            y = (bounds.height - height + bounds.y) / 2;
        }
        if (x < bounds.x) {
            x = bounds.x;
        }
        if (y < bounds.y) {
            y = bounds.y;
        }
        if (x + width > bounds.x + bounds.width) {
            x = bounds.width - width + bounds.x;
        }
        if (y + height > bounds.y + bounds.height) {
            y = bounds.height - height + bounds.y;
        }
        this.setBounds(x, y, width, height);
        this._setUpPanes();
        this.updateFileTitle();
        this._promptBeforeQuit = config.getSetting(QUIT_PROMPT);
        this._setMainFont();
        Font doclistFont = config.getSetting(FONT_DOCLIST);
        this._model.getDocCollectionWidget().setFont(doclistFont);
        this._updateNormalColor();
        this._updateBackgroundColor();
        config.addOptionListener(DEFINITIONS_NORMAL_COLOR, new NormalColorOptionListener(null));
        config.addOptionListener(DEFINITIONS_BACKGROUND_COLOR, new BackgroundColorOptionListener(null));
        config.addOptionListener(FONT_MAIN, new MainFontOptionListener(null));
        config.addOptionListener(FONT_LINE_NUMBERS, new LineNumbersFontOptionListener(null));
        config.addOptionListener(FONT_DOCLIST, new DoclistFontOptionListener(null));
        config.addOptionListener(FONT_TOOLBAR, new ToolbarFontOptionListener(null));
        config.addOptionListener(TOOLBAR_ICONS_ENABLED, new ToolbarOptionListener(null));
        config.addOptionListener(TOOLBAR_TEXT_ENABLED, new ToolbarOptionListener(null));
        config.addOptionListener(TOOLBAR_ENABLED, new ToolbarOptionListener(null));
        config.addOptionListener(WORKING_DIRECTORY, new WorkingDirOptionListener(null));
        config.addOptionListener(LINEENUM_ENABLED, new LineEnumOptionListener(null));
        config.addOptionListener(QUIT_PROMPT, new QuitPromptOptionListener(null));
        config.addOptionListener(RECENT_FILES_MAX_SIZE, new RecentFilesOptionListener(null));
        config.addOptionListener(JSR14_LOCATION, new OptionListener<File>(){

            @Override
            public void optionChanged(OptionEvent<File> oe) {
                boolean bootClasspathHasv2 = DrJava.bootClasspathHasJSR14v20();
                boolean bootClasspathHasv24 = DrJava.bootClasspathHasJSR14v24();
                if (oe.value != FileOption.NULL_FILE) {
                    boolean checkForV20 = DrJava.checkForJSR14v20();
                    boolean checkForV24 = DrJava.checkForJSR14v24();
                    if (checkForV24 && !bootClasspathHasv24) {
                        JOptionPane.showMessageDialog(MainFrame.access$6200(MainFrame.this), "You must restart DrJava to use the JSR-14 v2.4 compiler.", "JSR14 Warning", 2);
                    } else if (checkForV20 && !checkForV24 && (!bootClasspathHasv2 || bootClasspathHasv24)) {
                        JOptionPane.showMessageDialog(MainFrame.access$6200(MainFrame.this), "You must restart DrJava to use the JSR-14 v2.0/2.2 compiler.", "JSR14 Warning", 2);
                    } else if (!checkForV20 && bootClasspathHasv2) {
                        JOptionPane.showMessageDialog(MainFrame.access$6200(MainFrame.this), "You must restart DrJava to switch to 1.x versions of the JSR-14 compiler.", "JSR14 Warning", 2);
                    }
                }
            }
        });
        config.addOptionListener(LOOK_AND_FEEL, new OptionListener<String>(){

            @Override
            public void optionChanged(OptionEvent<String> oe) {
                ConfirmCheckBoxDialog dialog;
                String title = "Apply Look and Feel";
                String msg = "Look and feel changes will take effect when you restart DrJava.";
                if (config.getSetting(OptionConstants.WARN_CHANGE_LAF).booleanValue() && (dialog = new ConfirmCheckBoxDialog(MainFrame.access$6200(MainFrame.this), title, msg, "Do not show this message again", 1, -1)).show() == 0 && dialog.getCheckBoxValue()) {
                    config.setSetting(OptionConstants.WARN_CHANGE_LAF, Boolean.FALSE);
                }
            }
        });
        config.addOptionListener(JVM_ARGS, new OptionListener<String>(){

            @Override
            public void optionChanged(OptionEvent<String> oe) {
                int result;
                if (!((String)oe.value).equals("") && (result = JOptionPane.showConfirmDialog(MainFrame.access$6200(MainFrame.this), "Specifying JVM Args is an advanced option. Invalid arguments may cause the\nInteractions Pane to stop working.\nAre you sure you want to set this option?\n(You will have to reset the interactions pane before changes take effect.)", "Confirm JVM Arguments", 0)) != 0) {
                    config.setSetting(oe.option, "");
                }
            }
        });
        config.addOptionListener(ALLOW_PRIVATE_ACCESS, new OptionListener<Boolean>(){

            @Override
            public void optionChanged(OptionEvent<Boolean> oce) {
                MainFrame.access$700(MainFrame.this).getInteractionsModel().setPrivateAccessible((Boolean)oce.value);
            }
        });
        this._breakpointHighlights = new Hashtable();
        this._configFrame = null;
        this._helpFrame = null;
        this._aboutDialog = null;
        this._interactionsScriptController = null;
        this._projectPropertiesFrame = null;
        this._showConfigException();
        KeyBindingManager.Singleton.setShouldCheckConflict(false);
        PlatformFactory.ONLY.afterUISetup(this._aboutAction, this._editPreferencesAction, this._quitAction);
        this.setUpKeys();
    }

    private DirectoryChooser makeFolderChooser(File workDir) {
        DirectoryChooser dc = new DirectoryChooser(this);
        dc.setSelectedDirectory(workDir);
        dc.setApproveButtonText("Select");
        dc.setDialogTitle("Open Folder");
        dc.setAccessory(this._openRecursiveCheckBox);
        return dc;
    }

    private void setUpKeys() {
        this.setFocusTraversalKeysEnabled(false);
    }

    @Override
    public void dispose() {
        this._model.dispose();
        Utilities.invokeAndWait(new Runnable(){

            public void run() {
                MainFrame.access$8800(MainFrame.this);
            }
        });
    }

    private void disposeHelp() {
        super.dispose();
    }

    public SingleDisplayModel getModel() {
        return this._model;
    }

    InteractionsPane getInteractionsPane() {
        return this._interactionsPane;
    }

    InteractionsController getInteractionsController() {
        return this._interactionsController;
    }

    JButton getCloseButton() {
        return this._closeButton;
    }

    JButton getCompileAllButton() {
        return this._compileButton;
    }

    public void hourglassOn() {
        ++this.hourglassNestLevel;
        if (this.hourglassNestLevel == 1) {
            Utilities.invokeAndWait(new Runnable(){

                public void run() {
                    MainFrame.this.getGlassPane().setVisible(true);
                    MainFrame.access$4700(MainFrame.this).setEditable(false);
                    MainFrame.this.setAllowKeyEvents(false);
                }
            });
        }
    }

    public void hourglassOff() {
        --this.hourglassNestLevel;
        if (this.hourglassNestLevel == 0) {
            Utilities.invokeAndWait(new Runnable(){

                public void run() {
                    MainFrame.this.getGlassPane().setVisible(false);
                    MainFrame.access$4700(MainFrame.this).setEditable(true);
                    MainFrame.this.setAllowKeyEvents(true);
                }
            });
        }
    }

    public void setAllowKeyEvents(boolean a) {
        this.allow_key_events = a;
    }

    public boolean getAllowKeyEvents() {
        return this.allow_key_events;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void debuggerToggle() {
        block7: {
            Debugger debugger = this._model.getDebugger();
            try {
                if (this.inDebugMode()) {
                    debugger.shutdown();
                    break block7;
                }
                this.hourglassOn();
                try {
                    debugger.startup();
                    this._model.refreshActiveDocument();
                    this._updateDebugStatus();
                }
                finally {
                    this.hourglassOff();
                }
            }
            catch (DebugException de) {
                this._showError(de, "Debugger Error", "Could not start the debugger.");
            }
            catch (NoClassDefFoundError err) {
                this._showError(err, "Debugger Error", "Unable to find the JPDA package for the debugger.\nPlease make sure either tools.jar or jpda.jar is\nin your classpath when you start DrJava.");
                this._setDebugMenuItemsEnabled(false);
            }
        }
    }

    public void showDebugger() {
        this._setDebugMenuItemsEnabled(true);
        this._showDebuggerPanel();
    }

    public void hideDebugger() {
        this._setDebugMenuItemsEnabled(false);
        this._hideDebuggerPanel();
    }

    private void _showDebuggerPanel() {
        this._debugSplitPane.setTopComponent(this._docSplitPane);
        this._mainSplit.setTopComponent(this._debugSplitPane);
        this._debugPanel.updateData();
        this._lastFocusOwner.requestFocusInWindow();
    }

    private void _hideDebuggerPanel() {
        this._mainSplit.setTopComponent(this._docSplitPane);
        this._lastFocusOwner.requestFocusInWindow();
    }

    public void updateFileTitle(String text) {
        this._fileNameField.setText(text);
    }

    public void updateFileTitle() {
        OpenDefinitionsDocument doc = this._model.getActiveDocument();
        String filename = GlobalModelNaming.getDisplayFullPath(doc);
        if (!filename.equals(this._fileTitle)) {
            this._fileTitle = filename;
            this.setTitle(new StringBuffer().append("File: ").append(filename).toString());
            this._model.getDocCollectionWidget().repaint();
        }
        this._fileNameField.setText(GlobalModelNaming.getDisplayFullPath(doc));
    }

    public File[] getOpenFiles(JFileChooser jfc) throws OperationCanceledException {
        File selection = jfc.getSelectedFile();
        if (selection != null) {
            jfc.setSelectedFile(null);
        }
        int rc = jfc.showOpenDialog(this);
        return this.getChosenFiles(jfc, rc);
    }

    public File getSaveFile(JFileChooser jfc) throws OperationCanceledException {
        File selection = jfc.getSelectedFile();
        if (selection != null) {
            jfc.setSelectedFile(selection.getParentFile());
            jfc.setSelectedFile(selection);
            jfc.setSelectedFile(null);
        }
        OpenDefinitionsDocument active = this._model.getActiveDocument();
        try {
            String className = active.getFirstTopLevelClassName();
            if (!className.equals("")) {
                jfc.setSelectedFile(new File(jfc.getCurrentDirectory(), className));
            }
        }
        catch (ClassNameNotFoundException e) {
            // empty catch block
        }
        this._saveChooser.removeChoosableFileFilter(this._projectFilter);
        this._saveChooser.removeChoosableFileFilter(this._javaSourceFilter);
        this._saveChooser.setFileFilter(this._javaSourceFilter);
        int rc = jfc.showSaveDialog(this);
        return this.getChosenFile(jfc, rc);
    }

    public DefinitionsPane getCurrentDefPane() {
        return this._currentDefPane;
    }

    public ErrorPanel getSelectedErrorPanel() {
        Component c = this._tabbedPane.getSelectedComponent();
        if (c instanceof ErrorPanel) {
            return (ErrorPanel)c;
        }
        return null;
    }

    public boolean isCompilerTabSelected() {
        return this._tabbedPane.getSelectedComponent() == this._compilerErrorPanel;
    }

    public boolean isTestTabSelected() {
        return this._tabbedPane.getSelectedComponent() == this._junitErrorPanel;
    }

    public boolean isJavadocTabSelected() {
        return this._tabbedPane.getSelectedComponent() == this._javadocErrorPanel;
    }

    private void _installNewDocumentListener(Document d) {
        d.addDocumentListener(new DocumentUIListener(){

            public void changedUpdate(DocumentEvent e) {
                Utilities.invokeLater(new Runnable(){

                    public void run() {
                        OpenDefinitionsDocument doc = MainFrame.access$700(MainFrame.this).getActiveDocument();
                        if (doc.isModifiedSinceSave()) {
                            MainFrame.access$5000(MainFrame.this).setEnabled(true);
                            if (MainFrame.this.inDebugMode() && MainFrame.access$8900(MainFrame.this).getStatusText().equals("")) {
                                MainFrame.access$8900(MainFrame.this).setStatusText(MainFrame.DEBUGGER_OUT_OF_SYNC);
                            }
                            MainFrame.this.updateFileTitle();
                        }
                    }
                });
            }

            public void insertUpdate(DocumentEvent e) {
                Utilities.invokeLater(new Runnable(){

                    public void run() {
                        MainFrame.access$5000(MainFrame.this).setEnabled(true);
                        if (MainFrame.this.inDebugMode() && MainFrame.access$8900(MainFrame.this).getStatusText().equals("")) {
                            MainFrame.access$8900(MainFrame.this).setStatusText(MainFrame.DEBUGGER_OUT_OF_SYNC);
                        }
                        MainFrame.this.updateFileTitle();
                    }
                });
            }

            public void removeUpdate(DocumentEvent e) {
                Utilities.invokeLater(new Runnable(){

                    public void run() {
                        MainFrame.access$5000(MainFrame.this).setEnabled(true);
                        if (MainFrame.this.inDebugMode() && MainFrame.access$8900(MainFrame.this).getStatusText().equals("")) {
                            MainFrame.access$8900(MainFrame.this).setStatusText(MainFrame.DEBUGGER_OUT_OF_SYNC);
                        }
                        MainFrame.this.updateFileTitle();
                    }
                });
            }
        });
    }

    public void setStatusMessage(String msg) {
        this._sbMessage.setText(msg);
    }

    public void clearStatusMessage() {
        this._sbMessage.setText("");
    }

    public void setStatusMessageFont(Font f) {
        this._sbMessage.setFont(f);
    }

    public void setStatusMessageColor(Color c) {
        this._sbMessage.setForeground(c);
    }

    private void _moveToAuxiliary() {
        OpenDefinitionsDocument d = this._model.getDocumentNavigator().getCurrent();
        if (d != null && !d.isUntitled()) {
            this._model.addAuxiliaryFile(d);
            try {
                this._model.getDocumentNavigator().refreshDocument(d, this._model.fixPathForNavigator(d.getFile().getCanonicalPath()));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void _removeAuxiliary() {
        OpenDefinitionsDocument d = this._model.getDocumentNavigator().getCurrent();
        if (d != null && !d.isUntitled()) {
            this._model.removeAuxiliaryFile(d);
            try {
                this._model.getDocumentNavigator().refreshDocument(d, this._model.fixPathForNavigator(d.getFile().getCanonicalPath()));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void _new() {
        this._model.newFile();
    }

    private void _open() {
        this.open(this._openSelector);
    }

    private void _openFolder() {
        this.openFolder(this._folderChooser);
    }

    private void _openFileOrProject() {
        try {
            final File[] fileList = this._openFileOrProjectSelector.getFiles();
            FileOpenSelector fos = new FileOpenSelector(){

                public File[] getFiles() {
                    return fileList;
                }
            };
            if (this._openChooser.getFileFilter().equals(this._projectFilter)) {
                this.openProject(fos);
            } else {
                this.open(fos);
            }
        }
        catch (OperationCanceledException operationCanceledException) {
            // empty catch block
        }
    }

    private void _putTextIntoDefinitions(String text) {
        int caretPos = this._currentDefPane.getCaretPosition();
        try {
            this._model.getActiveDocument().insertString(caretPos, text, null);
        }
        catch (BadLocationException ble) {
            throw new UnexpectedException(ble);
        }
    }

    private void _resetNavigatorPane() {
        if (this._model.getDocumentNavigator() instanceof JTreeSortNavigator) {
            JTreeSortNavigator nav = (JTreeSortNavigator)this._model.getDocumentNavigator();
            nav.setDisplayManager(this.getNavPaneDisplayManager());
            nav.setRootIcon(_djProjectIcon);
        }
        this._docSplitPane.remove(this._docSplitPane.getLeftComponent());
        this._docSplitPane.setLeftComponent(new JScrollPane(this._model.getDocumentNavigator().asContainer()));
        Font doclistFont = DrJava.getConfig().getSetting(FONT_DOCLIST);
        this._model.getDocCollectionWidget().setFont(doclistFont);
        this._updateNormalColor();
        this._updateBackgroundColor();
    }

    private void _openProject() {
        this.openProject(this._openProjectSelector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openProject(FileOpenSelector projectSelector) {
        this._model.resetInteractions();
        try {
            this.hourglassOn();
            File[] file = projectSelector.getFiles();
            if (file.length < 1) {
                throw new IllegalStateException("Open project file selection not canceled but no project file was selected.");
            }
            if (!this._model.isProjectActive() || this._model.isProjectActive() && this._closeProject()) {
                this._openProjectHelper(file[0]);
            }
        }
        catch (OperationCanceledException oce) {
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        finally {
            this.hourglassOff();
        }
    }

    private void _openProjectHelper(File projectFile) {
        this._currentProjFile = projectFile;
        try {
            this._model.openProject(projectFile);
        }
        catch (MalformedProjectFileException e) {
            this._showProjectFileParseError(e);
            return;
        }
        catch (FileNotFoundException e) {
            this._showFileNotFoundError(e);
            return;
        }
        catch (IOException e) {
            this._showIOError(e);
            return;
        }
    }

    private void _openProjectUpdate() {
        if (this._model.isProjectActive()) {
            this._closeProjectAction.setEnabled(true);
            this._saveProjectAction.setEnabled(true);
            this._projectPropertiesAction.setEnabled(true);
            this._junitOpenProjectFilesAction.setEnabled(true);
            this._compileProjectAction.setEnabled(true);
            this._jarProjectAction.setEnabled(true);
            if (this._model.getBuildDirectory() != null) {
                this._cleanAction.setEnabled(true);
            }
            this._resetNavigatorPane();
            this._compileButton.setToolTipText("<html>Compile all documents in the project.<br>External files are excluded.</html>");
        }
    }

    boolean _closeProject() {
        if (this._checkProjectClose()) {
            List<OpenDefinitionsDocument> projDocs = this._model.getProjectDocuments();
            boolean couldClose = this._model.closeFiles(projDocs);
            if (!couldClose) {
                return false;
            }
            this._model.closeProject();
            Component renderer = this._model.getDocumentNavigator().getRenderer();
            new ForegroundColorListener(renderer);
            new BackgroundColorListener(renderer);
            this._resetNavigatorPane();
            if (this._model.getDocumentCount() == 1) {
                this._model.setActiveFirstDocument();
            }
            this._closeProjectAction.setEnabled(false);
            this._saveProjectAction.setEnabled(false);
            this._projectPropertiesAction.setEnabled(false);
            this._jarProjectAction.setEnabled(false);
            this._junitOpenProjectFilesAction.setEnabled(false);
            this._compileProjectAction.setEnabled(false);
            this._setUpContextMenus();
            this._currentProjFile = null;
            this._compileButton.setToolTipText("Compile all open documents");
            return true;
        }
        return false;
    }

    private boolean _checkProjectClose() {
        if (this._model.isProjectChanged()) {
            String fname = this._model.getProjectFile().getName();
            String text = new StringBuffer().append(fname).append(" has been modified. Would you like to save it?").toString();
            int rc = JOptionPane.showConfirmDialog(this, text, new StringBuffer().append("Save ").append(fname).append("?").toString(), 1);
            switch (rc) {
                case 0: {
                    this._saveProject();
                    return true;
                }
                case 1: {
                    return true;
                }
                case -1: 
                case 2: {
                    return false;
                }
            }
            throw new RuntimeException(new StringBuffer().append("Invalid rc: ").append(rc).toString());
        }
        return true;
    }

    public File getCurrentProject() {
        return this._currentProjFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(FileOpenSelector openSelector) {
        try {
            this.hourglassOn();
            this._model.openFiles(openSelector);
        }
        catch (AlreadyOpenException aoe) {
            String filename;
            OpenDefinitionsDocument openDoc = aoe.getOpenDocument();
            try {
                filename = openDoc.getFile().getName();
            }
            catch (IllegalStateException ise) {
                throw new UnexpectedException(ise);
            }
            catch (FileMovedException fme) {
                filename = fme.getFile().getName();
            }
            this._model.setActiveDocument(openDoc);
            if (openDoc.isModifiedSinceSave()) {
                String title = "Revert to Saved?";
                String message = new StringBuffer().append(filename).append(" is already open and modified.\n").append("Would you like to revert to the version on disk?\n").toString();
                int choice = JOptionPane.showConfirmDialog(this, message, title, 0);
                if (choice == 0) {
                    this._revert();
                }
            }
            try {
                File f = openDoc.getFile();
                if (!this._model.inProject(f)) {
                    this._recentFileManager.updateOpenFiles(f);
                }
            }
            catch (IllegalStateException ise) {
                throw new UnexpectedException(ise);
            }
            catch (FileMovedException fme) {
                File f = fme.getFile();
                if (!this._model.inProject(f)) {
                    this._recentFileManager.updateOpenFiles(f);
                }
            }
        }
        catch (OperationCanceledException oce) {
        }
        catch (FileNotFoundException fnf) {
            this._showFileNotFoundError(fnf);
        }
        catch (IOException ioe) {
            this._showIOError(ioe);
        }
        finally {
            this.hourglassOff();
        }
    }

    public void openFolder(DirectoryChooser chooser) {
        String type = new StringBuffer().append("'").append(DrJava.LANGUAGE_LEVEL_EXTENSIONS[DrJava.getConfig().getSetting(LANGUAGE_LEVEL)]).append("' ").toString();
        chooser.setDialogTitle(new StringBuffer().append("Open All ").append(type).append("Files In...").toString());
        File openDir = null;
        try {
            openDir = this._model.getActiveDocument().getFile().getParentFile();
        }
        catch (FileMovedException e) {
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        int result = chooser.showDialog(openDir);
        if (result != 0) {
            return;
        }
        File dir = chooser.getSelectedDirectory();
        boolean rec = this._openRecursiveCheckBox.isSelected();
        DrJava.getConfig().setSetting(OptionConstants.OPEN_FOLDER_RECURSIVE, Autobox.valueOf(rec));
        this._openFolder(dir, rec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _openFolder(File dir, boolean rec) {
        this.hourglassOn();
        try {
            this._model.openFolder(dir, rec);
        }
        catch (AlreadyOpenException e) {
        }
        catch (IOException e) {
            this._showIOError(e);
        }
        catch (OperationCanceledException operationCanceledException) {
        }
        finally {
            this.hourglassOff();
        }
    }

    private void _close() {
        if (this._model.isProjectActive() && this._model.getActiveDocument().isInProjectPath() || this._model.getActiveDocument().isAuxiliaryFile()) {
            String filename = null;
            OpenDefinitionsDocument doc = this._model.getActiveDocument();
            try {
                filename = doc.isUntitled() ? "File" : this._model.getActiveDocument().getFile().getName();
            }
            catch (FileMovedException e) {
                filename = e.getFile().getName();
            }
            String text = "Closing this file will permanently remove it from the current project.\nAre you sure that you want to close this file?";
            Object[] options = new Object[]{"Yes", "No"};
            int rc = JOptionPane.showOptionDialog(this, text, new StringBuffer().append("Close ").append(filename).append("?").toString(), 0, 3, null, options, options[1]);
            if (rc != 0) {
                return;
            }
            this._model.setProjectChanged(true);
        }
        this._model.closeFile(this._model.getActiveDocument());
    }

    private void _closeFolder() {
        Enumeration<OpenDefinitionsDocument> e = this._model.getDocumentNavigator().getDocuments();
        LinkedList<OpenDefinitionsDocument> l = new LinkedList<OpenDefinitionsDocument>();
        if (this._model.getDocumentNavigator().isGroupSelected()) {
            while (e.hasMoreElements()) {
                OpenDefinitionsDocument d = e.nextElement();
                if (!this._model.getDocumentNavigator().isSelectedInGroup(d)) continue;
                l.add(d);
            }
            this._model.closeFiles(l);
            if (!l.isEmpty()) {
                this._model.setProjectChanged(true);
            }
        }
    }

    private void _printDefDoc() {
        try {
            this._model.getActiveDocument().print();
        }
        catch (FileMovedException fme) {
            this._showFileMovedError(fme);
        }
        catch (PrinterException e) {
            this._showError(e, "Print Error", "An error occured while printing.");
        }
        catch (BadLocationException e) {
            this._showError(e, "Print Error", "An error occured while printing.");
        }
    }

    private void _printConsole() {
        try {
            this._model.getConsoleDocument().print();
        }
        catch (PrinterException e) {
            this._showError(e, "Print Error", "An error occured while printing.");
        }
    }

    private void _printInteractions() {
        try {
            this._model.getInteractionsDocument().print();
        }
        catch (PrinterException e) {
            this._showError(e, "Print Error", "An error occured while printing.");
        }
    }

    private void _printDefDocPreview() {
        try {
            this._model.getActiveDocument().preparePrintJob();
            new PreviewDefDocFrame(this._model, this);
        }
        catch (FileMovedException fme) {
            this._showFileMovedError(fme);
        }
        catch (BadLocationException e) {
            this._showError(e, "Print Error", "An error occured while preparing the print preview.");
        }
        catch (IllegalStateException e) {
            this._showError(e, "Print Error", "An error occured while preparing the print preview.");
        }
    }

    private void _printConsolePreview() {
        try {
            this._model.getConsoleDocument().preparePrintJob();
            new PreviewConsoleFrame(this._model, this, false);
        }
        catch (IllegalStateException e) {
            this._showError(e, "Print Error", "An error occured while preparing the print preview.");
        }
    }

    private void _printInteractionsPreview() {
        try {
            this._model.getInteractionsDocument().preparePrintJob();
            new PreviewConsoleFrame(this._model, this, true);
        }
        catch (IllegalStateException e) {
            this._showError(e, "Print Error", "An error occured while preparing the print preview.");
        }
    }

    private void _pageSetup() {
        PrinterJob job = PrinterJob.getPrinterJob();
        this._model.setPageFormat(job.pageDialog(this._model.getPageFormat()));
    }

    void closeAll() {
        this._closeAll();
    }

    private void _closeAll() {
        if (!this._model.isProjectActive() || this._model.isProjectActive() && this._closeProject()) {
            this._model.closeAllFiles();
        }
    }

    private boolean _save() {
        try {
            if (this._model.getActiveDocument().saveFile(this._saveSelector)) {
                this._currentDefPane.hasWarnedAboutModified(false);
                this._model.setActiveDocument(this._model.getActiveDocument());
                return true;
            }
            return false;
        }
        catch (IOException ioe) {
            this._showIOError(ioe);
            return false;
        }
    }

    private boolean _saveAs() {
        try {
            boolean toReturn = this._model.getActiveDocument().saveFileAs(this._saveAsSelector);
            this._model.setActiveDocument(this._model.getActiveDocument());
            return toReturn;
        }
        catch (IOException ioe) {
            this._showIOError(ioe);
            return false;
        }
    }

    private void _saveAll() {
        try {
            if (this._model.isProjectActive()) {
                this._saveProject();
            }
            this._model.saveAllFiles(this._saveSelector);
        }
        catch (IOException ioe) {
            this._showIOError(ioe);
        }
    }

    void saveProject() {
        this._saveProject();
    }

    private void _saveProject() {
        this._saveProjectHelper(this._currentProjFile);
    }

    private void _newProject() {
        this._closeAll();
        this._saveProjectAs();
    }

    private void _saveProjectAs() {
        File file;
        int rc;
        this._saveChooser.removeChoosableFileFilter(this._projectFilter);
        this._saveChooser.removeChoosableFileFilter(this._javaSourceFilter);
        this._saveChooser.setFileFilter(this._projectFilter);
        File selection = this._saveChooser.getSelectedFile();
        if (selection != null) {
            this._saveChooser.setSelectedFile(selection.getParentFile());
            this._saveChooser.setSelectedFile(selection);
            this._saveChooser.setSelectedFile(null);
        }
        if (this._currentProjFile != null) {
            this._saveChooser.setSelectedFile(this._currentProjFile);
        }
        if ((rc = this._saveChooser.showSaveDialog(this)) == 0 && (!(file = this._saveChooser.getSelectedFile()).exists() || this._verifyOverwrite())) {
            this._saveProjectHelper(file);
            try {
                if (file.getCanonicalPath().endsWith(".pjt")) {
                    this._openProjectHelper(file);
                } else {
                    this._openProjectHelper(new File(new StringBuffer().append(file.getCanonicalPath()).append(".pjt").toString()));
                }
            }
            catch (IOException e) {
                throw new UnexpectedException(e);
            }
        }
    }

    void _saveProjectHelper(File file) {
        try {
            if (file.getName().indexOf(".") == -1) {
                file = new File(new StringBuffer().append(file.getAbsolutePath()).append(".pjt").toString());
            }
            String filename = file.getCanonicalPath();
            this._model.saveProject(filename, this._gatherDocInfo());
        }
        catch (IOException ioe) {
            this._showIOError(ioe);
        }
        this._recentProjectManager.updateOpenFiles(file);
        this._model.setProjectChanged(false);
    }

    private Hashtable<OpenDefinitionsDocument, DocumentInfoGetter> _gatherDocInfo() {
        Hashtable<OpenDefinitionsDocument, DocumentInfoGetter> map = new Hashtable<OpenDefinitionsDocument, DocumentInfoGetter>();
        List<OpenDefinitionsDocument> docs = this._model.getOpenDefinitionsDocuments();
        for (OpenDefinitionsDocument doc : docs) {
            map.put(doc, this._makeInfoGetter(doc));
        }
        return map;
    }

    private DocumentInfoGetter _makeInfoGetter(final OpenDefinitionsDocument doc) {
        JScrollPane s = this._defScrollPanes.get(doc);
        if (s == null) {
            s = this._createDefScrollPane(doc);
        }
        JScrollPane scroller = s;
        final DefinitionsPane pane = (DefinitionsPane)scroller.getViewport().getView();
        return new DocumentInfoGetter(){

            @Override
            public Pair<Integer, Integer> getSelection() {
                Integer selStart = new Integer(pane.getSelectionStart());
                Integer selEnd = new Integer(pane.getSelectionEnd());
                if (pane.getCaretPosition() == selStart.intValue()) {
                    return new Pair<Integer, Integer>(selEnd, selStart);
                }
                return new Pair<Integer, Integer>(selStart, selEnd);
            }

            @Override
            public Pair<Integer, Integer> getScroll() {
                Integer scrollv = new Integer(pane.getVerticalScroll());
                Integer scrollh = new Integer(pane.getHorizontalScroll());
                return new Pair<Integer, Integer>(scrollv, scrollh);
            }

            @Override
            public File getFile() {
                if (doc.isUntitled()) {
                    return null;
                }
                try {
                    return doc.getFile();
                }
                catch (Exception e) {
                    throw new UnexpectedException(e);
                }
            }

            @Override
            public String getPackage() {
                try {
                    return doc.getPackageName();
                }
                catch (InvalidPackageException e) {
                    return null;
                }
            }

            @Override
            public boolean isActive() {
                return MainFrame.access$700(MainFrame.this).getActiveDocument() == doc;
            }

            @Override
            public boolean isUntitled() {
                return doc.isUntitled();
            }
        };
    }

    private void _revert() {
        try {
            this._model.getActiveDocument().revertFile();
        }
        catch (FileMovedException fme) {
            this._showFileMovedError(fme);
        }
        catch (IOException ioe) {
            this._showIOError(ioe);
        }
    }

    private void _saveCurrentDirectory() {
        try {
            try {
                DrJava.getConfig().setSetting(LAST_DIRECTORY, this._getFullFile(this._model.getActiveDocument().getFile()));
            }
            catch (IllegalStateException ise) {
                DrJava.getConfig().setSetting(LAST_DIRECTORY, this._getFullFile(this._openChooser.getCurrentDirectory()));
            }
            catch (FileMovedException fme) {
                DrJava.getConfig().setSetting(LAST_DIRECTORY, this._getFullFile(fme.getFile()));
            }
        }
        catch (IOException ioe) {
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void _quit() {
        if (this._promptBeforeQuit) {
            String title = "Quit DrJava?";
            String message = "Are you sure you want to quit DrJava?";
            ConfirmCheckBoxDialog dialog = new ConfirmCheckBoxDialog(this, title, message);
            int rc = dialog.show();
            if (rc != 0) {
                return;
            }
            if (dialog.getCheckBoxValue()) {
                DrJava.getConfig().setSetting(QUIT_PROMPT, Boolean.FALSE);
            }
        }
        if (!this._checkProjectClose()) {
            return;
        }
        this._recentFileManager.saveRecentFiles();
        this._recentProjectManager.saveRecentFiles();
        this._storePositionInfo();
        this._saveCurrentDirectory();
        if (!DrJava.getConfig().hadStartupException()) {
            try {
                DrJava.getConfig().saveConfiguration();
            }
            catch (IOException ioe) {
                this._showIOError(ioe);
            }
        }
        this._model.quit();
    }

    private void _storePositionInfo() {
        FileConfiguration config = DrJava.getConfig();
        if (config.getSetting(WINDOW_STORE_POSITION).booleanValue()) {
            Rectangle bounds = this.getBounds();
            config.setSetting(WINDOW_HEIGHT, new Integer(bounds.height));
            config.setSetting(WINDOW_WIDTH, new Integer(bounds.width));
            config.setSetting(WINDOW_X, new Integer(bounds.x));
            config.setSetting(WINDOW_Y, new Integer(bounds.y));
        } else {
            config.setSetting(WINDOW_HEIGHT, WINDOW_HEIGHT.getDefault());
            config.setSetting(WINDOW_WIDTH, WINDOW_WIDTH.getDefault());
            config.setSetting(WINDOW_X, WINDOW_X.getDefault());
            config.setSetting(WINDOW_Y, WINDOW_Y.getDefault());
        }
        if (this._debugPanel != null) {
            config.setSetting(DEBUG_PANEL_HEIGHT, new Integer(this._debugPanel.getHeight()));
        }
        config.setSetting(DOC_LIST_WIDTH, new Integer(this._docSplitPane.getDividerLocation()));
    }

    private void _cleanUpForCompile() {
        if (this.inDebugMode()) {
            this._model.getDebugger().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _compile() {
        this._cleanUpForCompile();
        this.hourglassOn();
        try {
            OpenDefinitionsDocument doc = this._model.getActiveDocument();
            try {
                this._model.getCompilerModel().compile(doc);
            }
            catch (FileMovedException fme) {
                this._showFileMovedError(fme);
            }
            catch (IOException ioe) {
                this._showIOError(ioe);
            }
        }
        finally {
            this.hourglassOff();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _compileFolder() {
        this._cleanUpForCompile();
        this.hourglassOn();
        try {
            Enumeration<OpenDefinitionsDocument> e = this._model.getDocumentNavigator().getDocuments();
            LinkedList<OpenDefinitionsDocument> l = new LinkedList<OpenDefinitionsDocument>();
            if (this._model.getDocumentNavigator().isGroupSelected()) {
                while (e.hasMoreElements()) {
                    OpenDefinitionsDocument d = e.nextElement();
                    if (!this._model.getDocumentNavigator().isSelectedInGroup(d)) continue;
                    l.add(d);
                }
                try {
                    this._model.getCompilerModel().compile(l);
                }
                catch (FileMovedException fme) {
                    this._showFileMovedError(fme);
                }
                catch (IOException ioe) {
                    this._showIOError(ioe);
                }
            }
        }
        finally {
            this.hourglassOff();
        }
    }

    private void _compileProject() {
        this._compileAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _compileAll() {
        this._cleanUpForCompile();
        this.hourglassOn();
        try {
            this._model.getCompilerModel().compileAll();
        }
        catch (FileMovedException fme) {
            this._showFileMovedError(fme);
        }
        catch (IOException ioe) {
            this._showIOError(ioe);
        }
        finally {
            this.hourglassOff();
        }
    }

    private boolean showCleanWarning() {
        if (DrJava.getConfig().getSetting(PROMPT_BEFORE_CLEAN).booleanValue()) {
            String buildDirTxt = "";
            try {
                buildDirTxt = this._model.getBuildDirectory().getCanonicalPath();
            }
            catch (Exception e) {
                buildDirTxt = this._model.getBuildDirectory().getPath();
            }
            ConfirmCheckBoxDialog dialog = new ConfirmCheckBoxDialog(this, "Clean Build Directory?", new StringBuffer().append("Cleaning your build directory will delete all\nclass files and empty folders within that directory.\nAre you sure you want to clean\n").append(buildDirTxt).append("?").toString(), "Do not show this message again");
            int rc = dialog.show();
            switch (rc) {
                case 0: {
                    this._saveAll();
                    if (dialog.getCheckBoxValue()) {
                        DrJava.getConfig().setSetting(PROMPT_BEFORE_CLEAN, Boolean.FALSE);
                    }
                    return true;
                }
                case 1: {
                    return false;
                }
                case 2: {
                    return false;
                }
                case -1: {
                    return false;
                }
            }
            throw new RuntimeException(new StringBuffer().append("Invalid rc from showConfirmDialog: ").append(rc).toString());
        }
        return true;
    }

    private void _clean() {
        SwingWorker worker = new SwingWorker(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object construct() {
                if (MainFrame.access$9000(MainFrame.this)) {
                    try {
                        MainFrame.this.hourglassOn();
                        MainFrame.access$700(MainFrame.this).cleanBuildDirectory();
                    }
                    catch (FileMovedException fme) {
                        MainFrame.this._showFileMovedError(fme);
                    }
                    catch (IOException ioe) {
                        MainFrame.this._showIOError(ioe);
                    }
                    finally {
                        MainFrame.this.hourglassOff();
                    }
                }
                return null;
            }
        };
        worker.start();
    }

    private void _runProject() {
        if (this._model.isProjectActive()) {
            try {
                File f = this._model.getMainClass();
                if (f != null) {
                    OpenDefinitionsDocument doc = this._model.getDocumentForFile(f);
                    doc.runMain();
                }
            }
            catch (ClassNameNotFoundException e) {
                String msg = "DrJava could not find the top level class name in the\ncurrent document, so it could not run the class.  Please\nmake sure that the class is properly defined first.";
                JOptionPane.showMessageDialog(this, msg, "No Class Found", 0);
            }
            catch (FileMovedException fme) {
                this._showFileMovedError(fme);
            }
            catch (IOException ioe) {
                this._showIOError(ioe);
            }
        } else {
            this._runMain();
        }
    }

    private void _runMain() {
        try {
            this._model.getActiveDocument().runMain();
        }
        catch (ClassNameNotFoundException e) {
            String msg = "DrJava could not find the top level class name in the\ncurrent document, so it could not run the class.  Please\nmake sure that the class is properly defined first.";
            JOptionPane.showMessageDialog(this, msg, "No Class Found", 0);
        }
        catch (FileMovedException fme) {
            this._showFileMovedError(fme);
        }
        catch (IOException ioe) {
            this._showIOError(ioe);
        }
    }

    private void _junit() {
        new Thread("Run JUnit on Current Document"){

            public void run() {
                MainFrame.access$9100(MainFrame.this);
                MainFrame.this.hourglassOn();
                try {
                    MainFrame.access$700(MainFrame.this).getActiveDocument().startJUnit();
                }
                catch (FileMovedException fme) {
                    MainFrame.this._showFileMovedError(fme);
                }
                catch (IOException ioe) {
                    MainFrame.this._showIOError(ioe);
                }
                catch (ClassNotFoundException cnfe) {
                    MainFrame.this._showClassNotFoundError(cnfe);
                }
                catch (NoClassDefFoundError ncde) {
                    MainFrame.this._showNoClassDefError(ncde);
                }
                catch (ExitingNotAllowedException enae) {
                    JOptionPane.showMessageDialog(MainFrame.this, "An exception occurred while running JUnit, which could\nnot be caught by DrJava.  Details about the exception should\nhave been printed to your console.\n\n", "Error Running JUnit", 0);
                }
            }
        }.start();
    }

    private void _junitFolder() {
        new Thread("Run JUnit on specified folder"){

            public void run() {
                MainFrame.access$9100(MainFrame.this);
                MainFrame.this.hourglassOn();
                if (MainFrame.access$700(MainFrame.this).getDocumentNavigator().isGroupSelected()) {
                    Enumeration<OpenDefinitionsDocument> docs = MainFrame.access$700(MainFrame.this).getDocumentNavigator().getDocuments();
                    LinkedList<OpenDefinitionsDocument> l = new LinkedList<OpenDefinitionsDocument>();
                    while (docs.hasMoreElements()) {
                        OpenDefinitionsDocument doc = docs.nextElement();
                        if (!MainFrame.access$700(MainFrame.this).getDocumentNavigator().isSelectedInGroup(doc)) continue;
                        l.add(doc);
                    }
                    try {
                        MainFrame.access$700(MainFrame.this).getJUnitModel().junitDocs(l);
                    }
                    catch (UnexpectedException e) {
                        MainFrame.access$9200(MainFrame.this, e);
                    }
                }
            }
        }.start();
    }

    private void _junitProject() {
        this._junitAll();
    }

    private void _junitAll() {
        new Thread("Running Junit Tests"){

            public void run() {
                MainFrame.access$9100(MainFrame.this);
                MainFrame.this.hourglassOn();
                try {
                    if (MainFrame.access$700(MainFrame.this).isProjectActive()) {
                        MainFrame.access$700(MainFrame.this).getJUnitModel().junitProject();
                    } else {
                        MainFrame.access$700(MainFrame.this).getJUnitModel().junitAll();
                    }
                }
                catch (UnexpectedException e) {
                    MainFrame.access$9200(MainFrame.this, e);
                }
            }
        }.start();
    }

    private void _dissableJUnitActions() {
        this._compileProjectActionEnabled = this._compileProjectAction.isEnabled();
        this._compileAllActionEnabled = this._compileAllAction.isEnabled();
        this._compileFolderActionEnabled = this._compileFolderAction.isEnabled();
        this._junitFolderActionEnabled = this._junitFolderAction.isEnabled();
        this._junitAllActionEnabled = this._junitAllAction.isEnabled();
        this._junitActionEnabled = this._junitAction.isEnabled();
        this._junitOpenProjectFilesActionEnabled = this._junitOpenProjectFilesAction.isEnabled();
        this._cleanActionEnabled = this._cleanAction.isEnabled();
        this._projectPropertiesActionEnabled = this._projectPropertiesAction.isEnabled();
        this._runProjectActionEnabled = this._runProjectAction.isEnabled();
        this._runActionEnabled = this._runAction.isEnabled();
        this._compileProjectAction.setEnabled(false);
        this._compileAllAction.setEnabled(false);
        this._compileFolderAction.setEnabled(false);
        this._junitFolderAction.setEnabled(false);
        this._junitAllAction.setEnabled(false);
        this._junitAction.setEnabled(false);
        this._junitOpenProjectFilesAction.setEnabled(false);
        this._cleanAction.setEnabled(false);
        this._projectPropertiesAction.setEnabled(false);
        this._runProjectAction.setEnabled(false);
        this._runAction.setEnabled(false);
    }

    private void _restoreJUnitActionsEnabled() {
        this._compileProjectAction.setEnabled(this._compileProjectActionEnabled);
        this._compileAllAction.setEnabled(this._compileAllActionEnabled);
        this._compileFolderAction.setEnabled(this._compileFolderActionEnabled);
        this._junitFolderAction.setEnabled(this._junitFolderActionEnabled);
        this._junitAllAction.setEnabled(this._junitAllActionEnabled);
        this._junitAction.setEnabled(this._junitActionEnabled);
        this._junitOpenProjectFilesAction.setEnabled(this._junitOpenProjectFilesActionEnabled);
        this._cleanAction.setEnabled(this._cleanActionEnabled);
        this._projectPropertiesAction.setEnabled(this._projectPropertiesActionEnabled);
        this._runProjectAction.setEnabled(this._runProjectActionEnabled);
        this._runAction.setEnabled(this._runActionEnabled);
    }

    void debuggerResume() throws DebugException {
        if (this.inDebugMode()) {
            this._model.getDebugger().resume();
            this._removeThreadLocationHighlight();
        }
    }

    void debuggerStep(int flag) {
        if (this.inDebugMode()) {
            try {
                this._model.getDebugger().step(flag);
            }
            catch (IllegalStateException ise) {
            }
            catch (DebugException de) {
                this._showError(de, "Debugger Error", "Could not create a step request.");
            }
        }
    }

    void debuggerToggleBreakpoint() {
        if (this.inDebugMode()) {
            OpenDefinitionsDocument doc = this._model.getActiveDocument();
            boolean isUntitled = doc.isUntitled();
            if (isUntitled) {
                JOptionPane.showMessageDialog(this, "You must save and compile this document before you can\nset a breakpoint in it.", "Must Save and Compile", 0);
                return;
            }
            boolean isModified = doc.isModifiedSinceSave();
            if (isModified && !this._currentDefPane.hasWarnedAboutModified() && DrJava.getConfig().getSetting(WARN_BREAKPOINT_OUT_OF_SYNC).booleanValue()) {
                String message = "This document has been modified and may be out of sync\nwith the debugger.  It is recommended that you first\nsave and recompile before continuing to use the debugger,\nto avoid any unexpected errors.  Would you still like to\ntoggle the breakpoint on the specified line?";
                String title = "Toggle breakpoint on modified file?";
                ConfirmCheckBoxDialog dialog = new ConfirmCheckBoxDialog(this, title, message);
                int rc = dialog.show();
                switch (rc) {
                    case 0: {
                        this._currentDefPane.hasWarnedAboutModified(true);
                        if (!dialog.getCheckBoxValue()) break;
                        DrJava.getConfig().setSetting(WARN_BREAKPOINT_OUT_OF_SYNC, Boolean.FALSE);
                        break;
                    }
                    case 1: {
                        if (!dialog.getCheckBoxValue()) break;
                        DrJava.getConfig().setSetting(WARN_BREAKPOINT_OUT_OF_SYNC, Boolean.FALSE);
                        break;
                    }
                    case -1: 
                    case 2: {
                        return;
                    }
                    default: {
                        throw new RuntimeException(new StringBuffer().append("Invalid rc from showConfirmDialog: ").append(rc).toString());
                    }
                }
            }
            try {
                Debugger debugger = this._model.getDebugger();
                debugger.toggleBreakpoint(doc, this._currentDefPane.getCaretPosition(), this._currentDefPane.getCurrentLine());
            }
            catch (DebugException de) {
                this._showError(de, "Debugger Error", "Could not set a breakpoint at the current line.");
            }
        }
    }

    void debuggerClearAllBreakpoints() {
        try {
            this._model.getDebugger().removeAllBreakpoints();
        }
        catch (DebugException de) {
            this._showError(de, "Debugger Error", "Could not remove all breakpoints.");
        }
    }

    void _showFileMovedError(FileMovedException fme) {
        try {
            File f = fme.getFile();
            OpenDefinitionsDocument doc = this._model.getDocumentForFile(f);
            if (doc != null && this._saveSelector.shouldSaveAfterFileMoved(doc, f)) {
                this._saveAs();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void _showProjectFileParseError(MalformedProjectFileException mpfe) {
        this._showError(mpfe, "Invalid Project File", "DrJava could not read the given project file.");
    }

    void _showFileNotFoundError(FileNotFoundException fnf) {
        this._showError(fnf, "File Not Found", "The specified file was not found on disk.");
    }

    void _showIOError(IOException ioe) {
        this._showError(ioe, "Input/output error", "An I/O exception occurred during the last operation.");
    }

    void _showClassNotFoundError(ClassNotFoundException cnfe) {
        this._showError(cnfe, "Class Not Found", "A ClassNotFound exception occurred during the last operation.\nPlease check that your classpath includes all relevant directories.\n\n");
    }

    void _showNoClassDefError(NoClassDefFoundError ncde) {
        this._showError(ncde, "No Class Def", "A NoClassDefFoundError occurred during the last operation.\nPlease check that your classpath includes all relevant paths.\n\n");
    }

    void _showDebugError(DebugException de) {
        this._showError(de, "Debug Error", "A Debugger error occurred in the last operation.\n\n");
    }

    void _showJUnitInterrupted(UnexpectedException e) {
        this._showWarning(e.getCause(), "JUnit Testing Interrupted", "The slave JVM has thrown a RemoteException probably indicating that it has been reset.\n\n");
    }

    private void _showError(Throwable e, String title, String message) {
        JOptionPane.showMessageDialog(this, new StringBuffer().append(message).append("\n").append(e).toString(), title, 0);
    }

    private void _showWarning(Throwable e, String title, String message) {
        JOptionPane.showMessageDialog(this, new StringBuffer().append(message).append("\n").append(e).toString(), title, 2);
    }

    private void _showConfigException() {
        if (DrJava.getConfig().hadStartupException()) {
            Exception e = DrJava.getConfig().getStartupException();
            this._showError(e, "Error in Config File", "Could not read the '.drjava' configuration file\nin your home directory.  Starting with default\nvalues instead.\n\nThe problem was:\n");
        }
    }

    private void _showDebuggingModifiedFileWarning() {
        if (DrJava.getConfig().getSetting(WARN_DEBUG_MODIFIED_FILE).booleanValue()) {
            String title = "Debugging modified file!";
            String msg = "This document has been modified since its last save and\nmay be out of sync with the debugger. It is suggested that\nyou save and recompile before continuing to debug in order\nto avoid any unexpected errors.";
            ConfirmCheckBoxDialog dialog = new ConfirmCheckBoxDialog(this, title, msg, "Do not show this message again", 2, -1);
            if (dialog.show() == 0 && dialog.getCheckBoxValue()) {
                DrJava.getConfig().setSetting(WARN_DEBUG_MODIFIED_FILE, Boolean.FALSE);
            }
            this._currentDefPane.hasWarnedAboutModified(true);
        }
    }

    private File getChosenFile(JFileChooser fc, int choice) throws OperationCanceledException {
        switch (choice) {
            case -1: 
            case 1: {
                throw new OperationCanceledException();
            }
            case 0: {
                File chosen = fc.getSelectedFile();
                if (chosen != null) {
                    if (fc.getFileFilter() instanceof JavaSourceFilter && chosen.getName().indexOf(".") == -1) {
                        return new File(new StringBuffer().append(chosen.getAbsolutePath()).append(DrJava.LANGUAGE_LEVEL_EXTENSIONS[DrJava.getConfig().getSetting(LANGUAGE_LEVEL)]).toString());
                    }
                    return chosen;
                }
                throw new RuntimeException("Filechooser returned null file");
            }
        }
        throw new RuntimeException(new StringBuffer().append("Filechooser returned bad rc ").append(choice).toString());
    }

    private File[] getChosenFiles(JFileChooser fc, int choice) throws OperationCanceledException {
        switch (choice) {
            case -1: 
            case 1: {
                throw new OperationCanceledException();
            }
            case 0: {
                File[] chosen = fc.getSelectedFiles();
                if (chosen == null) {
                    throw new UnexpectedException(new OperationCanceledException(), "filechooser returned null file");
                }
                if (chosen.length == 0) {
                    if (!fc.isMultiSelectionEnabled()) {
                        return new File[]{fc.getSelectedFile()};
                    }
                    throw new OperationCanceledException();
                }
                return chosen;
            }
        }
        throw new UnexpectedException(new OperationCanceledException(), new StringBuffer().append("filechooser returned bad rc ").append(choice).toString());
    }

    private void _selectAll() {
        this._currentDefPane.selectAll();
    }

    private int _gotoLine() {
        String msg = "What line would you like to go to?";
        String title = "Go to Line";
        String lineStr = JOptionPane.showInputDialog(this, "What line would you like to go to?", "Go to Line", 3);
        try {
            if (lineStr != null) {
                int lineNum = Integer.parseInt(lineStr);
                this._currentDefPane.centerViewOnLine(lineNum);
                int pos = this._model.getActiveDocument().gotoLine(lineNum);
                this._currentDefPane.setCaretPosition(pos);
                return pos;
            }
        }
        catch (NumberFormatException nfe) {
            Toolkit.getDefaultToolkit().beep();
        }
        return -1;
    }

    private void _removeErrorListener(OpenDefinitionsDocument doc) {
        JScrollPane scroll = this._defScrollPanes.get(doc);
        if (scroll != null) {
            DefinitionsPane pane = (DefinitionsPane)scroll.getViewport().getView();
            pane.removeCaretListener(pane.getErrorCaretListener());
        }
    }

    private void _setUpActions() {
        this._setUpAction(this._newAction, "New", "Create a new document");
        this._setUpAction(this._newJUnitTestAction, "New", "Create a new JUnit test case class");
        this._setUpAction(this._newProjectAction, "New", "Make a new project");
        this._setUpAction(this._openAction, "Open", "Open an existing file");
        this._setUpAction(this._openFolderAction, "Open Folder", "OpenAll", "Open all files within a directory");
        this._setUpAction(this._openFileOrProjectAction, "Open", "Open an existing file or project");
        this._setUpAction(this._openProjectAction, "Open", "Open an existing project");
        this._setUpAction(this._saveAction, "Save", "Save the current document");
        this._setUpAction(this._saveAsAction, "Save As", "SaveAs", "Save the current document with a new name");
        this._setUpAction(this._saveProjectAction, "Save", "Save", "Save the current project");
        this._saveProjectAction.setEnabled(false);
        this._setUpAction(this._revertAction, "Revert", "Revert the current document to the saved version");
        this._setUpAction(this._closeAction, "Close", "Close the current document");
        this._setUpAction(this._closeAllAction, "Close All", "CloseAll", "Close all documents");
        this._setUpAction(this._closeProjectAction, "Close", "CloseAll", "Close the current project");
        this._closeProjectAction.setEnabled(false);
        this._setUpAction(this._projectPropertiesAction, "Project Properties", "Preferences", "Edit Project Properties");
        this._projectPropertiesAction.setEnabled(false);
        this._setUpAction(this._junitOpenProjectFilesAction, "Test", "Test Project");
        this._junitOpenProjectFilesAction.setEnabled(false);
        this._setUpAction(this._compileProjectAction, "Compile", "Compile", "Compile the current project");
        this._compileProjectAction.setEnabled(false);
        this._setUpAction(this._runProjectAction, "Run", "Run the project's main method");
        this._runProjectAction.setEnabled(false);
        this._setUpAction(this._jarProjectAction, "Jar", "Create a jar archive from this project");
        this._jarProjectAction.setEnabled(false);
        this._setUpAction(this._saveAllAction, "Save All", "SaveAll", "Save all open documents");
        this._setUpAction(this._cleanAction, "Clean", "Clean Build directory");
        this._cleanAction.setEnabled(false);
        this._setUpAction(this._compileAction, "Compile", "Compile the current document");
        this._setUpAction(this._compileAllAction, "Compile All", "CompileAll", "Compile all open documents");
        this._setUpAction(this._printDefDocAction, "Print", "Print the current main document");
        this._setUpAction(this._printConsoleAction, "Print", "Print the Console pane");
        this._setUpAction(this._printInteractionsAction, "Print", "Print the Interactions pane");
        this._setUpAction(this._pageSetupAction, "Page Setup", "PageSetup", "Change the printer settings");
        this._setUpAction(this._printDefDocPreviewAction, "Print Preview", "PrintPreview", "Preview how the document will be printed");
        this._setUpAction(this._printConsolePreviewAction, "Print Preview", "PrintPreview", "Preview how the console document will be printed");
        this._setUpAction(this._printInteractionsPreviewAction, "Print Preview", "PrintPreview", "Preview how the interactions document will be printed");
        this._setUpAction(this._quitAction, "Quit", "Quit", "Quit DrJava");
        this._setUpAction(this._undoAction, "Undo", "Undo previous command");
        this._setUpAction(this._redoAction, "Redo", "Redo last undo");
        this._undoAction.putValue("Name", "Undo Previous Command");
        this._redoAction.putValue("Name", "Redo Last Undo");
        this._setUpAction(this.cutAction, "Cut", "Cut selected text to the clipboard");
        this._setUpAction(this.copyAction, "Copy", "Copy selected text to the clipboard");
        this._setUpAction(this.pasteAction, "Paste", "Paste text from the clipboard");
        this._setUpAction(this._selectAllAction, "Select All", "Select all text");
        this.cutAction.putValue("Name", "Cut");
        this.copyAction.putValue("Name", "Copy");
        this.pasteAction.putValue("Name", "Paste");
        this._setUpAction(this._indentLinesAction, "Indent Lines", "Indent all selected lines");
        this._setUpAction(this._commentLinesAction, "Comment Lines", "Comment out all selected lines");
        this._setUpAction(this._uncommentLinesAction, "Uncomment Lines", "Uncomment all selected lines");
        this._setUpAction(this._findReplaceAction, "Find", "Find or replace text in the document");
        this._setUpAction(this._findNextAction, "Find Next", "Repeats the last find");
        this._setUpAction(this._findPrevAction, "Find Previous", "Repeats the last find in the opposite direction");
        this._setUpAction(this._gotoLineAction, "Go to line", "Go to a line number in the document");
        this._setUpAction(this._switchToPrevAction, "Back", "Switch to the previous document");
        this._setUpAction(this._switchToNextAction, "Forward", "Switch to the next document");
        this._setUpAction(this._switchToPreviousPaneAction, "Previous Pane", "Switch focus to the previous pane");
        this._setUpAction(this._switchToNextPaneAction, "Next Pane", "Switch focus to the next pane");
        this._setUpAction(this._editPreferencesAction, "Preferences", "Edit configurable settings in DrJava");
        this._setUpAction(this._junitAction, "Test Current", "Run JUnit over the current document");
        this._setUpAction(this._junitAllAction, "Test", "Run JUnit over all open JUnit tests");
        this._setUpAction(this._javadocAllAction, "Javadoc", "Create and save Javadoc for the packages of all open documents");
        this._setUpAction(this._javadocCurrentAction, "Preview Javadoc Current", "Preview the Javadoc for the current document");
        this._setUpAction(this._runAction, "Run Document", "Run the main method of the current document");
        this._setUpAction(this._executeHistoryAction, "Execute History", "Load and execute a history of interactions from a file");
        this._setUpAction(this._loadHistoryScriptAction, "Load History as Script", "Load a history from a file as a series of interactions");
        this._setUpAction(this._saveHistoryAction, "Save History", "Save the history of interactions to a file");
        this._setUpAction(this._clearHistoryAction, "Clear History", "Clear the current history of interactions");
        this._setUpAction(this._resetInteractionsAction, "Reset", "Reset the Interactions Pane");
        this._setUpAction(this._viewInteractionsClasspathAction, "View Interactions Classpath", "Display the classpath in use by the Interactions Pane");
        this._setUpAction(this._copyInteractionToDefinitionsAction, "Lift Current Interaction", "Copy the current interaction into the Definitions Pane");
        this._setUpAction(this._clearConsoleAction, "Clear Console", "Clear all text in the Console Pane");
        this._setUpAction(this._showDebugConsoleAction, "Show DrJava Debug Console", "<html>Show a console for debugging DrJava<br>(with \"mainFrame\", \"model\", and \"config\" variables defined)</html>");
        this._setUpAction(this._toggleDebuggerAction, "Debug Mode", "Enable or disable DrJava's debugger");
        this._setUpAction(this._toggleBreakpointAction, "Toggle Breakpoint", "Set or clear a breakpoint on the current line");
        this._setUpAction(this._clearAllBreakpointsAction, "Clear Breakpoints", "Clear all breakpoints in all classes");
        this._setUpAction(this._resumeDebugAction, "Resume", "Resume the current suspended thread");
        this._setUpAction(this._stepIntoDebugAction, "Step Into", "Step into the current line or method call");
        this._setUpAction(this._stepOverDebugAction, "Step Over", "Step over the current line or method call");
        this._setUpAction(this._stepOutDebugAction, "Step Out", "Step out of the current method");
        this._setUpAction(this._helpAction, "Help", "Show documentation on how to use DrJava");
        this._setUpAction(this._quickStartAction, "Help", "View Quick Start Guide for DrJava");
        this._setUpAction(this._aboutAction, "About", "About DrJava");
    }

    private void _setUpAction(Action a, String name, String icon, String shortDesc) {
        a.putValue("SmallIcon", this._getIcon(new StringBuffer().append(icon).append("16.gif").toString()));
        a.putValue("Default", name);
        a.putValue("ShortDescription", shortDesc);
    }

    private void _setUpAction(Action a, String icon, String shortDesc) {
        this._setUpAction(a, icon, icon, shortDesc);
    }

    private ImageIcon _getIcon(String name) {
        return MainFrame.getIcon(name);
    }

    public static ImageIcon getIcon(String name) {
        URL url = (class$edu$rice$cs$drjava$ui$MainFrame == null ? (class$edu$rice$cs$drjava$ui$MainFrame = MainFrame.class$("edu.rice.cs.drjava.ui.MainFrame")) : class$edu$rice$cs$drjava$ui$MainFrame).getResource(new StringBuffer().append(ICON_PATH).append(name).toString());
        if (url != null) {
            return new ImageIcon(url);
        }
        return null;
    }

    private void _setUpMenuBar() {
        boolean showDebugger = this._model.getDebugger().isAvailable();
        int mask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        this._menuBar = new MenuBar(null);
        this._fileMenu = this._setUpFileMenu(mask);
        this._editMenu = this._setUpEditMenu(mask);
        this._toolsMenu = this._setUpToolsMenu(mask);
        this._projectMenu = this._setUpProjectMenu(mask);
        if (showDebugger) {
            this._debugMenu = this._setUpDebugMenu(mask);
        }
        this._languageLevelMenu = this._setUpLanguageLevelMenu(mask);
        this._helpMenu = this._setUpHelpMenu(mask);
        this._menuBar.add(this._fileMenu);
        this._menuBar.add(this._editMenu);
        this._menuBar.add(this._toolsMenu);
        this._menuBar.add(this._projectMenu);
        if (showDebugger) {
            this._menuBar.add(this._debugMenu);
        }
        this._menuBar.add(this._languageLevelMenu);
        this._menuBar.add(this._helpMenu);
        this.setJMenuBar(this._menuBar);
    }

    private void _addMenuItem(JMenu menu, Action a, Option<KeyStroke> opt) {
        JMenuItem item = menu.add(a);
        this._setMenuShortcut(item, a, opt);
    }

    private void _setMenuShortcut(JMenuItem item, Action a, Option<KeyStroke> opt) {
        KeyStroke ks = DrJava.getConfig().getSetting(opt);
        KeyBindingManager.Singleton.put(opt, a, item, item.getText());
        if (ks != KeyStrokeOption.NULL_KEYSTROKE && KeyBindingManager.Singleton.get(ks) == a) {
            item.setAccelerator(ks);
        }
    }

    private JMenu _setUpFileMenu(int mask) {
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic(70);
        this._addMenuItem(fileMenu, this._newAction, KEY_NEW_FILE);
        this._addMenuItem(fileMenu, this._newJUnitTestAction, KEY_NEW_TEST);
        this._addMenuItem(fileMenu, this._openAction, KEY_OPEN_FILE);
        this._addMenuItem(fileMenu, this._openFolderAction, KEY_OPEN_FOLDER);
        fileMenu.addSeparator();
        this._addMenuItem(fileMenu, this._saveAction, KEY_SAVE_FILE);
        this._saveAction.setEnabled(true);
        this._addMenuItem(fileMenu, this._saveAsAction, KEY_SAVE_FILE_AS);
        this._addMenuItem(fileMenu, this._saveAllAction, KEY_SAVE_ALL_FILES);
        this._addMenuItem(fileMenu, this._revertAction, KEY_REVERT_FILE);
        this._revertAction.setEnabled(false);
        fileMenu.addSeparator();
        this._addMenuItem(fileMenu, this._closeAction, KEY_CLOSE_FILE);
        this._addMenuItem(fileMenu, this._closeAllAction, KEY_CLOSE_ALL_FILES);
        fileMenu.addSeparator();
        this._addMenuItem(fileMenu, this._pageSetupAction, KEY_PAGE_SETUP);
        this._addMenuItem(fileMenu, this._printDefDocPreviewAction, KEY_PRINT_PREVIEW);
        this._addMenuItem(fileMenu, this._printDefDocAction, KEY_PRINT);
        fileMenu.addSeparator();
        this._addMenuItem(fileMenu, this._quitAction, KEY_QUIT);
        return fileMenu;
    }

    private JMenu _setUpEditMenu(int mask) {
        JMenu editMenu = new JMenu("Edit");
        editMenu.setMnemonic(69);
        this._addMenuItem(editMenu, this._undoAction, KEY_UNDO);
        this._addMenuItem(editMenu, this._redoAction, KEY_REDO);
        editMenu.addSeparator();
        this._addMenuItem(editMenu, this.cutAction, KEY_CUT);
        this._addMenuItem(editMenu, this.copyAction, KEY_COPY);
        this._addMenuItem(editMenu, this.pasteAction, KEY_PASTE);
        this._addMenuItem(editMenu, this._selectAllAction, KEY_SELECT_ALL);
        editMenu.addSeparator();
        JMenuItem editItem = editMenu.add(this._indentLinesAction);
        editItem.setAccelerator(KeyStroke.getKeyStroke(9, 0));
        this._addMenuItem(editMenu, this._commentLinesAction, KEY_COMMENT_LINES);
        this._addMenuItem(editMenu, this._uncommentLinesAction, KEY_UNCOMMENT_LINES);
        editMenu.addSeparator();
        this._addMenuItem(editMenu, this._findReplaceAction, KEY_FIND_REPLACE);
        this._addMenuItem(editMenu, this._findNextAction, KEY_FIND_NEXT);
        this._addMenuItem(editMenu, this._findPrevAction, KEY_FIND_PREV);
        this._addMenuItem(editMenu, this._gotoLineAction, KEY_GOTO_LINE);
        editMenu.addSeparator();
        this._addMenuItem(editMenu, this._switchToPrevAction, KEY_PREVIOUS_DOCUMENT);
        this._addMenuItem(editMenu, this._switchToNextAction, KEY_NEXT_DOCUMENT);
        this._addMenuItem(editMenu, this._switchToPreviousPaneAction, KEY_PREVIOUS_PANE);
        this._addMenuItem(editMenu, this._switchToNextPaneAction, KEY_NEXT_PANE);
        editMenu.addSeparator();
        this._addMenuItem(editMenu, this._editPreferencesAction, KEY_PREFERENCES);
        return editMenu;
    }

    private JMenu _setUpToolsMenu(int mask) {
        JMenu toolsMenu = new JMenu("Tools");
        toolsMenu.setMnemonic(84);
        this._addMenuItem(toolsMenu, this._compileAllAction, KEY_COMPILE_ALL);
        this._addMenuItem(toolsMenu, this._compileAction, KEY_COMPILE);
        this._addMenuItem(toolsMenu, this._junitAllAction, KEY_TEST_ALL);
        this._addMenuItem(toolsMenu, this._junitAction, KEY_TEST);
        this._addMenuItem(toolsMenu, this._javadocAllAction, KEY_JAVADOC_ALL);
        this._addMenuItem(toolsMenu, this._javadocCurrentAction, KEY_JAVADOC_CURRENT);
        toolsMenu.addSeparator();
        this._addMenuItem(toolsMenu, this._runAction, KEY_RUN);
        toolsMenu.addSeparator();
        this._addMenuItem(toolsMenu, this._executeHistoryAction, KEY_EXECUTE_HISTORY);
        this._addMenuItem(toolsMenu, this._loadHistoryScriptAction, KEY_LOAD_HISTORY_SCRIPT);
        this._addMenuItem(toolsMenu, this._saveHistoryAction, KEY_SAVE_HISTORY);
        this._addMenuItem(toolsMenu, this._clearHistoryAction, KEY_CLEAR_HISTORY);
        toolsMenu.addSeparator();
        this._addMenuItem(toolsMenu, this._resetInteractionsAction, KEY_RESET_INTERACTIONS);
        this._addMenuItem(toolsMenu, this._viewInteractionsClasspathAction, KEY_VIEW_INTERACTIONS_CLASSPATH);
        this._addMenuItem(toolsMenu, this._copyInteractionToDefinitionsAction, KEY_LIFT_CURRENT_INTERACTION);
        this._addMenuItem(toolsMenu, this._printInteractionsAction, KEY_PRINT_INTERACTIONS);
        toolsMenu.addSeparator();
        this._addMenuItem(toolsMenu, this._clearConsoleAction, KEY_CLEAR_CONSOLE);
        this._addMenuItem(toolsMenu, this._printConsoleAction, KEY_PRINT_CONSOLE);
        if (DrJava.getConfig().getSetting(SHOW_DEBUG_CONSOLE).booleanValue()) {
            toolsMenu.add(this._showDebugConsoleAction);
        }
        return toolsMenu;
    }

    private JMenu _setUpProjectMenu(int mask) {
        JMenu projectMenu = new JMenu("Project");
        projectMenu.setMnemonic(80);
        projectMenu.add(this._newProjectAction);
        this._addMenuItem(projectMenu, this._openProjectAction, KEY_OPEN_PROJECT);
        projectMenu.add(this._saveProjectAction);
        this._addMenuItem(projectMenu, this._closeProjectAction, KEY_CLOSE_PROJECT);
        projectMenu.addSeparator();
        projectMenu.add(this._cleanAction);
        projectMenu.add(this._compileProjectAction);
        projectMenu.add(this._jarProjectAction);
        this._addMenuItem(projectMenu, this._runProjectAction, KEY_RUN_MAIN);
        projectMenu.add(this._junitOpenProjectFilesAction);
        projectMenu.addSeparator();
        projectMenu.add(this._projectPropertiesAction);
        return projectMenu;
    }

    private JMenu _setUpDebugMenu(int mask) {
        JMenu debugMenu = new JMenu("Debugger");
        debugMenu.setMnemonic(68);
        this._debuggerEnabledMenuItem = this._newCheckBoxMenuItem(this._toggleDebuggerAction);
        this._debuggerEnabledMenuItem.setSelected(false);
        this._setMenuShortcut(this._debuggerEnabledMenuItem, this._toggleDebuggerAction, KEY_DEBUG_MODE_TOGGLE);
        debugMenu.add(this._debuggerEnabledMenuItem);
        debugMenu.addSeparator();
        this._addMenuItem(debugMenu, this._toggleBreakpointAction, KEY_DEBUG_BREAKPOINT_TOGGLE);
        this._addMenuItem(debugMenu, this._clearAllBreakpointsAction, KEY_DEBUG_CLEAR_ALL_BREAKPOINTS);
        debugMenu.addSeparator();
        this._addMenuItem(debugMenu, this._resumeDebugAction, KEY_DEBUG_RESUME);
        this._addMenuItem(debugMenu, this._stepIntoDebugAction, KEY_DEBUG_STEP_INTO);
        this._addMenuItem(debugMenu, this._stepOverDebugAction, KEY_DEBUG_STEP_OVER);
        this._addMenuItem(debugMenu, this._stepOutDebugAction, KEY_DEBUG_STEP_OUT);
        this._setDebugMenuItemsEnabled(false);
        return debugMenu;
    }

    private void _setDebugMenuItemsEnabled(boolean enabled) {
        this._debuggerEnabledMenuItem.setSelected(enabled);
        this._resumeDebugAction.setEnabled(false);
        this._stepIntoDebugAction.setEnabled(false);
        this._stepOverDebugAction.setEnabled(false);
        this._stepOutDebugAction.setEnabled(false);
        this._toggleBreakpointAction.setEnabled(enabled);
        this._clearAllBreakpointsAction.setEnabled(enabled);
        if (this._debugPanel != null) {
            this._debugPanel.disableButtons();
        }
    }

    private void _setThreadDependentDebugMenuItems(boolean isSuspended) {
        this._resumeDebugAction.setEnabled(isSuspended);
        this._stepIntoDebugAction.setEnabled(isSuspended);
        this._stepOverDebugAction.setEnabled(isSuspended);
        this._stepOutDebugAction.setEnabled(isSuspended);
        this._debugPanel.setThreadDependentButtons(isSuspended);
    }

    private JMenu _setUpLanguageLevelMenu(int mask) {
        JMenu languageLevelMenu = new JMenu("Language Level");
        languageLevelMenu.setMnemonic(76);
        ButtonGroup group = new ButtonGroup();
        final FileConfiguration config = DrJava.getConfig();
        int currentLanguageLevel = config.getSetting(LANGUAGE_LEVEL);
        JRadioButtonMenuItem rbMenuItem = new JRadioButtonMenuItem("Full Java");
        rbMenuItem.setToolTipText("Use full Java syntax");
        if (currentLanguageLevel == 0) {
            rbMenuItem.setSelected(true);
        }
        rbMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                config.setSetting(OptionConstants.LANGUAGE_LEVEL, Autobox.valueOf(0));
            }
        });
        group.add(rbMenuItem);
        languageLevelMenu.add(rbMenuItem);
        languageLevelMenu.addSeparator();
        rbMenuItem = new JRadioButtonMenuItem("Elementary");
        rbMenuItem.setToolTipText("Use Elementary language-level features");
        if (currentLanguageLevel == 1) {
            rbMenuItem.setSelected(true);
        }
        rbMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                config.setSetting(OptionConstants.LANGUAGE_LEVEL, Autobox.valueOf(1));
            }
        });
        group.add(rbMenuItem);
        languageLevelMenu.add(rbMenuItem);
        rbMenuItem = new JRadioButtonMenuItem("Intermediate");
        rbMenuItem.setToolTipText("Use Intermediate language-level features");
        if (currentLanguageLevel == 2) {
            rbMenuItem.setSelected(true);
        }
        rbMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                config.setSetting(OptionConstants.LANGUAGE_LEVEL, Autobox.valueOf(2));
            }
        });
        group.add(rbMenuItem);
        languageLevelMenu.add(rbMenuItem);
        rbMenuItem = new JRadioButtonMenuItem("Advanced");
        rbMenuItem.setToolTipText("Use Advanced language-level features");
        if (currentLanguageLevel == 3) {
            rbMenuItem.setSelected(true);
        }
        rbMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                config.setSetting(OptionConstants.LANGUAGE_LEVEL, Autobox.valueOf(3));
            }
        });
        group.add(rbMenuItem);
        languageLevelMenu.add(rbMenuItem);
        return languageLevelMenu;
    }

    private JMenu _setUpHelpMenu(int mask) {
        JMenu helpMenu = new JMenu("Help");
        helpMenu.setMnemonic(72);
        this._addMenuItem(helpMenu, this._helpAction, KEY_HELP);
        this._addMenuItem(helpMenu, this._quickStartAction, KEY_QUICKSTART);
        this._addMenuItem(helpMenu, this._aboutAction, KEY_ABOUT);
        return helpMenu;
    }

    JButton _createManualToolbarButton(Action a) {
        UnfocusableButton ret;
        Icon icon;
        Font buttonFont = DrJava.getConfig().getSetting(FONT_TOOLBAR);
        boolean useIcon = DrJava.getConfig().getSetting(TOOLBAR_ICONS_ENABLED);
        boolean useText = DrJava.getConfig().getSetting(TOOLBAR_TEXT_ENABLED);
        Icon icon2 = icon = useIcon ? (Icon)a.getValue("SmallIcon") : null;
        if (icon == null) {
            ret = new UnfocusableButton((String)a.getValue("Default"));
        } else {
            ret = new UnfocusableButton(icon);
            if (useText) {
                ret.setText((String)a.getValue("Default"));
            }
        }
        ret.setEnabled(false);
        ret.addActionListener(a);
        ret.setToolTipText((String)a.getValue("ShortDescription"));
        ret.setFont(buttonFont);
        Boolean test = Autobox.valueOf(a instanceof DelegatingAction);
        a.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("enabled".equals(evt.getPropertyName())) {
                    Boolean val = (Boolean)evt.getNewValue();
                    ret.setEnabled(val);
                }
            }
        });
        return ret;
    }

    public JButton _createToolbarButton(Action a) {
        boolean useText = DrJava.getConfig().getSetting(TOOLBAR_TEXT_ENABLED);
        boolean useIcons = DrJava.getConfig().getSetting(TOOLBAR_ICONS_ENABLED);
        Font buttonFont = DrJava.getConfig().getSetting(FONT_TOOLBAR);
        UnfocusableButton result = new UnfocusableButton(a);
        result.setText((String)a.getValue("Default"));
        result.setFont(buttonFont);
        if (!useIcons) {
            result.setIcon(null);
        }
        if (!useText && result.getIcon() != null) {
            result.setText("");
        }
        return result;
    }

    private void _setUpToolBar() {
        this._toolBar = new JToolBar();
        this._toolBar.setFloatable(false);
        this._toolBar.add(this._createToolbarButton(this._newAction));
        this._toolBar.add(this._createToolbarButton(this._openFileOrProjectAction));
        this._toolBar.add(this._createToolbarButton(this._saveAction));
        this._closeButton = this._createToolbarButton(this._closeAction);
        this._toolBar.add(this._closeButton);
        this._toolBar.addSeparator();
        this._toolBar.add(this._createToolbarButton(this.cutAction));
        this._toolBar.add(this._createToolbarButton(this.copyAction));
        this._toolBar.add(this._createToolbarButton(this.pasteAction));
        this._undoButton = this._createManualToolbarButton(this._undoAction);
        this._toolBar.add(this._undoButton);
        this._redoButton = this._createManualToolbarButton(this._redoAction);
        this._toolBar.add(this._redoButton);
        this._toolBar.addSeparator();
        this._toolBar.add(this._createToolbarButton(this._findReplaceAction));
        this._toolBar.addSeparator();
        this._compileButton = this._createToolbarButton(this._compileAllAction);
        this._toolBar.add(this._compileButton);
        this._toolBar.add(this._createToolbarButton(this._resetInteractionsAction));
        this._toolBar.addSeparator();
        this._toolBar.add(this._createToolbarButton(this._junitAllAction));
        this._toolBar.add(this._createToolbarButton(this._javadocAllAction));
        this._fixToolbarHeights();
        this.getContentPane().add((Component)this._toolBar, "North");
        this._updateToolbarVisible();
    }

    private void _updateToolbarVisible() {
        this._toolBar.setVisible(DrJava.getConfig().getSetting(TOOLBAR_ENABLED));
    }

    private void _updateToolbarButtons() {
        this._updateToolbarVisible();
        Component[] buttons = this._toolBar.getComponents();
        Font toolbarFont = DrJava.getConfig().getSetting(FONT_TOOLBAR);
        boolean iconsEnabled = DrJava.getConfig().getSetting(TOOLBAR_ICONS_ENABLED);
        boolean textEnabled = DrJava.getConfig().getSetting(TOOLBAR_TEXT_ENABLED);
        for (int i = 0; i < buttons.length; ++i) {
            if (!(buttons[i] instanceof JButton)) continue;
            JButton b = (JButton)buttons[i];
            Action a = b.getAction();
            b.setFont(toolbarFont);
            if (a == null) {
                if (b == this._undoButton) {
                    a = this._undoAction;
                } else {
                    if (b != this._redoButton) continue;
                    a = this._redoAction;
                }
            }
            if (b.getIcon() == null) {
                if (iconsEnabled) {
                    b.setIcon((Icon)a.getValue("SmallIcon"));
                }
            } else if (!iconsEnabled && b.getText().equals("")) {
                b.setIcon(null);
            }
            if (b.getText().equals("")) {
                if (!textEnabled) continue;
                b.setText((String)a.getValue("Default"));
                continue;
            }
            if (textEnabled || b.getIcon() == null) continue;
            b.setText("");
        }
        this._fixToolbarHeights();
    }

    private void _fixToolbarHeights() {
        Dimension d;
        JButton b;
        int i;
        Component[] buttons = this._toolBar.getComponents();
        int max = 0;
        for (i = 0; i < buttons.length; ++i) {
            if (!(buttons[i] instanceof JButton)) continue;
            b = (JButton)buttons[i];
            b.setPreferredSize(null);
            d = b.getPreferredSize();
            int cur = (int)d.getHeight();
            if (cur <= max) continue;
            max = cur;
        }
        for (i = 0; i < buttons.length; ++i) {
            if (!(buttons[i] instanceof JButton)) continue;
            b = (JButton)buttons[i];
            d = new Dimension((int)b.getPreferredSize().getWidth(), max);
            b.setPreferredSize(d);
            b.setMaximumSize(d);
        }
    }

    private void _setUpStatusBar() {
        this._fileNameField = new JLabel();
        this._fileNameField.setFont(this._fileNameField.getFont().deriveFont(0));
        this._sbMessage = new JLabel();
        this._sbMessage.setHorizontalAlignment(4);
        JPanel fileNameAndMessagePanel = new JPanel(new BorderLayout());
        fileNameAndMessagePanel.add((Component)this._fileNameField, "Center");
        fileNameAndMessagePanel.add((Component)this._sbMessage, "East");
        this._currLocationField = new JLabel();
        this._currLocationField.setFont(this._currLocationField.getFont().deriveFont(0));
        this._currLocationField.setHorizontalAlignment(4);
        this._currLocationField.setPreferredSize(new Dimension(65, 12));
        this._statusBar = new JPanel(new BorderLayout());
        this._statusBar.add((Component)fileNameAndMessagePanel, "Center");
        this._statusBar.add((Component)this._currLocationField, "East");
        this._statusBar.setBorder(new CompoundBorder(new EmptyBorder(2, 2, 2, 2), new CompoundBorder(new BevelBorder(1), new EmptyBorder(2, 2, 2, 2))));
        this.getContentPane().add((Component)this._statusBar, "South");
    }

    private void _setUpTabs() {
        this._compilerErrorPanel = new CompilerErrorPanel(this._model, this);
        this._consoleController = new ConsoleController(this._model.getConsoleDocument(), this._model.getSwingConsoleDocument());
        this._consolePane = this._consoleController.getPane();
        this._interactionsController = new InteractionsController(this._model.getInteractionsModel(), this._model.getSwingInteractionsDocument());
        this._interactionsController.setPrevPaneAction(this._switchToPreviousPaneAction);
        this._interactionsController.setNextPaneAction(this._switchToNextPaneAction);
        this._interactionsPane = this._interactionsController.getPane();
        this._findReplace = new FindReplaceDialog(this, this._model);
        this._consoleScroll = new BorderlessScrollPane(this._consolePane){

            public boolean requestFocusInWindow() {
                return MainFrame.access$9500(MainFrame.this).requestFocusInWindow();
            }
        };
        BorderlessScrollPane interactionsScroll = new BorderlessScrollPane(this._interactionsPane);
        this._interactionsContainer = new JPanel(new BorderLayout()){

            public boolean requestFocusInWindow() {
                return MainFrame.access$6700(MainFrame.this).requestFocusInWindow();
            }
        };
        this._interactionsContainer.add((Component)interactionsScroll, "Center");
        this._junitErrorPanel = new JUnitPanel(this._model, this);
        this._javadocErrorPanel = new JavadocErrorPanel(this._model, this);
        this._tabbedPane = new JTabbedPane();
        this._tabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                MainFrame.this.clearStatusMessage();
                if (MainFrame.access$5300(MainFrame.this).getSelectedComponent() == MainFrame.access$9600(MainFrame.this)) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            MainFrame.access$9500(MainFrame.this).requestFocusInWindow();
                        }
                    });
                }
                if (MainFrame.access$4700(MainFrame.this) != null) {
                    int pos = MainFrame.access$4700(MainFrame.this).getCaretPosition();
                    MainFrame.access$4700(MainFrame.this).removeErrorHighlight();
                    MainFrame.access$4700(MainFrame.this).getErrorCaretListener().updateHighlight(pos);
                }
            }
        });
        this._tabbedPane.add("Interactions", this._interactionsContainer);
        this._tabbedPane.add("Console", this._consoleScroll);
        this._tabs = new LinkedList();
        this._tabs.addLast(this._compilerErrorPanel);
        this._tabs.addLast(this._junitErrorPanel);
        this._tabs.addLast(this._javadocErrorPanel);
        this._tabs.addLast(this._findReplace);
        this._interactionsPane.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                MainFrame.access$9702(MainFrame.this, MainFrame.access$7100(MainFrame.this));
            }
        });
        this._consolePane.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                MainFrame.access$9702(MainFrame.this, MainFrame.access$9600(MainFrame.this));
            }
        });
        this._compilerErrorPanel.getMainPanel().addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                MainFrame.access$9702(MainFrame.this, MainFrame.access$9800(MainFrame.this));
            }
        });
        this._junitErrorPanel.getMainPanel().addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                MainFrame.access$9702(MainFrame.this, MainFrame.access$9900(MainFrame.this));
            }
        });
        this._javadocErrorPanel.getMainPanel().addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                MainFrame.access$9702(MainFrame.this, MainFrame.access$10000(MainFrame.this));
            }
        });
        this._findReplace.getFindField().addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                MainFrame.access$9702(MainFrame.this, MainFrame.access$1400(MainFrame.this));
            }
        });
        this.showTab(this._compilerErrorPanel);
        this._tabbedPane.setSelectedIndex(0);
    }

    private void _setUpContextMenus() {
        this._navPaneFolderPopupMenu = new JPopupMenu();
        this._navPaneFolderPopupMenu.add(this._newFileFolderAction);
        this._navPaneFolderPopupMenu.add(this._openOneFolderAction);
        this._navPaneFolderPopupMenu.add(this._openAllFolderAction);
        this._navPaneFolderPopupMenu.add(this._closeFolderAction);
        this._navPaneFolderPopupMenu.add(this._compileFolderAction);
        this._navPaneFolderPopupMenu.add(this._junitFolderAction);
        this._navPanePopupMenuForRoot = new JPopupMenu();
        this._navPanePopupMenuForRoot.add(this._saveProjectAction);
        this._navPanePopupMenuForRoot.add(this._closeProjectAction);
        this._navPanePopupMenuForRoot.addSeparator();
        this._navPanePopupMenuForRoot.add(this._compileProjectAction);
        this._navPanePopupMenuForRoot.add(this._runProjectAction);
        this._navPanePopupMenuForRoot.add(this._junitOpenProjectFilesAction);
        this._navPanePopupMenuForRoot.addSeparator();
        this._navPanePopupMenuForRoot.add(this._projectPropertiesAction);
        this._navPanePopupMenuForExternal = new JPopupMenu();
        this._navPanePopupMenuForExternal.add(this._saveAction);
        this._navPanePopupMenuForExternal.add(this._saveAsAction);
        this._navPanePopupMenuForExternal.add(this._revertAction);
        this._navPanePopupMenuForExternal.addSeparator();
        this._navPanePopupMenuForExternal.add(this._closeAction);
        this._navPanePopupMenuForExternal.addSeparator();
        this._navPanePopupMenuForExternal.add(this._printDefDocAction);
        this._navPanePopupMenuForExternal.add(this._printDefDocPreviewAction);
        this._navPanePopupMenuForExternal.addSeparator();
        this._navPanePopupMenuForExternal.add(this._compileAction);
        this._navPanePopupMenuForExternal.add(this._junitAction);
        this._navPanePopupMenuForExternal.add(this._javadocCurrentAction);
        this._navPanePopupMenuForExternal.add(this._runAction);
        this._navPanePopupMenuForExternal.addSeparator();
        this._navPanePopupMenuForExternal.add(this._moveToAuxiliaryAction);
        this._navPanePopupMenuForAuxiliary = new JPopupMenu();
        this._navPanePopupMenuForAuxiliary.add(this._saveAction);
        this._navPanePopupMenuForAuxiliary.add(this._saveAsAction);
        this._navPanePopupMenuForAuxiliary.add(this._revertAction);
        this._navPanePopupMenuForAuxiliary.addSeparator();
        this._navPanePopupMenuForAuxiliary.add(this._closeAction);
        this._navPanePopupMenuForAuxiliary.addSeparator();
        this._navPanePopupMenuForAuxiliary.add(this._printDefDocAction);
        this._navPanePopupMenuForAuxiliary.add(this._printDefDocPreviewAction);
        this._navPanePopupMenuForAuxiliary.addSeparator();
        this._navPanePopupMenuForAuxiliary.add(this._compileAction);
        this._navPanePopupMenuForAuxiliary.add(this._junitAction);
        this._navPanePopupMenuForAuxiliary.add(this._javadocCurrentAction);
        this._navPanePopupMenuForAuxiliary.add(this._runAction);
        this._navPanePopupMenuForAuxiliary.addSeparator();
        this._navPanePopupMenuForAuxiliary.add(this._removeAuxiliaryAction);
        this._navPanePopupMenu = new JPopupMenu();
        this._navPanePopupMenu.add(this._saveAction);
        this._navPanePopupMenu.add(this._saveAsAction);
        this._navPanePopupMenu.add(this._revertAction);
        this._navPanePopupMenu.addSeparator();
        this._navPanePopupMenu.add(this._closeAction);
        this._navPanePopupMenu.addSeparator();
        this._navPanePopupMenu.add(this._printDefDocAction);
        this._navPanePopupMenu.add(this._printDefDocPreviewAction);
        this._navPanePopupMenu.addSeparator();
        this._navPanePopupMenu.add(this._compileAction);
        this._navPanePopupMenu.add(this._junitAction);
        this._navPanePopupMenu.add(this._javadocCurrentAction);
        this._navPanePopupMenu.add(this._runAction);
        this._model.getDocCollectionWidget().addMouseListener(new RightClickMouseAdapter(){

            protected void _popupAction(MouseEvent e) {
                if (MainFrame.access$700(MainFrame.this).getDocumentNavigator().selectDocumentAt(e.getX(), e.getY())) {
                    if (MainFrame.access$700(MainFrame.this).getDocumentNavigator().isGroupSelected()) {
                        MainFrame.access$10100(MainFrame.this).show(e.getComponent(), e.getX(), e.getY());
                    } else {
                        try {
                            String groupName = MainFrame.access$700(MainFrame.this).getDocumentNavigator().getNameOfSelectedTopLevelGroup();
                            if (groupName.equals(MainFrame.access$700(MainFrame.this).getSourceBinTitle())) {
                                MainFrame.access$10200(MainFrame.this).show(e.getComponent(), e.getX(), e.getY());
                            } else if (groupName.equals(MainFrame.access$700(MainFrame.this).getExternalBinTitle())) {
                                OpenDefinitionsDocument n = MainFrame.access$700(MainFrame.this).getDocumentNavigator().getCurrent();
                                if (n != null) {
                                    OpenDefinitionsDocument d = n;
                                    if (d.isUntitled()) {
                                        MainFrame.access$10200(MainFrame.this).show(e.getComponent(), e.getX(), e.getY());
                                    } else {
                                        MainFrame.access$10300(MainFrame.this).show(e.getComponent(), e.getX(), e.getY());
                                    }
                                }
                            } else if (groupName.equals(MainFrame.access$700(MainFrame.this).getAuxiliaryBinTitle())) {
                                MainFrame.access$10400(MainFrame.this).show(e.getComponent(), e.getX(), e.getY());
                            }
                        }
                        catch (GroupNotSelectedException ex) {
                            if (MainFrame.access$700(MainFrame.this).isProjectActive()) {
                                MainFrame.access$10500(MainFrame.this).show(e.getComponent(), e.getX(), e.getY());
                            }
                            MainFrame.access$10200(MainFrame.this).show(e.getComponent(), e.getX(), e.getY());
                        }
                    }
                }
            }
        });
        this._interactionsPanePopupMenu = new JPopupMenu();
        this._interactionsPanePopupMenu.add(this.cutAction);
        this._interactionsPanePopupMenu.add(this.copyAction);
        this._interactionsPanePopupMenu.add(this.pasteAction);
        this._interactionsPanePopupMenu.addSeparator();
        this._interactionsPanePopupMenu.add(this._printInteractionsAction);
        this._interactionsPanePopupMenu.add(this._printInteractionsPreviewAction);
        this._interactionsPanePopupMenu.addSeparator();
        this._interactionsPanePopupMenu.add(this._executeHistoryAction);
        this._interactionsPanePopupMenu.add(this._loadHistoryScriptAction);
        this._interactionsPanePopupMenu.add(this._saveHistoryAction);
        this._interactionsPanePopupMenu.add(this._clearHistoryAction);
        this._interactionsPanePopupMenu.addSeparator();
        this._interactionsPanePopupMenu.add(this._resetInteractionsAction);
        this._interactionsPanePopupMenu.add(this._viewInteractionsClasspathAction);
        this._interactionsPanePopupMenu.add(this._copyInteractionToDefinitionsAction);
        this._interactionsPane.addMouseListener(new RightClickMouseAdapter(){

            protected void _popupAction(MouseEvent e) {
                MainFrame.access$6700(MainFrame.this).requestFocusInWindow();
                MainFrame.access$10600(MainFrame.this).show(e.getComponent(), e.getX(), e.getY());
            }
        });
        this._consolePanePopupMenu = new JPopupMenu();
        this._consolePanePopupMenu.add(this._clearConsoleAction);
        this._consolePanePopupMenu.addSeparator();
        this._consolePanePopupMenu.add(this._printConsoleAction);
        this._consolePanePopupMenu.add(this._printConsolePreviewAction);
        this._consolePane.addMouseListener(new RightClickMouseAdapter(){

            protected void _popupAction(MouseEvent e) {
                MainFrame.access$9500(MainFrame.this).requestFocusInWindow();
                MainFrame.access$10700(MainFrame.this).show(e.getComponent(), e.getX(), e.getY());
            }
        });
    }

    private void nextRecentDoc() {
        if (this._recentDocFrame.isVisible()) {
            this._recentDocFrame.next();
        } else {
            this._recentDocFrame.setVisible(true);
        }
    }

    private void prevRecentDoc() {
        if (this._recentDocFrame.isVisible()) {
            this._recentDocFrame.prev();
        } else {
            this._recentDocFrame.setVisible(true);
        }
    }

    private void hideRecentDocFrame() {
        if (this._recentDocFrame.isVisible()) {
            this._recentDocFrame.setVisible(false);
            OpenDefinitionsDocument doc = this._recentDocFrame.getDocument();
            if (doc != null) {
                this._model.getDocumentNavigator().setActiveDoc(doc);
            }
        }
    }

    JScrollPane _createDefScrollPane(OpenDefinitionsDocument doc) {
        DefinitionsPane pane = new DefinitionsPane(this, doc);
        pane.addKeyListener(this._historyListener);
        pane.addFocusListener(this._focusListenerForRecentDocs);
        this._installNewDocumentListener(doc);
        ErrorCaretListener caretListener = new ErrorCaretListener(doc, pane, this);
        pane.addErrorCaretListener(caretListener);
        pane.addCaretListener(this._posListener);
        pane.addFocusListener(new LastFocusListener(null));
        BorderlessScrollPane scroll = new BorderlessScrollPane(pane, 22, 30);
        pane.setScrollPane(scroll);
        if (DrJava.getConfig().getSetting(LINEENUM_ENABLED).booleanValue()) {
            scroll.setRowHeaderView(new LineEnumRule(pane));
        }
        this._defScrollPanes.put(doc, scroll);
        return scroll;
    }

    private void _setUpPanes() {
        JScrollPane defScroll = this._defScrollPanes.get(this._model.getActiveDocument());
        if (this._model.getDebugger().isAvailable()) {
            try {
                this._debugPanel = new DebugPanel(this);
                int debugHeight = DrJava.getConfig().getSetting(DEBUG_PANEL_HEIGHT);
                Dimension debugMinSize = this._debugPanel.getMinimumSize();
                if (debugHeight > debugMinSize.height) {
                    debugMinSize.height = debugHeight;
                }
                this._debugPanel.setPreferredSize(debugMinSize);
            }
            catch (NoClassDefFoundError e) {
                this._debugPanel = null;
            }
        } else {
            this._debugPanel = null;
        }
        this._docSplitPane = new BorderlessSplitPane(1, true, new JScrollPane(this._model.getDocumentNavigator().asContainer()), defScroll);
        this._debugSplitPane = new BorderlessSplitPane(0, true);
        this._debugSplitPane.setBottomComponent(this._debugPanel);
        this._mainSplit = new JSplitPane(0, true, this._docSplitPane, this._tabbedPane);
        this._mainSplit.setResizeWeight(1.0);
        this._debugSplitPane.setResizeWeight(1.0);
        this.getContentPane().add((Component)this._mainSplit, "Center");
        this._mainSplit.setDividerLocation(this._mainSplit.getHeight() - 132);
        this._mainSplit.setOneTouchExpandable(true);
        this._debugSplitPane.setOneTouchExpandable(true);
        int docListWidth = DrJava.getConfig().getSetting(DOC_LIST_WIDTH);
        this._docSplitPane.setDividerLocation(docListWidth);
        this._docSplitPane.setOneTouchExpandable(true);
    }

    void _switchDefScrollPane() {
        this._currentDefPane.notifyInactive();
        JScrollPane scroll = this._defScrollPanes.get(this._model.getActiveDocument());
        if (scroll == null) {
            scroll = this._createDefScrollPane(this._model.getActiveDocument());
        }
        this._reenableScrollBar();
        int oldLocation = this._docSplitPane.getDividerLocation();
        this._docSplitPane.setRightComponent(scroll);
        this._docSplitPane.setDividerLocation(oldLocation);
        if (this._currentDefPane.isEditable()) {
            this._currentDefPane = (DefinitionsPane)scroll.getViewport().getView();
            this._currentDefPane.notifyActive();
        } else {
            try {
                this._currentDefPane.setEditable(true);
            }
            catch (NoSuchDocumentException noSuchDocumentException) {
                // empty catch block
            }
            this._currentDefPane = (DefinitionsPane)scroll.getViewport().getView();
            this._currentDefPane.notifyActive();
            this._currentDefPane.setEditable(false);
        }
        this.resetUndo();
        this._updateDebugStatus();
    }

    public void resetUndo() {
        this._undoAction.setDelegatee(this._currentDefPane.getUndoAction());
        this._redoAction.setDelegatee(this._currentDefPane.getRedoAction());
    }

    public DefinitionsPane getDefPaneGivenODD(OpenDefinitionsDocument doc) {
        JScrollPane scroll = this._defScrollPanes.get(doc);
        if (scroll == null) {
            throw new UnexpectedException(new Exception("Breakpoint set in a closed document."));
        }
        DefinitionsPane pane = (DefinitionsPane)scroll.getViewport().getView();
        return pane;
    }

    private void _reenableScrollBar() {
        JScrollPane scroll = this._defScrollPanes.get(this._model.getActiveDocument());
        if (scroll == null) {
            throw new UnexpectedException(new Exception("Current definitions scroll pane not found."));
        }
        JScrollBar oldbar = scroll.getVerticalScrollBar();
        JScrollBar newbar = scroll.createVerticalScrollBar();
        newbar.setMinimum(oldbar.getMinimum());
        newbar.setMaximum(oldbar.getMaximum());
        newbar.setValue(oldbar.getValue());
        newbar.setVisibleAmount(oldbar.getVisibleAmount());
        newbar.setEnabled(true);
        newbar.revalidate();
        scroll.setVerticalScrollBar(newbar);
        oldbar = scroll.getHorizontalScrollBar();
        newbar = scroll.createHorizontalScrollBar();
        newbar.setMinimum(oldbar.getMinimum());
        newbar.setMaximum(oldbar.getMaximum());
        newbar.setValue(oldbar.getValue());
        newbar.setVisibleAmount(oldbar.getVisibleAmount());
        newbar.setEnabled(true);
        newbar.revalidate();
        scroll.setHorizontalScrollBar(newbar);
        scroll.revalidate();
    }

    private JMenuItem _newCheckBoxMenuItem(Action action) {
        String RADIO_ICON_KEY = "RadioButtonMenuItem.checkIcon";
        String CHECK_ICON_KEY = "CheckBoxMenuItem.checkIcon";
        Object radioIcon = UIManager.get(RADIO_ICON_KEY);
        UIManager.put(RADIO_ICON_KEY, UIManager.get(CHECK_ICON_KEY));
        JRadioButtonMenuItem pseudoCheckBox = new JRadioButtonMenuItem(action);
        UIManager.put(RADIO_ICON_KEY, radioIcon);
        return pseudoCheckBox;
    }

    private File _getFullFile(File f) throws IOException {
        if (PlatformFactory.ONLY.isWindowsPlatform() && (f.getAbsolutePath().indexOf("..") != -1 || f.getAbsolutePath().indexOf("./") != -1 || f.getAbsolutePath().indexOf(".\\") != -1)) {
            return f.getCanonicalFile();
        }
        return f.getAbsoluteFile();
    }

    private void _setCurrentDirectory(File file) {
        try {
            file = this._getFullFile(file);
            this._openChooser.setCurrentDirectory(file);
            this._saveChooser.setCurrentDirectory(file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void _setCurrentDirectory(OpenDefinitionsDocument doc) {
        try {
            File file = doc.getFile();
            this._setCurrentDirectory(file);
        }
        catch (IllegalStateException ise) {
        }
        catch (FileMovedException fme) {
            this._setCurrentDirectory(fme.getFile());
        }
    }

    private void _setMainFont() {
        Font f = DrJava.getConfig().getSetting(FONT_MAIN);
        for (JScrollPane scroll : this._defScrollPanes.values()) {
            if (scroll == null) continue;
            DefinitionsPane pane = (DefinitionsPane)scroll.getViewport().getView();
            pane.setFont(f);
            if (!DrJava.getConfig().getSetting(LINEENUM_ENABLED).booleanValue()) continue;
            scroll.setRowHeaderView(new LineEnumRule(pane));
        }
        this._interactionsPane.setFont(f);
        this._interactionsController.setDefaultFont(f);
        this._consolePane.setFont(f);
        this._consoleController.setDefaultFont(f);
        this._findReplace.setFieldFont(f);
        this._compilerErrorPanel.setListFont(f);
        this._junitErrorPanel.setListFont(f);
        this._javadocErrorPanel.setListFont(f);
    }

    private void _updateNormalColor() {
        Color norm = DrJava.getConfig().getSetting(DEFINITIONS_NORMAL_COLOR);
        this._model.getDocCollectionWidget().setForeground(norm);
        this._repaintLineNums();
    }

    private void _updateBackgroundColor() {
        Color back = DrJava.getConfig().getSetting(DEFINITIONS_BACKGROUND_COLOR);
        this._model.getDocCollectionWidget().setBackground(back);
        this._repaintLineNums();
    }

    private void _updateLineNums() {
        if (DrJava.getConfig().getSetting(LINEENUM_ENABLED).booleanValue()) {
            for (JScrollPane spane : this._defScrollPanes.values()) {
                LineEnumRule ler = (LineEnumRule)spane.getRowHeader().getView();
                ler.updateFont();
                ler.revalidate();
            }
            this._repaintLineNums();
        }
    }

    private void _repaintLineNums() {
        JViewport rhvport;
        JScrollPane front = this._defScrollPanes.get(this._model.getActiveDocument());
        if (front != null && (rhvport = front.getRowHeader()) != null) {
            Component view = rhvport.getView();
            view.repaint();
        }
    }

    private void _updateDefScrollRowHeader() {
        boolean ruleEnabled = DrJava.getConfig().getSetting(LINEENUM_ENABLED);
        for (JScrollPane scroll : this._defScrollPanes.values()) {
            if (scroll == null) continue;
            DefinitionsPane pane = (DefinitionsPane)scroll.getViewport().getView();
            if (scroll.getRowHeader() == null || scroll.getRowHeader().getView() == null) {
                if (!ruleEnabled) continue;
                scroll.setRowHeaderView(new LineEnumRule(pane));
                continue;
            }
            if (ruleEnabled) continue;
            scroll.setRowHeaderView(null);
        }
    }

    private void _removeThreadLocationHighlight() {
        if (this._currentThreadLocationHighlight != null) {
            this._currentThreadLocationHighlight.remove();
            this._currentThreadLocationHighlight = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _disableStepTimer() {
        Timer timer = this._debugStepTimer;
        synchronized (timer) {
            if (this._debugStepTimer.isRunning()) {
                this._debugStepTimer.stop();
            }
        }
    }

    private void _updateDebugStatus() {
        if (!this.inDebugMode()) {
            return;
        }
        if (this._model.getActiveDocument().isUntitled() || this._model.getActiveDocument().getClassFileInSync()) {
            if (this._debugPanel.getStatusText().equals(DEBUGGER_OUT_OF_SYNC)) {
                this._debugPanel.setStatusText("");
            }
        } else if (this._debugPanel.getStatusText().equals("")) {
            this._debugPanel.setStatusText(DEBUGGER_OUT_OF_SYNC);
        }
        this._debugPanel.repaint();
    }

    protected void _disableInteractionsPane() {
        Runnable command = new Runnable(){

            public void run() {
                MainFrame.access$6700(MainFrame.this).setEditable(false);
                MainFrame.access$6700(MainFrame.this).setCursor(Cursor.getPredefinedCursor(3));
                if (MainFrame.access$6800(MainFrame.this) != null) {
                    MainFrame.access$6800(MainFrame.this).setActionsDisabled();
                }
            }
        };
        Utilities.invokeLater(command);
    }

    protected void _enableInteractionsPane() {
        Runnable command = new Runnable(){

            public void run() {
                MainFrame.access$6700(MainFrame.this).setCursor(Cursor.getPredefinedCursor(2));
                MainFrame.access$6700(MainFrame.this).setEditable(true);
                MainFrame.access$4800(MainFrame.this).moveToEnd();
                if (MainFrame.access$6700(MainFrame.this).hasFocus()) {
                    MainFrame.access$6700(MainFrame.this).getCaret().setVisible(true);
                }
                if (MainFrame.access$6800(MainFrame.this) != null) {
                    MainFrame.access$6800(MainFrame.this).setActionsEnabled();
                }
            }
        };
        Utilities.invokeLater(command);
    }

    public void commentLines() {
        OpenDefinitionsDocument openDoc = this._model.getActiveDocument();
        int caretPos = this._currentDefPane.getCaretPosition();
        openDoc.setCurrentLocation(caretPos);
        int start = this._currentDefPane.getSelectionStart();
        int end = this._currentDefPane.getSelectionEnd();
        this._currentDefPane.endCompoundEdit();
        DummyOpenDefDoc dummy = new DummyOpenDefDoc();
        this._currentDefPane.notifyInactive();
        int newEnd = openDoc.commentLines(start, end);
        this._currentDefPane.notifyActive();
        this._currentDefPane.setCaretPosition(start + 2);
        if (start != end) {
            this._currentDefPane.moveCaretPosition(newEnd);
        }
    }

    public void uncommentLines() {
        Position startPos;
        OpenDefinitionsDocument openDoc = this._model.getActiveDocument();
        int caretPos = this._currentDefPane.getCaretPosition();
        openDoc.setCurrentLocation(caretPos);
        int start = this._currentDefPane.getSelectionStart();
        int end = this._currentDefPane.getSelectionEnd();
        this._currentDefPane.endCompoundEdit();
        this._currentDefPane.notifyInactive();
        openDoc.setCurrentLocation(start);
        try {
            startPos = openDoc.createPosition(start);
        }
        catch (BadLocationException e) {
            throw new UnexpectedException(e);
        }
        int startOffset = startPos.getOffset();
        int newEnd = openDoc.uncommentLines(start, end);
        this._currentDefPane.notifyActive();
        if (startOffset != startPos.getOffset()) {
            start -= 2;
        }
        this._currentDefPane.setCaretPosition(start);
        if (start != end) {
            this._currentDefPane.moveCaretPosition(newEnd);
        }
    }

    public JViewport getDefViewport() {
        OpenDefinitionsDocument doc = this._model.getActiveDocument();
        JScrollPane defScroll = this._defScrollPanes.get(doc);
        return defScroll.getViewport();
    }

    public void removeTab(final Component c) {
        Utilities.invokeLater(new Runnable(){

            public void run() {
                MainFrame.access$5300(MainFrame.this).remove(c);
                ((TabbedPanel)c).setDisplayed(false);
                MainFrame.access$5300(MainFrame.this).setSelectedIndex(0);
                MainFrame.access$4700(MainFrame.this).requestFocusInWindow();
            }
        });
    }

    public void showTab(final Component c) {
        Utilities.invokeLater(new Runnable(){

            public void run() {
                int numVisible = 0;
                if (c == MainFrame.access$6700(MainFrame.this)) {
                    MainFrame.access$5300(MainFrame.this).setSelectedIndex(0);
                } else if (c == MainFrame.access$9500(MainFrame.this)) {
                    MainFrame.access$5300(MainFrame.this).setSelectedIndex(1);
                } else {
                    Iterator i$ = MainFrame.access$14600(MainFrame.this).iterator();
                    while (i$.hasNext()) {
                        TabbedPanel tp = (TabbedPanel)i$.next();
                        if (tp == c) {
                            if (!tp.isDisplayed()) {
                                MainFrame.access$5300(MainFrame.this).insertTab(tp.getName(), null, tp, null, numVisible + 2);
                                tp.setDisplayed(true);
                            }
                            MainFrame.access$5300(MainFrame.this).setSelectedIndex(numVisible + 2);
                            c.requestFocusInWindow();
                            return;
                        }
                        if (!tp.isDisplayed()) continue;
                        ++numVisible;
                    }
                }
            }
        });
    }

    private boolean _warnFileOpen(File f) {
        OpenDefinitionsDocument d = null;
        try {
            d = this._model.getDocumentForFile(f);
        }
        catch (IOException ioe) {
            // empty catch block
        }
        Object[] options = new Object[]{"Yes", "No"};
        if (d == null) {
            return false;
        }
        boolean dMod = d.isModifiedSinceSave();
        String msg = new StringBuffer().append("This file is already open in DrJava").append(dMod ? " and has been modified" : "").append(".  Do you wish to overwrite it?").toString();
        int choice = JOptionPane.showOptionDialog(this, msg, "File Open Warning", 0, 3, null, options, options[1]);
        if (choice == 0) {
            return this._model.closeFileWithoutPrompt(d);
        }
        return false;
    }

    private boolean _verifyOverwrite() {
        Object[] options = new Object[]{"Yes", "No"};
        int n = JOptionPane.showOptionDialog(this, "This file already exists.  Do you wish to overwrite the file?", "Confirm Overwrite", 0, 3, null, options, options[1]);
        return n == 0;
    }

    private void _junitInterrupted(final UnexpectedException e) {
        Utilities.invokeLater(new Runnable(){

            public void run() {
                MainFrame.this._showJUnitInterrupted(e);
                MainFrame.this.removeTab(MainFrame.access$9900(MainFrame.this));
                MainFrame.access$700(MainFrame.this).refreshActiveDocument();
            }
        });
    }

    boolean inDebugMode() {
        Debugger dm = this._model.getDebugger();
        return dm.isAvailable() && dm.isReady() && this._debugPanel != null;
    }

    FindReplaceDialog getFindReplaceDialog() {
        return this._findReplace;
    }

    private void _setUpKeyBindingMaps() {
        ActionMap _actionMap = this._currentDefPane.getActionMap();
        KeyBindingManager.Singleton.put(KEY_BACKWARD, _actionMap.get("caret-backward"), null, "Backward");
        KeyBindingManager.Singleton.addShiftAction((Option<KeyStroke>)KEY_BACKWARD, "selection-backward");
        KeyBindingManager.Singleton.put(KEY_BEGIN_DOCUMENT, _actionMap.get("caret-begin"), null, "Begin Document");
        KeyBindingManager.Singleton.addShiftAction((Option<KeyStroke>)KEY_BEGIN_DOCUMENT, "selection-begin");
        KeyBindingManager.Singleton.put(KEY_BEGIN_LINE, this._beginLineAction, null, "Begin Line");
        KeyBindingManager.Singleton.addShiftAction((Option<KeyStroke>)KEY_BEGIN_LINE, this._selectionBeginLineAction);
        KeyBindingManager.Singleton.put(KEY_PREVIOUS_WORD, _actionMap.get("caret-previous-word"), null, "Previous Word");
        KeyBindingManager.Singleton.addShiftAction((Option<KeyStroke>)KEY_PREVIOUS_WORD, "selection-previous-word");
        KeyBindingManager.Singleton.put(KEY_DOWN, _actionMap.get("caret-down"), null, "Down");
        KeyBindingManager.Singleton.addShiftAction((Option<KeyStroke>)KEY_DOWN, "selection-down");
        KeyBindingManager.Singleton.put(KEY_END_DOCUMENT, _actionMap.get("caret-end"), null, "End Document");
        KeyBindingManager.Singleton.addShiftAction((Option<KeyStroke>)KEY_END_DOCUMENT, "selection-end");
        KeyBindingManager.Singleton.put(KEY_END_LINE, _actionMap.get("caret-end-line"), null, "End Line");
        KeyBindingManager.Singleton.addShiftAction((Option<KeyStroke>)KEY_END_LINE, "selection-end-line");
        KeyBindingManager.Singleton.put(KEY_NEXT_WORD, _actionMap.get("caret-next-word"), null, "Next Word");
        KeyBindingManager.Singleton.addShiftAction((Option<KeyStroke>)KEY_NEXT_WORD, "selection-next-word");
        KeyBindingManager.Singleton.put(KEY_FORWARD, _actionMap.get("caret-forward"), null, "Forward");
        KeyBindingManager.Singleton.addShiftAction((Option<KeyStroke>)KEY_FORWARD, "selection-forward");
        KeyBindingManager.Singleton.put(KEY_UP, _actionMap.get("caret-up"), null, "Up");
        KeyBindingManager.Singleton.addShiftAction((Option<KeyStroke>)KEY_UP, "selection-up");
        KeyBindingManager.Singleton.put(KEY_PAGE_DOWN, _actionMap.get("page-down"), null, "Page Down");
        KeyBindingManager.Singleton.put(KEY_PAGE_UP, _actionMap.get("page-up"), null, "Page Up");
        KeyBindingManager.Singleton.put(KEY_CUT_LINE, this._cutLineAction, null, "Cut Line");
        KeyBindingManager.Singleton.put(KEY_CLEAR_LINE, this._clearLineAction, null, "Clear Line");
        KeyBindingManager.Singleton.put(KEY_SHIFT_DELETE_PREVIOUS, _actionMap.get("delete-previous"), null, "Delete Previous");
        KeyBindingManager.Singleton.put(KEY_SHIFT_DELETE_NEXT, _actionMap.get("delete-next"), null, "Delete Next");
    }

    public void addComponentListenerToOpenDocumentsList(ComponentListener listener) {
        this._docSplitPane.getLeftComponent().addComponentListener(listener);
    }

    public String getFileNameField() {
        return this._fileNameField.getText();
    }

    public JMenu getEditMenu() {
        return this._editMenu;
    }

    static JFileChooser access$000(MainFrame x0) {
        return x0._openChooser;
    }

    static FileFilter access$100(MainFrame x0) {
        return x0._javaSourceFilter;
    }

    static FileFilter access$200(MainFrame x0) {
        return x0._projectFilter;
    }

    static JFileChooser access$300(MainFrame x0) {
        return x0._openProjectChooser;
    }

    static JFileChooser access$400(MainFrame x0) {
        return x0._saveChooser;
    }

    static boolean access$500(MainFrame x0, File x1) {
        return x0._warnFileOpen(x1);
    }

    static boolean access$600(MainFrame x0) {
        return x0._verifyOverwrite();
    }

    static SingleDisplayModel access$700(MainFrame x0) {
        return x0._model;
    }

    static void access$800(MainFrame x0) {
        x0._moveToAuxiliary();
    }

    static void access$900(MainFrame x0) {
        x0._removeAuxiliary();
    }

    static void access$1000(MainFrame x0) {
        x0._new();
    }

    static void access$1100(MainFrame x0) {
        x0._newProject();
    }

    static void access$1200(MainFrame x0) {
        x0._runProject();
    }

    static void access$1300(MainFrame x0) {
        x0._open();
    }

    static FindReplaceDialog access$1400(MainFrame x0) {
        return x0._findReplace;
    }

    static void access$1500(MainFrame x0) {
        x0._openFolder();
    }

    static void access$1600(MainFrame x0) {
        x0._openFileOrProject();
    }

    static void access$1700(MainFrame x0) {
        x0._openProject();
    }

    static void access$1800(MainFrame x0) {
        x0._close();
    }

    static void access$1900(MainFrame x0) {
        x0._closeAll();
    }

    static void access$2000(MainFrame x0) {
        x0._closeFolder();
    }

    static void access$2100(MainFrame x0, File x1, boolean x2) {
        x0._openFolder(x1, x2);
    }

    static void access$2200(MainFrame x0) {
        x0._junitFolder();
    }

    static boolean access$2300(MainFrame x0) {
        return x0._save();
    }

    static void access$2400(MainFrame x0) {
        x0.packHelp();
    }

    static boolean access$2500(MainFrame x0) {
        return x0._saveAs();
    }

    static void access$2600(MainFrame x0) {
        x0._saveAll();
    }

    static void access$2700(MainFrame x0) {
        x0._revert();
    }

    static void access$2800(MainFrame x0) {
        x0._printDefDoc();
    }

    static void access$2900(MainFrame x0) {
        x0._printConsole();
    }

    static void access$3000(MainFrame x0) {
        x0._printInteractions();
    }

    static void access$3100(MainFrame x0) {
        x0._printDefDocPreview();
    }

    static void access$3200(MainFrame x0) {
        x0._printConsolePreview();
    }

    static void access$3300(MainFrame x0) {
        x0._printInteractionsPreview();
    }

    static void access$3400(MainFrame x0) {
        x0._pageSetup();
    }

    static JSplitPane access$3500(MainFrame x0) {
        return x0._mainSplit;
    }

    static void access$3600(MainFrame x0) {
        x0._compile();
    }

    static void access$3700(MainFrame x0) {
        x0._compileProject();
    }

    static void access$3800(MainFrame x0) {
        x0._compileFolder();
    }

    static void access$3900(MainFrame x0) {
        x0._compileAll();
    }

    static void access$4000(MainFrame x0) {
        x0._clean();
    }

    static void access$4100(MainFrame x0) {
        x0._runMain();
    }

    static void access$4200(MainFrame x0) {
        x0._junit();
    }

    static void access$4300(MainFrame x0) {
        x0._junitAll();
    }

    static void access$4400(MainFrame x0) {
        x0._junitProject();
    }

    static JavadocDialog access$4500(MainFrame x0) {
        return x0._javadocSelector;
    }

    static FileSaveSelector access$4600(MainFrame x0) {
        return x0._saveSelector;
    }

    static DefinitionsPane access$4700(MainFrame x0) {
        return x0._currentDefPane;
    }

    static InteractionsController access$4800(MainFrame x0) {
        return x0._interactionsController;
    }

    static void access$4900(MainFrame x0, String x1) {
        x0._putTextIntoDefinitions(x1);
    }

    static Action access$5000(MainFrame x0) {
        return x0._saveAction;
    }

    static void access$5100(MainFrame x0) {
        x0._quit();
    }

    static void access$5200(MainFrame x0) {
        x0._selectAll();
    }

    static JTabbedPane access$5300(MainFrame x0) {
        return x0._tabbedPane;
    }

    static Action access$5400(MainFrame x0) {
        return x0._findReplaceAction;
    }

    static int access$5500(MainFrame x0) {
        return x0._gotoLine();
    }

    static void access$5600(MainFrame x0) {
        x0._doResetInteractions();
    }

    static HelpFrame access$5700(MainFrame x0) {
        return x0._helpFrame;
    }

    static HelpFrame access$5702(MainFrame x0, HelpFrame x1) {
        x0._helpFrame = x1;
        return x0._helpFrame;
    }

    static QuickStartFrame access$5800(MainFrame x0) {
        return x0._quickStartFrame;
    }

    static QuickStartFrame access$5802(MainFrame x0, QuickStartFrame x1) {
        x0._quickStartFrame = x1;
        return x0._quickStartFrame;
    }

    static AboutDialog access$5900(MainFrame x0) {
        return x0._aboutDialog;
    }

    static AboutDialog access$5902(MainFrame x0, AboutDialog x1) {
        x0._aboutDialog = x1;
        return x0._aboutDialog;
    }

    static JSplitPane access$6000(MainFrame x0) {
        return x0._docSplitPane;
    }

    static void access$6100(MainFrame x0, boolean x1) {
        x0._switchPaneFocus(x1);
    }

    static ConfigFrame access$6200(MainFrame x0) {
        return x0._configFrame;
    }

    static ConfigFrame access$6202(MainFrame x0, ConfigFrame x1) {
        x0._configFrame = x1;
        return x0._configFrame;
    }

    static ProjectPropertiesFrame access$6300(MainFrame x0) {
        return x0._projectPropertiesFrame;
    }

    static ProjectPropertiesFrame access$6302(MainFrame x0, ProjectPropertiesFrame x1) {
        x0._projectPropertiesFrame = x1;
        return x0._projectPropertiesFrame;
    }

    static int access$6400(MainFrame x0) {
        return x0._getBeginLinePos();
    }

    static JFileChooser access$6500(MainFrame x0) {
        return x0._interactionsHistoryChooser;
    }

    static FileOpenSelector access$6600(MainFrame x0) {
        return x0._interactionsHistoryFileSelector;
    }

    static InteractionsPane access$6700(MainFrame x0) {
        return x0._interactionsPane;
    }

    static InteractionsScriptController access$6802(MainFrame x0, InteractionsScriptController x1) {
        x0._interactionsScriptController = x1;
        return x0._interactionsScriptController;
    }

    static void access$6900(MainFrame x0) {
        x0._closeInteractionsScript();
    }

    static InteractionsScriptPane access$7002(MainFrame x0, InteractionsScriptPane x1) {
        x0._interactionsScriptPane = x1;
        return x0._interactionsScriptPane;
    }

    static InteractionsScriptController access$6800(MainFrame x0) {
        return x0._interactionsScriptController;
    }

    static InteractionsScriptPane access$7000(MainFrame x0) {
        return x0._interactionsScriptPane;
    }

    static JPanel access$7100(MainFrame x0) {
        return x0._interactionsContainer;
    }

    static File access$7200(MainFrame x0, JFileChooser x1, int x2) throws OperationCanceledException {
        return x0.getChosenFile(x1, x2);
    }

    static OddDisplayManager access$7300() {
        return _oddDisplayManager20;
    }

    static void access$8800(MainFrame x0) {
        x0.disposeHelp();
    }

    static DebugPanel access$8900(MainFrame x0) {
        return x0._debugPanel;
    }

    static boolean access$9000(MainFrame x0) {
        return x0.showCleanWarning();
    }

    static void access$9100(MainFrame x0) {
        x0._dissableJUnitActions();
    }

    static void access$9200(MainFrame x0, UnexpectedException x1) {
        x0._junitInterrupted(x1);
    }

    static JLabel access$9400(MainFrame x0) {
        return x0._currLocationField;
    }

    static InteractionsPane access$9500(MainFrame x0) {
        return x0._consolePane;
    }

    static JScrollPane access$9600(MainFrame x0) {
        return x0._consoleScroll;
    }

    static Component access$9702(MainFrame x0, Component x1) {
        x0._lastFocusOwner = x1;
        return x0._lastFocusOwner;
    }

    static CompilerErrorPanel access$9800(MainFrame x0) {
        return x0._compilerErrorPanel;
    }

    static JUnitPanel access$9900(MainFrame x0) {
        return x0._junitErrorPanel;
    }

    static JavadocErrorPanel access$10000(MainFrame x0) {
        return x0._javadocErrorPanel;
    }

    static JPopupMenu access$10100(MainFrame x0) {
        return x0._navPaneFolderPopupMenu;
    }

    static JPopupMenu access$10200(MainFrame x0) {
        return x0._navPanePopupMenu;
    }

    static JPopupMenu access$10300(MainFrame x0) {
        return x0._navPanePopupMenuForExternal;
    }

    static JPopupMenu access$10400(MainFrame x0) {
        return x0._navPanePopupMenuForAuxiliary;
    }

    static JPopupMenu access$10500(MainFrame x0) {
        return x0._navPanePopupMenuForRoot;
    }

    static JPopupMenu access$10600(MainFrame x0) {
        return x0._interactionsPanePopupMenu;
    }

    static JPopupMenu access$10700(MainFrame x0) {
        return x0._consolePanePopupMenu;
    }

    static void access$10800(MainFrame x0) {
        x0.nextRecentDoc();
    }

    static void access$10900(MainFrame x0) {
        x0.prevRecentDoc();
    }

    static void access$11000(MainFrame x0) {
        x0.hideRecentDocFrame();
    }

    static void access$11200(MainFrame x0) {
        x0._disableStepTimer();
    }

    static void access$11300(MainFrame x0) {
        x0._removeThreadLocationHighlight();
    }

    static HighlightManager.HighlightInfo access$11402(MainFrame x0, HighlightManager.HighlightInfo x1) {
        x0._currentThreadLocationHighlight = x1;
        return x0._currentThreadLocationHighlight;
    }

    static void access$11500(MainFrame x0) {
        x0._showDebuggingModifiedFileWarning();
    }

    static void access$11600(MainFrame x0) {
        x0._updateDebugStatus();
    }

    static Hashtable access$11700(MainFrame x0) {
        return x0._breakpointHighlights;
    }

    static Timer access$11800(MainFrame x0) {
        return x0._debugStepTimer;
    }

    static void access$11900(MainFrame x0, boolean x1) {
        x0._setThreadDependentDebugMenuItems(x1);
    }

    static void access$12000(MainFrame x0, Throwable x1, String x2, String x3) {
        x0._showError(x1, x2, x3);
    }

    static Action access$12100(MainFrame x0) {
        return x0._revertAction;
    }

    static RecentFileManager access$12200(MainFrame x0) {
        return x0._recentFileManager;
    }

    static void access$12500(MainFrame x0, OpenDefinitionsDocument x1) {
        x0._removeErrorListener(x1);
    }

    static Hashtable access$12600(MainFrame x0) {
        return x0._defScrollPanes;
    }

    static void access$12700(MainFrame x0, OpenDefinitionsDocument x1) {
        x0._setCurrentDirectory(x1);
    }

    static PositionListener access$12800(MainFrame x0) {
        return x0._posListener;
    }

    static Action access$12900(MainFrame x0) {
        return x0._runAction;
    }

    static Action access$13000(MainFrame x0) {
        return x0._junitAction;
    }

    static Action access$13100(MainFrame x0) {
        return x0._junitAllAction;
    }

    static void access$13200(MainFrame x0) {
        x0._restoreJUnitActionsEnabled();
    }

    static Action access$13300(MainFrame x0) {
        return x0._javadocAllAction;
    }

    static Action access$13400(MainFrame x0) {
        return x0._javadocCurrentAction;
    }

    static Action access$13500(MainFrame x0) {
        return x0._resetInteractionsAction;
    }

    static Action access$13600(MainFrame x0) {
        return x0._toggleDebuggerAction;
    }

    static void access$13800(MainFrame x0, File x1) {
        x0._setCurrentDirectory(x1);
    }

    static Action access$13900(MainFrame x0) {
        return x0._cleanAction;
    }

    static MouseListener access$14000(MainFrame x0) {
        return x0._resetFindReplaceListener;
    }

    static void access$14100(MainFrame x0) {
        x0._setUpContextMenus();
    }

    static RecentFileManager access$14200(MainFrame x0) {
        return x0._recentProjectManager;
    }

    static void access$14300(MainFrame x0) {
        x0._openProjectUpdate();
    }

    static Action access$14400(MainFrame x0) {
        return x0._runProjectAction;
    }

    static FileOpenSelector access$14500(MainFrame x0) {
        return x0._openSelector;
    }

    static LinkedList access$14600(MainFrame x0) {
        return x0._tabs;
    }

    static void access$14700(MainFrame x0) {
        x0._setMainFont();
    }

    static void access$14800(MainFrame x0) {
        x0._updateLineNums();
    }

    static void access$14900(MainFrame x0) {
        x0._updateToolbarButtons();
    }

    static void access$15000(MainFrame x0) {
        x0._updateNormalColor();
    }

    static void access$15100(MainFrame x0) {
        x0._updateBackgroundColor();
    }

    static void access$15200(MainFrame x0) {
        x0._updateDefScrollRowHeader();
    }

    static boolean access$15302(MainFrame x0, boolean x1) {
        x0._promptBeforeQuit = x1;
        return x0._promptBeforeQuit;
    }

    static {
        ImageIcon java = MainFrame.getIcon("JavaIcon20.gif");
        ImageIcon dj0 = MainFrame.getIcon("ElementaryIcon20.gif");
        ImageIcon dj1 = MainFrame.getIcon("IntermediateIcon20.gif");
        ImageIcon dj2 = MainFrame.getIcon("AdvancedIcon20.gif");
        ImageIcon other = MainFrame.getIcon("OtherIcon20.gif");
        _djFileDisplayManager20 = new DJFileDisplayManager(java, dj0, dj1, dj2, other);
        java = MainFrame.getIcon("JavaIcon30.gif");
        dj0 = MainFrame.getIcon("ElementaryIcon30.gif");
        dj1 = MainFrame.getIcon("IntermediateIcon30.gif");
        dj2 = MainFrame.getIcon("AdvancedIcon30.gif");
        other = MainFrame.getIcon("OtherIcon30.gif");
        _djFileDisplayManager30 = new DJFileDisplayManager(java, dj0, dj1, dj2, other);
        ImageIcon star = MainFrame.getIcon("ModStar20.gif");
        ImageIcon jup = MainFrame.getIcon("JUnitPass20.gif");
        ImageIcon juf = MainFrame.getIcon("JUnitFail20.gif");
        _oddDisplayManager20 = new OddDisplayManager(_djFileDisplayManager20, star, jup, juf);
        star = MainFrame.getIcon("ModStar30.gif");
        jup = MainFrame.getIcon("JUnitPass30.gif");
        juf = MainFrame.getIcon("JUnitFail30.gif");
        _oddDisplayManager30 = new OddDisplayManager(_djFileDisplayManager30, star, jup, juf);
        _djProjectIcon = MainFrame.getIcon("ProjectIcon.gif");
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }

    private class LastFocusListener
    extends FocusAdapter {
        private LastFocusListener() {
        }

        public void focusGained(FocusEvent e) {
            MainFrame.access$9702(MainFrame.this, e.getComponent());
        }

        LastFocusListener(1 x1) {
            this();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RecentFilesOptionListener
    implements OptionListener<Integer> {
        private RecentFilesOptionListener() {
        }

        @Override
        public void optionChanged(OptionEvent<Integer> oce) {
            MainFrame.access$12200(MainFrame.this).updateMax((Integer)oce.value);
            MainFrame.access$12200(MainFrame.this).numberItems();
            MainFrame.access$14200(MainFrame.this).updateMax((Integer)oce.value);
            MainFrame.access$14200(MainFrame.this).numberItems();
        }

        RecentFilesOptionListener(1 x1) {
            this();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class QuitPromptOptionListener
    implements OptionListener<Boolean> {
        private QuitPromptOptionListener() {
        }

        @Override
        public void optionChanged(OptionEvent<Boolean> oce) {
            MainFrame.access$15302(MainFrame.this, (Boolean)oce.value);
        }

        QuitPromptOptionListener(1 x1) {
            this();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LineEnumOptionListener
    implements OptionListener<Boolean> {
        private LineEnumOptionListener() {
        }

        @Override
        public void optionChanged(OptionEvent<Boolean> oce) {
            MainFrame.access$15200(MainFrame.this);
        }

        LineEnumOptionListener(1 x1) {
            this();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class WorkingDirOptionListener
    implements OptionListener<File> {
        private WorkingDirOptionListener() {
        }

        @Override
        public void optionChanged(OptionEvent<File> oce) {
            MainFrame.access$13800(MainFrame.this, (File)oce.value);
        }

        WorkingDirOptionListener(1 x1) {
            this();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ToolbarOptionListener
    implements OptionListener<Boolean> {
        private ToolbarOptionListener() {
        }

        @Override
        public void optionChanged(OptionEvent<Boolean> oce) {
            MainFrame.access$14900(MainFrame.this);
        }

        ToolbarOptionListener(1 x1) {
            this();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BackgroundColorOptionListener
    implements OptionListener<Color> {
        private BackgroundColorOptionListener() {
        }

        @Override
        public void optionChanged(OptionEvent<Color> oce) {
            MainFrame.access$15100(MainFrame.this);
        }

        BackgroundColorOptionListener(1 x1) {
            this();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NormalColorOptionListener
    implements OptionListener<Color> {
        private NormalColorOptionListener() {
        }

        @Override
        public void optionChanged(OptionEvent<Color> oce) {
            MainFrame.access$15000(MainFrame.this);
        }

        NormalColorOptionListener(1 x1) {
            this();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ToolbarFontOptionListener
    implements OptionListener<Font> {
        private ToolbarFontOptionListener() {
        }

        @Override
        public void optionChanged(OptionEvent<Font> oce) {
            MainFrame.access$14900(MainFrame.this);
        }

        ToolbarFontOptionListener(1 x1) {
            this();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DoclistFontOptionListener
    implements OptionListener<Font> {
        private DoclistFontOptionListener() {
        }

        @Override
        public void optionChanged(OptionEvent<Font> oce) {
            Font doclistFont = DrJava.getConfig().getSetting(OptionConstants.FONT_DOCLIST);
            MainFrame.access$700(MainFrame.this).getDocCollectionWidget().setFont(doclistFont);
        }

        DoclistFontOptionListener(1 x1) {
            this();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LineNumbersFontOptionListener
    implements OptionListener<Font> {
        private LineNumbersFontOptionListener() {
        }

        @Override
        public void optionChanged(OptionEvent<Font> oce) {
            MainFrame.access$14800(MainFrame.this);
        }

        LineNumbersFontOptionListener(1 x1) {
            this();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MainFontOptionListener
    implements OptionListener<Font> {
        private MainFontOptionListener() {
        }

        @Override
        public void optionChanged(OptionEvent<Font> oce) {
            MainFrame.access$14700(MainFrame.this);
        }

        MainFontOptionListener(1 x1) {
            this();
        }
    }

    private class ModelListener
    implements GlobalModelListener {
        private ModelListener() {
        }

        public void fileNotFound(File f) {
            MainFrame.access$700(MainFrame.this).setProjectChanged(true);
            MainFrame.this._showFileNotFoundError(new FileNotFoundException("File " + f + " cannot be found"));
        }

        public void newFileCreated(final OpenDefinitionsDocument doc) {
            Utilities.invokeLater(new Runnable(){

                public void run() {
                    MainFrame.this._createDefScrollPane(doc);
                }
            });
        }

        public void fileSaved(final OpenDefinitionsDocument doc) {
            Utilities.invokeLater(new Runnable(){

                public void run() {
                    block4: {
                        doc.documentSaved();
                        MainFrame.access$5000(MainFrame.this).setEnabled(false);
                        MainFrame.access$12100(MainFrame.this).setEnabled(true);
                        MainFrame.this.updateFileTitle();
                        MainFrame.access$4700(MainFrame.this).requestFocusInWindow();
                        try {
                            File f = doc.getFile();
                            if (!MainFrame.access$700(MainFrame.this).inProject(f)) {
                                MainFrame.access$12200(MainFrame.this).updateOpenFiles(f);
                            }
                        }
                        catch (IllegalStateException ise) {
                            throw new UnexpectedException(ise);
                        }
                        catch (FileMovedException fme) {
                            File f = fme.getFile();
                            if (MainFrame.access$700(MainFrame.this).inProject(f)) break block4;
                            MainFrame.access$12200(MainFrame.this).updateOpenFiles(f);
                        }
                    }
                    MainFrame.access$11600(MainFrame.this);
                }
            });
        }

        public void fileOpened(final OpenDefinitionsDocument doc) {
            Utilities.invokeLater(new Runnable(){

                public void run() {
                    ModelListener.access$12300(ModelListener.this, doc);
                }
            });
        }

        private void _fileOpened(OpenDefinitionsDocument doc) {
            block5: {
                try {
                    File f = doc.getFile();
                    if (!MainFrame.access$700(MainFrame.this).inProject(f)) {
                        MainFrame.access$12200(MainFrame.this).updateOpenFiles(f);
                        if (MainFrame.access$700(MainFrame.this).isInProjectPath(doc)) {
                            MainFrame.access$700(MainFrame.this).setProjectChanged(true);
                        }
                    }
                }
                catch (IllegalStateException ise) {
                    throw new UnexpectedException(ise);
                }
                catch (FileMovedException fme) {
                    File f = fme.getFile();
                    if (MainFrame.access$700(MainFrame.this).inProject(f)) break block5;
                    MainFrame.access$12200(MainFrame.this).updateOpenFiles(f);
                }
            }
        }

        public void fileClosed(final OpenDefinitionsDocument doc) {
            Utilities.invokeLater(new Runnable(){

                public void run() {
                    ModelListener.access$12400(ModelListener.this, doc);
                }
            });
        }

        private void _fileClosed(OpenDefinitionsDocument doc) {
            MainFrame.this._recentDocFrame.closeDocument(doc);
            MainFrame.access$12500(MainFrame.this, doc);
            JScrollPane jsp = (JScrollPane)MainFrame.access$12600(MainFrame.this).get(doc);
            if (jsp != null) {
                ((DefinitionsPane)jsp.getViewport().getView()).close();
                MainFrame.access$12600(MainFrame.this).remove(doc);
            }
            if (doc != null) {
                try {
                    File f = doc.getFile();
                }
                catch (FileMovedException fme) {
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
        }

        public void fileReverted(OpenDefinitionsDocument doc) {
            Utilities.invokeLater(new Runnable(){

                public void run() {
                    MainFrame.this.updateFileTitle();
                    MainFrame.access$5000(MainFrame.this).setEnabled(false);
                    MainFrame.access$4700(MainFrame.this).resetUndo();
                    MainFrame.access$4700(MainFrame.this).hasWarnedAboutModified(false);
                    MainFrame.access$4700(MainFrame.this).setPositionAndScroll(0);
                    MainFrame.access$11600(MainFrame.this);
                }
            });
        }

        public void undoableEditHappened() {
            Utilities.invokeLater(new Runnable(){

                public void run() {
                    MainFrame.access$4700(MainFrame.this).getUndoAction().updateUndoState();
                    MainFrame.access$4700(MainFrame.this).getRedoAction().updateRedoState();
                }
            });
        }

        public void activeDocumentChanged(final OpenDefinitionsDocument active) {
            Utilities.invokeLater(new Runnable(){

                public void run() {
                    MainFrame.this._recentDocFrame.pokeDocument(active);
                    MainFrame.this._switchDefScrollPane();
                    boolean isModified = active.isModifiedSinceSave();
                    boolean canCompile = !isModified && !active.isUntitled();
                    MainFrame.access$5000(MainFrame.this).setEnabled(!canCompile);
                    MainFrame.access$12100(MainFrame.this).setEnabled(!active.isUntitled());
                    int pos = MainFrame.access$4700(MainFrame.this).getCaretPosition();
                    MainFrame.access$4700(MainFrame.this).getErrorCaretListener().updateHighlight(pos);
                    MainFrame.access$12700(MainFrame.this, active);
                    MainFrame.this.updateFileTitle();
                    MainFrame.access$4700(MainFrame.this).requestFocusInWindow();
                    MainFrame.access$12800(MainFrame.this).updateLocation();
                    if (isModified) {
                        MainFrame.access$700(MainFrame.this).getDocumentNavigator().repaint();
                    }
                    try {
                        active.revertIfModifiedOnDisk();
                    }
                    catch (FileMovedException fme) {
                        MainFrame.this._showFileMovedError(fme);
                    }
                    catch (IOException e) {
                        MainFrame.this._showIOError(e);
                    }
                    if (MainFrame.access$1400(MainFrame.this).isDisplayed()) {
                        MainFrame.access$1400(MainFrame.this).stopListening();
                        MainFrame.access$1400(MainFrame.this).beginListeningTo(MainFrame.access$4700(MainFrame.this));
                    }
                }
            });
        }

        public void interactionStarted() {
            Utilities.invokeLater(new Runnable(){

                public void run() {
                    MainFrame.this._disableInteractionsPane();
                    MainFrame.access$12900(MainFrame.this).setEnabled(false);
                }
            });
        }

        public void interactionEnded() {
            Utilities.invokeLater(new Runnable(){

                public void run() {
                    MainFrame.this._enableInteractionsPane();
                    MainFrame.access$12900(MainFrame.this).setEnabled(true);
                }
            });
        }

        public void interactionErrorOccurred(final int offset, final int length) {
            Utilities.invokeLater(new Runnable(){

                public void run() {
                    MainFrame.access$6700(MainFrame.this).highlightError(offset, length);
                }
            });
        }

        public void interpreterChanged(final boolean inProgress) {
            Utilities.invokeLater(new Runnable(){

                public void run() {
                    MainFrame.access$12900(MainFrame.this).setEnabled(!inProgress);
                    if (inProgress) {
                        MainFrame.this._disableInteractionsPane();
                    } else {
                        MainFrame.this._enableInteractionsPane();
                    }
                }
            });
        }

        public void compileStarted() {
            Utilities.invokeLater(new Runnable(){

                public void run() {
                    MainFrame.this.showTab(MainFrame.access$9800(MainFrame.this));
                    MainFrame.access$9800(MainFrame.this).setCompilationInProgress();
                    MainFrame.access$5000(MainFrame.this).setEnabled(false);
                }
            });
        }

        public void compileEnded() {
            Utilities.invokeLater(new Runnable(){

                public void run() {
                    MainFrame.access$9800(MainFrame.this).reset();
                    if (MainFrame.this.inDebugMode()) {
                        MainFrame.access$700(MainFrame.this).getActiveDocument().checkIfClassFileInSync();
                        MainFrame.access$700(MainFrame.this).refreshActiveDocument();
                        MainFrame.access$11600(MainFrame.this);
                    }
                }
            });
        }

        public void runStarted(OpenDefinitionsDocument doc) {
            Utilities.invokeLater(new Runnable(){

                public void run() {
                    MainFrame.this.showTab(MainFrame.access$6700(MainFrame.this));
                }
            });
        }

        public void junitStarted() {
            Utilities.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        MainFrame.this.showTab(MainFrame.access$9900(MainFrame.this));
                        MainFrame.access$9900(MainFrame.this).setJUnitInProgress();
                        MainFrame.access$13000(MainFrame.this).setEnabled(false);
                        MainFrame.access$13100(MainFrame.this).setEnabled(false);
                    }
                    finally {
                        MainFrame.this.hourglassOff();
                    }
                }
            });
        }

        public void junitClassesStarted() {
            Utilities.invokeLater(new Runnable(){

                public void run() {
                    MainFrame.this.showTab(MainFrame.access$9900(MainFrame.this));
                    MainFrame.access$9900(MainFrame.this).setJUnitInProgress();
                    MainFrame.access$13000(MainFrame.this).setEnabled(false);
                    MainFrame.access$13100(MainFrame.this).setEnabled(false);
                }
            });
        }

        public void junitSuiteStarted(final int numTests) {
            Utilities.invokeLater(new Runnable(){

                public void run() {
                    MainFrame.access$9900(MainFrame.this).progressReset(numTests);
                }
            });
        }

        public void junitTestStarted(final String name) {
            Utilities.invokeLater(new Runnable(){

                public void run() {
                    MainFrame.access$9900(MainFrame.this).getErrorListPane().testStarted(name);
                }
            });
        }

        public void junitTestEnded(final String name, final boolean succeeded, final boolean causedError) {
            Utilities.invokeLater(new Runnable(){

                public void run() {
                    MainFrame.access$9900(MainFrame.this).getErrorListPane().testEnded(name, succeeded, causedError);
                    MainFrame.access$9900(MainFrame.this).progressStep(succeeded);
                    MainFrame.access$700(MainFrame.this).refreshActiveDocument();
                }
            });
        }

        public void junitEnded() {
            Utilities.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    MainFrame.access$13200(MainFrame.this);
                    MainFrame.access$9900(MainFrame.this).reset();
                    MainFrame.access$700(MainFrame.this).refreshActiveDocument();
                }
            });
        }

        public void javadocStarted() {
            Runnable command = new Runnable(){

                public void run() {
                    MainFrame.this.hourglassOn();
                    MainFrame.this.showTab(MainFrame.access$10000(MainFrame.this));
                    MainFrame.access$10000(MainFrame.this).setJavadocInProgress();
                    MainFrame.access$13300(MainFrame.this).setEnabled(false);
                    MainFrame.access$13400(MainFrame.this).setEnabled(false);
                }
            };
            Utilities.invokeLater(command);
        }

        public void javadocEnded(final boolean success, final File destDir, final boolean allDocs) {
            Runnable command = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        MainFrame.this.showTab(MainFrame.access$10000(MainFrame.this));
                        MainFrame.access$13300(MainFrame.this).setEnabled(true);
                        MainFrame.access$13400(MainFrame.this).setEnabled(true);
                        MainFrame.access$10000(MainFrame.this).reset();
                        MainFrame.access$700(MainFrame.this).refreshActiveDocument();
                    }
                    finally {
                        MainFrame.this.hourglassOff();
                    }
                    if (success) {
                        String className;
                        try {
                            className = MainFrame.access$700(MainFrame.this).getActiveDocument().getQualifiedClassName();
                            className = className.replace('.', File.separatorChar);
                        }
                        catch (ClassNameNotFoundException cnf) {
                            className = "";
                        }
                        try {
                            String filename = allDocs || className.equals("") ? "index.html" : className + ".html";
                            File index = new File(destDir, filename);
                            URL address = index.getAbsoluteFile().toURL();
                            if (!PlatformFactory.ONLY.openURL(address)) {
                                JavadocFrame _javadocFrame = new JavadocFrame(destDir, className, allDocs);
                                _javadocFrame.setVisible(true);
                            }
                        }
                        catch (MalformedURLException me) {
                            throw new UnexpectedException(me);
                        }
                        catch (IllegalStateException ise) {
                            String msg = "Javadoc completed successfully, but did not produce any HTML files.\nPlease ensure that your access level in Preferences is appropriate.";
                            JOptionPane.showMessageDialog(MainFrame.this, msg, "No output to display.", 1);
                        }
                    }
                }
            };
            Utilities.invokeLater(command);
        }

        public void interpreterExited(final int status) {
            if (DrJava.getConfig().getSetting(OptionConstants.INTERACTIONS_EXIT_PROMPT).booleanValue()) {
                Runnable command = new Runnable(){

                    public void run() {
                        String msg = "The interactions window was terminated by a call to System.exit(" + status + ").\n" + "The interactions window will now be restarted.";
                        String title = "Interactions terminated by System.exit(" + status + ")";
                        ConfirmCheckBoxDialog dialog = new ConfirmCheckBoxDialog(MainFrame.this, title, msg, "Do not show this message again", 1, -1);
                        if (dialog.show() == 0 && dialog.getCheckBoxValue()) {
                            DrJava.getConfig().setSetting(OptionConstants.INTERACTIONS_EXIT_PROMPT, Boolean.FALSE);
                        }
                    }
                };
                Utilities.invokeLater(command);
            }
        }

        public void interpreterResetFailed(Throwable t) {
            this.interpreterReady();
        }

        public void interpreterResetting() {
            Runnable command = new Runnable(){

                public void run() {
                    Debugger dm = MainFrame.access$700(MainFrame.this).getDebugger();
                    if (dm.isAvailable() && dm.isReady()) {
                        dm.shutdown();
                    }
                    MainFrame.access$13500(MainFrame.this).setEnabled(false);
                    MainFrame.access$13000(MainFrame.this).setEnabled(false);
                    MainFrame.access$13100(MainFrame.this).setEnabled(false);
                    MainFrame.access$12900(MainFrame.this).setEnabled(false);
                    MainFrame.access$6900(MainFrame.this);
                    MainFrame.access$6700(MainFrame.this).setEditable(false);
                    MainFrame.access$6700(MainFrame.this).setCursor(Cursor.getPredefinedCursor(3));
                    if (MainFrame.access$700(MainFrame.this).getDebugger().isAvailable()) {
                        MainFrame.access$13600(MainFrame.this).setEnabled(false);
                    }
                }
            };
            Utilities.invokeLater(command);
        }

        public void interpreterReady() {
            Runnable command = new Runnable(){

                public void run() {
                    ModelListener.this.interactionEnded();
                    MainFrame.access$12900(MainFrame.this).setEnabled(true);
                    MainFrame.access$13000(MainFrame.this).setEnabled(true);
                    MainFrame.access$13100(MainFrame.this).setEnabled(true);
                    MainFrame.access$13500(MainFrame.this).setEnabled(true);
                    if (MainFrame.access$700(MainFrame.this).getDebugger().isAvailable()) {
                        MainFrame.access$13600(MainFrame.this).setEnabled(true);
                    }
                    MainFrame.access$4800(MainFrame.this).notifyInputEnteredAction();
                }
            };
            Utilities.invokeLater(command);
        }

        public void consoleReset() {
        }

        public void saveBeforeCompile() {
            Utilities.invokeAndWait(new Runnable(){

                public void run() {
                    ModelListener.access$13700(ModelListener.this, "To compile, you must first save ALL modified files.\nWould you like to save and then compile?", OptionConstants.ALWAYS_SAVE_BEFORE_COMPILE, "Always save before compiling");
                }
            });
        }

        public void compileBeforeJUnit() {
            Frame parentFrame = JOptionPane.getFrameForComponent(MainFrame.this);
            if (parentFrame.isVisible()) {
                final BooleanOption option = OptionConstants.ALWAYS_COMPILE_BEFORE_JUNIT;
                Utilities.invokeLater(new Runnable(){

                    public void run() {
                        block6: {
                            block5: {
                                if (DrJava.getConfig().getSetting(option).booleanValue()) break block5;
                                ConfirmCheckBoxDialog dialog = new ConfirmCheckBoxDialog(MainFrame.this, "Must Compile All Files to Continue", "To unit test all documents, you must first compile all out of sync files.\nWould you like to compile and then test?", "Always compile before testing all files");
                                int rc = dialog.show();
                                switch (rc) {
                                    case 0: {
                                        MainFrame.access$3900(MainFrame.this);
                                        if (dialog.getCheckBoxValue()) {
                                            DrJava.getConfig().setSetting(option, Boolean.TRUE);
                                            break;
                                        }
                                        break block6;
                                    }
                                    case -1: 
                                    case 1: 
                                    case 2: {
                                        break;
                                    }
                                    default: {
                                        throw new RuntimeException("Invalid rc from showConfirmDialog: " + rc);
                                    }
                                }
                                break block6;
                            }
                            MainFrame.access$3900(MainFrame.this);
                        }
                    }
                });
            } else {
                MainFrame.access$3900(MainFrame.this);
            }
        }

        public void saveBeforeJavadoc() {
            Utilities.invokeLater(new Runnable(){

                public void run() {
                    ModelListener.access$13700(ModelListener.this, "To run Javadoc, you must first save ALL modified files.\nWould you like to save and then run Javadoc?", OptionConstants.ALWAYS_SAVE_BEFORE_JAVADOC, "Always save before running Javadoc");
                }
            });
        }

        private void _saveAllBeforeProceeding(String message, BooleanOption option, String checkMsg) {
            block5: {
                block6: {
                    if (!MainFrame.access$700(MainFrame.this).hasModifiedDocuments()) break block5;
                    if (DrJava.getConfig().getSetting(option).booleanValue()) break block6;
                    ConfirmCheckBoxDialog dialog = new ConfirmCheckBoxDialog(MainFrame.this, "Must Save All Files to Continue", message, checkMsg);
                    int rc = dialog.show();
                    switch (rc) {
                        case 0: {
                            MainFrame.access$2600(MainFrame.this);
                            if (dialog.getCheckBoxValue()) {
                                DrJava.getConfig().setSetting(option, Boolean.TRUE);
                                break;
                            }
                            break block5;
                        }
                        case -1: 
                        case 1: 
                        case 2: {
                            break;
                        }
                        default: {
                            throw new RuntimeException("Invalid rc from showConfirmDialog: " + rc);
                        }
                    }
                    break block5;
                }
                MainFrame.access$2600(MainFrame.this);
            }
        }

        public void saveUntitled() {
            MainFrame.access$2500(MainFrame.this);
        }

        public void filePathContainsPound() {
            Utilities.invokeLater(new Runnable(){

                public void run() {
                    String msg;
                    String title;
                    ConfirmCheckBoxDialog dialog;
                    if (DrJava.getConfig().getSetting(OptionConstants.WARN_PATH_CONTAINS_POUND).booleanValue() && (dialog = new ConfirmCheckBoxDialog(MainFrame.this, title = "Path Contains Pound Sign", msg = "Files whose paths contain the '#' symbol cannot be used in the\nInteractions Pane due to a bug in Java's file to URL conversion.\nIt is suggested that you change the name of the directory\ncontaining the '#' symbol.", "Do not show this message again", 2, -1)).show() == 0 && dialog.getCheckBoxValue()) {
                        DrJava.getConfig().setSetting(OptionConstants.WARN_PATH_CONTAINS_POUND, Boolean.FALSE);
                    }
                }
            });
        }

        public void nonTestCase(boolean isTestAll) {
            final String message = isTestAll ? "There are no open JUnit test cases.  Please make sure that:\n  - The documents containing tests have been compiled.\n  - They are subclasses of junit.framework.TestCase.\nFor more information on writing JUnit TestCases, view the\nJUnit chapter in the User Documentation." : "The current document is not a valid JUnit test case.\nPlease make sure that:\n  - This document has been compiled.\n  - It is a subclass of junit.framework.TestCase.\nFor more information on writing JUnit TestCases, view the\nJUnit chapter in the User Documentation.";
            Utilities.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    JOptionPane.showMessageDialog(MainFrame.this, message, "Test Works Only On JUnit TestCases", 0);
                    try {
                        MainFrame.this.showTab(MainFrame.access$9900(MainFrame.this));
                        MainFrame.access$13000(MainFrame.this).setEnabled(true);
                        MainFrame.access$13100(MainFrame.this).setEnabled(true);
                        MainFrame.access$9900(MainFrame.this).reset();
                    }
                    finally {
                        MainFrame.this.hourglassOff();
                        MainFrame.access$13200(MainFrame.this);
                    }
                }
            });
        }

        public void classFileError(ClassFileError e) {
            final String message = "The class file for class " + e.getClassName() + "in source file " + e.getCanonicalPath() + " cannot be loaded.\n " + "When DrJava tries to load it, the following error is generated:\n" + e.getError();
            Utilities.invokeLater(new Runnable(){

                public void run() {
                    JOptionPane.showMessageDialog(MainFrame.this, message, "Testing works only on well-formed, verifiable class files", 0);
                    MainFrame.this.showTab(MainFrame.access$9900(MainFrame.this));
                    MainFrame.access$13000(MainFrame.this).setEnabled(true);
                    MainFrame.access$13100(MainFrame.this).setEnabled(true);
                    MainFrame.access$9900(MainFrame.this).reset();
                }
            });
        }

        public void currentDirectoryChanged(File dir) {
            MainFrame.access$13800(MainFrame.this, dir);
        }

        public boolean canAbandonFile(OpenDefinitionsDocument doc) {
            return this._fileSaveHelper(doc, 1);
        }

        private boolean _fileSaveHelper(OpenDefinitionsDocument doc, int paneOption) {
            String text;
            String fname;
            OpenDefinitionsDocument lastActive = MainFrame.access$700(MainFrame.this).getActiveDocument();
            if (lastActive != doc) {
                MainFrame.access$700(MainFrame.this).setActiveDocument(doc);
            }
            boolean notFound = false;
            try {
                File file = doc.getFile();
                fname = file.getName();
                text = fname + " has been modified. Would you like to save it?";
            }
            catch (IllegalStateException ise) {
                fname = "Untitled file";
                text = "Untitled file has been modified. Would you like to save it?";
            }
            catch (FileMovedException fme) {
                fname = fme.getFile().getName();
                text = fname + " not found on disk. Would you like to save to another file?";
                notFound = true;
            }
            int rc = JOptionPane.showConfirmDialog(MainFrame.this, text, "Save " + fname + "?", paneOption);
            switch (rc) {
                case 0: {
                    boolean saved = false;
                    saved = notFound ? MainFrame.access$2500(MainFrame.this) : MainFrame.access$2300(MainFrame.this);
                    if (doc != lastActive) {
                        MainFrame.access$700(MainFrame.this).setActiveDocument(lastActive);
                    }
                    if (!saved) {
                        return false;
                    }
                    if (doc.isAuxiliaryFile() || MainFrame.access$700(MainFrame.this).isProjectActive() && doc.isInProjectPath()) {
                        try {
                            doc.getFile().getName();
                        }
                        catch (IllegalStateException ise) {
                            throw new UnexpectedException(ise);
                        }
                        catch (FileMovedException fme) {
                            throw new UnexpectedException(fme);
                        }
                    }
                    return true;
                }
                case 1: {
                    if (doc != lastActive) {
                        MainFrame.access$700(MainFrame.this).setActiveDocument(lastActive);
                    }
                    return true;
                }
                case -1: 
                case 2: {
                    return false;
                }
            }
            throw new RuntimeException("Invalid option: " + rc);
        }

        public void quitFile(OpenDefinitionsDocument doc) {
            this._fileSaveHelper(doc, 0);
        }

        public boolean shouldRevertFile(OpenDefinitionsDocument doc) {
            String fname;
            if (!MainFrame.access$700(MainFrame.this).getActiveDocument().equals(doc)) {
                MainFrame.access$700(MainFrame.this).setActiveDocument(doc);
            }
            try {
                File file = doc.getFile();
                fname = file.getName();
            }
            catch (IllegalStateException ise) {
                fname = "Untitled file";
            }
            catch (FileMovedException fme) {
                fname = fme.getFile().getName();
            }
            String text = fname + " has changed on disk. Would you like to reload it?\n" + "This will discard any changes you have made.";
            int rc = JOptionPane.showConfirmDialog(MainFrame.this, text, fname + " Modified on Disk", 0);
            switch (rc) {
                case 0: {
                    return true;
                }
                case 1: {
                    return false;
                }
                case -1: 
                case 2: {
                    return false;
                }
            }
            throw new RuntimeException("Invalid rc: " + rc);
        }

        public void interactionIncomplete() {
        }

        public void projectBuildDirChanged() {
            if (MainFrame.access$700(MainFrame.this).getBuildDirectory() != null) {
                MainFrame.access$13900(MainFrame.this).setEnabled(true);
            } else {
                MainFrame.access$13900(MainFrame.this).setEnabled(false);
            }
        }

        public void projectModified() {
        }

        public void projectClosed() {
            Utilities.invokeAndWait(new Runnable(){

                public void run() {
                    MainFrame.access$700(MainFrame.this).getDocumentNavigator().asContainer().addKeyListener(MainFrame.this._historyListener);
                    MainFrame.access$700(MainFrame.this).getDocumentNavigator().asContainer().addFocusListener(MainFrame.this._focusListenerForRecentDocs);
                    MainFrame.access$700(MainFrame.this).getDocumentNavigator().asContainer().addMouseListener(MainFrame.access$14000(MainFrame.this));
                    MainFrame.this.removeTab(MainFrame.access$9900(MainFrame.this));
                }
            });
        }

        public void projectOpened(File projectFile, FileOpenSelector files) {
            MainFrame.access$14100(MainFrame.this);
            MainFrame.access$14200(MainFrame.this).updateOpenFiles(projectFile);
            MainFrame.this.open(files);
            MainFrame.access$14300(MainFrame.this);
            MainFrame.access$700(MainFrame.this).getDocumentNavigator().asContainer().addKeyListener(MainFrame.this._historyListener);
            MainFrame.access$700(MainFrame.this).getDocumentNavigator().asContainer().addFocusListener(MainFrame.this._focusListenerForRecentDocs);
            MainFrame.access$700(MainFrame.this).getDocumentNavigator().asContainer().addMouseListener(MainFrame.access$14000(MainFrame.this));
        }

        public void projectRunnableChanged() {
            if (MainFrame.access$700(MainFrame.this).getMainClass() != null && MainFrame.access$700(MainFrame.this).getMainClass().exists()) {
                MainFrame.access$14400(MainFrame.this).setEnabled(true);
            } else {
                MainFrame.access$14400(MainFrame.this).setEnabled(false);
            }
        }

        public void documentNotFound(OpenDefinitionsDocument d, File f) {
            MainFrame.access$700(MainFrame.this).setProjectChanged(true);
            String text = "File " + f.getAbsolutePath() + "\ncould not be found on disk!  It was probably moved\n" + "or deleted.  Would you like to try to find it?";
            int rc = JOptionPane.showConfirmDialog(MainFrame.this, text, "File Moved or Deleted", 0);
            if (rc == 1) {
                return;
            }
            if (rc == 0) {
                try {
                    File[] opened = MainFrame.access$14500(MainFrame.this).getFiles();
                    d.setFile(opened[0]);
                }
                catch (OperationCanceledException oce) {
                    // empty catch block
                }
            }
        }

        ModelListener(1 x1) {
            this();
        }

        static void access$12300(ModelListener x0, OpenDefinitionsDocument x1) {
            x0._fileOpened(x1);
        }

        static void access$12400(ModelListener x0, OpenDefinitionsDocument x1) {
            x0._fileClosed(x1);
        }

        static void access$13700(ModelListener x0, String x1, BooleanOption x2, String x3) {
            x0._saveAllBeforeProceeding(x1, x2, x3);
        }
    }

    private class UIDebugListener
    implements DebugListener {
        private UIDebugListener() {
        }

        public void debuggerStarted() {
            MainFrame.this.showDebugger();
        }

        public void debuggerShutdown() {
            MainFrame.access$11200(MainFrame.this);
            MainFrame.this.hideDebugger();
            MainFrame.access$11300(MainFrame.this);
            List<OpenDefinitionsDocument> docs = MainFrame.access$700(MainFrame.this).getOpenDefinitionsDocuments();
            Iterator<OpenDefinitionsDocument> i$ = docs.iterator();
            while (i$.hasNext()) {
                OpenDefinitionsDocument doc = i$.next();
                doc.removeFromDebugger();
            }
        }

        public void currThreadSet(DebugThreadData dtd) {
        }

        public void threadLocationUpdated(final OpenDefinitionsDocument doc, final int lineNumber, final boolean shouldHighlight) {
            if (!MainFrame.access$700(MainFrame.this).getActiveDocument().equals(doc)) {
                MainFrame.access$700(MainFrame.this).setActiveDocument(doc);
            } else {
                MainFrame.access$700(MainFrame.this).refreshActiveDocument();
            }
            if (MainFrame.access$4700(MainFrame.this).getSize().getWidth() > 0.0 && MainFrame.access$4700(MainFrame.this).getSize().getHeight() > 0.0) {
                MainFrame.access$4700(MainFrame.this).centerViewOnLine(lineNumber);
                MainFrame.access$4700(MainFrame.this).requestFocusInWindow();
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (shouldHighlight) {
                        int endOffset;
                        MainFrame.access$11300(MainFrame.this);
                        int startOffset = doc.getOffset(lineNumber);
                        if (startOffset > -1 && (endOffset = doc.getLineEndPos(startOffset)) > -1) {
                            MainFrame.access$11402(MainFrame.this, MainFrame.access$4700(MainFrame.this).getHighlightManager().addHighlight(startOffset, endOffset, DefinitionsPane.THREAD_PAINTER));
                        }
                    }
                    if (doc.isModifiedSinceSave() && !MainFrame.access$4700(MainFrame.this).hasWarnedAboutModified()) {
                        MainFrame.access$11500(MainFrame.this);
                    }
                    if (shouldHighlight) {
                        MainFrame.access$6700(MainFrame.this).requestFocusInWindow();
                    }
                    MainFrame.this.showTab(MainFrame.access$6700(MainFrame.this));
                    MainFrame.access$11600(MainFrame.this);
                }
            });
        }

        public void breakpointSet(Breakpoint bp) {
            DefinitionsPane bpPane = MainFrame.this.getDefPaneGivenODD(bp.getDocument());
            MainFrame.access$11700(MainFrame.this).put(bp, bpPane.getHighlightManager().addHighlight(bp.getStartOffset(), bp.getEndOffset(), DefinitionsPane.BREAKPOINT_PAINTER));
            MainFrame.access$11600(MainFrame.this);
        }

        public void breakpointReached(Breakpoint bp) {
        }

        public void breakpointRemoved(Breakpoint bp) {
            HighlightManager.HighlightInfo highlight = (HighlightManager.HighlightInfo)MainFrame.access$11700(MainFrame.this).get(bp);
            if (highlight != null) {
                highlight.remove();
            }
            MainFrame.access$11700(MainFrame.this).remove(bp);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stepRequested() {
            Timer timer = MainFrame.access$11800(MainFrame.this);
            synchronized (timer) {
                if (!MainFrame.access$11800(MainFrame.this).isRunning()) {
                    MainFrame.access$11800(MainFrame.this).start();
                }
            }
        }

        public void currThreadSuspended() {
            MainFrame.access$11200(MainFrame.this);
            Runnable command = new Runnable(){

                public void run() {
                    MainFrame.access$11900(MainFrame.this, true);
                }
            };
            Utilities.invokeLater(command);
        }

        public void currThreadResumed() {
            MainFrame.access$11900(MainFrame.this, false);
            MainFrame.access$11300(MainFrame.this);
        }

        public void threadStarted() {
        }

        public void currThreadDied() {
            MainFrame.access$11200(MainFrame.this);
            if (MainFrame.this.inDebugMode()) {
                try {
                    if (!MainFrame.access$700(MainFrame.this).getDebugger().hasSuspendedThreads()) {
                        MainFrame.access$11900(MainFrame.this, false);
                        MainFrame.access$11300(MainFrame.this);
                        MainFrame.access$4800(MainFrame.this).moveToPrompt();
                    }
                }
                catch (DebugException de) {
                    MainFrame.access$12000(MainFrame.this, de, "Debugger Error", "Error with a thread in the debugger.");
                }
            }
        }

        public void nonCurrThreadDied() {
        }

        UIDebugListener(1 x1) {
            this();
        }
    }

    private static class GlassPane
    extends JComponent {
        public GlassPane() {
            this.addKeyListener(new KeyAdapter(){});
            this.addMouseListener(new MouseAdapter(){});
            super.setCursor(Cursor.getPredefinedCursor(3));
        }
    }

    private class PositionListener
    implements CaretListener {
        private PositionListener() {
        }

        public void caretUpdate(CaretEvent ce) {
            OpenDefinitionsDocument doc = MainFrame.access$700(MainFrame.this).getActiveDocument();
            doc.setCurrentLocation(ce.getDot());
            this.updateLocation();
        }

        public void updateLocation() {
            DefinitionsPane p = MainFrame.access$4700(MainFrame.this);
            MainFrame.access$9400(MainFrame.this).setText(p.getCurrentLine() + ":" + p.getCurrentCol() + "\t");
        }

        PositionListener(1 x1) {
            this();
        }
    }

    private class MenuBar
    extends JMenuBar {
        private MenuBar() {
        }

        public boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
            if (MainFrame.this.getAllowKeyEvents()) {
                return super.processKeyBinding(ks, e, condition, pressed);
            }
            return false;
        }

        MenuBar(1 x1) {
            this();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OddDisplayManager
    implements DisplayManager<OpenDefinitionsDocument> {
        private Icon _star;
        private FileDisplayManager _default;

        public OddDisplayManager(FileDisplayManager fdm, Icon star, Icon junitPass, Icon junitFail) {
            this._star = star;
            this._default = fdm;
        }

        @Override
        public Icon getIcon(OpenDefinitionsDocument odd) {
            File f = null;
            try {
                f = odd.getFile();
            }
            catch (IllegalStateException ise) {
            }
            catch (FileMovedException fileMovedException) {
                // empty catch block
            }
            if (odd.isModifiedSinceSave()) {
                return this.makeLayeredIcon(this._default.getIcon(f), this._star);
            }
            return this._default.getIcon(f);
        }

        @Override
        public String getName(OpenDefinitionsDocument doc) {
            return doc.getFilename();
        }

        private LayeredIcon makeLayeredIcon(Icon base, Icon star) {
            return new LayeredIcon(new Icon[]{base, star}, new int[]{0, 0}, new int[]{0, base.getIconHeight() / 4});
        }

        @Override
        public String getName(Object x0) {
            return this.getName((OpenDefinitionsDocument)x0);
        }

        @Override
        public Icon getIcon(Object x0) {
            return this.getIcon((OpenDefinitionsDocument)x0);
        }
    }

    private static class DJFileDisplayManager
    extends DefaultFileDisplayManager {
        private Icon _java;
        private Icon _dj0;
        private Icon _dj1;
        private Icon _dj2;
        private Icon _other;

        public DJFileDisplayManager(Icon java, Icon dj0, Icon dj1, Icon dj2, Icon other) {
            this._java = java;
            this._dj0 = dj0;
            this._dj1 = dj1;
            this._dj2 = dj2;
            this._other = other;
        }

        public Icon getIcon(File f) {
            if (f == null) {
                return this._other;
            }
            Icon ret = null;
            if (!f.isDirectory()) {
                String name = f.getName().toLowerCase();
                if (name.endsWith(".java")) {
                    ret = this._java;
                }
                if (name.endsWith(".dj0")) {
                    ret = this._dj0;
                }
                if (name.endsWith(".dj1")) {
                    ret = this._dj1;
                }
                if (name.endsWith(".dj2")) {
                    ret = this._dj2;
                }
            }
            if (ret == null && (ret = super.getIcon(f)).getIconHeight() < this._java.getIconHeight()) {
                ret = new CenteredIcon(ret, this._java.getIconWidth(), this._java.getIconHeight());
            }
            return ret;
        }

        public Icon getIcon(Object x0) {
            return this.getIcon((File)x0);
        }
    }
}

