/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.project;

import edu.rice.cs.drjava.project.DocFile;
import edu.rice.cs.drjava.project.MalformedProjectFileException;
import edu.rice.cs.drjava.project.ProjectFileIR;
import edu.rice.cs.util.Pair;
import edu.rice.cs.util.StringOps;
import edu.rice.cs.util.sexp.BoolAtom;
import edu.rice.cs.util.sexp.Cons;
import edu.rice.cs.util.sexp.Empty;
import edu.rice.cs.util.sexp.NumberAtom;
import edu.rice.cs.util.sexp.SEList;
import edu.rice.cs.util.sexp.SEListVisitor;
import edu.rice.cs.util.sexp.SExp;
import edu.rice.cs.util.sexp.SExpParseException;
import edu.rice.cs.util.sexp.SExpParser;
import edu.rice.cs.util.sexp.SExpVisitor;
import edu.rice.cs.util.sexp.TextAtom;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectFileParser {
    public static final ProjectFileParser ONLY = new ProjectFileParser();

    private ProjectFileParser() {
    }

    public ProjectFileIR parse(File projFile) throws IOException, FileNotFoundException, MalformedProjectFileException {
        List<SEList> forest = null;
        try {
            forest = SExpParser.parse(projFile);
        }
        catch (SExpParseException e) {
            throw new MalformedProjectFileException(new StringBuffer().append("Parse Error: ").append(e.getMessage()).toString());
        }
        ProjectFileIRImpl pfir = new ProjectFileIRImpl();
        try {
            for (SEList exp : forest) {
                this.evaluateExpression(exp, pfir, new FileListVisitor(projFile.getParent()));
            }
        }
        catch (PrivateProjectException e) {
            throw new MalformedProjectFileException(new StringBuffer().append("Parse Error: ").append(e.getMessage()).toString());
        }
        return pfir;
    }

    private void evaluateExpression(SEList e, ProjectFileIRImpl pfir, FileListVisitor flv) {
        if (e == Empty.ONLY) {
            return;
        }
        Cons exp = (Cons)e;
        String name = exp.accept(NameVisitor.ONLY);
        if (name.compareToIgnoreCase("source") == 0) {
            List<DocFile> fList = exp.getRest().accept(flv);
            pfir.setSourceFiles(fList);
        } else if (name.compareToIgnoreCase("auxiliary") == 0) {
            List<DocFile> fList = exp.getRest().accept(flv);
            pfir.setAuxiliaryFiles(fList);
        } else if (name.compareToIgnoreCase("collapsed") == 0) {
            List<String> sList = exp.getRest().accept(PathListVisitor.ONLY);
            pfir.setCollapsedPaths(sList);
        } else if (name.compareToIgnoreCase("build-dir") == 0) {
            List<DocFile> fList = exp.getRest().accept(flv);
            if (fList.size() > 1) {
                throw new PrivateProjectException("Cannot have multiple build directories");
            }
            if (fList.size() == 0) {
                pfir.setBuildDirectory(null);
            } else {
                pfir.setBuildDirectory(fList.get(0));
            }
        } else if (name.compareToIgnoreCase("classpaths") == 0) {
            List<DocFile> fList = exp.getRest().accept(flv);
            pfir.setClasspaths(fList);
        } else if (name.compareToIgnoreCase("main-class") == 0) {
            List<DocFile> fList = exp.getRest().accept(flv);
            if (fList.size() > 1) {
                throw new PrivateProjectException("Cannot have multiple main classes");
            }
            if (fList.size() == 0) {
                pfir.setMainClass(null);
            } else {
                pfir.setMainClass(fList.get(0));
            }
        } else if (name.compareToIgnoreCase("proj-root") == 0) {
            List<DocFile> fList = exp.getRest().accept(flv);
            if (fList.size() > 1) {
                throw new PrivateProjectException("Cannot have multiple project roots");
            }
            if (fList.size() == 0) {
                pfir.setProjectRoot(null);
            } else {
                pfir.setProjectRoot(fList.get(0));
            }
        }
    }

    DocFile parseFile(SExp s, String parentDir) {
        String name = s.accept(NameVisitor.ONLY);
        if (name.compareToIgnoreCase("file") != 0) {
            throw new PrivateProjectException(new StringBuffer().append("Expected a file tag, found: ").append(name).toString());
        }
        if (!(s instanceof Cons)) {
            throw new PrivateProjectException(new StringBuffer().append("Expected a labeled node, found a label: ").append(name).toString());
        }
        SEList c = ((Cons)s).getRest();
        FilePropertyVisitor v = new FilePropertyVisitor(parentDir);
        return c.accept(v);
    }

    private String parseFileName(SExp s) {
        if (s instanceof Cons) {
            SEList l = ((Cons)s).getRest();
            if (l == Empty.ONLY) {
                throw new PrivateProjectException("expected filename, but nothing found");
            }
            String name = l.accept(NameVisitor.ONLY);
            name = StringOps.replace(name, "\\", "/");
            return name;
        }
        throw new PrivateProjectException("expected name tag, found string");
    }

    private Pair<Integer, Integer> parseIntPair(SExp s) {
        if (!(s instanceof Cons)) {
            throw new PrivateProjectException("expected name tag, found string");
        }
        final ArrayList intList = new ArrayList();
        SEList l = ((Cons)s).getRest();
        List<Integer> li = l.accept(new SExpVisitor<List<Integer>>(){

            @Override
            public List<Integer> forEmpty(Empty e) {
                return intList;
            }

            @Override
            public List<Integer> forCons(Cons c) {
                c.getFirst().accept(this);
                return c.getRest().accept(this);
            }

            @Override
            public List<Integer> forBoolAtom(BoolAtom b) {
                throw new PrivateProjectException("unexpected boolean found, int expected");
            }

            @Override
            public List<Integer> forNumberAtom(NumberAtom n) {
                intList.add(new Integer(n.intValue()));
                return intList;
            }

            @Override
            public List<Integer> forTextAtom(TextAtom t) {
                throw new PrivateProjectException(new StringBuffer().append("unexpected string found where number expected: ").append(t.getText()).toString());
            }

            @Override
            public Object forTextAtom(TextAtom x0) {
                return this.forTextAtom(x0);
            }

            @Override
            public Object forNumberAtom(NumberAtom x0) {
                return this.forNumberAtom(x0);
            }

            @Override
            public Object forBoolAtom(BoolAtom x0) {
                return this.forBoolAtom(x0);
            }

            @Override
            public Object forCons(Cons x0) {
                return this.forCons(x0);
            }

            @Override
            public Object forEmpty(Empty x0) {
                return this.forEmpty(x0);
            }
        });
        if (li.size() == 2) {
            return new Pair<Integer, Integer>(li.get(0), li.get(1));
        }
        throw new PrivateProjectException(new StringBuffer().append("expected a list of 2 ints for select, found list of size ").append(li.size()).toString());
    }

    private String parseStringNode(SExp n) {
        if (n instanceof Cons) {
            return ((Cons)n).getRest().accept(NameVisitor.ONLY);
        }
        throw new PrivateProjectException("List expected, but found text instead");
    }

    static String access$000(ProjectFileParser x0, SExp x1) {
        return x0.parseFileName(x1);
    }

    static Pair access$100(ProjectFileParser x0, SExp x1) {
        return x0.parseIntPair(x1);
    }

    static String access$200(ProjectFileParser x0, SExp x1) {
        return x0.parseStringNode(x1);
    }

    private static class PrivateProjectException
    extends RuntimeException {
        public PrivateProjectException(String message) {
            super(message);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ProjectFileIRImpl
    implements ProjectFileIR {
        List<DocFile> _src = new ArrayList<DocFile>();
        List<DocFile> _aux = new ArrayList<DocFile>();
        List<String> _collapsed = new ArrayList<String>();
        File _buildDir = null;
        List<? extends File> _classpaths = new ArrayList<File>();
        File _mainClass = null;
        File _projRoot = null;

        @Override
        public DocFile[] getSourceFiles() {
            return this._src.toArray(new DocFile[0]);
        }

        @Override
        public DocFile[] getAuxiliaryFiles() {
            return this._aux.toArray(new DocFile[0]);
        }

        @Override
        public String[] getCollapsedPaths() {
            return this._collapsed.toArray(new String[0]);
        }

        @Override
        public File[] getClasspaths() {
            return this._classpaths.toArray(new File[0]);
        }

        @Override
        public File getBuildDirectory() {
            return this._buildDir;
        }

        @Override
        public File getMainClass() {
            return this._mainClass;
        }

        @Override
        public File getProjectRoot() {
            return this._projRoot;
        }

        void setSourceFiles(List<DocFile> src) {
            this._src = src;
        }

        void setAuxiliaryFiles(List<DocFile> aux) {
            this._aux = aux;
        }

        void setCollapsedPaths(List<String> path) {
            this._collapsed = path;
        }

        void setClasspaths(List<DocFile> cp) {
            this._classpaths = cp;
        }

        void setBuildDirectory(File dir) {
            this._buildDir = dir;
        }

        void setMainClass(File main) {
            this._mainClass = main;
        }

        void setProjectRoot(File root) {
            this._projRoot = root;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     * Duplicate member names - consider using --renamedupmembers true
     */
    private static class NameVisitor
    implements SExpVisitor<String> {
        public static final NameVisitor ONLY = new NameVisitor();

        private NameVisitor() {
        }

        @Override
        public String forEmpty(Empty e) {
            throw new PrivateProjectException("Found an empty node, expected a labeled node");
        }

        @Override
        public String forCons(Cons c) {
            return c.getFirst().accept(this);
        }

        @Override
        public String forBoolAtom(BoolAtom b) {
            throw new PrivateProjectException("Found a boolean, expected a label");
        }

        @Override
        public String forNumberAtom(NumberAtom n) {
            throw new PrivateProjectException("Found a number, expected a label");
        }

        @Override
        public String forTextAtom(TextAtom t) {
            return t.getText();
        }

        @Override
        public Object forTextAtom(TextAtom x0) {
            return this.forTextAtom(x0);
        }

        @Override
        public Object forNumberAtom(NumberAtom x0) {
            return this.forNumberAtom(x0);
        }

        @Override
        public Object forBoolAtom(BoolAtom x0) {
            return this.forBoolAtom(x0);
        }

        @Override
        public Object forCons(Cons x0) {
            return this.forCons(x0);
        }

        @Override
        public Object forEmpty(Empty x0) {
            return this.forEmpty(x0);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PathListVisitor
    implements SEListVisitor<List<String>> {
        public static final PathListVisitor ONLY = new PathListVisitor();

        private PathListVisitor() {
        }

        @Override
        public List<String> forEmpty(Empty e) {
            return new ArrayList<String>();
        }

        @Override
        public List<String> forCons(Cons c) {
            List<String> list = c.getRest().accept(this);
            SExp first = c.getFirst();
            String name = first.accept(NameVisitor.ONLY);
            if (name.compareToIgnoreCase("path") == 0) {
                String tmp = ProjectFileParser.access$200(ONLY, c.getFirst());
                list.add(0, tmp);
            }
            return list;
        }

        @Override
        public Object forCons(Cons x0) {
            return this.forCons(x0);
        }

        @Override
        public Object forEmpty(Empty x0) {
            return this.forEmpty(x0);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     * Duplicate member names - consider using --renamedupmembers true
     */
    private static class FilePropertyVisitor
    implements SEListVisitor<DocFile> {
        private String fname = "";
        private Pair<Integer, Integer> select = new Pair<Integer, Integer>(new Integer(0), new Integer(0));
        private Pair<Integer, Integer> scroll = new Pair<Integer, Integer>(new Integer(0), new Integer(0));
        private boolean active = false;
        private String pack = "";
        private Date modDate = null;
        private String _parentDir;

        public FilePropertyVisitor(String parentDir) {
            this._parentDir = parentDir;
        }

        @Override
        public DocFile forCons(Cons c) {
            String name = c.getFirst().accept(NameVisitor.ONLY);
            if (name.compareToIgnoreCase("name") == 0) {
                this.fname = ProjectFileParser.access$000(ONLY, c.getFirst());
            } else if (name.compareToIgnoreCase("select") == 0) {
                this.select = ProjectFileParser.access$100(ONLY, c.getFirst());
            } else if (name.compareToIgnoreCase("scroll") == 0) {
                this.scroll = ProjectFileParser.access$100(ONLY, c.getFirst());
            } else if (name.compareToIgnoreCase("active") == 0) {
                this.active = true;
            } else if (name.compareToIgnoreCase("package") == 0) {
                this.pack = ProjectFileParser.access$200(ONLY, c.getFirst());
            } else if (name.compareToIgnoreCase("mod-date") == 0) {
                String tmp = ProjectFileParser.access$200(ONLY, c.getFirst());
                try {
                    this.modDate = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss").parse(tmp);
                }
                catch (ParseException e) {
                    throw new PrivateProjectException(new StringBuffer().append("Bad mod-date: ").append(e.getMessage()).toString());
                }
            }
            return c.getRest().accept(this);
        }

        @Override
        public DocFile forEmpty(Empty c) {
            if (this._parentDir == null || new File(this.fname).isAbsolute()) {
                return new DocFile(this.fname, this.select, this.scroll, this.active, this.pack);
            }
            DocFile f = new DocFile(this._parentDir, this.fname, this.select, this.scroll, this.active, this.pack);
            if (this.modDate != null) {
                f.setSavedModDate(this.modDate.getTime());
            }
            return f;
        }

        @Override
        public Object forCons(Cons x0) {
            return this.forCons(x0);
        }

        @Override
        public Object forEmpty(Empty x0) {
            return this.forEmpty(x0);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FileListVisitor
    implements SEListVisitor<List<DocFile>> {
        String _parentDir;

        public FileListVisitor(String parent) {
            this._parentDir = parent;
        }

        @Override
        public List<DocFile> forEmpty(Empty e) {
            return new ArrayList<DocFile>();
        }

        @Override
        public List<DocFile> forCons(Cons c) {
            List<DocFile> list = c.getRest().accept(this);
            DocFile tmp = ONLY.parseFile(c.getFirst(), this._parentDir);
            list.add(0, tmp);
            return list;
        }

        @Override
        public Object forCons(Cons x0) {
            return this.forCons(x0);
        }

        @Override
        public Object forEmpty(Empty x0) {
            return this.forEmpty(x0);
        }
    }
}

