/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.plugins.eclipse;

import java.io.IOException;
import java.net.URL;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.ILibrary;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class EclipsePlugin
extends AbstractUIPlugin {
    private static EclipsePlugin _plugin;
    private ResourceBundle _resourceBundle;

    public EclipsePlugin() {
        _plugin = this;
        try {
            this._resourceBundle = ResourceBundle.getBundle("edu.rice.cs.drjava.plugins.eclipse.EclipsePluginResources");
        }
        catch (MissingResourceException x) {
            this._resourceBundle = null;
        }
    }

    public static EclipsePlugin getDefault() {
        return _plugin;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = EclipsePlugin.getDefault().getResourceBundle();
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        return this._resourceBundle;
    }

    public String getPluginClasspath() throws IOException {
        URL installURL = this.getDescriptor().getInstallURL();
        String installDir = Platform.resolve((URL)installURL).getPath();
        String pathSep = System.getProperty("path.separator");
        String fileSep = System.getProperty("file.separator");
        StringBuffer buf = new StringBuffer();
        ILibrary[] libs = this.getDescriptor().getRuntimeLibraries();
        for (int i = 0; i < libs.length; ++i) {
            buf.append(installDir);
            buf.append(fileSep);
            buf.append(libs[i].getPath().toOSString());
            buf.append(pathSep);
        }
        return buf.toString();
    }

    protected void initializeDefaultPreferences(IPreferenceStore store) {
        store.setDefault("interactions.reset.prompt", true);
        store.setDefault("allow.private.access", false);
        store.setDefault("interactions.exit.prompt", true);
        store.setDefault("history.max.size", 500);
        store.setDefault("jvm.args", "");
    }
}

