/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.definitions.reducedmodel;

import edu.rice.cs.drjava.model.definitions.reducedmodel.Brace;
import edu.rice.cs.drjava.model.definitions.reducedmodel.Gap;
import edu.rice.cs.drjava.model.definitions.reducedmodel.ModelList;
import edu.rice.cs.drjava.model.definitions.reducedmodel.ReducedModelState;
import edu.rice.cs.drjava.model.definitions.reducedmodel.ReducedModelStates;
import edu.rice.cs.drjava.model.definitions.reducedmodel.ReducedToken;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TokenList
extends ModelList<ReducedToken>
implements ReducedModelStates {
    public Iterator _getIterator() {
        return new Iterator();
    }

    public class Iterator
    extends ModelList.Iterator {
        private int _offset;

        public Iterator() {
            this._offset = 0;
        }

        Iterator(Iterator that) {
            TokenList tokenList2 = TokenList.this;
            tokenList2.getClass();
            super(that);
            this._offset = that.getBlockOffset();
        }

        public Iterator _copy() {
            return new Iterator(this);
        }

        public void setTo(Iterator that) {
            super.setTo(that);
            this._offset = that.getBlockOffset();
        }

        public int getBlockOffset() {
            return this._offset;
        }

        public void setBlockOffset(int offset) {
            this._offset = offset;
        }

        public ReducedModelState getStateAtCurrent() {
            if (this.atFirstItem() || this.atStart() || TokenList.this.isEmpty()) {
                return ReducedModelStates.FREE;
            }
            if (((ReducedToken)this.prevItem()).isLineComment() || ((ReducedToken)this.prevItem()).getState() == ReducedModelStates.INSIDE_LINE_COMMENT) {
                return ReducedModelStates.INSIDE_LINE_COMMENT;
            }
            if (((ReducedToken)this.prevItem()).isBlockCommentStart() || ((ReducedToken)this.prevItem()).getState() == ReducedModelStates.INSIDE_BLOCK_COMMENT) {
                return ReducedModelStates.INSIDE_BLOCK_COMMENT;
            }
            if (((ReducedToken)this.prevItem()).isDoubleQuote() && ((ReducedToken)this.prevItem()).isOpen() && ((ReducedToken)this.prevItem()).getState() == ReducedModelStates.FREE || ((ReducedToken)this.prevItem()).getState() == ReducedModelStates.INSIDE_DOUBLE_QUOTE) {
                return ReducedModelStates.INSIDE_DOUBLE_QUOTE;
            }
            if (((ReducedToken)this.prevItem()).isSingleQuote() && ((ReducedToken)this.prevItem()).isOpen() && ((ReducedToken)this.prevItem()).getState() == ReducedModelStates.FREE || ((ReducedToken)this.prevItem()).getState() == ReducedModelStates.INSIDE_SINGLE_QUOTE) {
                return ReducedModelStates.INSIDE_SINGLE_QUOTE;
            }
            return ReducedModelStates.FREE;
        }

        void insertBraceToGap(String text) {
            ((ReducedToken)this.current()).shrink(this.getBlockOffset());
            this.insert(Brace.MakeBrace(text, this.getStateAtCurrent()));
            if (this.getBlockOffset() > 0) {
                this.insert(new Gap(this.getBlockOffset(), this.getStateAtCurrent()));
                this.next();
            }
            this.next();
            this.setBlockOffset(0);
        }

        void insertNewBrace(String text) {
            this.insert(Brace.MakeBrace(text, this.getStateAtCurrent()));
            this.next();
            this.setBlockOffset(0);
        }

        void _splitCurrentIfCommentBlock(boolean splitClose, boolean splitEscape) {
            String type = ((ReducedToken)this.current()).getType();
            if (type.equals("//") || type.equals("/*") || splitClose && type.equals("*/") || splitEscape && type.equals("\\\\") || splitEscape && type.equals("\\\"") || splitEscape && type.equals("\\'")) {
                String first = type.substring(0, 1);
                String second = type.substring(1, 2);
                ((ReducedToken)this.current()).setType(first);
                ReducedModelState oldState = ((ReducedToken)this.current()).getState();
                this.next();
                this.insert(Brace.MakeBrace(second, oldState));
                this.prev();
            }
        }

        void updateBasedOnCurrentState() {
            if (this.atStart()) {
                this.next();
            }
            if (this.atEnd()) {
                return;
            }
            ReducedModelState curState = this.getStateAtCurrent();
            while (!this.atEnd()) {
                curState = curState.update(this);
            }
        }

        public void move(int count) {
            this._offset = this._move(count, this._offset);
        }

        private int _move(int count, int currentOffset) {
            int retval = currentOffset;
            if (count == 0) {
                return retval;
            }
            Iterator it = this._copy();
            retval = count > 0 ? it._moveRight(count, currentOffset) : it._moveLeft(Math.abs(count), currentOffset);
            this.setTo(it);
            it.dispose();
            return retval;
        }

        private int _moveRight(int count, int currentOffset) {
            if (this.atStart()) {
                currentOffset = 0;
                this.next();
            }
            if (this.atEnd()) {
                throw new IllegalArgumentException("At end");
            }
            while (count >= ((ReducedToken)this.current()).getSize() - currentOffset) {
                count = count - ((ReducedToken)this.current()).getSize() + currentOffset;
                this.next();
                currentOffset = 0;
                if (!this.atEnd()) continue;
                if (count == 0) break;
                throw new IllegalArgumentException("Moved into tail");
            }
            return count + currentOffset;
        }

        private int _moveLeft(int count, int currentOffset) {
            if (this.atEnd()) {
                this.prev();
                if (!this.atStart()) {
                    currentOffset = ((ReducedToken)this.current()).getSize();
                }
            }
            if (this.atStart()) {
                throw new IllegalArgumentException("At Start");
            }
            while (count > currentOffset) {
                count -= currentOffset;
                this.prev();
                if (this.atStart()) {
                    if (count > 0) {
                        throw new IllegalArgumentException("At Start");
                    }
                    this.next();
                    currentOffset = 0;
                    continue;
                }
                currentOffset = ((ReducedToken)this.current()).getSize();
            }
            return currentOffset - count;
        }

        public void delete(int count) {
            if (count == 0) {
                return;
            }
            Iterator copyCursor = this._copy();
            this._offset = this._delete(count, copyCursor);
            copyCursor.dispose();
        }

        private int _delete(int count, Iterator copyCursor) {
            try {
                if (count > 0) {
                    copyCursor.move(count);
                } else {
                    this.move(count);
                }
                return this.deleteRight(copyCursor);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Trying to delete past end of file.");
            }
        }

        void clipLeft() {
            if (this.atStart()) {
                return;
            }
            if (this.getBlockOffset() == 0) {
                this.remove();
            } else if (((ReducedToken)this.current()).isGap()) {
                int size = ((ReducedToken)this.current()).getSize();
                ((ReducedToken)this.current()).shrink(size - this.getBlockOffset());
            } else if (((ReducedToken)this.current()).isMultipleCharBrace()) {
                if (this.getBlockOffset() != 1) {
                    throw new IllegalArgumentException("Offset incorrect");
                }
                String type = ((ReducedToken)this.current()).getType();
                String first = type.substring(0, 1);
                ((ReducedToken)this.current()).setType(first);
            } else {
                throw new IllegalArgumentException("Cannot clip left.");
            }
        }

        void clipRight() {
            if (this.atEnd()) {
                return;
            }
            if (this.getBlockOffset() == 0) {
                return;
            }
            if (this.getBlockOffset() == ((ReducedToken)this.current()).getSize()) {
                this.remove();
            } else if (((ReducedToken)this.current()).isGap()) {
                ((ReducedToken)this.current()).shrink(this.getBlockOffset());
            } else if (((ReducedToken)this.current()).isMultipleCharBrace()) {
                if (this.getBlockOffset() != 1) {
                    throw new IllegalArgumentException("Offset incorrect");
                }
                String type = ((ReducedToken)this.current()).getType();
                String second = type.substring(1, 2);
                ((ReducedToken)this.current()).setType(second);
            } else {
                throw new IllegalArgumentException("Cannot clip left.");
            }
        }

        int deleteRight(Iterator delTo) {
            this.collapse(delTo);
            if (this.eq(delTo) && ((ReducedToken)this.current()).isGap()) {
                ((ReducedToken)this.current()).shrink(delTo.getBlockOffset() - this.getBlockOffset());
                return this.getBlockOffset();
            }
            if (!this.eq(delTo)) {
                this.clipLeft();
            }
            delTo.clipRight();
            if (!this.atStart()) {
                this.prev();
            }
            if (delTo.atEnd()) {
                this.setTo(delTo);
                return 0;
            }
            int delToSizeCurr = ((ReducedToken)delTo.current()).getSize();
            String delToTypeCurr = ((ReducedToken)delTo.current()).getType();
            delTo.prev();
            if (delTo.atStart()) {
                delTo.next();
                this.setTo(delTo);
                return 0;
            }
            int delToSizePrev = ((ReducedToken)delTo.current()).getSize();
            String delToTypePrev = ((ReducedToken)delTo.current()).getType();
            delTo.next();
            int temp = this._calculateOffset(delToSizePrev, delToTypePrev, delToSizeCurr, delToTypeCurr, delTo);
            this.setTo(delTo);
            return temp;
        }

        private int _calculateOffset(int delToSizePrev, String delToTypePrev, int delToSizeCurr, String delToTypeCurr, Iterator delTo) {
            int offset;
            int delToSizeChange = ((ReducedToken)delTo.current()).getSize();
            if (delTo.atEnd()) {
                throw new IllegalArgumentException("Shouldn't happen");
            }
            if (((ReducedToken)delTo.current()).isGap()) {
                return delToSizeChange - delToSizeCurr;
            }
            if (delToTypePrev.equals("/") && (delToTypeCurr.equals("/*") && this._checkPrevEquals(delTo, "//") || delToTypeCurr.equals("//") && this._checkPrevEquals(delTo, "//")) || delToTypePrev.equals("*") && (delToTypeCurr.equals("/*") && this._checkPrevEquals(delTo, "*/") || delToTypeCurr.equals("//") && this._checkPrevEquals(delTo, "*/")) || delToTypePrev.equals("\\") && (delToTypeCurr.equals("\\\\") && this._checkPrevEquals(delTo, "\\") || delToTypeCurr.equals("\\'") && this._checkPrevEquals(delTo, "'") || delToTypeCurr.equals("\\\"") && this._checkPrevEquals(delTo, "\""))) {
                delTo.prev();
                offset = 1;
            } else {
                offset = delToTypePrev.equals("/") && (delToTypeCurr.equals("*/") && ((ReducedToken)delTo.current()).getType().equals("/*") || delToTypeCurr.equals("*") && ((ReducedToken)delTo.current()).getType().equals("/*") || delToTypeCurr.equals("/") && ((ReducedToken)delTo.current()).getType().equals("//")) || delToTypePrev.equals("*") && delToTypeCurr.equals("/") && ((ReducedToken)delTo.current()).getType().equals("*/") || delToTypePrev.equals("\\") && (delToTypeCurr.equals("\\") && ((ReducedToken)delTo.current()).getType().equals("\\\\") || delToTypeCurr.equals("'") && ((ReducedToken)delTo.current()).getType().equals("\\'") || delToTypeCurr.equals("\"") && ((ReducedToken)delTo.current()).getType().equals("\\\"")) ? 1 : 0;
            }
            return offset;
        }

        private boolean _checkPrevEquals(Iterator delTo, String match) {
            if (delTo.atFirstItem() || delTo.atStart()) {
                return false;
            }
            return ((ReducedToken)delTo.prevItem()).getType().equals(match);
        }

        public String toString() {
            return "" + this.current();
        }
    }
}

