/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.compiler;

import java.io.File;
import java.io.Serializable;

public class CompilerError
implements Comparable,
Serializable {
    private File _file;
    private int _lineNumber;
    private int _startColumn;
    private String _message;
    private boolean _isWarning;
    private boolean _noLocation;

    public CompilerError(File file, int lineNumber, int startColumn, String message, boolean isWarning) {
        this._file = file;
        this._lineNumber = lineNumber;
        this._startColumn = startColumn;
        this._message = message;
        this._isWarning = isWarning;
        if (lineNumber < 0) {
            this._noLocation = true;
        }
    }

    public CompilerError(File file, String message, boolean isWarning) {
        this(file, -1, -1, message, isWarning);
    }

    public CompilerError(String message, boolean isWarning) {
        this(null, message, isWarning);
    }

    public boolean hasNoLocation() {
        return this._noLocation;
    }

    public String toString() {
        return this.getClass().toString() + "(file=" + this.fileName() + ", line=" + this._lineNumber + ", col=" + this._startColumn + ", msg=" + this._message + ")";
    }

    public File file() {
        return this._file;
    }

    public String fileName() {
        if (this._file == null) {
            return "";
        }
        return this._file.getAbsolutePath();
    }

    public int lineNumber() {
        return this._lineNumber;
    }

    public int startColumn() {
        return this._startColumn;
    }

    public String message() {
        return this._message;
    }

    public String getFileMessage() {
        if (this._file == null) {
            return "(no associated file)";
        }
        return this.fileName();
    }

    public String getLineMessage() {
        if (this._file == null || this._lineNumber < 0) {
            return "(no source location)";
        }
        return "" + (this._lineNumber + 1);
    }

    public boolean isWarning() {
        return this._isWarning;
    }

    public int compareTo(Object o) {
        CompilerError other = (CompilerError)o;
        if (this._file != null) {
            if (other.file() == null) {
                return 1;
            }
            int fileComp = this._file.compareTo(other.file());
            if (fileComp != 0) {
                return fileComp;
            }
            return this.compareByPosition(other);
        }
        if (other.file() == null) {
            return this.isWarning() ? (other.isWarning() ? 0 : 1) : (other.isWarning() ? -1 : 0);
        }
        return -1;
    }

    private int compareByPosition(CompilerError other) {
        if (this._lineNumber == other._lineNumber) {
            int byCol = this._startColumn - other._startColumn;
            return this.isWarning() ? (other.isWarning() ? byCol : 1) : (other.isWarning() ? -1 : byCol);
        }
        return this._lineNumber - other._lineNumber;
    }
}

