/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.config;

import edu.rice.cs.drjava.config.Option;
import edu.rice.cs.drjava.config.OptionListener;
import edu.rice.cs.drjava.config.OptionMap;
import edu.rice.cs.drjava.config.OptionMapLoader;
import edu.rice.cs.util.swing.Utilities;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Configuration {
    protected OptionMap map;
    protected Exception _startupException;

    public Configuration(OptionMap om) {
        this.map = om;
        this._startupException = null;
    }

    public <T> T setSetting(final Option<T> op, final T value) {
        T ret = this.map.setOption(op, value);
        Utilities.invokeAndWait(new Runnable(){

            public void run() {
                op.notifyListeners(Configuration.this, value);
            }
        });
        return ret;
    }

    public <T> T getSetting(Option<T> op) {
        return this.map.getOption(op);
    }

    public <T> void addOptionListener(Option<T> op, OptionListener<T> l) {
        op.addListener(this, l);
    }

    public <T> void removeOptionListener(Option<T> op, OptionListener<T> l) {
        op.removeListener(this, l);
    }

    public void resetToDefaults() {
        OptionMapLoader.DEFAULT.loadInto(this.map);
    }

    public boolean hadStartupException() {
        return this._startupException != null;
    }

    public Exception getStartupException() {
        return this._startupException;
    }

    public void storeStartupException(Exception e) {
        this._startupException = e;
    }

    public String toString() {
        return this.map.toString();
    }
}

