/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.ui.simplegui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.event.MouseInputListener;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import net.yura.domination.engine.ColorUtil;
import net.yura.domination.engine.Risk;
import net.yura.domination.engine.RiskAdapter;
import net.yura.domination.engine.RiskUIUtil;
import net.yura.domination.engine.RiskUtil;
import net.yura.domination.engine.guishared.AboutDialog;
import net.yura.domination.engine.guishared.PicturePanel;
import net.yura.domination.engine.guishared.RiskFileFilter;

public class RiskGUI
extends JFrame
implements MouseInputListener {
    private static final String version = "1.1.1.1";
    private static final String product = "Simple GUI for RISK";
    private JTextPane Console;
    private StyledDocument doc;
    private JTextField Command;
    private JButton Submit;
    private PicturePanel pp;
    private JLabel statusBar;
    private JLabel gameStatus;
    private JScrollPane Con;
    private Risk risk;
    private Vector history;
    private int pointer;
    private String temptext;
    private JPanel guiMain;
    private JPanel gp;
    private JLabel Pix;
    private JComboBox mapViewComboBox;

    public RiskGUI(Risk r) {
        this.risk = r;
        RiskAdapter SimpleRiskAdapter = new RiskAdapter(){

            public void sendMessage(String output, boolean redrawNeeded, boolean repaintNeeded) {
                Style style = RiskGUI.this.doc.addStyle("StyleName", null);
                int c = RiskGUI.this.risk.getCurrentPlayerColor();
                if (c != 0) {
                    StyleConstants.setForeground(style, new Color(c).darker());
                } else {
                    StyleConstants.setForeground(style, Color.black);
                }
                try {
                    RiskGUI.this.doc.insertString(RiskGUI.this.doc.getLength(), output + System.getProperty("line.separator"), style);
                    RiskGUI.this.Console.setCaretPosition(RiskGUI.this.doc.getLength());
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (redrawNeeded) {
                    RiskGUI.this.pprepaintCountries();
                }
                if (repaintNeeded) {
                    RiskGUI.this.repaint();
                }
            }

            public void needInput(int s) {
                RiskGUI.this.Submit.setEnabled(true);
                RiskGUI.this.Command.setEnabled(true);
                RiskGUI.this.Command.requestFocus();
                RiskGUI.this.statusBar.setText("Done... Ready");
            }

            public void noInput() {
                RiskGUI.this.statusBar.setText("Working...");
                RiskGUI.this.Submit.setEnabled(false);
                RiskGUI.this.Command.setEnabled(false);
            }

            public void setGameStatus(String state) {
                RiskGUI.this.gameStatus.setText(state);
                RiskGUI.this.gameStatus.repaint();
            }

            public void startGame(boolean s) {
                RiskGUI.this.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    RiskGUI.this.pp.load();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                RiskGUI.this.mapViewComboBox.setSelectedIndex(0);
                RiskGUI.this.guiMain.remove(RiskGUI.this.Pix);
                RiskGUI.this.guiMain.add((Component)RiskGUI.this.gp, "Center");
                RiskGUI.this.setCursor(Cursor.getPredefinedCursor(0));
            }

            public void closeGame() {
                RiskGUI.this.guiMain.remove(RiskGUI.this.gp);
                RiskGUI.this.guiMain.add((Component)RiskGUI.this.Pix, "Center");
            }
        };
        this.gameStatus = new JLabel("");
        this.risk.addRiskListener(SimpleRiskAdapter);
        this.history = new Vector();
        this.pointer = -1;
        this.Console = new JTextPane();
        this.doc = (StyledDocument)this.Console.getDocument();
        this.Command = new JTextField();
        this.Submit = new JButton();
        this.Pix = new JLabel();
        URL about = this.getClass().getResource("about.png");
        if (about != null) {
            this.Pix.setIcon(new ImageIcon(about));
        } else {
            System.out.println("WARN: no about.png image found");
        }
        this.pp = new PicturePanel(this.risk);
        this.gp = new GamePanel();
        this.statusBar = new JLabel("Loading...");
        this.Con = new JScrollPane(this.Console);
        this.initGUI();
        this.setResizable(false);
        this.pack();
        this.statusBar.setText("Ready");
    }

    private void initGUI() {
        this.setTitle(product);
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(AboutDialog.class.getResource("icon.gif")));
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(3, 3, 3, 3);
        Dimension ppSize = new Dimension(677, 425);
        this.pp.setPreferredSize(ppSize);
        this.pp.setMinimumSize(ppSize);
        this.pp.setMaximumSize(ppSize);
        this.pp.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0), 1));
        this.pp.addMouseListener(this);
        this.pp.addMouseMotionListener(this);
        this.Console.setText("");
        this.Console.setEditable(false);
        this.Con.setVerticalScrollBarPolicy(22);
        this.Con.setPreferredSize(new Dimension(677, 100));
        this.Con.setMinimumSize(new Dimension(677, 100));
        this.Command.setPreferredSize(new Dimension(600, 20));
        this.Command.setMinimumSize(new Dimension(600, 20));
        this.Command.setMaximumSize(new Dimension(600, 20));
        this.Submit.setText("Submit");
        this.guiMain = new JPanel();
        Dimension guiMainSize = new Dimension(677, 455);
        this.guiMain.setPreferredSize(guiMainSize);
        this.guiMain.setMinimumSize(guiMainSize);
        this.guiMain.setMaximumSize(guiMainSize);
        this.guiMain.setLayout(new BorderLayout());
        this.guiMain.add((Component)this.Pix, "Center");
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        c.gridheight = 2;
        this.getContentPane().add((Component)this.guiMain, c);
        c.fill = 1;
        c.gridx = 1;
        c.gridy = 3;
        c.gridwidth = 1;
        c.gridheight = 1;
        this.getContentPane().add((Component)this.Submit, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 2;
        c.gridheight = 1;
        this.getContentPane().add((Component)this.Con, c);
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 1;
        c.gridheight = 1;
        this.getContentPane().add((Component)this.Command, c);
        c.gridx = 0;
        c.gridy = 4;
        c.gridwidth = 1;
        c.gridheight = 1;
        this.getContentPane().add((Component)this.gameStatus, c);
        c.gridx = 1;
        c.gridy = 4;
        c.gridwidth = 1;
        c.gridheight = 1;
        this.getContentPane().add((Component)this.statusBar, c);
        ActionListener readCommand = new ActionListener(){

            public void actionPerformed(ActionEvent a) {
                String input = RiskGUI.this.Command.getText();
                RiskGUI.this.Command.setText("");
                RiskGUI.this.history.add(input);
                RiskGUI.this.pointer = RiskGUI.this.history.size() - 1;
                RiskGUI.this.go(input);
            }
        };
        this.Submit.addActionListener(readCommand);
        this.Command.addActionListener(readCommand);
        class CommandKeyAdapter
        extends KeyAdapter {
            RiskGUI adaptee;

            CommandKeyAdapter(RiskGUI adaptee) {
                this.adaptee = adaptee;
            }

            public void keyPressed(KeyEvent key) {
                if (key.getKeyCode() == 38) {
                    if (RiskGUI.this.pointer < 0) {
                        Toolkit.getDefaultToolkit().beep();
                    } else {
                        if (RiskGUI.this.pointer == RiskGUI.this.history.size() - 1) {
                            RiskGUI.this.temptext = RiskGUI.this.Command.getText();
                        }
                        RiskGUI.this.Command.setText((String)RiskGUI.this.history.elementAt(RiskGUI.this.pointer));
                        RiskGUI.this.pointer--;
                    }
                } else if (key.getKeyCode() == 40) {
                    if (RiskGUI.this.pointer > RiskGUI.this.history.size() - 2) {
                        Toolkit.getDefaultToolkit().beep();
                    } else if (RiskGUI.this.pointer == RiskGUI.this.history.size() - 2) {
                        RiskGUI.this.Command.setText(RiskGUI.this.temptext);
                        RiskGUI.this.pointer++;
                    } else {
                        RiskGUI.this.pointer = RiskGUI.this.pointer + 2;
                        RiskGUI.this.Command.setText((String)RiskGUI.this.history.elementAt(RiskGUI.this.pointer));
                        RiskGUI.this.pointer--;
                    }
                } else {
                    RiskGUI.this.pointer = RiskGUI.this.history.size() - 1;
                }
            }
        }
        this.Command.addKeyListener(new CommandKeyAdapter(this));
        JMenuBar menuBar = new JMenuBar();
        JMenu menuFile = new JMenu("File");
        menuFile.setMnemonic('F');
        JMenu menuHelp = new JMenu("Help");
        menuHelp.setMnemonic('H');
        JMenuItem Commands = new JMenuItem("Commands");
        Commands.setMnemonic('C');
        Commands.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RiskGUI.this.Commands();
            }
        });
        menuHelp.add(Commands);
        JMenuItem helpMan = new JMenuItem("Manual");
        helpMan.setMnemonic('M');
        helpMan.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RiskGUI.this.go("manual");
            }
        });
        menuHelp.add(helpMan);
        JMenuItem helpAbout = new JMenuItem("About");
        helpAbout.setMnemonic('A');
        helpAbout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RiskGUI.this.openAbout();
            }
        });
        menuHelp.add(helpAbout);
        JMenu menuClear = new JMenu("Clear");
        menuClear.setMnemonic('C');
        JMenuItem ClearConsole = new JMenuItem("Clear Console");
        ClearConsole.setMnemonic('C');
        ClearConsole.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RiskGUI.this.Console.setText("");
            }
        });
        menuClear.add(ClearConsole);
        JMenuItem ClearHistory = new JMenuItem("Clear History");
        ClearHistory.setMnemonic('H');
        ClearHistory.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RiskGUI.this.history.clear();
                RiskGUI.this.pointer = -1;
            }
        });
        menuClear.add(ClearHistory);
        JMenuItem openFile = new JMenuItem("Run Script");
        openFile.setMnemonic('R');
        openFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFileChooser fc = new JFileChooser();
                RiskFileFilter filter = new RiskFileFilter("risk");
                fc.setFileFilter(filter);
                int returnVal = fc.showDialog(RiskGUI.this, "Run");
                if (returnVal == 0) {
                    File file = fc.getSelectedFile();
                    try {
                        FileReader filein = new FileReader(file);
                        BufferedReader bufferin = new BufferedReader(filein);
                        String input = bufferin.readLine();
                        while (input != null) {
                            RiskGUI.this.go(input);
                            input = bufferin.readLine();
                        }
                        bufferin.close();
                    }
                    catch (Exception error) {
                        // empty catch block
                    }
                }
            }
        });
        menuFile.add(openFile);
        JMenuItem saveFile = new JMenuItem("Save Console");
        saveFile.setMnemonic('S');
        saveFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFileChooser fc = new JFileChooser();
                RiskFileFilter filter = new RiskFileFilter("log");
                fc.setFileFilter(filter);
                int returnVal = fc.showSaveDialog(RiskGUI.this);
                if (returnVal == 0) {
                    File file = fc.getSelectedFile();
                    String fileName = file.getAbsolutePath();
                    if (!fileName.endsWith(".log")) {
                        fileName = fileName + "." + "log";
                    }
                    try {
                        FileWriter fileout = new FileWriter(fileName);
                        BufferedWriter buffer = new BufferedWriter(fileout);
                        PrintWriter printer = new PrintWriter(buffer);
                        printer.write(RiskGUI.this.doc.getText(0, RiskGUI.this.doc.getLength()));
                        printer.close();
                    }
                    catch (Exception error) {
                        // empty catch block
                    }
                }
            }
        });
        menuFile.add(saveFile);
        JMenuItem fileExit = new JMenuItem("Exit");
        fileExit.setMnemonic('E');
        fileExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        menuFile.add(fileExit);
        menuBar.add(menuFile);
        menuBar.add(menuClear);
        menuBar.add(menuHelp);
        this.setJMenuBar(menuBar);
        this.setBounds(new Rectangle(0, 0, 905, 629));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                RiskGUI.this.exitForm();
            }
        });
    }

    private void exitForm() {
        System.exit(0);
    }

    public void go(String input) {
        if (input.equals("exit")) {
            System.exit(0);
        } else if (input.equals("help")) {
            this.Commands();
        } else if (input.equals("about")) {
            this.openAbout();
        } else if (input.equals("clear")) {
            this.Console.setText("");
        } else if (input.equals("manual")) {
            try {
                RiskUtil.openDocs("help/index_commands.htm");
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, "Unable to open manual: " + e.getMessage(), "Error", 0);
            }
        } else {
            this.risk.parser(input);
        }
    }

    public void Commands() {
        String commands = "";
        try {
            FileReader filein = new FileReader("commands.txt");
            BufferedReader bufferin = new BufferedReader(filein);
            String input = bufferin.readLine();
            while (input != null) {
                commands = commands.equals("") ? input : commands + "\n" + input;
                input = bufferin.readLine();
            }
            bufferin.close();
            JOptionPane.showMessageDialog(this, commands, "Commands:", -1);
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void openAbout() {
        RiskUIUtil.openAbout(this, product, version);
    }

    public void pprepaintCountries() {
        int tmp = this.mapViewComboBox.getSelectedIndex();
        int newview = -1;
        switch (tmp) {
            case 0: {
                newview = 0;
                break;
            }
            case 1: {
                newview = 1;
                break;
            }
            case 2: {
                newview = 2;
                break;
            }
            case 3: {
                newview = 3;
                break;
            }
            case 4: {
                newview = 4;
                break;
            }
            case 5: {
                newview = 5;
            }
        }
        this.pp.repaintCountries(newview);
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
        if (this.pp.getHighLight() != 255) {
            this.pp.setHighLight(255);
            this.pp.repaint();
        }
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
        int pixColor;
        if (e.getX() < 677 && e.getY() < 425 && e.getX() >= 0 && e.getY() >= 0 && (pixColor = this.pp.getCountryNumber(e.getX(), e.getY())) != 255) {
            String name = pixColor + "";
            this.Command.setText(this.Command.getText() + " " + name);
        }
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
        int cc = this.pp.getCountryNumber(e.getX(), e.getY());
        if (this.pp.getHighLight() != cc) {
            this.pp.setHighLight(cc);
            this.pp.repaint();
        }
    }

    public static void main(String[] argv) {
        RiskUIUtil.parseArgs(argv);
        RiskGUI gui = new RiskGUI(new Risk());
        RiskUIUtil.center(gui);
        gui.setVisible(true);
    }

    class GamePanel
    extends JPanel {
        public GamePanel() {
            JPanel OptionsPanel = new JPanel();
            OptionsPanel.setLayout(new FlowLayout(1, 5, 0));
            JLabel mapLookLabel = new JLabel("Map Look:");
            RiskGUI.this.mapViewComboBox = new JComboBox();
            JButton closegame = new JButton("closegame");
            JButton about = new JButton("About");
            Dimension mapViewSize = new Dimension(150, 20);
            RiskGUI.this.mapViewComboBox.setPreferredSize(mapViewSize);
            RiskGUI.this.mapViewComboBox.setMinimumSize(mapViewSize);
            RiskGUI.this.mapViewComboBox.setMaximumSize(mapViewSize);
            RiskGUI.this.mapViewComboBox.addItem("Continents");
            RiskGUI.this.mapViewComboBox.addItem("Ownership");
            RiskGUI.this.mapViewComboBox.addItem("Border Threat");
            RiskGUI.this.mapViewComboBox.addItem("Risk Card Ownership");
            RiskGUI.this.mapViewComboBox.addItem("Troop Strength");
            RiskGUI.this.mapViewComboBox.addItem("Connected Empire");
            RiskGUI.this.mapViewComboBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent a) {
                    RiskGUI.this.pprepaintCountries();
                    RiskGUI.this.pp.repaint();
                }
            });
            JLabel playersLabel = new JLabel("Players:");
            Dimension playerPanelSize = new Dimension(120, 20);
            playersPanel players = new playersPanel();
            players.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0), 1));
            players.setPreferredSize(playerPanelSize);
            players.setMinimumSize(playerPanelSize);
            players.setMaximumSize(playerPanelSize);
            closegame.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent a) {
                    RiskGUI.this.go("closegame");
                }
            });
            about.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent a) {
                    RiskGUI.this.openAbout();
                }
            });
            Dimension size = new Dimension(677, 30);
            OptionsPanel.setPreferredSize(size);
            OptionsPanel.setMinimumSize(size);
            OptionsPanel.setMaximumSize(size);
            OptionsPanel.add(mapLookLabel);
            OptionsPanel.add(RiskGUI.this.mapViewComboBox);
            OptionsPanel.add(playersLabel);
            OptionsPanel.add(players);
            OptionsPanel.add(closegame);
            OptionsPanel.add(about);
            this.setLayout(new BorderLayout());
            this.add((Component)OptionsPanel, "North");
            this.add((Component)RiskGUI.this.pp, "Center");
        }
    }

    class playersPanel
    extends JPanel {
        playersPanel() {
        }

        public void paintComponent(Graphics g) {
            int[] colors = RiskGUI.this.risk.getPlayerColors();
            for (int c = 0; c < colors.length; ++c) {
                g.setColor(new Color(colors[c]));
                g.fillRect(120 / colors.length * c, 0, 120 / colors.length, 20);
            }
            g.setColor(new Color(ColorUtil.getTextColorFor(colors[0])));
            g.drawRect(2, 2, 120 / colors.length - 5, 15);
            g.setColor(Color.black);
            g.drawLine(120 / colors.length - 1, 0, 120 / colors.length - 1, 19);
        }
    }
}

