/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.ui.flashgui;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.image.BufferedImage;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import javax.swing.JDialog;
import javax.swing.JPanel;
import net.yura.domination.engine.Risk;
import net.yura.domination.engine.RiskUIUtil;
import net.yura.domination.ui.flashgui.GameFrame;

public class MissionDialog
extends JDialog
implements MouseListener {
    private BufferedImage mission;
    private String text;

    public MissionDialog(Frame parent, boolean modal, Risk r) {
        super(parent, modal);
        this.text = r.getCurrentMission();
        this.mission = RiskUIUtil.getUIImage(this.getClass(), "mission.jpg");
        this.initGUI();
        this.setResizable(false);
        this.pack();
    }

    private void initGUI() {
        this.setTitle("");
        Dimension d = new Dimension(150, 230);
        missionPanel missionpanel = new missionPanel();
        missionpanel.setPreferredSize(d);
        missionpanel.setMinimumSize(d);
        missionpanel.setMaximumSize(d);
        missionpanel.addMouseListener(this);
        this.getContentPane().add(missionpanel);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                MissionDialog.this.exitForm();
            }
        });
    }

    private void exitForm() {
        this.setVisible(false);
        this.dispose();
    }

    public void mouseClicked(MouseEvent e) {
        this.exitForm();
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    class missionPanel
    extends JPanel {
        missionPanel() {
        }

        public void paintComponent(Graphics g) {
            g.drawImage(MissionDialog.this.mission, 0, 0, this);
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int cardWidth = 150;
            Font font = new Font("SansSerif", 0, 11);
            AttributedString as = new AttributedString(MissionDialog.this.text);
            as.addAttribute(TextAttribute.FONT, font);
            AttributedCharacterIterator aci = as.getIterator();
            FontRenderContext frc = g2.getFontRenderContext();
            LineBreakMeasurer lbm = new LineBreakMeasurer(aci, frc);
            g2.setColor(GameFrame.UI_COLOR);
            TextLayout tl = new TextLayout(aci, frc);
            float y = 70.0f;
            lbm.setPosition(0);
            while (lbm.getPosition() < MissionDialog.this.text.length()) {
                tl = lbm.nextLayout(cardWidth - 50);
                tl.draw(g2, (float)((double)(cardWidth / 2) - tl.getBounds().getWidth() / 2.0), y += tl.getAscent());
                y += tl.getDescent() + tl.getLeading();
            }
        }
    }
}

