/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.ui.flashgui;

import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.MouseInputAdapter;
import net.yura.domination.engine.ColorUtil;
import net.yura.domination.engine.Risk;
import net.yura.domination.engine.RiskUIUtil;
import net.yura.domination.engine.RiskUtil;
import net.yura.domination.engine.core.Country;
import net.yura.domination.engine.core.RiskGame;
import net.yura.domination.engine.guishared.AboutDialog;
import net.yura.domination.engine.guishared.MapMouseListener;
import net.yura.domination.engine.guishared.PicturePanel;
import net.yura.domination.engine.translation.TranslationBundle;
import net.yura.domination.ui.flashgui.BattleDialog;
import net.yura.domination.ui.flashgui.CardsDialog;
import net.yura.domination.ui.flashgui.MissionDialog;
import net.yura.domination.ui.flashgui.MoveDialog;
import net.yura.domination.ui.flashgui.NewGameFrame;
import net.yura.domination.ui.flashgui.StatsDialog;

public class GameFrame
extends JFrame
implements KeyListener {
    public static final Color UI_COLOR = Color.RED;
    private BufferedImage gameImg;
    private Risk myrisk;
    private PicturePanel pp;
    private GameMenuPanel gm;
    private int mapView;
    private String gameStatus;
    private boolean localGame;
    private int gameState;
    private String note;
    private JButton cardsbutton;
    private JButton missionbutton;
    private JButton undobutton;
    private JButton menubutton;
    private JButton graphbutton;
    private JButton gobutton;
    private ResourceBundle resb;
    private StatsDialog graphdialog;
    private boolean menuOn;
    private boolean graphOn;
    private int[] colors;
    private CardsDialog cardsDialog;
    private MoveDialog movedialog;
    private JButton savebutton;
    private JButton resumebutton;
    private JCheckBox AutoEndGo;
    private JCheckBox AutoDefend;
    private JButton helpbutton;
    private JButton closebutton;
    private MouseInputAdapter mapListener;
    ActionListener buttonActionListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == GameFrame.this.cardsbutton) {
                GameFrame.this.displayCards();
            } else if (e.getSource() == GameFrame.this.missionbutton) {
                GameFrame.this.displayMission();
            } else if (e.getSource() == GameFrame.this.undobutton) {
                GameFrame.this.doUndo();
            } else if (e.getSource() == GameFrame.this.menubutton) {
                GameFrame.this.displayMenu();
            } else if (e.getSource() == GameFrame.this.graphbutton) {
                GameFrame.this.displayGraph();
            } else if (e.getSource() == GameFrame.this.gobutton) {
                GameFrame.this.goOn();
            } else if (e.getSource() == GameFrame.this.savebutton) {
                String name = RiskUIUtil.getSaveFileName(GameFrame.this);
                if (name != null) {
                    GameFrame.this.go("savegame " + name);
                }
            } else if (e.getSource() == GameFrame.this.resumebutton) {
                GameFrame.this.displayMenu();
            } else if (e.getSource() == GameFrame.this.AutoEndGo) {
                if (GameFrame.this.AutoEndGo.isSelected()) {
                    GameFrame.this.go("autoendgo on");
                } else {
                    GameFrame.this.go("autoendgo off");
                }
            } else if (e.getSource() == GameFrame.this.closebutton) {
                GameFrame.this.closeleave();
            } else if (e.getSource() == GameFrame.this.AutoDefend) {
                if (GameFrame.this.AutoDefend.isSelected()) {
                    GameFrame.this.go("autodefend on");
                } else {
                    GameFrame.this.go("autodefend off");
                }
            } else if (e.getSource() == GameFrame.this.helpbutton) {
                try {
                    RiskUtil.openDocs(GameFrame.this.resb.getString("helpfiles.flash"));
                }
                catch (Exception er) {
                    JOptionPane.showMessageDialog(GameFrame.this, "Unable to open manual: " + er.getMessage(), "Error", 0);
                }
            }
        }
    };
    private BattleDialog battledialog;

    public GameFrame(Risk r, PicturePanel p) {
        this.myrisk = r;
        this.pp = p;
        final MapMouseListener mml = new MapMouseListener(this.myrisk, this.pp);
        this.mapListener = new MouseInputAdapter(){

            public void mouseExited(MouseEvent e) {
                mml.mouseExited();
            }

            public void mouseReleased(MouseEvent e) {
                int[] click = mml.mouseReleased(e.getX(), e.getY(), GameFrame.this.gameState);
                if (click != null) {
                    GameFrame.this.mapClick(click, e);
                }
            }

            public void mouseMoved(MouseEvent e) {
                mml.mouseMoved(e.getX(), e.getY(), GameFrame.this.gameState);
            }
        };
        this.menuOn = false;
        this.graphOn = false;
        this.gameImg = RiskUIUtil.getUIImage(this.getClass(), "game.jpg");
        this.initGUI();
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(AboutDialog.class.getResource("icon.gif")));
        this.pack();
        this.graphdialog = null;
        try {
            this.setMinimumSize(this.getPreferredSize());
        }
        catch (NoSuchMethodError ex) {
            this.setResizable(false);
        }
    }

    private void initGUI() {
        this.resb = TranslationBundle.getBundle();
        this.setTitle("yura.net " + RiskUtil.GAME_NAME);
        int l = 715;
        int m = 6;
        final BufferedImage topleft = this.gameImg.getSubimage(63, 0, l, 54);
        final BufferedImage topmiddle = this.gameImg.getSubimage(63 + l, 0, m, 54);
        final BufferedImage topright = this.gameImg.getSubimage(63 + l + m, 0, 740 - (l + m), 54);
        JPanel fp = new JPanel(){

            public void paintComponent(Graphics g) {
                g.drawImage(topleft, 0, 0, this);
                for (int c = topleft.getWidth(); c < this.getWidth() - topright.getWidth(); c += topmiddle.getWidth()) {
                    g.drawImage(topmiddle, c, 0, this);
                }
                g.drawImage(topright, this.getWidth() - topright.getWidth(), 0, this);
                Graphics2D g2 = (Graphics2D)g;
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                FontRenderContext frc = g2.getFontRenderContext();
                Font font = g2.getFont();
                g2.setColor(Color.BLACK);
                TextLayout tl = new TextLayout(GameFrame.this.resb.getString("game.tabs.continents"), font, frc);
                tl.draw(g2, (float)(81.0 - tl.getBounds().getWidth() / 2.0), 26.0f);
                tl = new TextLayout(GameFrame.this.resb.getString("game.tabs.ownership"), font, frc);
                tl.draw(g2, (float)(196.0 - tl.getBounds().getWidth() / 2.0), 26.0f);
                tl = new TextLayout(GameFrame.this.resb.getString("game.tabs.borderthreat"), font, frc);
                tl.draw(g2, (float)(311.0 - tl.getBounds().getWidth() / 2.0), 26.0f);
                tl = new TextLayout(GameFrame.this.resb.getString("game.tabs.cardownership"), font, frc);
                tl.draw(g2, (float)(426.0 - tl.getBounds().getWidth() / 2.0), 26.0f);
                tl = new TextLayout(GameFrame.this.resb.getString("game.tabs.troopstrength"), font, frc);
                tl.draw(g2, (float)(541.0 - tl.getBounds().getWidth() / 2.0), 26.0f);
                tl = new TextLayout(GameFrame.this.resb.getString("game.tabs.connectedempire"), font, frc);
                tl.draw(g2, (float)(656.0 - tl.getBounds().getWidth() / 2.0), 26.0f);
                if (GameFrame.this.mapView == 0) {
                    g.drawImage(GameFrame.this.gameImg, 24, 32, 139, 39, 64, 383, 179, 390, this);
                } else if (GameFrame.this.mapView == 1) {
                    g.drawImage(GameFrame.this.gameImg, 139, 32, 254, 39, 64, 390, 179, 397, this);
                } else if (GameFrame.this.mapView == 2) {
                    g.drawImage(GameFrame.this.gameImg, 254, 32, 369, 39, 64, 397, 179, 404, this);
                } else if (GameFrame.this.mapView == 3) {
                    g.drawImage(GameFrame.this.gameImg, 369, 32, 484, 39, 64, 404, 179, 411, this);
                } else if (GameFrame.this.mapView == 4) {
                    g.drawImage(GameFrame.this.gameImg, 484, 32, 599, 39, 64, 411, 179, 418, this);
                } else if (GameFrame.this.mapView == 5) {
                    g.drawImage(GameFrame.this.gameImg, 599, 32, 714, 39, 64, 418, 179, 425, this);
                }
                g.drawLine(30, 53, this.getWidth() - 32, 53);
            }
        };
        fp.addMouseListener(new MouseInputAdapter(){

            public void mouseReleased(MouseEvent e) {
                int click = GameFrame.this.insideButton(e.getX(), e.getY());
                if (click != -1 && GameFrame.this.mapView != click) {
                    GameFrame.this.setMapView(click);
                }
            }
        });
        l = 551;
        m = 6;
        final BufferedImage bottomleft = this.gameImg.getSubimage(63, 54, l, 121);
        final BufferedImage bottommiddle = this.gameImg.getSubimage(63 + l, 54, m, 121);
        final BufferedImage bottomright = this.gameImg.getSubimage(63 + l + m, 54, 740 - (l + m), 121);
        JPanel fpBottom = new JPanel(){

            public void paintComponent(Graphics g) {
                g.drawImage(bottomleft, 0, 0, this);
                for (int c = bottomleft.getWidth(); c < this.getWidth() - bottomright.getWidth(); c += bottommiddle.getWidth()) {
                    g.drawImage(bottommiddle, c, 0, this);
                }
                g.drawImage(bottomright, this.getWidth() - bottomright.getWidth(), 0, this);
                Graphics2D g2 = (Graphics2D)g;
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                int[] cols = GameFrame.this.colors;
                for (int c = 0; c < cols.length; ++c) {
                    Color col = new Color(cols[c]);
                    g.setColor(new Color(col.getRed(), col.getGreen(), col.getBlue(), 100));
                    if (c == 0) {
                        g.fillArc(8, 89, 24, 24, 90, 180);
                        g.fillRect(20, 89, this.getWidth() - 173 - 24 * (cols.length - c), 24);
                        continue;
                    }
                    g.fillRect(this.getWidth() - 177 - 24 * (cols.length - c), 89, 24, 24);
                }
                if (GameFrame.this.gameStatus != null) {
                    g.setColor(new Color(ColorUtil.getTextColorFor(cols[0])));
                    g.setFont(new Font("SansSerif", 0, 11));
                    g.drawString(GameFrame.this.gameStatus, 22, 105);
                }
                g2.setColor(Color.BLACK);
                TextLayout tl = null;
                FontRenderContext frc = g2.getFontRenderContext();
                Font font = g2.getFont();
                if (GameFrame.this.gameState == 0) {
                    tl = new TextLayout(GameFrame.this.resb.getString("game.pleasewait"), font, frc);
                } else if (!(GameFrame.this.gameState != 1 && GameFrame.this.gameState != 2 && GameFrame.this.gameState != 3 && GameFrame.this.gameState != 9 && GameFrame.this.gameState != 6 || GameFrame.this.note.equals(""))) {
                    tl = new TextLayout(GameFrame.this.note, font, frc);
                }
                if (tl != null) {
                    tl.draw(g2, (float)((double)(this.getWidth() - 84) - tl.getBounds().getWidth() / 2.0), 57.0f);
                }
                g.drawLine(30, 0, this.getWidth() - 32, 0);
            }

            public void setBounds(int x, int y, int w, int h) {
                super.setBounds(x, y, w, h);
                GameFrame.this.gobutton.setBounds(this.getWidth() - 140, 74, 115, 31);
            }
        };
        fpBottom.setLayout(null);
        JPanel fpLeft = new JPanel(){

            public void paintComponent(Graphics g) {
                g.drawImage(GameFrame.this.gameImg, 0, 0, 31, this.getHeight(), 0, 0, 31, 425, this);
                g.setColor(Color.BLACK);
                g.drawLine(30, 0, 30, this.getHeight());
            }
        };
        JPanel fpRight = new JPanel(){

            public void paintComponent(Graphics g) {
                g.drawImage(GameFrame.this.gameImg, 0, 0, 32, this.getHeight(), 31, 0, 63, 425, this);
                g.setColor(Color.BLACK);
                g.drawLine(0, 0, 0, this.getHeight());
            }
        };
        int w = 114;
        int h = 66;
        int x = 63;
        int y = 77;
        this.graphbutton = GameFrame.makeRiskButton(this.gameImg.getSubimage(x, y, w, h), this.gameImg.getSubimage(x, y + 230, w, h), this.gameImg.getSubimage(x, y + 164, w, h), this.gameImg.getSubimage(x, y + 98, w, h));
        this.graphbutton.setBounds(x - 63, y - 54, w, h);
        this.graphbutton.addActionListener(this.buttonActionListener);
        this.graphbutton.setToolTipText(this.resb.getString("game.button.statistics"));
        this.cardsbutton = GameFrame.makeRiskButton(this.gameImg.getSubimage(x += w, y, w, h), this.gameImg.getSubimage(x, y + 230, w, h), this.gameImg.getSubimage(x, y + 164, w, h), this.gameImg.getSubimage(x, y + 98, w, h));
        this.cardsbutton.setBounds(x - 63, y - 54, w, h);
        this.cardsbutton.addActionListener(this.buttonActionListener);
        this.cardsbutton.setToolTipText(this.resb.getString("game.button.cards"));
        this.missionbutton = GameFrame.makeRiskButton(this.gameImg.getSubimage(x += w, y, w, h), this.gameImg.getSubimage(x, y + 230, w, h), this.gameImg.getSubimage(x, y + 164, w, h), this.gameImg.getSubimage(x, y + 98, w, h));
        this.missionbutton.setBounds(x - 63, y - 54, w, h);
        this.missionbutton.addActionListener(this.buttonActionListener);
        this.missionbutton.setToolTipText(this.resb.getString("game.button.mission"));
        this.undobutton = GameFrame.makeRiskButton(this.gameImg.getSubimage(x += w, y, w, h), this.gameImg.getSubimage(x, y + 230, w, h), this.gameImg.getSubimage(x, y + 164, w, h), this.gameImg.getSubimage(x, y + 98, w, h));
        this.undobutton.setBounds(x - 63, y - 54, w, h);
        this.undobutton.addActionListener(this.buttonActionListener);
        this.undobutton.setToolTipText(this.resb.getString("game.button.undo"));
        this.menubutton = GameFrame.makeRiskButton(this.gameImg.getSubimage(x += w, y, w, h), this.gameImg.getSubimage(x, y + 230, w, h), this.gameImg.getSubimage(x, y + 164, w, h), this.gameImg.getSubimage(x, y + 98, w, h));
        this.menubutton.setBounds(x - 63, y - 54, w, h);
        this.menubutton.addActionListener(this.buttonActionListener);
        this.menubutton.setToolTipText(this.resb.getString("game.button.menu"));
        w = 115;
        h = 31;
        this.gobutton = GameFrame.makeRiskButton(this.gameImg.getSubimage(663, 128, w, h), this.gameImg.getSubimage(412, 394, w, h), this.gameImg.getSubimage(296, 394, w, h), this.gameImg.getSubimage(180, 394, w, h));
        this.gobutton.addActionListener(this.buttonActionListener);
        fpBottom.add(this.graphbutton);
        fpBottom.add(this.cardsbutton);
        fpBottom.add(this.missionbutton);
        fpBottom.add(this.undobutton);
        fpBottom.add(this.menubutton);
        fpBottom.add(this.gobutton);
        this.pp.addMouseListener(this.mapListener);
        this.pp.addMouseMotionListener(this.mapListener);
        this.pp.setBackground(Color.BLACK);
        this.gm = new GameMenuPanel();
        this.gm.setVisible(false);
        this.gm.setBounds(285, 141, 170, 250);
        this.getRootPane().getLayeredPane().add((Component)this.gm, JLayeredPane.MODAL_LAYER);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                GameFrame.this.closeleave();
            }
        });
        this.addKeyListener(this);
        this.cardsbutton.addKeyListener(this);
        this.missionbutton.addKeyListener(this);
        this.undobutton.addKeyListener(this);
        this.menubutton.addKeyListener(this);
        this.graphbutton.addKeyListener(this);
        this.gobutton.addKeyListener(this);
        this.cardsDialog = new CardsDialog((Frame)this, true, this.myrisk, this.pp);
        RiskUIUtil.center(this.cardsDialog);
        this.movedialog = new MoveDialog((Frame)this, false);
        RiskUIUtil.center(this.movedialog);
        Dimension d = new Dimension(740, 54);
        fp.setPreferredSize(d);
        fp.setMinimumSize(d);
        fp.setMaximumSize(d);
        d = new Dimension(740, 121);
        fpBottom.setPreferredSize(d);
        fpBottom.setMinimumSize(d);
        fpBottom.setMaximumSize(d);
        d = new Dimension(31, 425);
        fpLeft.setPreferredSize(d);
        fpLeft.setMinimumSize(d);
        fpLeft.setMaximumSize(d);
        d = new Dimension(32, 425);
        fpRight.setPreferredSize(d);
        fpRight.setMinimumSize(d);
        fpRight.setMaximumSize(d);
        JPanel flashPanel = new JPanel(new BorderLayout());
        flashPanel.add((Component)fp, "North");
        flashPanel.add(this.pp);
        flashPanel.add((Component)fpBottom, "South");
        flashPanel.add((Component)fpLeft, "West");
        flashPanel.add((Component)fpRight, "East");
        this.getContentPane().add(flashPanel);
    }

    public void setup(boolean s) {
        try {
            this.pp.load();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.gameState = 0;
        this.mapView = 0;
        this.setGameStatus(null);
        this.note = "";
        this.localGame = s;
        this.closebutton.setText(this.resb.getString(this.localGame ? "game.menu.close" : "game.menu.leave"));
        this.repaintCountries();
        AbstractButton[] buttons = new AbstractButton[]{this.savebutton, this.AutoEndGo, this.AutoDefend, this.cardsbutton, this.missionbutton, this.undobutton, this.gobutton};
        for (int c = 0; c < buttons.length; ++c) {
            buttons[c].setEnabled(false);
        }
    }

    public void closeleave() {
        if (this.graphOn) {
            this.graphdialog.setVisible(false);
            this.graphOn = false;
        }
        this.go("closegame");
    }

    public void repaintCountries() {
        this.pp.repaintCountries(this.mapView);
    }

    public void setGameStatus(String state) {
        int[] cols = null;
        if (state != null && (cols = this.myrisk.getPlayerColors()).length == 0) {
            cols = null;
        }
        if (cols == null) {
            cols = new int[]{-8355712};
        }
        this.gameStatus = state;
        this.colors = cols;
        this.repaint();
    }

    public void needInput(int s) {
        this.gameState = s;
        String goButtonText = null;
        switch (this.gameState) {
            case 1: {
                this.pp.setC1(255);
                this.pp.setC2(255);
                if (this.myrisk.getGame().canEndTrade()) {
                    goButtonText = this.resb.getString("game.button.go.endtrade");
                }
                this.note = this.getArmiesLeftText();
                break;
            }
            case 2: {
                if (!this.myrisk.getGame().NoEmptyCountries()) {
                    goButtonText = this.resb.getString("game.button.go.autoplace");
                }
                this.note = this.getArmiesLeftText();
                break;
            }
            case 3: {
                this.pp.setC1(255);
                this.pp.setC2(255);
                this.note = this.resb.getString("game.note.selectattacker");
                goButtonText = this.resb.getString("game.button.go.endattack");
                break;
            }
            case 6: {
                this.note = this.resb.getString("game.note.selectsource");
                goButtonText = this.resb.getString("game.button.go.nomove");
                break;
            }
            case 7: {
                goButtonText = this.resb.getString("game.button.go.endgo");
                break;
            }
            case 8: {
                if (this.myrisk.getGame().canContinue()) {
                    goButtonText = this.resb.getString("game.button.go.continue");
                    break;
                }
                if (this.localGame) {
                    goButtonText = this.resb.getString("game.button.go.closegame");
                    break;
                }
                goButtonText = this.resb.getString("game.button.go.leavegame");
                break;
            }
            case 9: {
                this.note = this.resb.getString("game.note.happyok");
                goButtonText = this.resb.getString("game.button.go.ok");
                break;
            }
            case 5: {
                RiskGame game = this.myrisk.getGame();
                this.openMove(game.getMustMove(), game.getAttacker().getColor(), game.getDefender().getColor(), false);
                this.movedialog.setVisible(true);
                break;
            }
        }
        if (goButtonText != null) {
            this.gobutton.setEnabled(true);
            this.gobutton.setText(goButtonText);
        } else {
            this.gobutton.setEnabled(false);
            this.gobutton.setText("");
        }
        this.cardsbutton.setEnabled(true);
        this.missionbutton.setEnabled(true);
        if (this.localGame) {
            if (this.gameState != 10) {
                this.undobutton.setEnabled(true);
            }
            this.savebutton.setEnabled(true);
        }
        this.AutoEndGo.setEnabled(true);
        this.AutoEndGo.setBackground(Color.white);
        this.AutoEndGo.setSelected(this.myrisk.getAutoEndGo());
        this.AutoDefend.setEnabled(true);
        this.AutoDefend.setBackground(Color.white);
        this.AutoDefend.setSelected(this.myrisk.getAutoDefend());
        this.repaint();
    }

    public String getArmiesLeftText() {
        int l = this.myrisk.getGame().getCurrentPlayer().getExtraArmies();
        return RiskUtil.replaceAll(this.resb.getString("game.note.armiesleft"), "{0}", String.valueOf(l));
    }

    public int insideButton(int x, int y) {
        int B = -1;
        if (y >= 9 && y < 32) {
            int W = 115;
            if (x >= 24 && x < 24 + W) {
                B = 0;
            } else if (x >= 139 && x < 139 + W) {
                B = 1;
            } else if (x >= 254 && x < 254 + W) {
                B = 2;
            } else if (x >= 369 && x < 369 + W) {
                B = 3;
            } else if (x >= 484 && x < 484 + W) {
                B = 4;
            } else if (x >= 599 && x < 599 + W) {
                B = 5;
            }
        }
        return B;
    }

    public void setBattleDialog(BattleDialog bd) {
        this.battledialog = bd;
    }

    public void go(String command) {
        this.blockInput();
        this.myrisk.parser(command);
    }

    public void blockInput() {
        this.pp.setHighLight(255);
        if (this.gameState == 4 || this.gameState == 10) {
            this.battledialog.blockInput();
        }
        if (this.gameState == 5 || this.gameState == 6) {
            this.movedialog.exitForm();
        }
        if (this.gameState != 2 || !this.myrisk.getGame().getSetup()) {
            this.noInput();
        }
    }

    public void noInput() {
        this.cardsbutton.setEnabled(false);
        this.missionbutton.setEnabled(false);
        this.undobutton.setEnabled(false);
        this.savebutton.setEnabled(false);
        this.AutoEndGo.setEnabled(false);
        this.AutoEndGo.setBackground(Color.lightGray);
        this.AutoDefend.setEnabled(false);
        this.AutoDefend.setBackground(Color.lightGray);
        this.gobutton.setText("");
        this.gobutton.setEnabled(false);
        this.note = "";
        this.gameState = 0;
    }

    public BufferedImage getCountryImage(int a) {
        return this.pp.getCountryImage(a, true);
    }

    public void openMove(int min, int c1num, int c2num, boolean tacmove) {
        int src = this.myrisk.hasArmiesInt(c1num);
        int des = this.myrisk.hasArmiesInt(c2num);
        BufferedImage c1img = this.pp.getCountryImage(c1num, true);
        BufferedImage c2img = this.pp.getCountryImage(c2num, true);
        Country country1 = this.myrisk.getGame().getCountryInt(c1num);
        Country country2 = this.myrisk.getGame().getCountryInt(c2num);
        int color = this.myrisk.getCurrentPlayerColor();
        this.movedialog.setup(tacmove, min, src, des, c1img, c2img, country1, country2, new Color(color));
    }

    public void mapClick(int[] countries, MouseEvent e) {
        String oldnote = this.note;
        if (this.gameState == 2) {
            if (countries.length == 1) {
                if (e.getModifiers() == 16) {
                    this.go("placearmies " + countries[0] + " 1");
                } else {
                    this.go("placearmies " + countries[0] + " 10");
                }
            }
        } else if (this.gameState == 3) {
            if (countries.length == 0) {
                this.note = this.resb.getString("game.note.selectattacker");
            } else if (countries.length == 1) {
                this.note = this.resb.getString("game.note.selectdefender");
            } else {
                this.go("attack " + countries[0] + " " + countries[1]);
                this.note = this.resb.getString("game.note.selectattacker");
            }
        } else if (this.gameState == 6) {
            if (countries.length == 0) {
                this.note = this.resb.getString("game.note.selectsource");
            } else if (countries.length == 1) {
                this.note = this.resb.getString("game.note.selectdestination");
            } else {
                this.note = "";
                this.repaint();
                this.openMove(1, countries[0], countries[1], true);
                this.movedialog.setModal(true);
                this.movedialog.setVisible(true);
                this.movedialog.setModal(false);
                this.pp.setC1(255);
                this.pp.setC2(255);
                this.note = this.resb.getString("game.note.selectsource");
            }
        } else if (this.gameState == 9) {
            // empty if block
        }
        if (oldnote != this.note) {
            this.repaint();
        }
    }

    private void setMapView(int click) {
        this.mapView = click;
        this.repaintCountries();
        this.repaint();
    }

    private void displayCards() {
        this.cardsDialog.setup(this.gameState == 1);
        this.cardsDialog.setVisible(true);
    }

    private void displayMission() {
        MissionDialog missiondialog = new MissionDialog((Frame)this, true, this.myrisk);
        Dimension frameSize = this.getSize();
        Dimension aboutSize = missiondialog.getSize();
        int x = this.getLocation().x + (frameSize.width - aboutSize.width) / 2;
        int y = this.getLocation().y + (frameSize.height - aboutSize.height) / 2;
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        missiondialog.setLocation(x, y);
        missiondialog.setVisible(true);
    }

    private void doUndo() {
        this.pp.setC1(255);
        this.pp.setC2(255);
        this.go("undo");
    }

    private void displayMenu() {
        if (this.menuOn) {
            this.gm.setVisible(false);
            this.pp.addMouseListener(this.mapListener);
            this.pp.addMouseMotionListener(this.mapListener);
            this.menuOn = false;
        } else {
            this.pp.removeMouseListener(this.mapListener);
            this.pp.removeMouseMotionListener(this.mapListener);
            if (this.myrisk.getGame().getCurrentPlayer() != null) {
                this.AutoEndGo.setSelected(this.myrisk.getAutoEndGo());
                this.AutoDefend.setSelected(this.myrisk.getAutoDefend());
            }
            this.gm.setVisible(true);
            this.menuOn = true;
        }
    }

    public void displayGraph() {
        if (this.graphOn) {
            this.graphdialog.setVisible(false);
            this.graphOn = false;
        } else {
            if (this.graphdialog == null) {
                this.graphdialog = new StatsDialog((Frame)this, false, this.myrisk);
                Dimension frameSize = this.getPreferredSize();
                Dimension graphSize = this.graphdialog.getSize();
                int a = this.getLocation().x + (frameSize.width - graphSize.width) / 2;
                int b = this.getLocation().y + (frameSize.height - graphSize.height) / 2;
                if (a < 0) {
                    a = 0;
                }
                if (b < 0) {
                    b = 0;
                }
                this.graphdialog.setLocation(a, b);
            }
            this.graphdialog.setVisible(true);
            this.graphOn = true;
        }
    }

    private void goOn() {
        if (this.gameState == 1) {
            this.go("endtrade");
        } else if (this.gameState == 2) {
            this.go("autoplace");
        } else if (this.gameState == 3) {
            this.pp.setC1(255);
            this.go("endattack");
        } else if (this.gameState == 6) {
            this.pp.setC1(255);
            this.go("nomove");
        } else if (this.gameState == 7) {
            this.go("endgo");
        } else if (this.gameState == 8) {
            RiskGame game = this.myrisk.getGame();
            if (game != null && game.canContinue()) {
                this.go("continue");
            } else {
                this.closeleave();
            }
        } else if (this.gameState == 9) {
            int c1Id = this.pp.getC1();
            this.pp.setC1(255);
            this.go("capital " + c1Id);
        }
    }

    public static JButton makeRiskButton(Image gobutton1, Image gobutton2, Image gobutton3, Image gobutton4) {
        JButton button = new JButton();
        NewGameFrame.sortOutButton(button, gobutton1, gobutton3, gobutton2);
        button.setDisabledIcon(new ImageIcon(gobutton4));
        return button;
    }

    public void keyReleased(KeyEvent event) {
        switch (event.getKeyCode()) {
            case 49: {
                this.setMapView(0);
                break;
            }
            case 50: {
                this.setMapView(1);
                break;
            }
            case 51: {
                this.setMapView(2);
                break;
            }
            case 52: {
                this.setMapView(3);
                break;
            }
            case 53: {
                this.setMapView(4);
                break;
            }
            case 54: {
                this.setMapView(5);
            }
        }
        switch (event.getKeyCode()) {
            case 67: {
                if (this.gameState == 0) break;
                this.displayCards();
                break;
            }
            case 77: {
                if (this.gameState == 0) break;
                this.displayMission();
                break;
            }
            case 85: {
                if (this.gameState == 0 || this.gameState == 10) break;
                this.doUndo();
                break;
            }
            case 121: {
                this.displayMenu();
                break;
            }
            case 71: {
                if (this.gameState == 0) break;
                this.goOn();
            }
        }
    }

    public void keyTyped(KeyEvent event) {
    }

    public void keyPressed(KeyEvent event) {
    }

    class GameMenuPanel
    extends JPanel {
        public GameMenuPanel() {
            this.setLayout(null);
            int w = 100;
            GameFrame.this.savebutton = GameFrame.makeRiskButton(GameFrame.this.gameImg.getSubimage(480, 373, w, 21), GameFrame.this.gameImg.getSubimage(380, 373, w, 21), GameFrame.this.gameImg.getSubimage(280, 373, w, 21), GameFrame.this.gameImg.getSubimage(180, 373, w, 21));
            GameFrame.this.savebutton.setText(GameFrame.this.resb.getString("game.menu.save"));
            GameFrame.this.savebutton.setBounds(35, 50, w, 20);
            GameFrame.this.savebutton.addActionListener(GameFrame.this.buttonActionListener);
            GameFrame.this.closebutton = GameFrame.makeRiskButton(GameFrame.this.gameImg.getSubimage(480, 373, w, 21), GameFrame.this.gameImg.getSubimage(380, 373, w, 21), GameFrame.this.gameImg.getSubimage(280, 373, w, 21), GameFrame.this.gameImg.getSubimage(180, 373, w, 21));
            GameFrame.this.closebutton.setBounds(35, 80, w, 20);
            GameFrame.this.closebutton.addActionListener(GameFrame.this.buttonActionListener);
            GameFrame.this.AutoEndGo = new JCheckBox(GameFrame.this.resb.getString("game.menu.autoendgo"));
            GameFrame.this.AutoEndGo.setToolTipText(GameFrame.this.resb.getString("game.menu.autoendgo"));
            GameFrame.this.AutoEndGo.setMargin(new Insets(0, 0, 0, 0));
            GameFrame.this.AutoEndGo.setBorderPainted(false);
            GameFrame.this.AutoEndGo.setFocusPainted(false);
            GameFrame.this.AutoEndGo.setBounds(35, 110, w, 20);
            GameFrame.this.AutoEndGo.addActionListener(GameFrame.this.buttonActionListener);
            GameFrame.this.AutoEndGo.setBackground(Color.lightGray);
            GameFrame.this.AutoDefend = new JCheckBox(GameFrame.this.resb.getString("game.menu.autodefend"));
            GameFrame.this.AutoDefend.setToolTipText(GameFrame.this.resb.getString("game.menu.autodefend"));
            GameFrame.this.AutoDefend.setMargin(new Insets(0, 0, 0, 0));
            GameFrame.this.AutoDefend.setBorderPainted(false);
            GameFrame.this.AutoDefend.setFocusPainted(false);
            GameFrame.this.AutoDefend.setBounds(35, 140, w, 20);
            GameFrame.this.AutoDefend.addActionListener(GameFrame.this.buttonActionListener);
            GameFrame.this.AutoDefend.setBackground(Color.lightGray);
            GameFrame.this.helpbutton = GameFrame.makeRiskButton(GameFrame.this.gameImg.getSubimage(480, 373, w, 21), GameFrame.this.gameImg.getSubimage(380, 373, w, 21), GameFrame.this.gameImg.getSubimage(280, 373, w, 21), GameFrame.this.gameImg.getSubimage(180, 373, w, 21));
            GameFrame.this.helpbutton.setText(GameFrame.this.resb.getString("game.menu.manual"));
            GameFrame.this.helpbutton.setBounds(35, 170, w, 20);
            GameFrame.this.helpbutton.addActionListener(GameFrame.this.buttonActionListener);
            GameFrame.this.resumebutton = GameFrame.makeRiskButton(GameFrame.this.gameImg.getSubimage(480, 373, w, 21), GameFrame.this.gameImg.getSubimage(380, 373, w, 21), GameFrame.this.gameImg.getSubimage(280, 373, w, 21), GameFrame.this.gameImg.getSubimage(180, 373, w, 21));
            GameFrame.this.resumebutton.setText(GameFrame.this.resb.getString("game.menu.closemenu"));
            GameFrame.this.resumebutton.setBounds(35, 200, w, 20);
            GameFrame.this.resumebutton.addActionListener(GameFrame.this.buttonActionListener);
            this.add(GameFrame.this.savebutton);
            this.add(GameFrame.this.AutoDefend);
            this.add(GameFrame.this.helpbutton);
            this.add(GameFrame.this.AutoEndGo);
            this.add(GameFrame.this.closebutton);
            this.add(GameFrame.this.resumebutton);
        }

        public void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            AlphaComposite ac = AlphaComposite.getInstance(3, 0.8f);
            g2.setComposite(ac);
            g2.drawImage(GameFrame.this.gameImg, 0, 0, 170, 250, 633, 175, 803, 425, this);
            FontRenderContext frc = g2.getFontRenderContext();
            Font font = new Font("Arial", 1, 24);
            g2.setColor(Color.black);
            TextLayout tl = new TextLayout(GameFrame.this.resb.getString("game.menu.title"), font, frc);
            tl.draw(g2, (float)(85.0 - tl.getBounds().getWidth() / 2.0), 40.0f);
        }
    }
}

