/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.ui.flashgui;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RescaleOp;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import net.yura.domination.engine.Risk;
import net.yura.domination.engine.RiskUIUtil;
import net.yura.domination.engine.core.Card;
import net.yura.domination.engine.guishared.PicturePanel;
import net.yura.domination.engine.translation.TranslationBundle;
import net.yura.domination.ui.flashgui.GameFrame;

public class CardsDialog
extends JDialog {
    private Risk myrisk;
    private Vector cards;
    private JPanel myCardsPanel;
    private JPanel TradePanel;
    private JScrollPane CardsPlane;
    private BufferedImage Cards;
    private BufferedImage Back;
    private PicturePanel pp;
    private BufferedImage Infantry;
    private BufferedImage Cavalry;
    private BufferedImage Artillery;
    private BufferedImage Wildcard;
    private JButton tradeButton;
    private boolean canTrade;
    private ResourceBundle resb;

    public CardsDialog(Frame parent, boolean modal, Risk r, PicturePanel p) {
        super(parent, modal);
        this.myrisk = r;
        this.pp = p;
        this.Cards = RiskUIUtil.getUIImage(this.getClass(), "cards.jpg");
        this.Back = this.Cards.getSubimage(0, 0, 630, 500);
        this.Wildcard = this.Cards.getSubimage(630, 0, 50, 145);
        this.Cavalry = this.Cards.getSubimage(630, 145, 50, 70);
        this.Infantry = this.Cards.getSubimage(630, 215, 50, 70);
        this.Artillery = this.Cards.getSubimage(630, 285, 70, 50);
        this.initGUI();
        this.pack();
    }

    public void setup(boolean ct) {
        int c;
        this.canTrade = ct;
        Component[] oldcards = this.myCardsPanel.getComponents();
        for (c = 0; c < oldcards.length; ++c) {
            this.myCardsPanel.remove(oldcards[c]);
        }
        oldcards = this.TradePanel.getComponents();
        for (c = 0; c < oldcards.length; ++c) {
            this.TradePanel.remove(oldcards[c]);
        }
        this.cards = this.myrisk.getCurrentCards();
        for (c = 0; c < this.cards.size(); ++c) {
            CardPanel cp = new CardPanel((Card)this.cards.elementAt(c));
            this.myCardsPanel.add(cp);
        }
        this.tradeButton.setEnabled(false);
    }

    private void initGUI() {
        this.resb = TranslationBundle.getBundle();
        this.setTitle(this.resb.getString("cards.title"));
        this.setResizable(false);
        CardsPanel cardspanel = new CardsPanel();
        cardspanel.setLayout(null);
        Dimension Size = new Dimension(630, 500);
        cardspanel.setPreferredSize(Size);
        cardspanel.setMinimumSize(Size);
        cardspanel.setMaximumSize(Size);
        this.myCardsPanel = new JPanel();
        this.myCardsPanel.setLayout(new FlowLayout(0));
        this.myCardsPanel.setOpaque(false);
        this.TradePanel = new JPanel();
        this.TradePanel.setLayout(new FlowLayout(0));
        this.TradePanel.setOpaque(false);
        this.tradeButton = GameFrame.makeRiskButton(this.Cards.getSubimage(396, 420, 88, 31), this.Cards.getSubimage(630, 335, 88, 31), this.Cards.getSubimage(630, 366, 88, 31), this.Cards.getSubimage(630, 397, 88, 31));
        this.tradeButton.setText(this.resb.getString("cards.trade"));
        this.tradeButton.setBounds(396, 420, 88, 31);
        JTextArea note = new JTextArea(this.resb.getString("cards.note"));
        note.setLineWrap(true);
        note.setWrapStyleWord(true);
        note.setFont(new JLabel().getFont());
        note.setEditable(false);
        note.setBounds(400, 270, 180, 150);
        note.setOpaque(false);
        Dimension noteSize = new Dimension(180, 120);
        note.setPreferredSize(noteSize);
        note.setMinimumSize(noteSize);
        note.setMaximumSize(noteSize);
        JButton okButton = GameFrame.makeRiskButton(this.Cards.getSubimage(500, 420, 88, 31), this.Cards.getSubimage(630, 428, 88, 31), this.Cards.getSubimage(630, 459, 88, 31), this.Cards.getSubimage(500, 420, 88, 31));
        okButton.setText(this.resb.getString("cards.done"));
        okButton.setBounds(500, 420, 88, 31);
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CardsDialog.this.closeDialog();
            }
        });
        this.tradeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Component[] cards2 = CardsDialog.this.TradePanel.getComponents();
                if (cards2.length == 3) {
                    CardsDialog.this.myrisk.parser("trade " + ((CardPanel)cards2[0]).getCardName() + " " + ((CardPanel)cards2[1]).getCardName() + " " + ((CardPanel)cards2[2]).getCardName());
                    CardsDialog.this.TradePanel.remove(CardsDialog.this.TradePanel.getComponent(2));
                    CardsDialog.this.TradePanel.remove(CardsDialog.this.TradePanel.getComponent(1));
                    CardsDialog.this.TradePanel.remove(CardsDialog.this.TradePanel.getComponent(0));
                    CardsDialog.this.TradePanel.validate();
                    CardsDialog.this.tradeButton.setEnabled(false);
                    CardsDialog.this.repaint();
                }
            }
        });
        this.CardsPlane = new JScrollPane();
        this.CardsPlane.setOpaque(false);
        this.CardsPlane.getViewport().add(this.myCardsPanel);
        this.CardsPlane.getViewport().setOpaque(false);
        this.CardsPlane.setBorder(null);
        this.CardsPlane.setBounds(49, 48, 532, 198);
        this.TradePanel.setBounds(49, 270, 322, 182);
        cardspanel.add(note);
        cardspanel.add(this.tradeButton);
        cardspanel.add(okButton);
        cardspanel.add(this.CardsPlane);
        cardspanel.add(this.TradePanel);
        this.getContentPane().add(cardspanel);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                CardsDialog.this.closeDialog();
            }
        });
    }

    public Image getCountryImage(int a) {
        BufferedImage pictureB = this.myrisk.isOwnedCurrentPlayerInt(a) ? this.pp.getCountryImage(a, true) : this.pp.getCountryImage(a, false);
        int width = pictureB.getWidth();
        int height = pictureB.getHeight();
        if (width > 50) {
            width = 50;
        }
        if (height > 50) {
            height = 50;
        }
        return pictureB.getScaledInstance(width, height, 4);
    }

    public String getNumArmies() {
        if (this.myrisk.getGame().getCardMode() == 1) {
            return this.resb.getString("cards.fixed");
        }
        if (this.myrisk.getGame().getCardMode() == 2) {
            return this.resb.getString("cards.italianlike");
        }
        return this.resb.getString("cards.nexttrade").replaceAll("\\{0\\}", "" + this.myrisk.getNewCardState());
    }

    private void closeDialog() {
        this.setVisible(false);
    }

    class CardPanel
    extends JPanel
    implements MouseListener {
        private Card card;
        private BufferedImage grayImage;
        private BufferedImage highlightImage;
        private boolean select;

        public CardPanel(Card c) {
            this.card = c;
            this.addMouseListener(this);
            int cardWidth = 100;
            int cardHeight = 170;
            this.select = false;
            Dimension CardSize = new Dimension(cardWidth, cardHeight);
            this.setPreferredSize(CardSize);
            this.setMinimumSize(CardSize);
            this.setMaximumSize(CardSize);
            this.setOpaque(false);
            this.grayImage = new BufferedImage(cardWidth, cardHeight, 1);
            Graphics2D g2 = this.grayImage.createGraphics();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setColor(Color.lightGray);
            g2.fillRect(0, 0, cardWidth, cardHeight);
            if (!this.card.getName().equals("wildcard")) {
                String text = this.card.getCountry().getName();
                Font font = g2.getFont();
                AttributedString as = new AttributedString(text);
                as.addAttribute(TextAttribute.FONT, font);
                AttributedCharacterIterator aci = as.getIterator();
                FontRenderContext frc = g2.getFontRenderContext();
                LineBreakMeasurer lbm = new LineBreakMeasurer(aci, frc);
                g2.setColor(GameFrame.UI_COLOR);
                TextLayout tl = new TextLayout(aci, frc);
                float y = 5.0f;
                lbm.setPosition(0);
                while (lbm.getPosition() < text.length()) {
                    tl = lbm.nextLayout(cardWidth - 10);
                    tl.draw(g2, (float)((double)(cardWidth / 2) - tl.getBounds().getWidth() / 2.0), y += tl.getAscent());
                    y += tl.getDescent() + tl.getLeading();
                }
                Image i = CardsDialog.this.getCountryImage(this.card.getCountry().getColor());
                g2.drawImage(i, 25 + (25 - i.getWidth(this) / 2), 35 + (25 - i.getHeight(this) / 2), null);
                if (this.card.getName().equals("Infantry")) {
                    g2.drawImage((Image)CardsDialog.this.Infantry, 25, 90, null);
                } else if (this.card.getName().equals("Cavalry")) {
                    g2.drawImage((Image)CardsDialog.this.Cavalry, 25, 90, null);
                } else if (this.card.getName().equals("Cannon")) {
                    g2.drawImage((Image)CardsDialog.this.Artillery, 15, 105, null);
                }
            } else {
                g2.drawImage((Image)CardsDialog.this.Wildcard, 25, 10, null);
            }
            g2.setColor(GameFrame.UI_COLOR);
            RoundRectangle2D.Float shape2 = new RoundRectangle2D.Float(2.0f, 2.0f, 95.0f, 165.0f, 20.0f, 20.0f);
            g2.draw(shape2);
            this.highlightImage = new BufferedImage(cardWidth, cardHeight, 1);
            RescaleOp HighLight = new RescaleOp(1.5f, 1.0f, null);
            HighLight.filter(this.grayImage, this.highlightImage);
            g2.dispose();
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2 = (Graphics2D)g;
            AlphaComposite ac = AlphaComposite.getInstance(3, 0.7f);
            g2.setComposite(ac);
            RoundRectangle2D.Float shape = new RoundRectangle2D.Float(0.0f, 0.0f, 100.0f, 170.0f, 25.0f, 25.0f);
            g2.clip(shape);
            if (this.select) {
                g2.drawImage((Image)this.highlightImage, 0, 0, this);
            } else {
                g2.drawImage((Image)this.grayImage, 0, 0, this);
            }
        }

        public String getCardName() {
            if (!this.card.getName().equals("wildcard")) {
                return this.card.getCountry().getColor() + "";
            }
            return this.card.getName();
        }

        public void mouseClicked(MouseEvent e) {
            if (this.getParent() == CardsDialog.this.myCardsPanel) {
                if (CardsDialog.this.TradePanel.getComponentCount() < 3) {
                    CardsDialog.this.myCardsPanel.remove(this);
                    this.select = false;
                    CardsDialog.this.TradePanel.add(this);
                }
                if (CardsDialog.this.TradePanel.getComponentCount() == 3 && CardsDialog.this.canTrade && CardsDialog.this.myrisk.canTrade(((CardPanel)CardsDialog.this.TradePanel.getComponent(0)).getCardName(), ((CardPanel)CardsDialog.this.TradePanel.getComponent(1)).getCardName(), ((CardPanel)CardsDialog.this.TradePanel.getComponent(2)).getCardName())) {
                    CardsDialog.this.tradeButton.setEnabled(true);
                }
            } else if (this.getParent() == CardsDialog.this.TradePanel) {
                CardsDialog.this.TradePanel.remove(this);
                this.select = false;
                CardsDialog.this.myCardsPanel.add(this);
                CardsDialog.this.tradeButton.setEnabled(false);
            }
            CardsDialog.this.myCardsPanel.validate();
            CardsDialog.this.TradePanel.validate();
            CardsDialog.this.CardsPlane.validate();
            CardsDialog.this.myCardsPanel.repaint();
            CardsDialog.this.TradePanel.repaint();
        }

        public void mouseEntered(MouseEvent e) {
            this.select = true;
            this.repaint();
        }

        public void mouseExited(MouseEvent e) {
            this.select = false;
            this.repaint();
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }
    }

    class CardsPanel
    extends JPanel {
        CardsPanel() {
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.drawImage(CardsDialog.this.Back, 0, 0, this);
            g.drawString(CardsDialog.this.resb.getString("cards.yourcards"), 60, 41);
            g.drawString(CardsDialog.this.resb.getString("cards.trade"), 60, 263);
            g.drawString(CardsDialog.this.getNumArmies(), 400, 410);
        }
    }
}

