/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.engine.p2pserver;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import net.yura.domination.engine.RiskController;
import net.yura.domination.engine.p2pserver.ChatServerThread;

public class ChatArea
extends Thread {
    private ServerSocket serverSocket = null;
    private RiskController gui;
    private ChatServerThread[] chatArr = new ChatServerThread[100];
    private boolean stopFlag = false;

    public ChatArea(RiskController g, int port) throws Exception {
        this.gui = g;
        InetAddress iaddr = InetAddress.getLocalHost();
        this.serverSocket = new ServerSocket(port);
        this.gui.sendMessage("getHostName = " + iaddr.getHostName(), false, false);
        this.gui.sendMessage("getHostAddress = " + iaddr.getHostAddress(), false, false);
        this.gui.sendMessage("port = " + port, false, false);
        this.start();
    }

    public void run() {
        int nThreadCount = 0;
        try {
            while (true) {
                ChatServerThread childThread;
                Socket nextSock = this.serverSocket.accept();
                this.gui.sendMessage("Another Client has joined: " + nThreadCount, false, false);
                this.chatArr[nThreadCount] = childThread = new ChatServerThread(nextSock, this, nThreadCount++);
                if (childThread == null) continue;
                childThread.start();
            }
        }
        catch (IOException e) {
            this.gui.sendMessage("no one can join now", false, false);
            return;
        }
    }

    public synchronized void closeSocket() throws IOException {
        this.serverSocket.close();
        this.stopFlag = true;
        this.notifyAll();
    }

    public boolean isOff() {
        return this.serverSocket.isClosed();
    }

    synchronized void putString(int index, String s) {
        for (int i = 0; i < this.chatArr.length; ++i) {
            if (this.chatArr[i] == null) continue;
            this.chatArr[i].m_lList.addLast(s);
        }
        this.notifyAll();
        try {
            this.serverSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    synchronized String getStrings(int index) {
        if (this.chatArr[index] == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer("");
        LinkedList lList = this.chatArr[index].m_lList;
        int num = lList.size();
        try {
            for (int i = 0; i < num; ++i) {
                String str = (String)lList.removeFirst();
                sb.append(str);
                sb.append("\n");
            }
        }
        catch (NoSuchElementException e) {
            System.err.println("Our List Count is Messed Up???");
        }
        return sb.toString();
    }

    synchronized String waitForString(int index) {
        String str;
        do {
            if ((str = this.getStrings(index)) == null) {
                return null;
            }
            try {
                if (str.length() == 0) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.stopFlag) continue;
            return null;
        } while (str.length() == 0);
        return str;
    }

    synchronized void imDead(int index) {
        this.chatArr[index] = null;
        this.notifyAll();
    }
}

