/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.engine.core;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class Statistic
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int COUNTRIES = 1;
    public static final int ARMIES = 2;
    public static final int KILLS = 3;
    public static final int CASUALTIES = 4;
    public static final int REINFORCEMENTS = 5;
    public static final int CONTINENTS = 6;
    public static final int CONECTED_EMPIRE = 7;
    public static final int ATTACKS = 8;
    public static final int RETREATS = 9;
    public static final int COUNTRIES_WON = 10;
    public static final int COUNTRIES_LOST = 11;
    public static final int ATTACKED = 12;
    public static final int CARDS = 13;
    private int[] statistics = new int[13];

    public Statistic() {
        for (int i = 0; i < this.statistics.length; ++i) {
            this.statistics[i] = 0;
        }
    }

    public void endGoStatistics(int countries, int armies, int continents, int conectedEmpire, int cards) {
        this.statistics[Statistic.getIndexFromStatistic((int)1)] = countries;
        this.statistics[Statistic.getIndexFromStatistic((int)2)] = armies;
        this.statistics[Statistic.getIndexFromStatistic((int)6)] = continents;
        this.statistics[Statistic.getIndexFromStatistic((int)7)] = conectedEmpire;
        this.statistics[Statistic.getIndexFromStatistic((int)13)] = cards;
    }

    public void addReinforcements(int a) {
        int n = Statistic.getIndexFromStatistic(5);
        this.statistics[n] = this.statistics[n] + a;
    }

    public void addKill() {
        int n = Statistic.getIndexFromStatistic(3);
        this.statistics[n] = this.statistics[n] + 1;
    }

    public void addCasualty() {
        int n = Statistic.getIndexFromStatistic(4);
        this.statistics[n] = this.statistics[n] + 1;
    }

    public void addAttack() {
        int n = Statistic.getIndexFromStatistic(8);
        this.statistics[n] = this.statistics[n] + 1;
    }

    public void addAttacked() {
        int n = Statistic.getIndexFromStatistic(12);
        this.statistics[n] = this.statistics[n] + 1;
    }

    public void addRetreat() {
        int n = Statistic.getIndexFromStatistic(9);
        this.statistics[n] = this.statistics[n] + 1;
    }

    public void addCountriesWon() {
        int n = Statistic.getIndexFromStatistic(10);
        this.statistics[n] = this.statistics[n] + 1;
    }

    public void addCountriesLost() {
        int n = Statistic.getIndexFromStatistic(11);
        this.statistics[n] = this.statistics[n] + 1;
    }

    public int get(int statistic) {
        return this.statistics[Statistic.getIndexFromStatistic(statistic)];
    }

    private static int getIndexFromStatistic(int statistic) {
        return statistic - 1;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.statistics.length < 13) {
            int[] old = this.statistics;
            this.statistics = new int[13];
            System.arraycopy(old, 0, this.statistics, 0, old.length);
        }
    }
}

