/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.engine;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.StringReader;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.AccessControlException;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.crypto.NullCipher;
import javax.crypto.SealedObject;
import net.yura.domination.engine.ColorUtil;
import net.yura.domination.engine.OnlineRisk;
import net.yura.domination.engine.RiskController;
import net.yura.domination.engine.RiskListener;
import net.yura.domination.engine.RiskUtil;
import net.yura.domination.engine.ai.AIManager;
import net.yura.domination.engine.core.Card;
import net.yura.domination.engine.core.Country;
import net.yura.domination.engine.core.Mission;
import net.yura.domination.engine.core.Player;
import net.yura.domination.engine.core.RiskGame;
import net.yura.domination.engine.p2pclient.ChatClient;
import net.yura.domination.engine.p2pserver.ChatArea;
import net.yura.domination.engine.translation.TranslationBundle;

public class Risk
extends Thread {
    public static String RISK_VERSION;
    private StringTokenizer StringT;
    protected RiskController controller;
    protected RiskGame game;
    OnlineRisk onlinePlayClient;
    private ChatArea p2pServer;
    private int port;
    protected String myAddress;
    private ByteArrayOutputStream Undo = new ByteArrayOutputStream();
    protected boolean unlimitedLocalMode;
    private boolean autoplaceall;
    private boolean battle;
    private boolean replay;
    protected final Vector inbox;
    protected ResourceBundle resb;
    protected Properties riskconfig;
    public static final String[] types;
    public static final String[] names;
    public static final String[] colors;
    boolean running = true;
    final AIManager ai = new AIManager();
    boolean skipUndo;

    public Risk(String b, String c) {
        this();
        RiskGame.setDefaultMapAndCards(b, c);
    }

    public Risk() {
        super(null, null, "DOMINATION-GAME-THREAD", 100000000L);
        this.resb = TranslationBundle.getBundle();
        try {
            String newName = System.getProperty("user.name");
            if (newName == null || "".equals(newName.trim())) {
                throw new Exception("bad user name");
            }
            for (int c = 0; c < names.length; ++c) {
                if (!names[c].equals(newName)) continue;
                throw new Exception("name already in use");
            }
            Risk.names[0] = newName;
        }
        catch (Throwable th) {
            // empty catch block
        }
        this.riskconfig = new Properties();
        this.riskconfig.setProperty("default.port", "4444");
        this.riskconfig.setProperty("default.host", "localhost");
        this.riskconfig.setProperty("default.map", RiskGame.getDefaultMap());
        this.riskconfig.setProperty("default.cards", RiskGame.getDefaultCards());
        this.riskconfig.setProperty("default.autoplaceall", "false");
        this.riskconfig.setProperty("default.recyclecards", "true");
        this.riskconfig.setProperty("ai.wait", String.valueOf(AIManager.getWait()));
        for (int c = 0; c < names.length; ++c) {
            this.riskconfig.setProperty("default.player" + (c + 1) + ".type", types[c]);
            this.riskconfig.setProperty("default.player" + (c + 1) + ".color", colors[c]);
            this.riskconfig.setProperty("default.player" + (c + 1) + ".name", names[c]);
        }
        try {
            this.riskconfig.load(RiskUtil.openStream("game.ini"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        AIManager.setWait(Integer.parseInt(this.riskconfig.getProperty("ai.wait")));
        this.myAddress = Risk.createRandomUniqueAddress();
        RiskGame.setDefaultMapAndCards(this.riskconfig.getProperty("default.map"), this.riskconfig.getProperty("default.cards"));
        this.port = Integer.parseInt(this.riskconfig.getProperty("default.port"));
        this.battle = false;
        this.replay = false;
        this.controller = new RiskController();
        this.inbox = new Vector();
        this.start();
    }

    static String createRandomUniqueAddress() {
        String randomString = "#" + String.valueOf(Math.round(Math.random() * 9.223372036854776E18));
        try {
            try {
                return InetAddress.getLocalHost().getHostName() + randomString;
            }
            catch (Throwable th) {
                return "sandbox" + randomString;
            }
        }
        catch (Exception e) {
            return "nonet" + randomString;
        }
    }

    public String GetNext() {
        return this.StringT.nextToken();
    }

    public String getRiskConfig(String a) {
        return this.riskconfig.getProperty(a);
    }

    public void addRiskListener(RiskListener o) {
        this.controller.addListener(o);
        this.setHelp();
    }

    public void deleteRiskListener(RiskListener o) {
        this.controller.deleteListener(o);
    }

    public void parser(String m) {
        this.addToInbox(new GameCommand(1, m));
    }

    public void parserFromNetwork(String m) {
        this.addToInbox(new GameCommand(2, m));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToInbox(GameCommand m) {
        Vector vector = this.inbox;
        synchronized (vector) {
            this.inbox.add(m);
            this.inbox.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kill() {
        Vector vector = this.inbox;
        synchronized (vector) {
            this.running = false;
            this.inbox.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        GameCommand message = null;
        while (this.running) {
            try {
                Vector vector = this.inbox;
                synchronized (vector) {
                    while (this.inbox.isEmpty()) {
                        if (!this.running) {
                            return;
                        }
                        try {
                            this.inbox.wait();
                        }
                        catch (InterruptedException e) {
                            System.err.println("InterruptedException in " + this.getName());
                        }
                    }
                    message = (GameCommand)this.inbox.remove(0);
                }
                if (message.type == 1) {
                    this.processFromUI(message.command);
                    continue;
                }
                if (message.type == 2) {
                    this.inGameParser(message.command);
                    continue;
                }
                throw new RuntimeException();
            }
            catch (Exception ex) {
                System.err.println("ERROR processing " + message);
                RiskUtil.printStackTrace(ex);
            }
        }
    }

    private void processFromUI(String message) {
        if (message.trim().length() == 0) {
            this.controller.sendMessage(">", false, false);
            this.getInput();
            return;
        }
        if (message.equals("ver")) {
            this.controller.sendMessage(">" + message, false, false);
            this.controller.sendMessage(RiskUtil.GAME_NAME + " Game Engine [Version " + RISK_VERSION + "]", false, false);
            this.getInput();
        } else if (message.startsWith("rem ")) {
            this.controller.sendMessage(">" + message, false, false);
            this.getInput();
        } else if (this.game == null) {
            this.noGameParser(message);
        } else if (message.equals("closegame")) {
            this.controller.sendMessage("game>" + message, false, false);
            this.closeGame();
            this.controller.sendMessage(this.resb.getString("core.close.closed"), false, false);
            this.getInput();
        } else if (this.onlinePlayClient == null) {
            this.inGameParser(this.myAddress + " " + message);
        } else {
            this.onlinePlayClient.sendUserCommand(message);
        }
    }

    private void noGameParser(String message) {
        String output;
        this.StringT = new StringTokenizer(message);
        String input = this.GetNext();
        this.controller.sendMessage(">" + message, false, false);
        if (input.equals("newgame")) {
            if (!this.StringT.hasMoreTokens()) {
                try {
                    this.game = new RiskGame();
                    this.unlimitedLocalMode = true;
                    this.controller.newGame(true);
                    this.setupPreviews(this.doesMapHaveMission());
                    output = this.resb.getString("core.newgame.created");
                }
                catch (Exception e) {
                    RiskUtil.printStackTrace(e);
                    output = this.resb.getString("core.newgame.error") + " " + e.toString();
                }
            } else {
                output = RiskUtil.replaceAll(this.resb.getString("core.error.syntax"), "{0}", "newgame");
            }
        } else if (input.equals("loadgame")) {
            if (this.StringT.countTokens() >= 1) {
                String filename = this.GetNext();
                while (this.StringT.hasMoreElements()) {
                    filename = filename + " " + this.GetNext();
                }
                try {
                    this.game = RiskGame.loadGame(filename);
                    if (this.game == null) {
                        throw new Exception("no game");
                    }
                    this.unlimitedLocalMode = true;
                    if (this.game.getState() == 0) {
                        this.controller.newGame(true);
                        this.setupPreviews(this.doesMapHaveMission());
                    } else {
                        this.controller.startGame(this.unlimitedLocalMode);
                    }
                    output = this.resb.getString("core.loadgame.loaded");
                    Player player = this.game.getCurrentPlayer();
                    if (player != null) {
                        this.saveGameToUndoObject();
                        output = output + System.getProperty("line.separator") + this.resb.getString("core.loadgame.currentplayer") + " " + player.getName();
                    }
                }
                catch (Exception ex) {
                    System.err.println("error loading game from file: " + filename);
                    RiskUtil.printStackTrace(ex);
                    output = this.resb.getString("core.loadgame.error.load") + " " + ex;
                    this.showMessageDialog(output);
                }
            } else {
                output = RiskUtil.replaceAll(this.resb.getString("core.error.syntax"), "{0}", "loadgame filename");
            }
        } else if (input.equals("join")) {
            if (this.StringT.countTokens() == 1) {
                try {
                    this.onlinePlayClient = new ChatClient(this, this.myAddress, this.GetNext(), this.port);
                    this.game = new RiskGame();
                    this.unlimitedLocalMode = false;
                    this.controller.newGame(false);
                    this.setupPreviews(this.doesMapHaveMission());
                    output = this.resb.getString("core.join.created");
                }
                catch (UnknownHostException e) {
                    this.game = null;
                    output = this.resb.getString("core.join.error.unknownhost");
                }
                catch (ConnectException e) {
                    this.game = null;
                    output = this.resb.getString("core.join.error.connect");
                }
                catch (IllegalArgumentException e) {
                    this.game = null;
                    output = this.resb.getString("core.join.error.nothostname");
                }
                catch (IOException e) {
                    this.game = null;
                    output = this.resb.getString("core.join.error.002");
                }
                catch (AccessControlException e) {
                    this.game = null;
                    output = "AccessControlException:\n" + this.resb.getString("core.error.applet");
                }
                catch (Exception e) {
                    this.game = null;
                    output = this.resb.getString("core.join.error.create") + " " + e;
                }
                if (this.game == null) {
                    this.showMessageDialog(output);
                }
            } else {
                output = RiskUtil.replaceAll(this.resb.getString("core.error.syntax"), "{0}", "join server");
            }
        } else if (input.equals("startserver")) {
            if (!this.StringT.hasMoreTokens()) {
                if (this.p2pServer == null) {
                    try {
                        this.p2pServer = new ChatArea(this.controller, this.port);
                        output = this.resb.getString("core.startserver.started");
                        this.controller.serverState(true);
                    }
                    catch (Exception e) {
                        this.p2pServer = null;
                        output = this.resb.getString("core.startserver.error") + " " + e;
                        this.showMessageDialog(output);
                    }
                } else {
                    output = this.resb.getString("core.startserver.error");
                }
            } else {
                output = RiskUtil.replaceAll(this.resb.getString("core.error.syntax"), "{0}", "startserver");
            }
        } else if (input.equals("killserver")) {
            if (!this.StringT.hasMoreTokens()) {
                if (this.p2pServer != null) {
                    try {
                        if (this.p2pServer != null) {
                            this.p2pServer.closeSocket();
                            this.p2pServer = null;
                        }
                        output = this.resb.getString("core.killserver.killed");
                        this.controller.serverState(false);
                    }
                    catch (Exception e) {
                        output = this.resb.getString("core.killserver.error") + " " + e.getMessage();
                    }
                } else {
                    output = this.resb.getString("core.killserver.noserver");
                }
            } else {
                output = RiskUtil.replaceAll(this.resb.getString("core.error.syntax"), "{0}", "killserver");
            }
        } else {
            output = this.resb.getString("core.loadgame.nogame");
        }
        this.controller.sendMessage(output, false, true);
        this.getInput();
    }

    protected void inGameParser(String message) {
        this.controller.sendDebug(message);
        boolean needInput = true;
        String output = null;
        this.StringT = new StringTokenizer(message);
        String Addr = this.GetNext();
        if (!Addr.equals("ERROR")) {
            this.game.addCommand(message);
        }
        if (Addr.equals("ERROR")) {
            String Pname = this.GetNext();
            while (this.StringT.hasMoreElements()) {
                Pname = Pname + " " + this.GetNext();
            }
            this.showMessageDialog(Pname);
        } else if (Addr.equals("LEAVE")) {
            int c;
            String id = this.GetNext();
            if (!(this.game.getCurrentPlayer() == null || this.game.getCurrentPlayer().getAddress().equals(id) && this.game.getCurrentPlayer().getType() == 0)) {
                needInput = false;
            }
            output = "someone has gone: ";
            Vector leavers = this.game.getPlayers();
            String newPlayerAddress = null;
            for (c = 0; c < leavers.size(); ++c) {
                if (((Player)leavers.elementAt(c)).getAddress().equals(id)) continue;
                newPlayerAddress = ((Player)leavers.elementAt(c)).getAddress();
                break;
            }
            for (c = 0; c < leavers.size(); ++c) {
                Player patc = (Player)leavers.elementAt(c);
                if (!patc.getAddress().equals(id)) continue;
                if (patc.getType() == 0) {
                    output = output + patc.getName() + " ";
                    if (this.game.getState() == 0) {
                        if (this.game.delPlayer(patc.getName())) {
                            --c;
                            this.controller.delPlayer(patc.getName());
                            patc = null;
                        }
                    } else {
                        patc.setType(3);
                    }
                }
                if (patc == null || newPlayerAddress == null) continue;
                patc.setAddress(newPlayerAddress);
            }
        } else if (Addr.equals("DICE")) {
            int attSize = RiskGame.getNumber(this.GetNext());
            int defSize = RiskGame.getNumber(this.GetNext());
            output = this.resb.getString("core.dice.rolling") + System.getProperty("line.separator") + this.resb.getString("core.dice.results");
            int[] att = new int[attSize];
            output = output + " " + this.resb.getString("core.dice.attacker");
            for (int c = 0; c < attSize; ++c) {
                att[c] = RiskGame.getNumber(this.GetNext());
                output = output + " " + (att[c] + 1);
            }
            int[] def = new int[defSize];
            output = output + " " + this.resb.getString("core.dice.defender");
            for (int c = 0; c < defSize; ++c) {
                def[c] = RiskGame.getNumber(this.GetNext());
                output = output + " " + (def[c] + 1);
            }
            output = output + System.getProperty("line.separator");
            int[] result = this.game.battle(att, def);
            if (result[0] == 1) {
                output = output + RiskUtil.replaceAll(RiskUtil.replaceAll(this.resb.getString("core.dice.result"), "{0}", String.valueOf(result[2])), "{1}", String.valueOf(result[1]));
                if (result[3] == 0) {
                    int n = this.game.getAttacker().getArmies() - 1;
                    output = output + System.getProperty("line.separator") + this.resb.getString("core.dice.notdefeated") + " ";
                    if (n > 0) {
                        if (n > 3) {
                            n = 3;
                        }
                        output = output + RiskUtil.replaceAll(this.resb.getString("core.dice.attackagain"), "{0}", "" + n);
                    } else {
                        output = output + this.resb.getString("core.dice.noattackagain");
                    }
                } else {
                    output = output + System.getProperty("line.separator") + this.resb.getString("core.dice.defeated") + " ";
                    if (result[3] == 2) {
                        output = output + this.resb.getString("core.dice.eliminated") + " ";
                    }
                    if (result[4] == result[5]) {
                        int noa = this.game.moveAll();
                        int ma = this.game.moveArmies(noa);
                        output = output + RiskUtil.replaceAll(this.resb.getString("core.dice.armiesmoved"), "{0}", String.valueOf(noa));
                        if (ma == 2) {
                            output = output + this.whoWon();
                        }
                    } else {
                        output = output + RiskUtil.replaceAll(RiskUtil.replaceAll(this.resb.getString("core.dice.howmanyarmies"), "{0}", String.valueOf(result[4])), "{1}", String.valueOf(result[5]));
                    }
                }
                if (this.battle) {
                    this.controller.showDiceResults(att, def);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {}
                }
            } else {
                output = this.resb.getString("core.dice.error.unabletoroll");
            }
            if (this.game.getState() != 4 && this.game.getState() != 10) {
                this.closeBattle();
            }
        } else if (Addr.equals("PLAYER")) {
            String Pname = this.GetNext();
            while (this.StringT.hasMoreElements()) {
                Pname = Pname + " " + this.GetNext();
            }
            Player p = this.game.setCurrentPlayer(Pname);
            this.controller.sendMessage("Game started", false, false);
            output = RiskUtil.replaceAll(this.resb.getString("core.player.randomselected"), "{0}", p.getName());
            if (this.game.getGameMode() == 3 || this.autoplaceall) {
                needInput = false;
            } else {
                this.saveGameToUndoObject();
            }
        } else if (Addr.equals("CARD")) {
            if (this.StringT.hasMoreTokens()) {
                String name = this.GetNext();
                Card card = this.game.findCardAndRemoveIt(name);
                this.game.getCurrentPlayer().giveCard(card);
                if (this.showHumanPlayerThereInfo()) {
                    String cardName = name.equals("wildcard") ? name : card.getName() + " " + this.game.getCountryInt(Integer.parseInt(name)).getName();
                    this.controller.sendMessage("You got a new card: \"" + cardName + "\"", false, false);
                }
            }
            Player newplayer = this.game.endGo();
            output = RiskUtil.replaceAll(this.resb.getString("core.player.newselected"), "{0}", newplayer.getName());
            if (this.unlimitedLocalMode && this.game.getSetup() && newplayer.getName().equals("Theo")) {
                newplayer.addArmies(newplayer.getExtraArmies());
            }
            this.saveGameToUndoObject();
        } else if (Addr.equals("PLACE")) {
            Country c = this.game.getCountryInt(Integer.parseInt(this.GetNext()));
            this.game.placeArmy(c, 1);
            this.controller.sendMessage(RiskUtil.replaceAll(this.resb.getString("core.place.oneplacedin"), "{0}", c.getName()), false, false);
            output = this.resb.getString("core.place.autoplaceok");
        } else if (Addr.equals("PLACEALL")) {
            for (int c = 0; c < this.game.getNoCountries(); ++c) {
                Country t = this.game.getCountryInt(Integer.parseInt(this.GetNext()));
                this.game.placeArmy(t, 1);
                this.controller.sendMessage(RiskUtil.replaceAll(RiskUtil.replaceAll(this.resb.getString("core.place.getcountry"), "{0}", this.game.getCurrentPlayer().getName()), "{1}", t.getName()), false, false);
                this.game.endGo();
            }
            this.saveGameToUndoObject();
            this.controller.sendMessage("Auto place all successful.", false, false);
            output = RiskUtil.replaceAll(this.resb.getString("core.player.newselected"), "{0}", this.game.getCurrentPlayer().getName());
        } else if (Addr.equals("MISSION")) {
            Vector m = this.game.getMissions();
            Vector p = this.game.getPlayers();
            for (int c = 0; c < p.size(); ++c) {
                int i = RiskGame.getNumber(this.GetNext());
                ((Player)p.elementAt(c)).setMission((Mission)m.elementAt(i));
                m.removeElementAt(i);
            }
            output = null;
            needInput = false;
        } else {
            block293: {
                String arg2;
                String arg1;
                String option;
                String strSelected;
                Vector replayCommands;
                String echo = message.substring(Addr.length() + 1);
                if (this.game != null && this.game.getCurrentPlayer() != null && this.game.getState() != 8) {
                    String typeString;
                    int type = this.game.getCurrentPlayer().getType();
                    String key = type == 0 ? "newgame.player.type.human" : "newgame.player.type." + this.ai.getCommandFromType(type) + "ai";
                    try {
                        typeString = this.resb.getString(key);
                    }
                    catch (MissingResourceException ex) {
                        typeString = key;
                    }
                    this.controller.sendMessage(this.game.getCurrentPlayer().getName() + "(" + typeString + ")>" + echo, false, false);
                } else {
                    this.controller.sendMessage("game>" + echo, false, false);
                }
                String input = this.GetNext();
                output = "";
                if (this.game.getState() == 0) {
                    String filename;
                    if (input.equals("choosemap")) {
                        if (this.StringT.countTokens() >= 1) {
                            filename = this.GetNext();
                            while (this.StringT.hasMoreElements()) {
                                filename = filename + " " + this.GetNext();
                            }
                            try {
                                this.setMap(filename);
                            }
                            catch (Exception e) {
                                RiskUtil.streamOpener.getMap(filename, this, e);
                            }
                            output = null;
                        } else {
                            output = RiskUtil.replaceAll(this.resb.getString("core.error.syntax"), "{0}", "choosemap filename");
                        }
                    } else if (input.equals("choosecards")) {
                        if (this.StringT.countTokens() >= 1) {
                            filename = this.GetNext();
                            while (this.StringT.hasMoreElements()) {
                                filename = filename + " " + this.GetNext();
                            }
                            try {
                                boolean yesmissions = this.game.setCardsfile(filename);
                                this.controller.showCardsFile(this.game.getCardsFile(), yesmissions);
                                output = RiskUtil.replaceAll(this.resb.getString("core.choosecards.chosen"), "{0}", filename);
                            }
                            catch (Exception e) {
                                output = this.resb.getString("core.choosecards.error.unable");
                            }
                        } else {
                            output = RiskUtil.replaceAll(this.resb.getString("core.error.syntax"), "{0}", "choosecards filename");
                        }
                    } else if (input.equals("newplayer")) {
                        if (this.StringT.countTokens() >= 3) {
                            String type = this.GetNext();
                            if (type.equals("ai")) {
                                type = type + " " + this.GetNext();
                            }
                            String c = this.GetNext();
                            String name = "";
                            while (this.StringT.hasMoreElements()) {
                                name = name + this.GetNext();
                                if (!this.StringT.hasMoreElements()) continue;
                                name = name + " ";
                            }
                            int t = this.getType(type);
                            int color = ColorUtil.getColor(c);
                            if (color != 0 && t != -1 && !name.equals("") && (this.unlimitedLocalMode && this.game.addPlayer(t, name, color, "LOCALGAME") || !this.unlimitedLocalMode && this.game.addPlayer(t, name, color, Addr))) {
                                output = RiskUtil.replaceAll(RiskUtil.replaceAll(this.resb.getString("core.newplayer.created"), "{0}", name), "{1}", c);
                                this.controller.addPlayer(t, name, color, Addr);
                            } else {
                                output = this.resb.getString("core.newplayer.error.unable");
                            }
                        } else {
                            output = RiskUtil.replaceAll(this.resb.getString("core.error.syntax"), "{0}", "newplayer type (skill) color name");
                        }
                    } else if (input.equals("delplayer")) {
                        if (this.StringT.countTokens() >= 1) {
                            String name = this.GetNext();
                            while (this.StringT.hasMoreElements()) {
                                name = name + " " + this.GetNext();
                            }
                            if (this.game.delPlayer(name)) {
                                this.controller.delPlayer(name);
                                output = RiskUtil.replaceAll(this.resb.getString("core.delplayer.deleted"), "{0}", name);
                            } else {
                                output = this.resb.getString("core.delplayer.error.unable");
                            }
                        } else {
                            output = RiskUtil.replaceAll(this.resb.getString("core.error.syntax"), "{0}", "delplayer name");
                        }
                    } else if (input.equals("info")) {
                        if (!this.StringT.hasMoreTokens()) {
                            output = this.resb.getString("core.info.title") + "\n";
                            Vector players = this.game.getPlayers();
                            for (int a = 0; a < players.size(); ++a) {
                                output = output + this.resb.getString("core.info.player") + " " + ((Player)players.elementAt(a)).getName() + "\n";
                            }
                            output = output + this.resb.getString("core.info.mapfile") + " " + this.game.getMapFile() + "\n";
                            output = output + this.resb.getString("core.info.cardsfile") + " " + this.game.getCardsFile();
                        } else {
                            output = RiskUtil.replaceAll(this.resb.getString("core.error.syntax"), "{0}", "info");
                        }
                    } else if (input.equals("autosetup")) {
                        if (!this.StringT.hasMoreTokens()) {
                            if (this.game.getPlayers().size() == 0) {
                                if (!this.replay) {
                                    for (int c = 1; c <= 6; ++c) {
                                        this.parser("newplayer " + this.riskconfig.getProperty("default.player" + c + ".type") + " " + this.riskconfig.getProperty("default.player" + c + ".color") + " " + this.riskconfig.getProperty("default.player" + c + ".name"));
                                    }
                                    output = this.resb.getString("core.info.autosetup");
                                } else {
                                    output = "replay mode, nothing done";
                                }
                            } else {
                                output = this.resb.getString("core.info.autosetup.error");
                            }
                        } else {
                            output = RiskUtil.replaceAll(this.resb.getString("core.error.syntax"), "{0}", "autosetup");
                        }
                    } else if (input.equals("startgame")) {
                        if (this.StringT.countTokens() >= 2 && this.StringT.countTokens() <= 4) {
                            int n = this.game.getPlayers().size();
                            int newgame_type = -1;
                            int newgame_cardType = -1;
                            boolean newgame_autoplaceall = false;
                            boolean newgame_recycle = false;
                            boolean threeDice = false;
                            String crap = null;
                            while (this.StringT.hasMoreTokens()) {
                                String newOption = this.GetNext();
                                if (newOption.equals("domination")) {
                                    newgame_type = 0;
                                    continue;
                                }
                                if (newOption.equals("capital")) {
                                    newgame_type = 2;
                                    continue;
                                }
                                if (newOption.equals("mission")) {
                                    newgame_type = 3;
                                    continue;
                                }
                                if (newOption.equals("increasing")) {
                                    newgame_cardType = 0;
                                    continue;
                                }
                                if (newOption.equals("fixed")) {
                                    newgame_cardType = 1;
                                    continue;
                                }
                                if (newOption.equals("italianlike")) {
                                    newgame_cardType = 2;
                                    threeDice = true;
                                    continue;
                                }
                                if (newOption.equals("autoplaceall")) {
                                    newgame_autoplaceall = true;
                                    continue;
                                }
                                if (newOption.equals("recycle")) {
                                    newgame_recycle = true;
                                    continue;
                                }
                                crap = newOption;
                            }
                            if (crap == null) {
                                if (newgame_type != -1 && newgame_cardType != -1 && n >= 2 && n <= 6) {
                                    this.autoplaceall = newgame_autoplaceall;
                                    try {
                                        this.game.startGame(newgame_type, newgame_cardType, newgame_recycle, threeDice);
                                    }
                                    catch (Exception e) {
                                        RiskUtil.printStackTrace(e);
                                    }
                                }
                                if (this.game.getState() != 0) {
                                    this.controller.noInput();
                                    this.controller.startGame(this.unlimitedLocalMode);
                                    if (this.shouldGameCommand(Addr)) {
                                        this.gameCommand(Addr, "PLAYER", this.game.getRandomPlayer());
                                        if (this.game.getGameMode() == 3) {
                                            Random r = new Random();
                                            int a = this.game.getNoMissions();
                                            int b = this.game.getNoPlayers();
                                            StringBuffer outputa = new StringBuffer();
                                            for (int c = 0; c < b; ++c) {
                                                if (outputa.length() != 0) {
                                                    outputa.append(' ');
                                                }
                                                outputa.append(r.nextInt(a));
                                                --a;
                                            }
                                            this.gameCommand(Addr, "MISSION", outputa.toString());
                                        }
                                        if (this.game.getGameMode() == 3 || this.autoplaceall) {
                                            List a = this.game.shuffleCountries();
                                            StringBuffer outputb = new StringBuffer();
                                            for (int c = 0; c < a.size(); ++c) {
                                                if (outputb.length() != 0) {
                                                    outputb.append(' ');
                                                }
                                                outputb.append(((Country)a.get(c)).getColor());
                                            }
                                            this.gameCommand(Addr, "PLACEALL", outputb.toString());
                                        }
                                    }
                                    output = null;
                                    needInput = false;
                                } else {
                                    output = this.resb.getString("core.start.error.players");
                                }
                            } else {
                                output = "unknown option: " + crap;
                            }
                        } else {
                            output = RiskUtil.replaceAll(this.resb.getString("core.error.syntax"), "{0}", "startgame gametype cardtype (autoplaceall recycle)");
                        }
                    } else if (input.equals("play")) {
                        if (this.StringT.countTokens() >= 1) {
                            filename = this.GetNext();
                            while (this.StringT.hasMoreElements()) {
                                filename = filename + " " + this.GetNext();
                            }
                            try {
                                URL url = new File(filename).toURI().toURL();
                                BufferedReader bufferin = new BufferedReader(new InputStreamReader(url.openStream()));
                                class Replay
                                extends Thread {
                                    private Risk risk;
                                    private BufferedReader bufferin;

                                    public Replay(Risk r, BufferedReader in) {
                                        this.risk = r;
                                        this.bufferin = in;
                                    }

                                    public void run() {
                                        try {
                                            String input = this.bufferin.readLine();
                                            while (input != null) {
                                                this.risk.inGameParser(input);
                                                input = this.bufferin.readLine();
                                            }
                                            this.bufferin.close();
                                        }
                                        catch (Exception error) {
                                            RiskUtil.printStackTrace(error);
                                        }
                                        Risk.this.replay = false;
                                        Risk.this.getInput();
                                    }
                                }
                                Replay replaythread = new Replay(this, bufferin);
                                this.replay = true;
                                replaythread.start();
                                output = "playing \"" + filename + "\"";
                            }
                            catch (Exception error) {
                                output = "unable to play \"" + filename + "\"";
                            }
                        } else {
                            output = RiskUtil.replaceAll(this.resb.getString("core.error.syntax"), "{0}", "play filename");
                        }
                    } else {
                        output = RiskUtil.replaceAll(this.resb.getString("core.error.incorrect"), "{0}", "newplayer, delplayer, startgame, choosemap, choosecards, info, autosetup");
                    }
                } else if (input.equals("undo")) {
                    if (!this.StringT.hasMoreTokens()) {
                        if (this.unlimitedLocalMode) {
                            try {
                                if (this.game.getState() != 10 && this.Undo != null && this.Undo.size() != 0) {
                                    ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(this.Undo.toByteArray()));
                                    this.game = (RiskGame)in.readObject();
                                    output = this.resb.getString("core.undo.undone");
                                    break block293;
                                }
                                output = this.resb.getString("core.undo.error.unable");
                            }
                            catch (Exception e) {
                                System.out.print(this.resb.getString("core.loadgame.error.undo") + "\n");
                                RiskUtil.printStackTrace(e);
                            }
                        } else {
                            output = this.resb.getString("core.undo.error.network");
                        }
                    } else {
                        output = RiskUtil.replaceAll(this.resb.getString("core.error.syntax"), "{0}", "undo");
                    }
                } else if (input.equals("replay")) {
                    if (!this.StringT.hasMoreTokens()) {
                        if (this.unlimitedLocalMode) {
                            try {
                                replayCommands = this.game.getCommands();
                                replayCommands.remove(replayCommands.size() - 1);
                                this.saveGameToUndoObject();
                                this.game = new RiskGame();
                                this.replay = true;
                                Enumeration e = replayCommands.elements();
                                while (e.hasMoreElements()) {
                                    this.inGameParser((String)e.nextElement());
                                }
                                this.replay = false;
                                output = "replay of game finished";
                            }
                            catch (Exception e) {
                                System.out.print(this.resb.getString("core.loadgame.error.undo") + "\n");
                                RiskUtil.printStackTrace(e);
                            }
                        } else {
                            output = this.resb.getString("core.undo.error.network");
                        }
                    } else {
                        output = RiskUtil.replaceAll(this.resb.getString("core.error.syntax"), "{0}", "replay");
                    }
                } else if (input.equals("savegame")) {
                    if (this.StringT.countTokens() >= 1) {
                        if (this.unlimitedLocalMode) {
                            replayCommands = this.game.getCommands();
                            replayCommands.remove(replayCommands.size() - 1);
                            String filename = this.GetNext();
                            while (this.StringT.hasMoreElements()) {
                                filename = filename + " " + this.GetNext();
                            }
                            try {
                                RiskUtil.saveFile(filename, this.game);
                                output = this.resb.getString("core.save.saved");
                            }
                            catch (Exception ex) {
                                System.err.println("error saving game to file: " + filename);
                                RiskUtil.printStackTrace(ex);
                                output = this.resb.getString("core.save.error.unable") + " " + ex;
                                this.showMessageDialog(output);
                            }
                        } else {
                            output = this.resb.getString("core.save.error.unable");
                        }
                    } else {
                        output = RiskUtil.replaceAll(this.resb.getString("core.error.syntax"), "{0}", "savegame filename");
                    }
                } else if (input.equals("showmission")) {
                    output = !this.StringT.hasMoreTokens() ? (this.showHumanPlayerThereInfo() ? this.resb.getString("core.showmission.mission") + " " + this.getCurrentMission() : this.resb.getString("core.showmission.error")) : RiskUtil.replaceAll(this.resb.getString("core.error.syntax"), "{0}", "showmission");
                } else if (input.equals("showarmies")) {
                    if (!this.StringT.hasMoreTokens()) {
                        if (this.game.getState() != 0) {
                            Country[] v = this.game.getCountries();
                            output = this.resb.getString("core.showarmies.countries") + System.getProperty("line.separator");
                            for (int c = 0; c < v.length; ++c) {
                                output = output + v[c].getColor() + " " + v[c].getName() + " - ";
                                if (v[c].getOwner() != null) {
                                    output = output + v[c].getOwner().getName() + " (" + v[c].getArmies() + ")";
                                    if (this.game.getGameMode() == 2 && this.game.getSetup() && this.game.getState() != 9) {
                                        Vector players = this.game.getPlayers();
                                        for (int a = 0; a < players.size(); ++a) {
                                            if (((Player)players.elementAt(a)).getCapital() == null || ((Player)players.elementAt(a)).getCapital() != v[c]) continue;
                                            output = output + " " + RiskUtil.replaceAll(this.resb.getString("core.showarmies.captial"), "{0}", ((Player)players.elementAt(a)).getName());
                                        }
                                    }
                                    output = output + System.getProperty("line.separator");
                                    continue;
                                }
                                output = output + this.resb.getString("core.showarmies.noowner") + System.getProperty("line.separator");
                            }
                        } else {
                            output = this.resb.getString("core.showarmies.error.unable");
                        }
                    } else {
                        output = RiskUtil.replaceAll(this.resb.getString("core.error.syntax"), "{0}", "showarmies");
                    }
                } else if (input.equals("showcards")) {
                    if (!this.StringT.hasMoreTokens()) {
                        if (this.showHumanPlayerThereInfo()) {
                            Vector c = this.game.getCurrentPlayer().getCards();
                            if (c.size() == 0) {
                                output = this.resb.getString("core.showcards.nocards");
                            } else {
                                output = this.resb.getString("core.showcards.youhave");
                                for (int a = 0; a < c.size(); ++a) {
                                    output = ((Card)c.elementAt(a)).getName().equals("wildcard") ? output + " " + "wildcard" : output + " \"" + ((Card)c.elementAt(a)).getName() + " " + ((Card)c.elementAt(a)).getCountry().getName() + " (" + ((Card)c.elementAt(a)).getCountry().getColor() + ")\"";
                                }
                            }
                            output = this.game.getCardMode() == 1 ? output + "\n" + this.resb.getString("cards.fixed") : (this.game.getCardMode() == 2 ? output + "\n" + this.resb.getString("cards.italianlike") : output + "\n" + RiskUtil.replaceAll(this.resb.getString("cards.nexttrade"), "{0}", String.valueOf(this.getNewCardState())));
                        } else {
                            output = this.resb.getString("core.showcards.error.unable");
                        }
                    } else {
                        output = RiskUtil.replaceAll(this.resb.getString("core.error.syntax"), "{0}", "showcards");
                    }
                } else if (input.equals("autoendgo")) {
                    if (!this.StringT.hasMoreTokens()) {
                        strSelected = this.game.getCurrentPlayer().getAutoEndGo() ? "core.autoendgo.on" : "core.autoendgo.off";
                        output = RiskUtil.replaceAll(this.resb.getString("core.autoendgo.setto"), "{0}", this.resb.getString(strSelected));
                    } else if (this.StringT.countTokens() == 1) {
                        option = this.GetNext();
                        if (option.equals("on")) {
                            this.game.getCurrentPlayer().setAutoEndGo(true);
                            output = RiskUtil.replaceAll(this.resb.getString("core.autoendgo.setto"), "{0}", this.resb.getString("core.autoendgo.on"));
                        } else if (option.equals("off")) {
                            this.game.getCurrentPlayer().setAutoEndGo(false);
                            output = RiskUtil.replaceAll(this.resb.getString("core.autoendgo.setto"), "{0}", this.resb.getString("core.autoendgo.off"));
                        } else {
                            output = RiskUtil.replaceAll(this.resb.getString("core.autoendgo.error.unknown"), "{0}", option);
                        }
                    } else {
                        output = RiskUtil.replaceAll(this.resb.getString("core.error.syntax"), "{0}", "autoendgo on/off");
                    }
                } else if (input.equals("autodefend")) {
                    if (!this.StringT.hasMoreTokens()) {
                        strSelected = this.game.getCurrentPlayer().getAutoDefend() ? "core.autodefend.on" : "core.autodefend.on";
                        output = RiskUtil.replaceAll(this.resb.getString("core.autodefend.setto"), "{0}", this.resb.getString(strSelected));
                    } else if (this.StringT.countTokens() == 1) {
                        option = this.GetNext();
                        if (option.equals("on")) {
                            this.game.getCurrentPlayer().setAutoDefend(true);
                            output = RiskUtil.replaceAll(this.resb.getString("core.autodefend.setto"), "{0}", this.resb.getString("core.autodefend.on"));
                        } else if (option.equals("off")) {
                            this.game.getCurrentPlayer().setAutoDefend(false);
                            output = RiskUtil.replaceAll(this.resb.getString("core.autodefend.setto"), "{0}", this.resb.getString("core.autodefend.off"));
                        } else {
                            output = RiskUtil.replaceAll(this.resb.getString("core.autodefend.error.unknown"), "{0}", option);
                        }
                    } else {
                        output = RiskUtil.replaceAll(this.resb.getString("core.error.syntax"), "{0}", "autodefend on/off");
                    }
                } else if (this.game.getState() == 1) {
                    if (input.equals("trade")) {
                        if (this.StringT.countTokens() == 3) {
                            int noa = 0;
                            Card[] cards = this.game.getCards(this.GetNext(), this.GetNext(), this.GetNext());
                            if (cards[0] != null && cards[1] != null && cards[2] != null) {
                                noa = this.game.trade(cards[0], cards[1], cards[2]);
                            }
                            output = noa != 0 ? RiskUtil.replaceAll(this.resb.getString("core.trade.traded"), "{0}", "" + noa) : this.resb.getString("core.trade.error.unable");
                        } else {
                            output = RiskUtil.replaceAll(this.resb.getString("core.error.syntax"), "{0}", "trade card card card");
                        }
                    } else {
                        output = input.equals("endtrade") ? (!this.StringT.hasMoreTokens() ? (this.game.endTrade() ? this.resb.getString("core.trade.endtrade") : this.resb.getString("core.trade.end.error.unable")) : RiskUtil.replaceAll(this.resb.getString("core.error.syntax"), "{0}", "endtrade")) : RiskUtil.replaceAll(this.resb.getString("core.error.incorrect"), "{0}", "showcards, trade" + (this.game.canEndTrade() ? ", endtrade" : ""));
                    }
                } else if (this.game.getState() == 2) {
                    if (input.equals("placearmies")) {
                        if (this.StringT.countTokens() == 2) {
                            String country = this.GetNext();
                            int c = RiskGame.getNumber(country);
                            int num = RiskGame.getNumber(this.GetNext());
                            Country t = c != -1 ? this.game.getCountryInt(c) : null;
                            if (!(t == null || num == -1 || this.game.getGameMode() == 1 && t.getOwner() == null || this.game.getGameMode() == 3 && t.getOwner() == null)) {
                                int result = this.game.placeArmy(t, num);
                                if (result != 0) {
                                    output = RiskUtil.replaceAll(RiskUtil.replaceAll(this.resb.getString("core.place.placed"), "{0}", String.valueOf(num)), "{1}", t.getName());
                                    if (result == 2) {
                                        output = output + this.whoWon();
                                    }
                                } else {
                                    output = this.resb.getString("core.place.error.unable");
                                }
                            } else {
                                output = this.resb.getString("core.place.error.invalid");
                            }
                        } else {
                            output = RiskUtil.replaceAll(this.resb.getString("core.error.syntax"), "{0}", "placearmies country number");
                        }
                    } else if (input.equals("autoplace")) {
                        if (!this.StringT.hasMoreTokens()) {
                            if (!this.game.NoEmptyCountries()) {
                                if (this.shouldGameCommand(Addr)) {
                                    this.gameCommand(Addr, "PLACE", String.valueOf(this.game.getEmptyCountry()));
                                }
                                needInput = false;
                                output = null;
                            } else {
                                output = this.resb.getString("core.autoplace.error.unable");
                            }
                        } else {
                            output = RiskUtil.replaceAll(this.resb.getString("core.error.syntax"), "{0}", "autoplace");
                        }
                    } else {
                        output = RiskUtil.replaceAll(this.resb.getString("core.error.incorrect"), "{0}", "showarmies, placearmies, autoplace");
                    }
                } else if (this.game.getState() == 3) {
                    if (input.equals("attack")) {
                        if (this.StringT.countTokens() == 2) {
                            int a2;
                            Country country2;
                            arg1 = this.GetNext();
                            arg2 = this.GetNext();
                            int a1 = RiskGame.getNumber(arg1);
                            Country country1 = a1 != -1 ? this.game.getCountryInt(a1) : null;
                            boolean a = this.game.attack(country1, country2 = (a2 = RiskGame.getNumber(arg2)) != -1 ? this.game.getCountryInt(a2) : null);
                            output = a ? RiskUtil.replaceAll(RiskUtil.replaceAll(RiskUtil.replaceAll(RiskUtil.replaceAll(RiskUtil.replaceAll(this.resb.getString("core.attack.attacking"), "{0}", country2.getName()), "{1}", "" + country2.getArmies()), "{2}", country1.getName()), "{3}", "" + country1.getArmies()), "{4}", "" + this.game.getNoAttackDice()) : this.resb.getString("core.attack.error.unable");
                        } else {
                            output = RiskUtil.replaceAll(this.resb.getString("core.error.syntax"), "{0}", "attack country country");
                        }
                    } else {
                        output = input.equals("endattack") ? (!this.StringT.hasMoreTokens() ? (this.game.endAttack() ? this.resb.getString("core.attack.end.ended") : this.resb.getString("core.attack.end.error.unable")) : RiskUtil.replaceAll(this.resb.getString("core.error.syntax"), "{0}", "endattack")) : RiskUtil.replaceAll(this.resb.getString("core.error.incorrect"), "{0}", "attack, endattack");
                    }
                } else if (this.game.getState() == 4) {
                    if (input.equals("roll")) {
                        if (this.StringT.countTokens() == 1) {
                            int dice = RiskGame.getNumber(this.GetNext());
                            if (dice != -1 && this.game.rollA(dice)) {
                                if (this.battle) {
                                    this.controller.setNODAttacker(dice);
                                }
                                int n = this.game.getNoDefendDice();
                                output = RiskUtil.replaceAll(RiskUtil.replaceAll(this.resb.getString("core.roll.rolled"), "{0}", this.game.getCurrentPlayer().getName()), "{1}", "" + n);
                            } else {
                                output = this.resb.getString("core.roll.error.unable");
                            }
                        } else {
                            output = RiskUtil.replaceAll(this.resb.getString("core.error.syntax"), "{0}", "roll number");
                        }
                    } else {
                        output = input.equals("retreat") ? (!this.StringT.hasMoreTokens() ? (this.game.retreat() ? this.resb.getString("core.retreat.retreated") : this.resb.getString("core.retreat.error.unable")) : RiskUtil.replaceAll(this.resb.getString("core.error.syntax"), "{0}", "retreat")) : RiskUtil.replaceAll(this.resb.getString("core.error.incorrect"), "{0}", "roll, retreat");
                    }
                } else if (this.game.getState() == 5) {
                    if (input.equals("move")) {
                        if (this.StringT.countTokens() == 1) {
                            String num = this.GetNext();
                            int noa = num.equals("all") ? this.game.moveAll() : RiskGame.getNumber(num);
                            int mov = this.game.moveArmies(noa);
                            if (mov != 0) {
                                output = RiskUtil.replaceAll(this.resb.getString("core.move.moved"), "{0}", "" + noa);
                                if (mov == 2) {
                                    output = output + this.whoWon();
                                }
                            } else {
                                output = this.resb.getString("core.move.error.unable");
                            }
                        } else {
                            output = RiskUtil.replaceAll(this.resb.getString("core.error.syntax"), "{0}", "move number");
                        }
                    } else {
                        output = RiskUtil.replaceAll(this.resb.getString("core.error.incorrect"), "{0}", "move");
                    }
                } else if (this.game.getState() == 6) {
                    if (input.equals("movearmies")) {
                        if (this.StringT.countTokens() == 3) {
                            int noa;
                            int a2;
                            Country country2;
                            arg1 = this.GetNext();
                            arg2 = this.GetNext();
                            int a1 = RiskGame.getNumber(arg1);
                            Country country1 = a1 != -1 ? this.game.getCountryInt(a1) : null;
                            output = this.game.moveArmy(country1, country2 = (a2 = RiskGame.getNumber(arg2)) != -1 ? this.game.getCountryInt(a2) : null, noa = RiskGame.getNumber(this.GetNext())) ? RiskUtil.replaceAll(RiskUtil.replaceAll(RiskUtil.replaceAll(this.resb.getString("core.tacmove.movedfromto"), "{0}", "" + noa), "{1}", country1.getName()), "{2}", country2.getName()) : this.resb.getString("core.tacmove.error.unable");
                        } else {
                            output = RiskUtil.replaceAll(this.resb.getString("core.error.syntax"), "{0}", "movearmies country country number");
                        }
                    } else {
                        output = input.equals("nomove") ? (!this.StringT.hasMoreTokens() ? (this.game.noMove() ? this.resb.getString("core.tacmove.no.nomoves") : this.resb.getString("core.tacmove.no.error.unable")) : RiskUtil.replaceAll(this.resb.getString("core.error.syntax"), "{0}", "nomove")) : RiskUtil.replaceAll(this.resb.getString("core.error.incorrect"), "{0}", "movearmies, nomove");
                    }
                } else if (this.game.getState() == 7) {
                    if (input.equals("endgo")) {
                        if (!this.StringT.hasMoreTokens()) {
                            needInput = false;
                            output = null;
                            this.controller.sendMessage(this.resb.getString("core.endgo.ended"), false, false);
                            this.DoEndGo();
                        } else {
                            output = RiskUtil.replaceAll(this.resb.getString("core.error.syntax"), "{0}", "endgo");
                        }
                    } else {
                        output = RiskUtil.replaceAll(this.resb.getString("core.error.incorrect"), "{0}", "emdgo");
                    }
                } else if (this.game.getState() == 8) {
                    output = input.equals("continue") ? (!this.StringT.hasMoreTokens() ? (this.game.continuePlay() ? this.resb.getString("core.continue.successful") : this.resb.getString("core.continue.error.unable")) : RiskUtil.replaceAll(this.resb.getString("core.error.syntax"), "{0}", "continue")) : RiskUtil.replaceAll(this.resb.getString("core.gameover.won"), "{0}", this.game.getCurrentPlayer().getName());
                } else if (this.game.getState() == 9) {
                    String strCountry;
                    int nCountryId;
                    Country t;
                    output = input.equals("capital") ? (this.StringT.countTokens() == 1 ? ((t = (nCountryId = RiskGame.getNumber(strCountry = this.GetNext())) != -1 ? this.game.getCountryInt(nCountryId) : null) != null && this.game.setCapital(t) ? (this.showHumanPlayerThereInfo() ? RiskUtil.replaceAll(this.resb.getString("core.capital.selected"), "{0}", t.getName()) : this.resb.getString("core.capital.hasbeenselected")) : this.resb.getString("core.capital.error.unable")) : RiskUtil.replaceAll(this.resb.getString("core.error.syntax"), "{0}", "capital country")) : RiskUtil.replaceAll(this.resb.getString("core.error.incorrect"), "{0}", "capital");
                } else if (this.game.getState() == 10) {
                    if (input.equals("roll")) {
                        if (this.StringT.countTokens() == 1) {
                            int dice = RiskGame.getNumber(this.GetNext());
                            if (dice != -1 && this.game.rollD(dice)) {
                                if (this.battle) {
                                    this.controller.setNODDefender(dice);
                                    try {
                                        Thread.sleep(500L);
                                    }
                                    catch (InterruptedException e) {
                                        // empty catch block
                                    }
                                }
                                if (this.shouldGameCommand(Addr)) {
                                    int c;
                                    int[] attackerResults = this.game.rollDice(this.game.getAttackerDice());
                                    int[] defenderResults = this.game.rollDice(this.game.getDefenderDice());
                                    String serverRoll = "";
                                    serverRoll = serverRoll + attackerResults.length + " ";
                                    serverRoll = serverRoll + defenderResults.length + " ";
                                    for (c = 0; c < attackerResults.length; ++c) {
                                        serverRoll = serverRoll + attackerResults[c] + " ";
                                    }
                                    for (c = 0; c < defenderResults.length; ++c) {
                                        serverRoll = serverRoll + defenderResults[c] + " ";
                                    }
                                    this.gameCommand(Addr, "DICE", serverRoll);
                                }
                                output = null;
                                needInput = false;
                            } else {
                                output = this.resb.getString("core.roll.error.unable");
                            }
                        } else {
                            output = RiskUtil.replaceAll(this.resb.getString("core.error.syntax"), "{0}", "roll number");
                        }
                    } else {
                        output = RiskUtil.replaceAll(this.resb.getString("core.error.incorrect"), "{0}", "roll");
                    }
                } else {
                    output = this.resb.getString("core.error.unknownstate");
                }
            }
            this.updateBattleState();
        }
        if (output != null) {
            if (this.game == null) {
                this.controller.sendMessage(output, false, true);
            } else if (this.game.getState() == 0) {
                this.controller.sendMessage(output, false, true);
            } else if (this.game.getState() == 8) {
                this.controller.sendMessage(output, true, true);
            } else if (this.game.getState() == 7) {
                if (this.game.getCurrentPlayer().getAutoEndGo()) {
                    this.controller.sendMessage(output, false, false);
                } else {
                    this.controller.sendMessage(output, true, true);
                }
            } else {
                this.controller.sendMessage(output, true, true);
            }
        }
        if (this.game != null && this.game.getState() == 7 && this.game.getCurrentPlayer().getAutoEndGo()) {
            needInput = false;
            this.DoEndGo();
        }
        if (needInput && this.inbox.isEmpty()) {
            this.getInput();
        }
    }

    public void setMap(String filename) throws Exception {
        if (this.game.getState() == 0) {
            boolean yesmissions = this.game.setMapfile(filename);
            this.setupPreviews(yesmissions);
            String output = RiskUtil.replaceAll(this.resb.getString("core.choosemap.mapselected"), "{0}", filename);
            this.controller.sendMessage(output, false, true);
        } else {
            this.controller.startGame(this.unlimitedLocalMode);
        }
    }

    public void getMapError(String exception) {
        String output = this.resb.getString("core.choosemap.error.unable") + " " + exception;
        this.controller.sendMessage(output, false, true);
        this.showMessageDialog(output);
    }

    private void setupPreviews(boolean yesmissions) {
        this.controller.showMapPic(this.game);
        this.controller.showCardsFile(this.game.getCardsFile(), yesmissions);
    }

    private boolean doesMapHaveMission() {
        Map cardsinfo = RiskUtil.loadInfo(this.game.getCardsFile(), true);
        String[] missions = (String[])cardsinfo.get("missions");
        return missions.length > 0;
    }

    public int getType(String type) {
        if (type.equals("human")) {
            return 0;
        }
        if (type.startsWith("ai ")) {
            String aiType = type.substring(3);
            try {
                return this.ai.getTypeFromCommand(aiType);
            }
            catch (IllegalArgumentException ex) {
                return -1;
            }
        }
        return -1;
    }

    public String getType(int type) {
        if (type == 0) {
            return "human";
        }
        return "ai " + this.ai.getCommandFromType(type);
    }

    private boolean showHumanPlayerThereInfo(Player p) {
        return this.game.getState() == 8 || p != null && p.getType() == 0 && (this.unlimitedLocalMode || this.myAddress.equals(p.getAddress()));
    }

    public boolean showHumanPlayerThereInfo() {
        return this.showHumanPlayerThereInfo(this.game.getCurrentPlayer());
    }

    public void DoEndGo() {
        this.controller.noInput();
        String Addr = this.game.getCurrentPlayer().getAddress();
        if (this.shouldGameCommand(Addr)) {
            this.gameCommand(Addr, "CARD", this.game.getDesrvedCard());
        }
    }

    void gameCommand(String address, String command, String options) {
        if (!this.replay) {
            String fullCommand = command + " " + options;
            if (this.onlinePlayClient == null) {
                this.inGameParser(fullCommand);
            } else if (address.equals(this.myAddress)) {
                this.onlinePlayClient.sendGameCommand(fullCommand);
            }
        }
    }

    boolean shouldGameCommand(String Addr) {
        return !this.replay && (this.onlinePlayClient == null || this.myAddress.equals(Addr));
    }

    public void setReplay(boolean a) {
        this.replay = a;
    }

    public void getInput() {
        this.setHelp();
        if (this.game == null) {
            this.controller.needInput(-1);
        } else if (this.game != null && this.game.getCurrentPlayer() != null && this.game.getState() != 8) {
            this.updateBattleState();
            if (this.game.getState() == 1) {
                this.controller.sendMessage(RiskUtil.replaceAll(this.resb.getString("core.input.newarmies"), "{0}", this.game.getCurrentPlayer().getExtraArmies() + ""), false, false);
            } else if (this.game.getState() == 2) {
                this.controller.sendMessage(RiskUtil.replaceAll(this.resb.getString("core.input.armiesleft"), "{0}", this.game.getCurrentPlayer().getExtraArmies() + ""), false, false);
            }
            if (!this.replay && (this.unlimitedLocalMode || this.game.getCurrentPlayer().getAddress().equals(this.myAddress))) {
                if (this.game.getState() == 10 && this.game.getCurrentPlayer().getAutoDefend()) {
                    this.parser(this.getBasicPassiveGo());
                } else if (this.game.getCurrentPlayer().getType() == 0) {
                    this.controller.needInput(this.game.getState());
                } else {
                    this.ai.play(this);
                }
            }
        } else {
            this.controller.needInput(this.game.getState());
        }
    }

    public String getBasicPassiveGo() {
        return this.ai.getOutput(this.game, 3);
    }

    public String[] getAICommands() {
        return this.ai.getAICommands();
    }

    public String getCommandFromType(int type) {
        return this.ai.getCommandFromType(type);
    }

    public String whoWon() {
        String winner = System.getProperty("line.separator") + RiskUtil.replaceAll(this.resb.getString("core.whowon.hehaswon"), "{0}", this.game.getCurrentPlayer().getName());
        if (this.game.getGameMode() == 3) {
            winner = winner + System.getProperty("line.separator") + RiskUtil.replaceAll(this.resb.getString("core.whowon.mission"), "{0}", this.game.getCurrentPlayer().getMission().getDiscription());
        }
        return winner;
    }

    public void setHelp() {
        String help = "";
        if (this.game != null && this.game.getCurrentPlayer() != null) {
            String strId = null;
            int type = this.game.getCurrentPlayer().getType();
            strId = type == 0 ? "core.help.move.human" : "core.help.move.ai." + this.ai.getCommandFromType(type);
            try {
                help = RiskUtil.replaceAll(this.resb.getString(strId), "{0}", this.game.getCurrentPlayer().getName()) + " ";
            }
            catch (MissingResourceException ex) {
                help = strId + ": (" + this.game.getCurrentPlayer().getName() + ") ";
            }
        }
        help = this.game == null ? this.resb.getString("core.help.newgame") : (this.game.getState() == 0 ? this.resb.getString("core.help.createplayers") : (this.game.getState() == 1 ? help + this.resb.getString("core.help.trade") : (this.game.getState() == 2 ? (this.game.getSetup() ? help + this.resb.getString("core.help.placearmies") : (this.game.NoEmptyCountries() ? help + this.resb.getString("core.help.placearmy") : help + this.resb.getString("core.help.placearmyempty"))) : (this.game.getState() == 3 ? help + this.resb.getString("core.help.attack") : (this.game.getState() == 4 ? help + this.resb.getString("core.help.rollorretreat") : (this.game.getState() == 5 ? help + this.resb.getString("core.help.youhavewon") : (this.game.getState() == 6 ? help + this.resb.getString("core.help.fortifyposition") : (this.game.getState() == 7 ? help + this.resb.getString("core.help.endgo") : (this.game.getState() == 8 ? RiskUtil.replaceAll(this.resb.getString("core.help.gameover"), "{0}", this.game.getCurrentPlayer().getName()) : (this.game.getState() == 9 ? help + this.resb.getString("core.help.selectcapital") : (this.game.getState() == 10 ? help + this.resb.getString("core.help.defendyourself") : this.resb.getString("core.help.error.unknownstate"))))))))))));
        this.controller.setGameStatus(help);
    }

    private void saveGameToUndoObject() {
        if (this.skipUndo) {
            return;
        }
        if (this.unlimitedLocalMode) {
            try {
                this.Undo.reset();
                this.game.saveGame(this.Undo);
            }
            catch (OutOfMemoryError e) {
                this.skipUndo = true;
                System.out.println(this.resb.getString("core.loadgame.error.undo") + " " + e);
            }
            catch (Throwable e) {
                this.skipUndo = true;
                System.out.print(this.resb.getString("core.loadgame.error.undo") + "\n");
                RiskUtil.printStackTrace(e);
            }
        }
    }

    public void setSkipUndo(boolean skip) {
        this.skipUndo = skip;
    }

    public void disconnected() {
        this.closeGame();
        this.controller.sendMessage(this.resb.getString("core.kicked.error.disconnected"), false, false);
        this.getInput();
    }

    private void updateBattleState() {
        if (!(this.game.getState() != 4 && this.game.getState() != 10 || this.battle)) {
            Player attackingPlayer = this.game.getAttacker().getOwner();
            Player defendingPlayer = this.game.getDefender().getOwner();
            if (this.showHumanPlayerThereInfo(attackingPlayer) || this.showHumanPlayerThereInfo(defendingPlayer)) {
                this.controller.openBattle(this.game.getAttacker().getColor(), this.game.getDefender().getColor());
                if (this.game.getState() == 10) {
                    this.controller.setNODAttacker(this.game.getAttackerDice());
                }
                this.battle = true;
            }
        } else if (this.game.getState() != 4 && this.game.getState() != 10) {
            this.closeBattle();
        }
    }

    public void closeBattle() {
        if (this.battle) {
            this.controller.closeBattle();
            this.battle = false;
        }
    }

    public Vector getCurrentCards() {
        return this.game.getCurrentPlayer().getCards();
    }

    public int hasArmiesInt(int name) {
        return this.game.getCountryInt(name).getArmies();
    }

    public boolean canAttack(int nCountryFrom, int nCountryTo) {
        return this.game.getCountryInt(nCountryFrom).isNeighbours(this.game.getCountryInt(nCountryTo));
    }

    public boolean isOwnedCurrentPlayerInt(int name) {
        return this.game != null && this.game.getCurrentPlayer() != null && this.game.getCountryInt(name) != null && (this.game.getCountryInt(name).getOwner() == null || this.game.getCountryInt(name).getOwner() == this.game.getCurrentPlayer());
    }

    public String getCurrentMission() {
        if (this.game.getGameMode() == 0) {
            return this.resb.getString("core.mission.conquerworld");
        }
        if (this.game.getGameMode() == 2) {
            return this.resb.getString("core.mission.capturecapitals");
        }
        if (this.game.getGameMode() == 3) {
            return this.game.getCurrentPlayer().getMission().getDiscription();
        }
        return this.resb.getString("core.mission.error.cantshow");
    }

    public int[] getPlayerColors() {
        Country defender;
        RiskGame g = this.game;
        if (g == null) {
            return new int[0];
        }
        if (g.getState() == 10 && (defender = g.getDefender()) != null) {
            return new int[]{defender.getOwner().getColor()};
        }
        Vector Players = g.getPlayers();
        boolean setup = g.NoEmptyCountries();
        int num = 0;
        int start = 0;
        for (int c = 0; c < Players.size(); ++c) {
            if (((Player)Players.get(c)).getNoTerritoriesOwned() > 0 || !setup) {
                ++num;
            }
            if ((Player)Players.get(c) != g.getCurrentPlayer()) continue;
            start = c;
        }
        int[] playerColors = new int[num];
        int current = 0;
        for (int c = start; c < Players.size(); ++c) {
            if (((Player)Players.get(c)).getNoTerritoriesOwned() > 0 || !setup) {
                playerColors[current] = ((Player)Players.get(c)).getColor();
                ++current;
            }
            if (current == num) break;
            if (c != Players.size() - 1) continue;
            c = -1;
        }
        return playerColors;
    }

    public int getCurrentPlayerColor() {
        if (this.game != null && this.game.getState() != 0) {
            return this.game.getCurrentPlayer().getColor();
        }
        return 0;
    }

    public int getColorOfOwner(int n) {
        return this.game.getCountryInt(n).getOwner().getColor();
    }

    public boolean canTrade(String c1, String c2, String c3) {
        if (this.game.getState() == 1) {
            Card[] cards = this.game.getCards(c1, c2, c3);
            return this.game.checkTrade(cards[0], cards[1], cards[2]);
        }
        return false;
    }

    public int getNewCardState() {
        return this.game.getNewCardState();
    }

    public RiskGame getGame() {
        return this.game;
    }

    public boolean getLocalGame() {
        return this.unlimitedLocalMode;
    }

    public String getCountryName(int c) {
        Country t = this.game.getCountryInt(c);
        if (t == null) {
            return "";
        }
        return t.getName();
    }

    public boolean getAutoEndGo() {
        if (this.game != null && this.game.getCurrentPlayer() != null) {
            return this.game.getCurrentPlayer().getAutoEndGo();
        }
        return false;
    }

    public boolean getAutoDefend() {
        if (this.game != null && this.game.getCurrentPlayer() != null) {
            return this.game.getCurrentPlayer().getAutoDefend();
        }
        return false;
    }

    public void showMessageDialog(String a) {
        this.controller.showMessageDialog(a);
    }

    public void renamePlayer(String oldser, String newuser) {
        Vector players = this.game.getPlayers();
        for (int c = 0; c < players.size(); ++c) {
            Player player = (Player)players.elementAt(c);
            if (!oldser.equals(player.getName())) continue;
            player.rename(newuser);
            break;
        }
        this.setHelp();
    }

    private synchronized void closeGame() {
        if (this.onlinePlayClient != null) {
            this.onlinePlayClient.closeGame();
            this.onlinePlayClient = null;
            this.myAddress = Risk.createRandomUniqueAddress();
        }
        if (!this.inbox.isEmpty()) {
            System.out.println("clearing commands " + this.inbox);
            this.inbox.clear();
        }
        if (this.game != null) {
            this.closeBattle();
            this.controller.closeGame();
            this.game = null;
        }
    }

    public void newMemoryGame(RiskGame g, String map) {
        this.closeGame();
        try {
            NullCipher nullCipher = new NullCipher();
            this.game = (RiskGame)new SealedObject(g, nullCipher).getObject(nullCipher);
            this.game.loadMap(false, new BufferedReader(new StringReader(map)));
            for (int c = 1; c <= 6; ++c) {
                this.game.delPlayer("PLAYER" + c);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.controller.newGame(true);
        this.controller.showCardsFile("loaded from memory", this.game.getNoMissions() != 0);
        this.unlimitedLocalMode = true;
    }

    public void lobbyMessage(Map map, String myName, OnlineRisk lrisk) {
        String command = (String)map.get("command");
        if ("game".equals(command)) {
            String address = (String)map.get("playerId");
            RiskGame thegame = (RiskGame)map.get("game");
            this.onlinePlayClient = lrisk;
            this.myAddress = address;
            this.unlimitedLocalMode = false;
            this.setGame(thegame);
        } else if ("rename".equals(command)) {
            this.myAddress = (String)map.get("playerId");
            String oldName = (String)map.get("oldName");
            String newName = (String)map.get("newName");
            String newAddress = (String)map.get("newAddress");
            int newType = (Integer)map.get("newType");
            this.renamePlayer(oldName, newName, newAddress, newType);
        } else {
            throw new RuntimeException("unknown command " + command);
        }
    }

    public void setGame(RiskGame b) {
        if (this.game != null) {
            this.controller.closeGame();
        }
        this.inbox.clear();
        this.game = b;
        this.controller.startGame(this.unlimitedLocalMode);
        this.getInput();
    }

    public void renamePlayer(String name, String newName, String newAddress, int newType) {
        if (this.game != null) {
            Vector players = this.game.getPlayers();
            Player leaver = null;
            for (int c = 0; c < players.size(); ++c) {
                Player player = (Player)players.get(c);
                if (!player.getName().equals(name)) continue;
                player.rename(newName);
                player.setType(newType);
                player.setAddress(newAddress);
                leaver = player;
                break;
            }
            if (leaver == this.game.getCurrentPlayer()) {
                this.getInput();
            }
        }
    }

    public Player findEmptySpot() {
        if (this.game != null) {
            Vector players = this.game.getPlayers();
            for (int c = 0; c < players.size(); ++c) {
                Player player = (Player)players.get(c);
                if (player.getType() != 3 || player.getExtraArmies() <= 0 && player.getNoTerritoriesOwned() <= 0) continue;
                return player;
            }
        }
        return null;
    }

    static {
        types = new String[]{"human", "ai easy", "ai easy", "ai easy", "ai average", "ai average"};
        names = new String[]{"player", "bob", "fred", "ted", "yura", "lala"};
        colors = new String[]{"green", "blue", "red", "cyan", "magenta", "yellow"};
    }

    private static class GameCommand {
        public static final int UI_COMMAND = 1;
        public static final int NETWORK_COMMAND = 2;
        final int type;
        final String command;

        public GameCommand(int t, String c) {
            this.type = t;
            this.command = c;
        }

        public String toString() {
            return (this.type == 1 ? "UI" : "NETWORK") + " " + this.command;
        }
    }
}

