/*
 * Decompiled with CFR 0.152.
 */
package net.yura.mobile.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import net.yura.mobile.io.UTF8InputStreamReader;
import net.yura.mobile.io.XMLUtil;
import net.yura.mobile.io.json.JSONTokener;
import net.yura.mobile.io.json.JSONWriter;
import net.yura.mobile.logging.Logger;

public class JSONUtil {
    public void save(OutputStream out, Object obj) throws IOException {
        OutputStreamWriter w = new OutputStreamWriter(out);
        JSONWriter writer = new JSONWriter(w);
        this.saveObject(writer, obj);
        w.flush();
    }

    public Object load(InputStream in) throws IOException {
        JSONTokener tokener = new JSONTokener(new UTF8InputStreamReader(in));
        return this.readObject(tokener);
    }

    protected void saveObject(JSONWriter serializer, Object object) throws IOException {
        if (object == null) {
            serializer.nullValue();
        } else if (object instanceof String) {
            serializer.value((String)object);
        } else if (object instanceof Boolean) {
            serializer.value((Boolean)object);
        } else if (object instanceof Vector) {
            this.saveVector(serializer, (Vector)object);
        } else if (object instanceof Hashtable) {
            serializer.object();
            serializer.key("Hashtable");
            this.saveHashtable(serializer, (Hashtable)object);
            serializer.endObject();
        } else if (object instanceof Object[]) {
            serializer.object();
            serializer.key("ArrayList");
            this.saveArray(serializer, (Object[])object);
            serializer.endObject();
        } else {
            serializer.object();
            serializer.key(XMLUtil.getObjectType(object));
            if (object instanceof Character) {
                serializer.value(((Character)object).charValue());
            } else if (object instanceof Integer) {
                serializer.value(((Integer)object).longValue());
            } else if (object instanceof Double) {
                serializer.value((Double)object);
            } else if (object instanceof Float) {
                serializer.value(((Float)object).doubleValue());
            } else if (object instanceof Byte) {
                serializer.value(((Byte)object).byteValue());
            } else if (object instanceof Short) {
                serializer.value(((Short)object).shortValue());
            } else if (object instanceof Long) {
                serializer.value((Long)object);
            } else {
                throw new IOException();
            }
            serializer.endObject();
        }
    }

    protected Object readObject(JSONTokener x) throws IOException {
        Object result;
        char c = x.nextClean();
        x.back();
        switch (c) {
            case '\"': 
            case '\'': {
                result = x.nextString();
                break;
            }
            case '{': {
                x.startObject();
                String key = x.nextKey();
                result = this.readObject(x, key);
                if (x.endObject()) break;
                throw new IOException("anon object does not end after 1 value");
            }
            case '(': 
            case '[': {
                result = this.readVector(x);
                break;
            }
            default: {
                String s = x.nextSimple();
                if (s.equalsIgnoreCase("true")) {
                    result = Boolean.TRUE;
                    break;
                }
                if (s.equalsIgnoreCase("false")) {
                    result = Boolean.FALSE;
                    break;
                }
                if (s.equalsIgnoreCase("null")) {
                    result = null;
                    break;
                }
                throw new IOException("numbers not wraped in a object not aupported " + s);
            }
        }
        return result;
    }

    protected Object readObject(JSONTokener tokener, String name) throws IOException {
        if ("ArrayList".equals(name)) {
            Vector vector = this.readVector(tokener);
            Object[] array = new Object[vector.size()];
            vector.copyInto(array);
            return array;
        }
        if ("Hashtable".equals(name)) {
            return this.readHashtable(tokener);
        }
        String value = tokener.nextSimple();
        if ("Integer".equals(name)) {
            return Integer.valueOf(value);
        }
        if ("Double".equals(name)) {
            return Double.valueOf(value);
        }
        if ("Float".equals(name)) {
            return Float.valueOf(value);
        }
        if ("Short".equals(name)) {
            return new Short(Short.parseShort(value));
        }
        if ("Long".equals(name)) {
            return new Long(Long.parseLong(value));
        }
        if ("Character".equals(name)) {
            return new Character(value.charAt(0));
        }
        if ("Byte".equals(name)) {
            return new Byte(Byte.parseByte(value));
        }
        Logger.warn("unknown object: " + name);
        throw new IOException();
    }

    protected void saveHashtable(JSONWriter serializer, Hashtable hashtable) throws IOException {
        Object key;
        boolean keyObject = false;
        Enumeration enu = hashtable.keys();
        while (enu.hasMoreElements()) {
            key = enu.nextElement();
            if (key instanceof String) continue;
            keyObject = true;
            break;
        }
        if (keyObject) {
            serializer.array();
            enu = hashtable.keys();
            while (enu.hasMoreElements()) {
                key = enu.nextElement();
                Object obj = hashtable.get(key);
                this.saveObject(serializer, key);
                this.saveObject(serializer, obj);
            }
            serializer.endArray();
        } else {
            serializer.object();
            enu = hashtable.keys();
            while (enu.hasMoreElements()) {
                key = (String)enu.nextElement();
                Object obj = hashtable.get(key);
                serializer.key((String)key);
                this.saveObject(serializer, obj);
            }
            serializer.endObject();
        }
    }

    protected void saveVector(JSONWriter serializer, Vector object) throws IOException {
        serializer.array();
        for (int c = 0; c < object.size(); ++c) {
            this.saveObject(serializer, object.elementAt(c));
        }
        serializer.endArray();
    }

    protected void saveArray(JSONWriter serializer, Object[] object) throws IOException {
        serializer.array();
        for (int c = 0; c < object.length; ++c) {
            this.saveObject(serializer, object[c]);
        }
        serializer.endArray();
    }

    protected Vector readVector(JSONTokener x) throws IOException {
        Vector<Object> vector = new Vector<Object>();
        x.startArray();
        if (x.nextClean() == ']') {
            return vector;
        }
        x.back();
        do {
            if (x.nextClean() == ',') {
                x.back();
                vector.addElement(null);
                continue;
            }
            x.back();
            vector.addElement(this.readObject(x));
        } while (!x.endArray());
        return vector;
    }

    protected Hashtable readHashtable(JSONTokener x) throws IOException {
        Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>();
        if (x.nextClean() == '[') {
            Object key = null;
            do {
                if (key == null) {
                    key = this.readObject(x);
                    continue;
                }
                hashtable.put(key, this.readObject(x));
                key = null;
            } while (!x.endArray());
            return hashtable;
        }
        x.back();
        x.startObject();
        if (x.nextClean() == '}') {
            return hashtable;
        }
        x.back();
        boolean end = false;
        while (!end) {
            String key = x.nextKey();
            Object obj = this.readObject(x);
            hashtable.put(key, obj);
            end = x.endObject();
        }
        return hashtable;
    }
}

