/*
 * Decompiled with CFR 0.152.
 */
package net.yura.mobile.io;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import net.yura.mobile.logging.Logger;

public class BinUtil {
    public static final int TYPE_BYTE_ARRAY = 13;
    public static final int TYPE_HASHTABLE = 12;
    public static final int TYPE_VECTOR = 10;
    public static final int TYPE_ARRAY = 11;
    public static final int TYPE_STRING = 5;
    public static final int TYPE_INTEGER = 1;
    public static final int TYPE_DOUBLE = 2;
    public static final int TYPE_FLOAT = 3;
    public static final int TYPE_BOOLEAN = 4;
    public static final int TYPE_SHORT = 6;
    public static final int TYPE_LONG = 7;
    public static final int TYPE_CHARACTER = 8;
    public static final int TYPE_BYTE = 9;
    public static final int TYPE_NULL = 0;

    public void save(OutputStream out, Object obj) throws IOException {
        DataOutputStream out2 = new DataOutputStream(out);
        this.writeObject(out2, obj);
        out2.flush();
    }

    public Object load(InputStream in) throws IOException {
        DataInputStream int2 = new DataInputStream(in);
        return this.readObject(int2);
    }

    protected void writeObject(DataOutputStream out, Object obj) throws IOException {
        if (obj instanceof Double) {
            out.writeInt(2);
            out.writeDouble((Double)obj);
        } else if (obj instanceof Integer) {
            out.writeInt(1);
            out.writeInt((Integer)obj);
        } else if (obj instanceof Vector) {
            out.writeInt(10);
            this.writeVector(out, (Vector)obj);
        } else if (obj instanceof String) {
            out.writeInt(5);
            out.writeUTF((String)obj);
        } else if (obj instanceof Float) {
            out.writeInt(3);
            out.writeFloat(((Float)obj).floatValue());
        } else if (obj instanceof Short) {
            out.writeInt(6);
            out.writeShort(((Short)obj).shortValue());
        } else if (obj instanceof Long) {
            out.writeInt(7);
            out.writeLong((Long)obj);
        } else if (obj instanceof Boolean) {
            out.writeInt(4);
            out.writeBoolean((Boolean)obj);
        } else if (obj instanceof Byte) {
            out.writeInt(9);
            out.writeByte(((Byte)obj).byteValue());
        } else if (obj instanceof Object[]) {
            out.writeInt(11);
            this.writeArray(out, (Object[])obj);
        } else if (obj instanceof Hashtable) {
            out.writeInt(12);
            this.writeHashtable(out, (Hashtable)obj);
        } else if (obj instanceof byte[]) {
            out.writeInt(13);
            this.writeBytes(out, (byte[])obj);
        } else if (obj instanceof Character) {
            out.writeInt(8);
            out.writeChar(((Character)obj).charValue());
        } else if (obj == null) {
            out.writeInt(0);
        } else {
            out.writeInt(-1);
            out.writeInt(0);
            throw new IOException();
        }
    }

    protected void writeBytes(DataOutputStream out, byte[] bytes) throws IOException {
        out.writeInt(bytes.length);
        out.write(bytes);
    }

    protected void writeVector(DataOutputStream out, Vector vector) throws IOException {
        int size = vector.size();
        out.writeInt(size);
        for (int c = 0; c < size; ++c) {
            this.writeObject(out, vector.elementAt(c));
        }
    }

    protected void writeArray(DataOutputStream out, Object[] object) throws IOException {
        out.writeInt(object.length);
        for (int c = 0; c < object.length; ++c) {
            this.writeObject(out, object[c]);
        }
    }

    protected void writeHashtable(DataOutputStream out, Hashtable hashtable) throws IOException {
        int size = hashtable.size();
        out.writeInt(size * 2);
        Enumeration enu = hashtable.keys();
        while (enu.hasMoreElements()) {
            Object key = enu.nextElement();
            Object obj = hashtable.get(key);
            this.writeObject(out, key);
            this.writeObject(out, obj);
        }
    }

    protected Object readObject(DataInputStream in2) throws IOException {
        int type = in2.readInt();
        switch (type) {
            case 1: {
                return new Integer(in2.readInt());
            }
            case 2: {
                return new Double(in2.readDouble());
            }
            case 10: {
                return this.readVector(in2);
            }
            case 5: {
                return in2.readUTF();
            }
            case 4: {
                return in2.readBoolean() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 9: {
                return new Byte(in2.readByte());
            }
            case 8: {
                return new Character(in2.readChar());
            }
            case 6: {
                return new Short(in2.readShort());
            }
            case 7: {
                return new Long(in2.readLong());
            }
            case 11: {
                return this.readArray(in2);
            }
            case 12: {
                return this.readHashtable(in2);
            }
            case 3: {
                return new Float(in2.readFloat());
            }
            case 13: {
                return this.readBytes(in2);
            }
            case 0: {
                return null;
            }
        }
        int size = in2.readInt();
        return this.readObject(in2, type, size);
    }

    protected Object readObject(DataInputStream in2, int type, int size) throws IOException {
        Logger.warn("unknown object, type: " + type + " length: " + size);
        for (int c = 0; c < size; ++c) {
            Object obj = this.readObject(in2);
            Logger.warn("unknown object, content: " + obj);
        }
        throw new IOException();
    }

    protected void skipUnknownObjects(DataInputStream in, int num) throws IOException {
        for (int c = 0; c < num; ++c) {
            Object obj = this.readObject(in);
            Logger.warn("unknown object found: " + obj);
        }
    }

    protected static void checkType(int got, int want) throws IOException {
        if (want != got) {
            throw new IOException("wrong type, expected: " + want + " got: " + got);
        }
    }

    protected Vector readVector(DataInputStream in2) throws IOException {
        int size = in2.readInt();
        Vector<Object> vector = new Vector<Object>(size);
        for (int c = 0; c < size; ++c) {
            Object obj = this.readObject(in2);
            vector.addElement(obj);
        }
        return vector;
    }

    protected Object[] readArray(DataInputStream in2) throws IOException {
        int size = in2.readInt();
        Object[] vector = new Object[size];
        for (int c = 0; c < size; ++c) {
            Object obj;
            vector[c] = obj = this.readObject(in2);
        }
        return vector;
    }

    protected byte[] readBytes(DataInputStream in2) throws IOException {
        int size = in2.readInt();
        byte[] bytes = new byte[size];
        in2.readFully(bytes);
        return bytes;
    }

    protected Hashtable readHashtable(DataInputStream in2) throws IOException {
        int size = in2.readInt() / 2;
        Hashtable<Object, Object> vector = new Hashtable<Object, Object>(size);
        for (int c = 0; c < size; ++c) {
            Object key = this.readObject(in2);
            Object value = this.readObject(in2);
            vector.put(key, value);
        }
        return vector;
    }
}

