/*
 * Decompiled with CFR 0.152.
 */
package net.yura.translation;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import net.yura.grasshopper.SimpleBug;
import net.yura.swing.CollapsiblePanel;
import net.yura.swing.Service;
import net.yura.swing.TCPopupEventQueue;
import net.yura.swing.TreeCombo;
import net.yura.translation.DoublePanel;
import net.yura.translation.Mtcomm;
import net.yura.translation.MyNode;
import net.yura.translation.MyPanel;
import net.yura.translation.PartnerNode;
import net.yura.translation.Result;

public class MessageTool
extends JPanel
implements ActionListener,
TreeSelectionListener,
TreeWillExpandListener,
ListSelectionListener {
    private JTree tree;
    protected Mtcomm mycomm;
    private MyPanel box;
    private JTextField status;
    private JComboBox address;
    private JComboBox local;
    private TreeCombo part;
    private JButton find;
    private Vector partners;
    private MyNode message;
    private JCheckBox wrap;
    private JTextField searchbox;
    private JList results;
    private Locale currentlocale;
    private PartnerNode currentpartner;
    private JComboBox filter1;
    private JCheckBox filter3;
    private JToolBar toolbar;
    public static final String appName = "yura.net CUNNING LINGUIST Translation Tool";
    public static final String version = "2.7";
    public static final String WEBSITE = "http://cunninglinguist.sf.net/";
    private Map partmap;
    public static final Comparator CASE_POSTERIORITY_ORDER = new Comparator(){

        public int compare(Object o1, Object o2) {
            int a = o1.toString().compareToIgnoreCase(o2.toString());
            return a == 0 ? o1.toString().compareTo(o2.toString()) : a;
        }
    };
    private boolean actioncancelled;
    private boolean searching;
    private Result[] fullResults;
    Thread setLocale;
    private static Object FILTER_DEFAULT_CURRENT = "Default&Current";
    private static Object FILTER_ALL = "All";
    private static Object FILTER_DEFAULT = "Default";

    public MessageTool() {
        try {
            Toolkit.getDefaultToolkit().getSystemEventQueue().push(new TCPopupEventQueue());
        }
        catch (Throwable th) {
            System.err.println("TCPopupEventQueue error: " + th.toString());
        }
        this.setName("yura.net CUNNING LINGUIST Translation Tool 2.7");
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        JButton load = new JButton("Load", new ImageIcon(MessageTool.class.getResource("openFile.png")));
        load.setActionCommand("load");
        load.addActionListener(this);
        this.wrap = new JCheckBox("Word Wrap");
        this.wrap.setActionCommand("wrap");
        this.wrap.addActionListener(this);
        this.toolbar = new JToolBar();
        this.toolbar.setFloatable(false);
        this.address = new JComboBox();
        this.address.setEditable(true);
        this.address.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    MessageTool.this.actionPerformed(new ActionEvent(e, e.getKeyCode(), "go"));
                }
            }
        });
        JButton go = new JButton("Go");
        go.setActionCommand("go");
        go.addActionListener(this);
        JPanel addressbar = new JPanel(new BorderLayout());
        addressbar.add((Component)new JLabel("   Address: "), "West");
        addressbar.add(this.address);
        addressbar.add((Component)go, "East");
        addressbar.setOpaque(false);
        JButton add = new JButton("add Message", new ImageIcon(MessageTool.class.getResource("New16.gif")));
        add.setActionCommand("add");
        add.addActionListener(this);
        AbstractAction refresh = new AbstractAction("refresh tree", new ImageIcon(MessageTool.class.getResource("Refresh16.gif"))){

            public void actionPerformed(ActionEvent e) {
                MessageTool.this.actionPerformed(new ActionEvent(e.getSource(), e.getID(), "refresh"));
            }
        };
        this.getInputMap(2).put(KeyStroke.getKeyStroke("F5"), "refresh_tree");
        this.getActionMap().put("refresh_tree", refresh);
        JButton save = new JButton("save Message", new ImageIcon(MessageTool.class.getResource("Save16.gif")));
        save.setActionCommand("save message");
        save.addActionListener(this);
        JButton revert = new JButton("revert Message", new ImageIcon(MessageTool.class.getResource("Undo16.gif")));
        revert.setActionCommand("revert");
        revert.addActionListener(this);
        this.toolbar.add(load);
        this.toolbar.addSeparator();
        this.toolbar.add(add);
        this.toolbar.add(new JButton(refresh));
        this.toolbar.addSeparator();
        this.toolbar.add(save);
        this.toolbar.add(revert);
        this.local = new JComboBox();
        this.local.setActionCommand("locale");
        this.local.addActionListener(this);
        Dimension size = new Dimension(80, 25);
        this.local.setMaximumSize(size);
        this.local.setMinimumSize(size);
        this.local.setPreferredSize(size);
        this.part = new TreeCombo();
        this.part.setActionCommand("partner");
        this.part.addActionListener(this);
        size = new Dimension(150, 20);
        this.part.setMaximumSize(size);
        this.part.setMinimumSize(size);
        this.part.setPreferredSize(size);
        this.toolbar.add(Box.createHorizontalGlue());
        this.toolbar.add(new JLabel("  Locale: "));
        this.toolbar.add(this.local);
        this.toolbar.add(new JLabel("  Partner: "));
        this.toolbar.add(this.part);
        this.toolbar.setRollover(true);
        this.tree = new JTree((TreeNode)null);
        this.tree.addTreeSelectionListener(this);
        this.tree.addTreeWillExpandListener(this);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setCellRenderer(new MyRenderer());
        JSplitPane splitPane = new JSplitPane();
        this.box = new MyPanel();
        JScrollPane scrollPane = new JScrollPane(this.box, 21, 32);
        this.find = new JButton("find");
        this.find.setActionCommand("find");
        this.find.addActionListener(this);
        this.searchbox = new JTextField();
        this.searchbox.setActionCommand("find");
        this.searchbox.addActionListener(this);
        JPanel search = new JPanel(new BorderLayout());
        search.setOpaque(false);
        JPanel stop = new JPanel(new BorderLayout());
        stop.setOpaque(false);
        stop.add(this.searchbox);
        stop.add((Component)this.find, "East");
        this.results = new JList();
        this.results.addListSelectionListener(this);
        this.results.setSelectionMode(0);
        this.filter1 = new JComboBox();
        this.filter1.setActionCommand("filter");
        this.filter1.addActionListener(this);
        this.filter3 = new JCheckBox();
        this.filter3.setActionCommand("missing");
        this.filter3.addActionListener(this);
        this.filter3.setOpaque(false);
        JPanel advanced = new JPanel(new GridBagLayout());
        advanced.setOpaque(false);
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(3, 3, 3, 3);
        c.fill = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        advanced.add((Component)new JLabel("Locale: "), c);
        c.weightx = 1.0;
        c.gridx = 1;
        c.gridy = 0;
        advanced.add((Component)this.filter1, c);
        c.weightx = 0.0;
        c.gridx = 0;
        c.gridy = 1;
        advanced.add((Component)new JLabel("Partner: "), c);
        c.weightx = 1.0;
        c.gridx = 1;
        c.gridy = 1;
        advanced.add(new JComboBox(), c);
        c.weightx = 0.0;
        c.gridx = 0;
        c.gridy = 2;
        advanced.add((Component)new JLabel("Missing: "), c);
        c.weightx = 1.0;
        c.gridx = 1;
        c.gridy = 2;
        advanced.add((Component)this.filter3, c);
        JPanel more = new JPanel(new BorderLayout());
        more.setOpaque(false);
        CollapsiblePanel advanced1 = new CollapsiblePanel(advanced, "Advanced Filters");
        advanced1.setOpaque(false);
        more.add((Component)advanced1, "North");
        more.add(new JScrollPane(this.results));
        search.add((Component)stop, "North");
        search.add(more);
        JTabbedPane tabs = new JTabbedPane();
        tabs.add("tree", new JScrollPane(this.tree));
        tabs.add("search", search);
        splitPane.setLeftComponent(tabs);
        splitPane.setRightComponent(scrollPane);
        splitPane.setDividerLocation(200);
        splitPane.setContinuousLayout(true);
        this.status = new JTextField("plugin not loaded");
        this.status.setEnabled(false);
        this.status.setDisabledTextColor(this.getForeground());
        this.status.setOpaque(false);
        this.wrap.setOpaque(false);
        JPanel bottom = new JPanel(new BorderLayout());
        bottom.setOpaque(false);
        bottom.add(this.status);
        bottom.add((Component)this.wrap, "East");
        this.add((Component)addressbar, "North");
        this.add(splitPane);
        this.add((Component)bottom, "South");
        this.partners = new Vector();
    }

    public Locale getCurrentLocale() {
        return this.currentlocale;
    }

    public Mtcomm getPlugin() {
        return this.mycomm;
    }

    public JToolBar getToolBar() {
        return this.toolbar;
    }

    public JMenu getMenu() {
        return null;
    }

    public void valueChanged(TreeSelectionEvent e) {
        MyNode node = (MyNode)this.tree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        if (this.actioncancelled) {
            this.actioncancelled = false;
            return;
        }
        if (node.hasMessage() && this.checkChange()) {
            this.actioncancelled = true;
            this.tree.setSelectionPath(e.getOldLeadSelectionPath());
            return;
        }
        String name = node.getName();
        this.address.removeItem(name);
        this.address.insertItemAt(name, 0);
        this.address.setSelectedIndex(0);
        if (!node.hasMessage()) {
            return;
        }
        this.message = node;
        this.redoMessage();
    }

    public boolean checkChange() {
        boolean needsave = false;
        Component[] nowpartners = this.box.getComponents();
        for (int c = 0; c < nowpartners.length; ++c) {
            DoublePanel p = (DoublePanel)nowpartners[c];
            if (!p.checkChange()) continue;
            needsave = true;
            break;
        }
        if (needsave) {
            int result = JOptionPane.showConfirmDialog(this, "do you want to save changes to: " + this.message.getName(), "save?", 1);
            if (result == 2) {
                return true;
            }
            if (result == 0) {
                this.saveChanges();
            }
        }
        return false;
    }

    public void redoMessage() {
        if (this.message == null) {
            return;
        }
        PartnerNode[] partnersh = (PartnerNode[])this.partmap.get(this.currentpartner);
        if (partnersh == null) {
            try {
                partnersh = MessageTool.getPartnerHierarchy(this.currentpartner);
                if (partnersh == null || partnersh.length == 0) {
                    throw new Exception("nothing returned");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.showError("unable to load partners hierarchy: " + e.getMessage());
            }
            this.partmap.put(this.currentpartner, partnersh);
        }
        boolean dowrap = this.wrap.isSelected();
        while (this.partners.size() < partnersh.length) {
            DoublePanel p = new DoublePanel(this.tree);
            this.partners.add(p);
            p.setWrap(dowrap);
        }
        this.box.removeAll();
        for (int c = 0; c < partnersh.length; ++c) {
            DoublePanel p = (DoublePanel)this.partners.elementAt(c);
            try {
                p.reuse(this.message, partnersh[c], null, this.currentlocale, this.mycomm);
                this.box.add(p);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.showError("unable to load message: " + e.getMessage());
                e.printStackTrace();
            }
        }
        this.box.validate();
        this.box.repaint();
    }

    public static PartnerNode[] getPartnerHierarchy(PartnerNode p) throws Exception {
        TreeNode[] path = p.getPath();
        PartnerNode[] paths = new PartnerNode[path.length];
        for (int c = 0; c < path.length; ++c) {
            paths[c] = (PartnerNode)path[path.length - 1 - c];
        }
        return paths;
    }

    public void saveChanges() {
        Component[] nowpartners = this.box.getComponents();
        try {
            for (int c = 0; c < nowpartners.length; ++c) {
                DoublePanel p = (DoublePanel)nowpartners[c];
                p.saveChanges();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.showError("unable to save: " + e.getMessage());
        }
    }

    public void treeWillExpand(TreeExpansionEvent e) throws ExpandVetoException {
        MyNode node = (MyNode)e.getPath().getLastPathComponent();
        try {
            node.loadChildren(this.mycomm, this.currentlocale);
        }
        catch (Exception ex) {
            this.showError("unable to load children: " + ex.getMessage());
            throw new ExpandVetoException(e);
        }
    }

    public void treeWillCollapse(TreeExpansionEvent e) throws ExpandVetoException {
    }

    public static String getNewPlugin(Component parent, String[] files) {
        if (files.length == 1) {
            return files[0];
        }
        JComboBox<String> box = new JComboBox<String>();
        for (int c = 0; c < files.length; ++c) {
            box.addItem(files[c].substring(files[c].lastIndexOf(46) + 1, files[c].length()));
        }
        Object[] message = new Object[]{"Select Plugin:", box};
        Object[] options = new String[]{"OK", "cancel"};
        int result = JOptionPane.showOptionDialog(parent, message, "select plugin", 2, 3, null, options, options[0]);
        if (result == 0) {
            return files[((JComboBox)message[1]).getSelectedIndex()];
        }
        return null;
    }

    public static String[] getPlugins() {
        Iterator providers = Service.providerClasses(MessageTool.class);
        ArrayList<String> list = new ArrayList<String>();
        while (providers.hasNext()) {
            String name = ((Class)providers.next()).getName();
            if (list.contains(name)) continue;
            list.add(name);
        }
        return list.toArray(new String[list.size()]);
    }

    public void actionPerformed(ActionEvent ae) {
        if (ae.getActionCommand().equals("load")) {
            if (this.checkChange()) {
                return;
            }
            this.load();
        } else if (ae.getActionCommand().equals("add")) {
            MyNode newnode;
            MyNode node;
            String name;
            TreePath path = this.tree.getSelectionPath();
            if (path != null && (name = JOptionPane.showInputDialog(this, "Select name:", (node = (MyNode)path.getLastPathComponent()).getName())) != null && (newnode = this.addNode(name)) != null) {
                TreePath treepath = new TreePath(newnode.getPath());
                this.tree.setSelectionPath(treepath);
                this.tree.scrollPathToVisible(treepath);
            }
        } else if (ae.getActionCommand().equals("refresh")) {
            TreePath path = this.tree.getSelectionPath();
            if (path != null) {
                MyNode node = (MyNode)path.getLastPathComponent();
                node.removeAllChildren();
                try {
                    node.loadChildren(this.mycomm, this.currentlocale);
                }
                catch (Exception e) {
                    this.showError("unable to load children: " + e.getMessage());
                }
                ((DefaultTreeModel)this.tree.getModel()).reload(node);
            }
        } else if (ae.getActionCommand().equals("find")) {
            if (this.mycomm != null && !this.searching) {
                this.searching = true;
                this.find.setEnabled(false);
                this.status.setText("Searching...");
                new Thread(){

                    public void run() {
                        try {
                            MessageTool.access$002(MessageTool.this, MessageTool.this.mycomm.search(MessageTool.this.filter3.isSelected() ? null : MessageTool.this.searchbox.getText()));
                            MessageTool.this.doFilter();
                        }
                        catch (Throwable e) {
                            MessageTool.this.showError("unable to search: " + e.getMessage());
                            e.printStackTrace();
                            MessageTool.this.status.setText("Ready");
                        }
                        MessageTool.this.find.setEnabled(true);
                        MessageTool.this.searching = false;
                    }
                }.start();
            }
        } else if (ae.getActionCommand().equals("go")) {
            String name = ((JTextComponent)this.address.getEditor().getEditorComponent()).getText();
            if (name == "" || this.mycomm == null) {
                return;
            }
            MyNode node = this.getNode(name);
            if (node != null) {
                TreePath treepath = new TreePath(node.getPath());
                this.tree.setSelectionPath(treepath);
                this.tree.scrollPathToVisible(treepath);
            }
        } else if (ae.getActionCommand().equals("locale")) {
            if (this.checkChange()) {
                this.local.setSelectedItem(this.currentlocale);
                return;
            }
            final Thread old = this.setLocale;
            this.setLocale = new Thread(){

                public void run() {
                    try {
                        if (old != null) {
                            old.join();
                        }
                        MessageTool.this.setCurrentLocale((Locale)MessageTool.this.local.getSelectedItem());
                    }
                    catch (InterruptedException in) {
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        MessageTool.this.showError("unable to setup locale: " + e);
                    }
                }
            };
            this.setLocale.start();
        } else if (ae.getActionCommand().equals("partner")) {
            if (this.checkChange()) {
                this.part.setSelectedItem(this.currentpartner);
                return;
            }
            this.currentpartner = (PartnerNode)this.part.getSelectedItem();
            this.redoMessage();
        } else if (ae.getActionCommand().equals("wrap")) {
            boolean dowrap = this.wrap.isSelected();
            for (int c = 0; c < this.partners.size(); ++c) {
                DoublePanel p = (DoublePanel)this.partners.elementAt(c);
                p.setWrap(dowrap);
            }
        } else if (ae.getActionCommand().equals("save message")) {
            this.saveChanges();
        } else if (ae.getActionCommand().equals("revert")) {
            Component[] nowpartners = this.box.getComponents();
            for (int c = 0; c < nowpartners.length; ++c) {
                ((DoublePanel)nowpartners[c]).revert();
            }
        } else if (ae.getActionCommand().equals("filter")) {
            this.doFilter();
        } else if (ae.getActionCommand().equals("missing")) {
            this.searchbox.setEnabled(!this.filter3.isSelected());
            this.searchbox.setOpaque(!this.filter3.isSelected());
        } else {
            System.out.println("unknown command: " + ae.getActionCommand());
        }
    }

    private void setCurrentLocale(Locale l) throws Exception {
        if (l != this.currentlocale) {
            this.currentlocale = l;
            for (int c = 0; c < this.partners.size(); ++c) {
                DoublePanel p = (DoublePanel)this.partners.elementAt(c);
                p.resetLocale(this.currentlocale);
            }
            ((MyNode)this.tree.getModel().getRoot()).nodeWorkRefresh(this.mycomm, this.currentlocale);
            this.tree.repaint();
            if (this.filter1.getSelectedItem() == FILTER_DEFAULT_CURRENT) {
                this.doFilter();
            }
        }
    }

    private void doFilter() {
        if (this.fullResults != null) {
            Result[] res = this.filter(this.fullResults);
            Arrays.sort(res, CASE_POSTERIORITY_ORDER);
            this.results.setListData(res);
            this.status.setText("Found " + res.length + " results");
        }
    }

    private Result[] filter(Result[] res) {
        Vector<Result> v = new Vector<Result>();
        Object selected = this.filter1.getSelectedItem();
        Object current = this.local.getSelectedItem();
        for (int c = 0; c < res.length; ++c) {
            if (selected != FILTER_ALL && (selected != FILTER_DEFAULT || res[c].locale != null) && (selected != FILTER_DEFAULT_CURRENT || res[c].locale != null && !current.equals(res[c].locale)) && !selected.equals(res[c].locale)) continue;
            v.add(res[c]);
        }
        return v.toArray(new Result[v.size()]);
    }

    public void valueChanged(ListSelectionEvent lse) {
        Result r;
        if (!lse.getValueIsAdjusting() && (r = (Result)this.results.getSelectedValue()) != null) {
            MyNode node = this.getNode(r.node);
            if (node != null) {
                TreePath treepath = new TreePath(node.getPath());
                this.tree.setSelectionPath(treepath);
                this.tree.scrollPathToVisible(treepath);
            }
            if (r.locale != null) {
                this.local.setSelectedItem(r.locale);
            }
        }
    }

    public void exit() {
        if (!this.checkChange()) {
            System.exit(0);
        }
    }

    public void showError(String s) {
        JOptionPane.showMessageDialog(this, s, "Error", 0);
    }

    public MyNode addNode(String name) {
        if (name.equals("") || name.charAt(0) == '.' || name.charAt(name.length() - 1) == '.' || name.indexOf("..") != -1) {
            this.showError("unable to create message\nbad name: " + name);
            return null;
        }
        try {
            return this.addNode(name, (MyNode)this.tree.getModel().getRoot());
        }
        catch (Exception ex) {
            this.showError("unable to create node: " + ex.getMessage());
            return null;
        }
    }

    public MyNode addNode(String s, MyNode n) throws Exception {
        MyNode node;
        n.loadChildren(this.mycomm, this.currentlocale);
        if (s.indexOf(46) == -1) {
            MyNode node2;
            Enumeration<TreeNode> en = n.children();
            MyNode exists = null;
            while (en.hasMoreElements()) {
                node2 = (MyNode)en.nextElement();
                if (!node2.getUserObject().equals(s)) continue;
                if (node2.hasMessage()) {
                    throw new Exception("node already exists");
                }
                exists = node2;
                node2.setHasMessage(true);
            }
            if (exists == null) {
                node2 = new MyNode(s, true);
                n.add(node2);
                exists = node2;
            }
            ((DefaultTreeModel)this.tree.getModel()).reload(n);
            return exists;
        }
        String name = s.substring(0, s.indexOf(46));
        String name2 = s.substring(s.indexOf(46) + 1, s.length());
        Enumeration<TreeNode> en = n.children();
        while (en.hasMoreElements()) {
            node = (MyNode)en.nextElement();
            if (!node.getUserObject().equals(name)) continue;
            node.setHasChildren(true);
            return this.addNode(name2, node);
        }
        node = new MyNode(name, false);
        n.add(node);
        ((DefaultTreeModel)this.tree.getModel()).reload(n);
        return this.addNode(name2, node);
    }

    public MyNode getNode(String name) {
        int result;
        String[] names = name.split("\\.");
        MyNode node = (MyNode)this.tree.getModel().getRoot();
        for (int c = 0; c < names.length; ++c) {
            if ("".equals(names[c])) {
                node = null;
                break;
            }
            try {
                node.loadChildren(this.mycomm, this.currentlocale);
            }
            catch (Exception e) {
                System.err.println("Error with loadChildren " + node);
                e.printStackTrace();
                this.showError("Error loading children node: " + node);
                return null;
            }
            node = node.getChild(names[c]);
            if (node == null) break;
        }
        if (node == null && (result = JOptionPane.showConfirmDialog(this, "do you want to add: " + name, "confirm add", 0)) == 0) {
            node = this.addNode(name);
        }
        return node;
    }

    public void load() {
        try {
            String plugin = MessageTool.getNewPlugin(this, MessageTool.getPlugins());
            if (plugin != null) {
                this.load(plugin, null);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            StackTraceElement[] st = e.getStackTrace();
            String info = "";
            for (int i = 0; i < st.length; ++i) {
                info = info + "      at " + st[i] + "\n";
            }
            JOptionPane.showMessageDialog(this, "Error Loading plugin: " + e.getMessage() + "\n\n" + e.toString() + "\n" + info, "Load error!", 0);
        }
    }

    public void load(String plugin, Object auth) throws Exception {
        Class<?> myclass = Class.forName(plugin);
        final Mtcomm mycomm1 = auth == null ? (Mtcomm)myclass.newInstance() : (Mtcomm)myclass.getConstructor(auth.getClass()).newInstance(auth);
        Runnable runner = new Runnable(){

            public void run() {
                try {
                    if (mycomm1.load()) {
                        MessageTool.this.load(mycomm1);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        new Thread(runner, "Mtcomm-Load-Thread").start();
    }

    public void load(Mtcomm mycomm1) {
        try {
            Locale[] locales = mycomm1.getLocales();
            PartnerNode[] parts = mycomm1.getPartners();
            Locale systemDefault = Locale.getDefault();
            Locale defaultLocale = Arrays.asList(locales).contains(systemDefault) ? systemDefault : locales[0];
            if (locales == null || locales.length == 0) {
                throw new Exception("unable to get info from plugin");
            }
            this.fullResults = null;
            MyNode root = new MyNode("ROOT", false, true);
            root.loadChildren(mycomm1, defaultLocale);
            ((DefaultTreeModel)this.tree.getModel()).setRoot(root);
            this.address.removeAllItems();
            this.box.removeAll();
            this.box.validate();
            this.box.repaint();
            this.message = null;
            this.local.setModel(new DefaultComboBoxModel<Locale>(locales));
            this.part.setModel(new DefaultComboBoxModel<PartnerNode>(parts));
            this.currentpartner = (PartnerNode)parts[0].getRoot();
            this.part.setModel(new DefaultTreeModel(this.currentpartner));
            this.part.setSelectedItem(this.currentpartner);
            this.results.setListData(new Object[0]);
            this.filter1.setModel(new DefaultComboBoxModel<Locale>(locales));
            this.filter1.insertItemAt(FILTER_DEFAULT_CURRENT, 0);
            this.filter1.insertItemAt(FILTER_ALL, 1);
            this.filter1.insertItemAt(FILTER_DEFAULT, 2);
            this.filter1.setSelectedIndex(0);
            this.partmap = new HashMap();
            this.mycomm = mycomm1;
            this.local.setSelectedItem(defaultLocale);
            this.local.repaint();
            this.status.setText("Ready");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.showError(ex.toString());
        }
    }

    public static void main(String[] args) {
        try {
            SimpleBug.initSimple((String)appName, (String)version, (String)Locale.getDefault().toString());
        }
        catch (Throwable th) {
            // empty catch block
        }
        MessageTool mt = new MessageTool();
        JFrame frame = new JFrame(mt.getName() + " " + WEBSITE);
        frame.getContentPane().add((Component)mt.getToolBar(), "North");
        frame.getContentPane().add(mt);
        frame.setSize(700, 500);
        frame.setLocationRelativeTo(null);
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }

    static /* synthetic */ Result[] access$002(MessageTool x0, Result[] x1) {
        x0.fullResults = x1;
        return x1;
    }

    class MyRenderer
    extends DefaultTreeCellRenderer {
        ImageIcon fc = new ImageIcon((class$net$yura$translation$MessageTool == null ? (class$net$yura$translation$MessageTool = MessageTool.class$("net.yura.translation.MessageTool")) : class$net$yura$translation$MessageTool).getResource("fc.gif"));
        ImageIcon fcm = new ImageIcon((class$net$yura$translation$MessageTool == null ? (class$net$yura$translation$MessageTool = MessageTool.class$("net.yura.translation.MessageTool")) : class$net$yura$translation$MessageTool).getResource("fcm.gif"));
        ImageIcon fo = new ImageIcon((class$net$yura$translation$MessageTool == null ? (class$net$yura$translation$MessageTool = MessageTool.class$("net.yura.translation.MessageTool")) : class$net$yura$translation$MessageTool).getResource("fo.gif"));
        ImageIcon fom = new ImageIcon((class$net$yura$translation$MessageTool == null ? (class$net$yura$translation$MessageTool = MessageTool.class$("net.yura.translation.MessageTool")) : class$net$yura$translation$MessageTool).getResource("fom.gif"));
        ImageIcon m = new ImageIcon((class$net$yura$translation$MessageTool == null ? (class$net$yura$translation$MessageTool = MessageTool.class$("net.yura.translation.MessageTool")) : class$net$yura$translation$MessageTool).getResource("m.gif"));
        ImageIcon fc_E;
        ImageIcon fcm_E;
        ImageIcon fo_E;
        ImageIcon fom_E;
        ImageIcon m_E;
        ImageIcon w = new ImageIcon((class$net$yura$translation$MessageTool == null ? (class$net$yura$translation$MessageTool = MessageTool.class$("net.yura.translation.MessageTool")) : class$net$yura$translation$MessageTool).getResource("work.png"));

        public MyRenderer() {
            this.fc_E = this.paintDot(this.fc);
            this.fcm_E = this.paintDot(this.fcm);
            this.fo_E = this.paintDot(this.fo);
            this.fom_E = this.paintDot(this.fom);
            this.m_E = this.paintDot(this.m);
        }

        private ImageIcon paintDot(ImageIcon a) {
            int s = 5;
            BufferedImage b = new BufferedImage(a.getIconWidth(), a.getIconHeight(), 2);
            Graphics g = b.getGraphics();
            g.drawImage(a.getImage(), 0, 0, this);
            g.drawImage(this.w.getImage(), 0, 0, this);
            g.dispose();
            return new ImageIcon(b);
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            MyNode node = (MyNode)value;
            boolean wn = node.workNeeded();
            if (leaf && node.hasMessage()) {
                this.setIcon(wn ? this.m_E : this.m);
            } else if (expanded && node.hasMessage()) {
                this.setIcon(wn ? this.fom_E : this.fom);
            } else if (!expanded && node.hasMessage()) {
                this.setIcon(wn ? this.fcm_E : this.fcm);
            } else if (expanded && !node.hasMessage()) {
                this.setIcon(wn ? this.fo_E : this.fo);
            } else {
                this.setIcon(wn ? this.fc_E : this.fc);
            }
            return this;
        }
    }
}

