/*
 * Decompiled with CFR 0.152.
 */
package net.yura.lobby.client;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class NioClient
implements Runnable {
    private InetAddress hostAddress;
    private int port;
    private Selector selector;
    private ByteBuffer readBuffer = ByteBuffer.allocate(8192);
    private List pendingChanges = new LinkedList();
    private Map pendingData = new HashMap();
    private Map rspHandlers = Collections.synchronizedMap(new HashMap());

    public NioClient(InetAddress hostAddress, int port) throws IOException {
        this.hostAddress = hostAddress;
        this.port = port;
        this.selector = this.initSelector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(byte[] data, RspHandler handler) throws IOException {
        SocketChannel socket = this.initiateConnection();
        this.rspHandlers.put(socket, handler);
        Map map = this.pendingData;
        synchronized (map) {
            ArrayList<ByteBuffer> queue = (ArrayList<ByteBuffer>)this.pendingData.get(socket);
            if (queue == null) {
                queue = new ArrayList<ByteBuffer>();
                this.pendingData.put(socket, queue);
            }
            queue.add(ByteBuffer.wrap(data));
        }
        this.selector.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            try {
                block10: while (true) {
                    List list = this.pendingChanges;
                    synchronized (list) {
                        Iterator changes = this.pendingChanges.iterator();
                        while (changes.hasNext()) {
                            ChangeRequest change = (ChangeRequest)changes.next();
                            switch (change.type) {
                                case 2: {
                                    SelectionKey key = change.socket.keyFor(this.selector);
                                    key.interestOps(change.ops);
                                    break;
                                }
                                case 1: {
                                    change.socket.register(this.selector, change.ops);
                                }
                            }
                        }
                        this.pendingChanges.clear();
                    }
                    this.selector.select();
                    Iterator<SelectionKey> selectedKeys = this.selector.selectedKeys().iterator();
                    while (true) {
                        if (!selectedKeys.hasNext()) continue block10;
                        SelectionKey key = selectedKeys.next();
                        selectedKeys.remove();
                        if (!key.isValid()) continue;
                        if (key.isConnectable()) {
                            this.finishConnection(key);
                            continue;
                        }
                        if (key.isReadable()) {
                            this.read(key);
                            continue;
                        }
                        if (!key.isWritable()) continue;
                        this.write(key);
                    }
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    private void read(SelectionKey key) throws IOException {
        int numRead;
        SocketChannel socketChannel = (SocketChannel)key.channel();
        this.readBuffer.clear();
        try {
            numRead = socketChannel.read(this.readBuffer);
        }
        catch (IOException e) {
            key.cancel();
            socketChannel.close();
            return;
        }
        if (numRead == -1) {
            key.channel().close();
            key.cancel();
            return;
        }
        this.handleResponse(socketChannel, this.readBuffer.array(), numRead);
    }

    private void handleResponse(SocketChannel socketChannel, byte[] data, int numRead) throws IOException {
        byte[] rspData = new byte[numRead];
        System.arraycopy(data, 0, rspData, 0, numRead);
        RspHandler handler = (RspHandler)this.rspHandlers.get(socketChannel);
        if (handler.handleResponse(rspData)) {
            socketChannel.close();
            socketChannel.keyFor(this.selector).cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(SelectionKey key) throws IOException {
        SocketChannel socketChannel = (SocketChannel)key.channel();
        Map map = this.pendingData;
        synchronized (map) {
            List queue = (List)this.pendingData.get(socketChannel);
            while (!queue.isEmpty()) {
                ByteBuffer buf = (ByteBuffer)queue.get(0);
                socketChannel.write(buf);
                if (buf.remaining() > 0) break;
                queue.remove(0);
            }
            if (queue.isEmpty()) {
                key.interestOps(1);
            }
        }
    }

    private void finishConnection(SelectionKey key) throws IOException {
        SocketChannel socketChannel = (SocketChannel)key.channel();
        try {
            socketChannel.finishConnect();
        }
        catch (IOException e) {
            System.out.println(e);
            key.cancel();
            return;
        }
        key.interestOps(4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SocketChannel initiateConnection() throws IOException {
        SocketChannel socketChannel = SocketChannel.open();
        socketChannel.configureBlocking(false);
        socketChannel.connect(new InetSocketAddress(this.hostAddress, this.port));
        List list = this.pendingChanges;
        synchronized (list) {
            this.pendingChanges.add(new ChangeRequest(socketChannel, 1, 8));
        }
        return socketChannel;
    }

    private Selector initSelector() throws IOException {
        return SelectorProvider.provider().openSelector();
    }

    public static void main(String[] args) {
        try {
            NioClient client = new NioClient(InetAddress.getByName("www.google.com"), 80);
            Thread t = new Thread(client);
            t.setDaemon(true);
            t.start();
            RspHandler handler = new RspHandler();
            client.send("GET / HTTP/1.0\r\n\r\n".getBytes(), handler);
            handler.waitForResponse();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class RspHandler {
        private byte[] rsp = null;

        public synchronized boolean handleResponse(byte[] rsp) {
            this.rsp = rsp;
            this.notify();
            return true;
        }

        public synchronized void waitForResponse() {
            while (this.rsp == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            System.out.println(new String(this.rsp));
        }
    }

    public static class ChangeRequest {
        public static final int REGISTER = 1;
        public static final int CHANGEOPS = 2;
        public SocketChannel socket;
        public int type;
        public int ops;

        public ChangeRequest(SocketChannel socket, int type, int ops) {
            this.socket = socket;
            this.type = type;
            this.ops = ops;
        }
    }
}

