package net.yura.util;

import java.io.File;
import java.util.Locale;
import net.yura.translation.plugins.xcode.XcodeComm;

/**
 * @author yura
 */
public class iPhone2Android {
    
    String input,output,defaultLocale;
    
    public void execute() throws Exception {

        File in = new File(input);
        File file = new File(in.getParentFile(), defaultLocale+".lproj");
        
        XcodeComm comms = new XcodeComm();
        comms.load( in , file);

        Locale[] a = comms.getLocales();

        // remove last SCREEN_LOCALE
        Locale l[] = new Locale[a.length - 1];
        System.arraycopy(a, 0, l, 0, l.length);

        AndroidExport.export(comms, new File(output) , l);
        
    }

    public String getInput() {
        return input;
    }

    public void setInput(String input) {
        this.input = input;
    }

    public String getOutput() {
        return output;
    }

    public void setOutput(String output) {
        this.output = output;
    }

    public String getDefaultLocale() {
        return defaultLocale;
    }

    public void setDefaultLocale(String defaultLocale) {
        this.defaultLocale = defaultLocale;
    }
    
}
