/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package net.yura.util;

import java.io.*;

/**
 *
 * @author user30
 */
public class CommentStrippingReader extends Reader {

    private final PushbackReader in;

    public CommentStrippingReader(Reader in) {
        this.in = new PushbackReader(in);
    }
    

    public int read(char[] cbuf, int off, int len) throws IOException {
        for (int i = 0, c, c2; i < len;) {
            c = in.read();
            switch (c) {
                case -1:
                    return i == 0 ? -1 : i;
                case '/':
                    c2 = in.read();
                    switch (c2) {
                        case '*':
                            for (c2 = -1; in.read() != '*' || (c2 = in.read()) != '/'; c2 = -1) {
                                if (c2 != -1) {
                                    in.unread(c2);
                                }
                            }
                            continue;
                        case '/':
                            while ((c = in.read()) != '\n');
                            break;
                        default:
                            in.unread(c2);
                            break;
                    }
                default:
                    cbuf[off + i++] = (char) c;
            }
        }
        return len;
    }

    @Override
    public void close() throws IOException {
       in.close();
    }


}
