package net.yura.util;

import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.yura.mobile.io.kxml2.KXmlSerializer;
import org.xmlpull.v1.XmlSerializer;
import net.yura.translation.Mtcomm;
import net.yura.translation.MyNode;

/**
 * @author Yura
 */
public class AndroidExport {
    
    public static final String resources = "resources";
    public static final String string = "string";
    public static final String name = "name";
    
    public static void export(Mtcomm comms, File resDir, Locale[] locales) throws Exception {
        
            MyNode root = new MyNode("ROOT", false, true);
            //root.loadChildren(comms, locales[0]); // TODO just pass any loacle in here???

            // export default locale
            export(null, root, comms, resDir);
            
            // export all other locales
            for (int c=0;c<locales.length;c++) {
                export(locales[c], root, comms, resDir);
            }
    }
    
    static void export(Locale l,MyNode root,Mtcomm comms,File resDir) throws Exception {
    
            Map map = new HashMap();
            addToMap(root, map, comms, l);

            if (map.size() > 0) {
                
                File file = new File(resDir,"values"+(l==null?"":"-"+toString(l))+"/strings.xml");
                
                export(map, file);
            }
        
    }

    static String getParentMessage(MyNode node,Mtcomm comms,Locale locale) throws Exception {

        String language = locale.getLanguage();
        String country = locale.getCountry();
        String variant = locale.getVariant();

        if (!"".equals(variant)) {
            String message = comms.getMessage(node, null, new Locale(language, country) );
            if (message != null) {
                return message;
            }
        }
        if (!"".equals(country)) {
            String message = comms.getMessage(node, null, new Locale(language) );
            if (message != null) {
                return message;
            }
        }

        return comms.getMessage(node, null, null ); // this can NOT return null;

    }

    static void addToMap(MyNode node,Map map,Mtcomm comms, Locale locale) throws Exception {
            
            if (node.hasMessage()) {
                //String message = node.getMessage(comms, null, locale);
                String message = comms.getMessage(node, null, locale);
                if (message!=null) {
                    String parent = locale==null?null:getParentMessage(node,comms,locale);
                    if (!message.equals(parent)) {
                        map.put( node.getName() , message );
                    }
                }
            }
            if (node.hasChildren()) {
                
                node.loadChildren(comms, locale);
                
                //if (locale==null) { // TODO ??? only for default locale
                //    //comms.addChildren(node); // this is not good enough as does not remove dummy node
                //}
                
                int count = node.getChildCount();
                for (int c=0;c<count;c++) {
                    MyNode child = (MyNode)node.getChildAt(c);
                    
                    addToMap(child, map, comms, locale);
                }
            }
        
    }
    
    static String convertKey(String message) {
        
        // for some crazy reason Android can not have a - in the key
        int apos = message.indexOf('-');
        if (apos>=0) {
            for (int c=apos;c<message.length();c++) {
                char ch = message.charAt(c);
                if (ch=='-') {
                    message = message.substring(0, c)+'_'+message.substring( c+1 );
                }
            }
        }
        return message;
    }
    
    static String convertMessage(String message) {
        
        // for some crazy reason Android needs a \ before every '
        int apos = message.indexOf('\'');
        if (apos>=0) {
            for (int c=apos;c<message.length();c++) {
                char ch = message.charAt(c);
                if (ch=='\'') {
                    message = message.substring(0, c)+'\\'+message.substring(c);
                    c++;
                }
            }
        }

        // we need to conver %@ and %a    to {1}
        String oldMessage;
        int c=0;
        do {
            oldMessage = message; // TODO does not support %2.2f
            message = message.replaceFirst("%[A-Za-z@]", "{"+(c++)+"}");

        } while (!message.equals(oldMessage));

        return message;
        
    }
    
    static void export(Map map, File outFile) throws Exception {
        

            outFile.getParentFile().mkdirs();
            outFile.createNewFile();
        
            FileOutputStream output = new FileOutputStream(outFile);

            List keys = new ArrayList( map.keySet() );
            Collections.sort(keys);

            XmlSerializer serializer = new KXmlSerializer();
            serializer.setOutput(output,"UTF-8");
            serializer.startDocument("UTF-8", null);

            serializer.text("\n");
            serializer.startTag(null,resources);
            serializer.text("\n");
            
            for (Iterator e = keys.iterator(); e.hasNext();) {
                String key = String.valueOf( e.next() );
                String message = String.valueOf( map.get(key) );
                
                serializer.startTag(null,string);
                serializer.attribute(null, name, convertKey(key) );
                serializer.text( convertMessage(message) );
                serializer.endTag(null,string);
                serializer.text("\n");
            
            }
            
            serializer.endTag(null,resources);

            serializer.endDocument();
            serializer.flush();

            output.close();
    }
    
    
    /**
     * Android uses "en-rGB" and not "_"
     */
    public static String toString(Locale locale) {
        String language = locale.getLanguage();
        String country = locale.getCountry();
        String variant = locale.getVariant();
        boolean l = language.length() != 0;
        boolean c = country.length() != 0;
        boolean v = variant.length() != 0;
        StringBuilder result = new StringBuilder(language);
        if (c||(l&&v)) {
            result.append("-r").append(country); // This may just append '_'
        }
        if (v&&(l||c)) {
            result.append("-v").append(variant); // TODO Android does not support variant
        }
        return result.toString();
    }
    
}
