package net.yura.translation.plugins.xcode;

import net.yura.util.AndroidExport;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import net.yura.translation.MessageTool;
import net.yura.translation.Mtcomm;
import net.yura.translation.MyNode;

/**
 * @author Yura Mamyrin
 */
public class XcodeTranslationTool extends MessageTool {

    private String[] screens;
    private MyNode selectedKey;
    private final ImageView preview;
    private final JList list;
    JTextArea description;

    class ImageView extends JComponent {

        private Image img;

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (img!=null) {
                int imgW = img.getWidth(this);
                int imgH = img.getHeight(this);

                double s = Math.min(getHeight()/(double)imgH,getWidth()/(double)imgW);
                int imgX =  (int) (getWidth() - (imgW * s)) / 2;
                int imgY = (int) (getHeight() - (imgH * s)) / 2;

                g.drawImage( img, imgX, imgY, imgX+(int)(imgW * s), imgY+(int)(imgH * s),
                        0,0,img.getWidth(this),img.getHeight(this),this
                        );
            }
        }

        public void setIcon(ImageIcon i) {
            img = i!=null?i.getImage():null;
            repaint();
        }

    }

    public XcodeTranslationTool() {
        preview = new ImageView();
        preview.setPreferredSize(new Dimension(320, 480));
        
        description = new JTextArea();
        description.setLineWrap(true);
        description.setWrapStyleWord(true);
        
        list = new JList();
        list.setDragEnabled(true);
        list.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        list.addListSelectionListener(new ListSelectionListener() {

            public void valueChanged(ListSelectionEvent e) {
                if (list.getSelectedIndex() >= 0) {
                    setPreviewImage( screens[list.getSelectedIndex()] );
                }
            }
        });
        list.setTransferHandler(new TransferHandler() {

            @Override
            public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
                for (int i = 0; i < transferFlavors.length; i++) {
                    if (DataFlavor.javaFileListFlavor.match(transferFlavors[i])) {
                        return mycomm != null && selectedKey!=null && selectedKey.getName().length() > 0;
                    }
                }
                return false;
            }

            @Override
            public boolean importData(JComponent comp, Transferable t) {
                boolean imported = false;
                String newNames="";
                try {
                    List files = (List) t.getTransferData(DataFlavor.javaFileListFlavor);

                    for (Iterator<File> i = files.iterator(); i.hasNext();) {
                        File file = i.next();
                        if (file.getName().toLowerCase().endsWith(".jpg") || file.getName().toLowerCase().endsWith(".png")) {
                            ((XcodeCommXtra)mycomm).addScreen(file);
                            newNames = newNames+file.getName()+",";
                            imported = true;
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    if (imported) {
                        // we use this for saving, as it scans up and down the tree to check if other nodes need to be changed
                        String string = mycomm.getMessage(selectedKey, mycomm.getPartners()[0], XcodeComm.SCREEN_LOCALE);
                        selectedKey.saveMessage(mycomm, mycomm.getPartners()[0], XcodeComm.SCREEN_LOCALE, (string==null?"":string)+newNames, getCurrentLocale() );

                        // TODO when we update the screens by editing the textarea it does not refresh the top right list
                        // TODO when we del OR add a message from the top right list it does not update the textarea

                        // this is the OLD way of updating the "work needed" flag/icon, but is not good enough as does not look to the parent
                        //mycomm.setupMissingTranslation(selectedKey, getCurrentLocale());

                        setSelectKey(selectedKey); // update the screens list, (top right)
                        repaint();
                    }
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
                return imported;
            }
        });
        list.addKeyListener(new KeyAdapter() {

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == KeyEvent.VK_BACK_SPACE || e.getKeyCode() == KeyEvent.VK_DELETE) {
                    if(list.getSelectedIndex()>=0) {

                        try {
                            String string = mycomm.getMessage(selectedKey, mycomm.getPartners()[0], XcodeComm.SCREEN_LOCALE);
                            string = string.replaceFirst( Pattern.quote( screens[list.getSelectedIndex()] +",") , "");
                            selectedKey.saveMessage(mycomm, mycomm.getPartners()[0], XcodeComm.SCREEN_LOCALE, "".equals(string)?null:string, getCurrentLocale() );
                        }
                        catch (Exception ex) {
                            throw new RuntimeException(ex);
                        }
                        //mycomm.getProject().removeScreen(selectedKey.getName(), screens[list.getSelectedIndex()]);
                        //mycomm.setupMissingTranslation(selectedKey, getCurrentLocale());
                        
                        setSelectKey(selectedKey);
                        repaint();
                    }
                }
            }
        });
        preview.setTransferHandler(list.getTransferHandler());
    }

    public void valueChanged(TreeSelectionEvent e) {
        super.valueChanged(e);
        MyNode node = (MyNode) e.getPath().getLastPathComponent();

        if (node.hasMessage()) {
            setSelectKey(node);
        }

    }

    private void setSelectKey(MyNode key) {
        selectedKey = key;
        
        try {
            String screens1 = mycomm.getMessage(key, null, XcodeComm.SCREEN_LOCALE);
            if (screens1==null) { screens1=""; } // avoid null pointers

            String[] split = screens1.split(",");
            screens = (split.length == 1 && split[0].length() == 0) ? new String[0] : split; // avoid empty item


            String[] names = new String[screens.length];
            for (int i = 0; i < names.length; i++) {
                int dot = screens[i].lastIndexOf('.');
                names[i] = dot<=0?screens[i]:screens[i].substring(0, dot);
            }
            list.setListData(names);
            if (screens.length > 0) {
                list.setSelectedIndex(0);
                setPreviewImage(screens[0]);
            }
            else {
                preview.setIcon(null);
            }
            
            String descriptionText = mycomm.getMessage(key, null, XcodeComm.DESCRIPTION_LOCALE);
            description.setText(descriptionText);
            
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }

    }
    
    private void setPreviewImage(String screenUID) {
        try {
            ImageIcon img = ((XcodeCommXtra)mycomm).getScreenImage(screenUID);
            preview.setIcon(img);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
    
    public Component getMainPanel() {

        JButton button = new JButton("Export for Android");
        button.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                if (mycomm!=null) {
                    
                    JFileChooser chooser = new JFileChooser();
                    chooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);

                    int result = chooser.showSaveDialog( XcodeTranslationTool.this );

                    if (result == JFileChooser.APPROVE_OPTION) {

                        try {
                            
                            Locale[] a = mycomm.getLocales();
                            
                            // remove last SCREEN_LOCALE
                            Locale l[] = new Locale[a.length - 1];
                            System.arraycopy(a, 0, l, 0, l.length);
                            
                            AndroidExport.export(mycomm, chooser.getSelectedFile() , l);
                            
                            JOptionPane.showMessageDialog(XcodeTranslationTool.this, "Done");
                        }
                        catch (Exception ex) {
                            JOptionPane.showMessageDialog(XcodeTranslationTool.this, "Error with export: "+ex);
                            ex.printStackTrace();
                        }

                    }

                }
            }
        });
        
        JButton save = new JButton( new ImageIcon(MessageTool.class.getResource("Save16.gif")) );
        save.setToolTipText("Save Description");
        save.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                try {
                    if (mycomm!=null) {
                        String descriptionText = description.getText();
                        mycomm.saveMessage(selectedKey,null,XcodeComm.DESCRIPTION_LOCALE, "".equals(descriptionText)?null:descriptionText );
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        
        int m = save.getMargin().top;
        Insets margin = new Insets(m, m, m, m);
        button.setMargin(margin);
        save.setMargin(margin);
        
        JPanel topPanel = new JPanel();
        spellingOnly = new JCheckBox("Spelling Only");
        
        topPanel.add(spellingOnly);
        topPanel.add(save);
        topPanel.add(button);
        
        
        
        
        JScrollPane listScroll = new JScrollPane(list);
        listScroll.setPreferredSize( new Dimension(50, 50) );
        
        JPanel panel = new JPanel(new BorderLayout());  
        panel.add(topPanel, BorderLayout.NORTH);
        panel.add(new JScrollPane(description));
        panel.add(listScroll, BorderLayout.SOUTH);
        
        JSplitPane split1 = new JSplitPane(JSplitPane.VERTICAL_SPLIT);
        split1.setContinuousLayout(true);
        split1.setResizeWeight(1);
        split1.setTopComponent(panel);
        split1.setBottomComponent(preview);
        
        //panel.setMinimumSize( new Dimension(50, 50) );
        JSplitPane split = new JSplitPane();
        //split.setDividerLocation(1000 - 320);
        split.setLeftComponent(this);
        split.setRightComponent(split1);
        split.setResizeWeight(1);
        split.setContinuousLayout(true);
        
        return split;
    }

    JCheckBox spellingOnly;

    @Override
    public void load() {
        new Thread() {

            public void run() {
                try {
                    
                    Mtcomm mycomm = new XcodeComm();

                    if (mycomm.load()) {
                        load(mycomm);
                    }
                }
                catch (Throwable e) {
                    JOptionPane.showMessageDialog(XcodeTranslationTool.this, "Error loading: "+mycomm+" "+e);
                    e.printStackTrace();
                }
            }
        }.start();
    }
    
    public void load(Mtcomm mycomm1) {
        
        Mtcomm oldCom = mycomm;
        super.load(mycomm1);
        if (oldCom!=mycomm && mycomm instanceof XcodeCommXtra) {
            ((XcodeCommXtra)mycomm).setSpellingOnlyChackbox(spellingOnly);
        }
        
    }
    
    
    
    
    public static void main(String[] args) {

        String myName = "Xcode";
        String myVer= "1.15";

        // crazy hack for OS X to not spam my email
        // Failed to create resources from application bundle.  Using Java-based resources.
        new JPanel();
        
        try {
            net.yura.grasshopper.SimpleBug.initSimple(appName+"/"+myName, version+"/"+myVer, "NA");
            System.out.println("Grasshopper loaded");
        }
        catch (Throwable th) {
            System.out.println("failed to load Grasshopper");
        }

        try {
            UIManager.setLookAndFeel( UIManager.getSystemLookAndFeelClassName() );
        }
        catch (Exception ex) { }
        
        final XcodeTranslationTool tt = new XcodeTranslationTool();
        final JFrame frame = new JFrame( tt.getName()+ " "+myName+" "+myVer+" "+WEBSITE);
        frame.setIconImage( Toolkit.getDefaultToolkit().getImage(XcodeTranslationTool.class.getResource("/icon.png") ) );
        frame.getContentPane().add(tt.getToolBar(), BorderLayout.NORTH);

        frame.setSize(1000, 700);
        frame.setLocationRelativeTo(null);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        
        frame.getContentPane().add( tt.getMainPanel() );
        frame.setVisible(true);
    }

    
}
