/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package net.yura.util;

import com.glaforge.i18n.io.SmartEncodingInputStream;
import java.io.*;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.InvalidPropertiesFormatException;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

/**
 * Subclass of Properties class adding support for the Apple Strings File format
 * @author user30
 */
public class StringsProperties extends Properties {

    private static final int KEY = 0, VALUE = 1;
    private static final String HEADER = "/* net.yura.util.StringProperties\n";

    final static Charset UTF_16LE = Charset.forName("UTF-16LE");
    final static Charset UTF_16BE = Charset.forName("UTF-16BE");
    final static Charset UTF_8 = Charset.forName("UTF-8");

    private Charset encoding = UTF_8; // default encoding

    public synchronized CharSequence loadFromStrings(InputStream in) throws IOException, InvalidPropertiesFormatException {

        SmartEncodingInputStream r1 = new SmartEncodingInputStream(in);
        encoding = r1.getEncoding();

        // WE HAVE HAD NO BOM, so we assuse UTF-8 (and NOT the system default like the SmartEncodingInputStream does)
        if ( !UTF_16LE.equals(encoding) && !UTF_16BE.equals(encoding) ) {
            encoding = UTF_8;
        }

        PushbackReader r = new PushbackReader(new BufferedReader( new InputStreamReader(r1, encoding) ), HEADER.length());
        //check for comment
        StringBuilder comments = new StringBuilder();
        CharBuffer header = CharBuffer.allocate(HEADER.length());
        r.read(header);
        header.rewind();
        if (!HEADER.contentEquals(header)) {
            r.unread(header.array());
        } else {
            for (int current = r.read(), next = r.read(); current != '*' || next != '/'; current = next, next = r.read()) {
                if(next==-1)
                    throw new InvalidPropertiesFormatException("Unclosed C-style comment");
                comments.append((char)current);
            }
        }
        StreamTokenizer st = new StreamTokenizer(r);
        st.slashStarComments(true);
        st.slashSlashComments(true);
        //st.quoteChar('"'); // does not seem to need this

        String[] property = new String[2];
        loop:
        for (int type = KEY; true;) {
            switch (st.nextToken()) {
                case '"':
                    property[type] = st.sval;
                    break;
                case '=':
                    type = VALUE;
                    break;
                case ';':
                    String old = (String)get(property[KEY]);
                    if (old!=null) {
                        System.out.println("key is defined twice: "+property[KEY]);
                    }
                    put(property[KEY], ((old != null)?old:"") + property[VALUE]);
                    type = KEY;
                    break;
                case StreamTokenizer.TT_EOF:
                    break loop;
            }
        }
        r.close();
        return comments;
    }

    public synchronized void storeToStrings(OutputStream os, CharSequence comment) throws IOException {

        // write UTF_16 BOM, as java does not write this by default
        if (UTF_16LE.equals(encoding)) {
            os.write(0xFF);
            os.write(0xFE);
        }
        if (UTF_16BE.equals(encoding)) {
            os.write(0xFE);
            os.write(0xFF);
        }

        Writer w = new BufferedWriter(new OutputStreamWriter(os, encoding ));
        if (comment != null) {
            w.append(HEADER).append(comment).append("*/\n");
        }

        List keys = new ArrayList( keySet() );
        Collections.sort(keys);

        for (Iterator e = keys.iterator(); e.hasNext();) {
            String key = e.next().toString();
            w.append('"').append( saveConvert(key) ).append("\" = \"").append( saveConvert(getProperty(key)) ).append("\";\n");
        }
        w.close();
    }



    /**
     * Converts unicodes to encoded &#92;uxxxx and escapes
     * special characters with a preceding slash
     */
    private String saveConvert(String theString) {
        int len = theString.length();
        int bufLen = len * 2;
        if (bufLen < 0) {
            bufLen = Integer.MAX_VALUE;
        }
        StringBuffer outBuffer = new StringBuffer(bufLen);

        for(int x=0; x<len; x++) {
            char aChar = theString.charAt(x);
            // Handle common case first, selecting largest block that
            // avoids the specials below
            if ((aChar > 61) && (aChar < 127)) {
                if (aChar == '\\') {
                    outBuffer.append('\\'); outBuffer.append('\\');
                    continue;
                }
                outBuffer.append(aChar);
                continue;
            }
            switch(aChar) {
//		case ' ':
//		    if (x == 0 || escapeSpace)
//			outBuffer.append('\\');
//		    outBuffer.append(' ');
//		    break;
                case '\t':outBuffer.append('\\'); outBuffer.append('t');
                          break;
                case '\n':outBuffer.append('\\'); outBuffer.append('n');
                          break;
                case '\r':outBuffer.append('\\'); outBuffer.append('r');
                          break;
                case '\f':outBuffer.append('\\'); outBuffer.append('f');
                          break;
//                case '=': // Fall through
//                case ':': // Fall through
//                case '#': // Fall through
//                case '!':
                case '"':
                    outBuffer.append('\\'); outBuffer.append(aChar);
                    break;
                default:
//                    if (((aChar < 0x0020) || (aChar > 0x007e)) & escapeUnicode ) {
//                        outBuffer.append('\\');
//                        outBuffer.append('u');
//                        outBuffer.append(toHex((aChar >> 12) & 0xF));
//                        outBuffer.append(toHex((aChar >>  8) & 0xF));
//                        outBuffer.append(toHex((aChar >>  4) & 0xF));
//                        outBuffer.append(toHex( aChar        & 0xF));
//                    } else {
                        outBuffer.append(aChar);
//                    }
            }
        }
        return outBuffer.toString();
    }


}
