package net.yura.translation.plugins;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import javax.swing.JFileChooser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Properties;
import java.util.Enumeration;
import java.util.Vector;
import java.util.Locale;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Arrays;

import java.util.Collections;
import javax.swing.filechooser.FileFilter;
import net.yura.translation.MessageTool;
import net.yura.translation.Mtcomm;
import net.yura.translation.MyNode;
import net.yura.translation.PartnerNode;
import net.yura.translation.Result;

public class PropertiesComm implements Mtcomm {

    private Properties props;
    private HashMap map;
    private String name;
    private String extension;
    private File myDir = new File("risk/engine/translation");

    public boolean load() throws Exception {

        JFileChooser fc = new JFileChooser(myDir);

        setupFilter(fc);

        fc.setFileSelectionMode(JFileChooser.FILES_ONLY);

        int returnVal = fc.showDialog(null, "Select");

        // if a file is selected instead of a dir, the return value is the same as if you cancel

        if (returnVal == JFileChooser.APPROVE_OPTION) {
            // get all propaties files
            File file = fc.getSelectedFile();

            load(file);

            return true;
        }
        else {
            return false;
        }

    }

    public void load(File file) throws Exception {

        myDir = file.getParentFile();

        //File[] files = file.listFiles();


        props = load(new FileInputStream(file));

        map = new HashMap();

        name = file.getPath();

        extension = name.substring(name.lastIndexOf('.'), name.length()); // this gives ".properties"

        name = name.substring(0, name.lastIndexOf('.'));

    }

    public void setupFilter(JFileChooser fc) {
        FileFilter ff = new FileFilter() {

            public boolean accept(File f) {
                return (f.isDirectory() || (f.getName().toLowerCase().endsWith(".properties")));
            }

            public String getDescription() {
                return "Java Properties Files (*.properties)";
            }
        };
        fc.addChoosableFileFilter(ff);
        fc.setFileFilter(ff);
    }

    public Properties load(FileInputStream in) throws Exception {

        Properties p = new Properties();
        p.load(in);
        return p;

    }

    public void store(final Properties p, FileOutputStream out, final String a) throws Exception {

        final PipedOutputStream pout = new PipedOutputStream();
        PipedInputStream pin = new PipedInputStream(pout);

        final Vector errors = new Vector();

        new Thread() {
            public void run() {
                try {
                    p.store(pout, a);

                    pout.close(); // MUST close or will get a IOException in the read, "write end dead"
                }
                catch (Throwable ex) {
                    errors.add(ex);
                }
            }
        }.start();


        BufferedReader reader = new BufferedReader(new InputStreamReader(pin));

        String input = reader.readLine();
        Vector lines = new Vector();
        while(input != null) {
            lines.add(input);
            input = reader.readLine();
        }

        Collections.sort(lines);

        BufferedWriter bufferout = new BufferedWriter( new OutputStreamWriter(out) );
        for (int c=0;c<lines.size();c++) {
            bufferout.write( (String)lines.elementAt(c) );
            bufferout.newLine();
        }
        bufferout.close(); // flush anything from the buffer
        
        if (!errors.isEmpty()) {
            throw new Exception( (Throwable)errors.firstElement() );
        }

    }

    public void addChildren(MyNode node) {

        String name = node.getName();

        if (name.length() > 0) {
            name = name + ".";
        }

        Enumeration en = props.propertyNames();

        while (en.hasMoreElements()) {

            String s = en.nextElement().toString();			// swing.setup.title	swing.mainbox

            if (s.startsWith(name)) {

                // cut off name and first dot
                s = s.substring(name.length(), s.length());	// setup.title		mainbox

                boolean children = false;
                boolean message = false;

                // cut off everything after dot, if there is any

                if (s.indexOf('.') != -1) {			// setup		mainbox

                    children = true;				// ########## it has children!!!!
                    s = s.substring(0, s.indexOf('.'));

                }
                else {
                    message = true;				// ########## it has a message!!!!
                }


                MyNode newnode = new MyNode(s, message, children);

                node.add(newnode);
            }

        }


    }

    public String getMessage(MyNode node, PartnerNode partner, Locale l) {

        return getLocaleProperties(l).getProperty(node.getName());

    }

    public Properties getLocaleProperties(Locale l) {

        if (l == null) {
            return props;
        }

        if (!map.containsKey(l)) {

            Properties pp;

            try {

                pp = load(new FileInputStream(new File(name + "_" + l + extension)));

            }
            catch (Exception e) {
                pp = new Properties();
                System.out.println("not found: " + l);
            }

            map.put(l, pp);

        }

        return (Properties) map.get(l);

    }

    public String toString() {

        return "Risk Language Plugin\nBy Yura Mamyrin (yura@yura.net)\nRisk site: http://jrisk.sf.net/";

    }

    public void saveMessage(MyNode node, PartnerNode part, Locale l, String message) throws Exception {

        Properties p = getLocaleProperties(l);

        if (message == null) {

            p.remove(node.getName());

        }
        else {

            p.setProperty(node.getName(), message);

        }

        FileOutputStream fos = new FileOutputStream(name + ((l == null) ? ("") : ("_" + l)) + extension);

        // java 1.4 fucks this up, so cant have more then 1 line
        store(p, fos, "yura.net Translation Tool " + MessageTool.version); // +"\nSaved with "+toString() );

    }

    public Locale[] getLocales() {

        Locale[] a = Locale.getAvailableLocales();
        Arrays.sort(a, MessageTool.CASE_POSTERIORITY_ORDER);
        return a;

    }

    public Result[] search(String s) throws Exception {

        Locale[] mylocs = Locale.getAvailableLocales();

        Vector results = new Vector();

        if (s!=null) {
            s = s.toLowerCase();
            findString(null, props, s, results);
            for (int c = 0; c < mylocs.length; c++) {
                findString(mylocs[c], getLocaleProperties(mylocs[c]), s, results);
            }
        }
        else {
            Enumeration it = props.keys();
            while (it.hasMoreElements()) {
                String key = (String)it.nextElement();
                for (int c = 0; c < mylocs.length; c++) {
                    Properties p = getLocaleProperties(mylocs[c]);
                    if (p.size()!=0 && p.get(key)==null) {
                        Result res = new Result();
                        res.node = key;
                        res.locale = mylocs[c];
                        results.add(res);
                    }
                }
            }
        }

        return (Result[]) results.toArray(new Result[results.size()]);

    }

    private void findString(Locale l, Properties p, String s, Vector r) {

        Iterator it = p.entrySet().iterator();

        while (it.hasNext()) {

            java.util.Map.Entry me = (java.util.Map.Entry) it.next();

            String key = (String) me.getKey();
            String value = (String) me.getValue();

            if (value.toLowerCase().indexOf(s) > -1) {

                Result res = new Result();
                res.node = key;
                res.locale = l;
                r.add(res);

            }
        }
    }

    public void setupMissingTranslation(MyNode node, Locale l) throws Exception {

        String realname = node.getName();
        String name = node.getName();

        if (name.length() > 0) {
            name = name + ".";
        }

        Enumeration en = props.keys();

        Properties props2 = getLocaleProperties(l);

        while (en.hasMoreElements()) {

            String key = (String) en.nextElement();

            if (key.equals(realname) || key.startsWith(name)) {

                if (!props2.containsKey(key)) {

                    node.setWorkNeeded(true);
                    return;
                }

            }

        }

        node.setWorkNeeded(false);

    }

    public PartnerNode[] getPartners() throws Exception {
        return new PartnerNode[]{new PartnerNode(0, "DEFAULT", null)};
    }
}
