package net.yura.translation.plugins;

import java.awt.Component;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.Socket;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Locale;
import java.util.Vector;
import javax.crypto.Cipher;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import net.yura.translation.Mtcomm;
import net.yura.translation.MyNode;
import net.yura.translation.PartnerNode;
import net.yura.translation.Result;

/**
 * @author Yura Mamyrin
 */
public class NetComm implements Mtcomm {
    
    private Socket socket;
    private ObjectOutputStream out;
    private ObjectInputStream in;
    
    public boolean load() throws Exception {

            String auth = getLogin(null, getAuth("") );

            if (auth!=null) {
                
                saveAuth(auth);

                load(auth);

                return true;
            }
            return false;
	}
    
        public void load(String auth) throws Exception {
            
                String port = getPort(auth);
                int portInt = ("".equals(port))?8096:Integer.parseInt(port);

		socket = new Socket( getServer(auth) ,portInt );
		out = new ObjectOutputStream(socket.getOutputStream());
		in = new ObjectInputStream(socket.getInputStream());

		PublicKey pubk = (PublicKey)in.readObject();

		Cipher cipher = Cipher.getInstance("RSA");

		cipher.init(Cipher.ENCRYPT_MODE, pubk);

		byte[] name = cipher.doFinal( getUsername(auth).getBytes() );
		byte[] pass = cipher.doFinal( getPassword(auth).getBytes() );

		Object[] messages = new Object[4];
		messages[0] = name;
		messages[1] = pass;
		messages[2] = "1";
		messages[3] = getRemoteClass().getName(); // class of what to load on the other end

		System.out.println( callMethod("Hello",messages) );
            
        }

        public Class getRemoteClass() {
            return TestComm.class;
        }
        public void saveAuth(String auth) {
            // nothing
        }
        public String getAuth(String defaultAuth) {
            return defaultAuth;
        }
    
	public PartnerNode[] getPartners() throws Exception {

		return (PartnerNode[])callMethod("getPartners",new Object[0]);

	}

	public Locale[] getLocales() throws Exception {

		return (Locale[])callMethod("getLocales",new Object[0]);

	}


	public Result[] search(String s) throws Exception {

		Object[] messages = new Object[1];
		messages[0] = s;

		return (Result[])callMethod("search",messages);

	}

	public String getMessage(MyNode node, PartnerNode partner, Locale l) throws Exception {

		Object[] messages = new Object[3];
		messages[0] = node.getName();
		messages[1] = partner;
		messages[2] = l;

		return (String)callMethod("getMessage",messages);
                
        }
                    
	public void addChildren(MyNode node) throws Exception {

		Object[] messages = new Object[1];
		messages[0] = node.getName();

		Vector nodes = (Vector)callMethod("getChildren",messages);

		Iterator i = nodes.iterator();

		while(i.hasNext()) {
                    TheNode newNode = (TheNode)i.next();
                    node.add( new MyNode(newNode.name, newNode.hasmessage, newNode.haschildren) );
		}
		
	}

	public void saveMessage(MyNode node, PartnerNode partner, Locale l, String message) throws Exception {

		Object[] messages = new Object[4];
		messages[0] = node.getName();
		messages[1] = partner;
		messages[2] = l;
		messages[3] = message;

		callMethod("saveMessage",messages);

	}



	public void setupMissingTranslation(MyNode node, Locale l) throws Exception {
            
		Object[] messages = new Object[2];
		messages[0] = node.getName();
		messages[1] = l;

		Boolean bool = (Boolean)callMethod("getMissingTranslation",messages);
            
                node.setWorkNeeded(bool.booleanValue());
        }

    

	public synchronized Object callMethod(String name,Object[] a) throws Exception {
            
                TheMethod method = new TheMethod();
                method.name = name;
                method.params = a;
            
		out.writeObject( method );
		Object o = in.readObject();
		if (o instanceof Exception) {
			throw (Exception)o;
		}
		return o;

	}
    
    
    
    public static class TheNode implements Serializable {
        public String name;
	public boolean hasmessage;
        public boolean haschildren;
    }
    public static class TheMethod implements Serializable {
        public String name;
        public Object[] params;
        public String toString() {
            return name+" "+(params==null?"no params":String.valueOf(Arrays.asList(params)));
        }
    }
    
    
    
    
    
    
    static String getUsername(String auth) {
        int at = auth.lastIndexOf('@');
        if (at >=0 ) {
            String first = auth.substring(0, at);
            int colon = first.indexOf(':');
            if (colon >=0 ) {
                return first.substring(0,colon);
            }
            return first;
        }
        return "";
    }
    static String getPassword(String auth) {
        int at = auth.lastIndexOf('@');
        if (at >=0 ) {
            String first = auth.substring(0, at);
            int colon = first.indexOf(':');
            if (colon >=0 ) {
                return first.substring(colon+1);
            }
            return "";
        }
        return "";
    }
    static String getServer(String auth) {
        int at = auth.lastIndexOf('@');
        String first = (at>=0)?auth.substring(at+1):auth;
        int colon = first.lastIndexOf(':');
        if (colon >=0 ) {
            return first.substring(0,colon);
        }
        return first;
    }
    static String getPort(String auth) {
        int at = auth.lastIndexOf('@');
        String first = (at>=0)?auth.substring(at+1):auth;
        int colon = first.lastIndexOf(':');
        if (colon >=0 ) {
            return first.substring(colon+1);
        }
        return "";
    }
    
    public static String getLogin(Component parentComponent,String auth) {

	Object[] message = new Object[6];
	message[0] = "server name:";
        String port = getPort(auth);
	message[1] = new JTextField( getServer(auth)+("".equals(port)?"":":"+port) );
	message[2] = "user name:";
	message[3] = new JTextField( getUsername(auth) );
	message[4] = "password:";
	message[5] = new JPasswordField( getPassword(auth) );

	String[] options = {
	    "OK", 
	    "cancel"
	}; 

	int result = JOptionPane.showOptionDialog( 
	    parentComponent,                             // the parent that the dialog blocks 
	    message,                                    // the dialog message array 
	    "login to server", // the title of the dialog window 
	    JOptionPane.OK_CANCEL_OPTION,                 // option type 
	    JOptionPane.QUESTION_MESSAGE,            // message type 
	    null,                                       // optional icon, use null to use the default icon 
	    options,                                    // options string array, will be made into buttons 
	    options[0]                                  // option that should be made into a default button 
	);

	if (result == JOptionPane.OK_OPTION ) {
            String username = ((JTextField)message[3]).getText();
            String password = new String( ((JPasswordField)message[5]).getPassword() );
            return username+("".equals(password)?"":":"+password)+(("".equals(username)&&"".equals(password))?"":"@")+((JTextField)message[1]).getText();
	}

	return null;

    }
}
