package net.yura.translation;

import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import java.util.Collections;
import java.io.Serializable;
import java.util.Comparator;

public class PartnerNode extends DefaultMutableTreeNode implements Serializable {

        private int partnerId;
        private String parentWebKey;
	private boolean selected;

        public PartnerNode( int partnerId, String webKey, String parentWebKey ) {

		super(webKey);

            this.partnerId = partnerId;
            this.parentWebKey = parentWebKey;
        }
        
        public int getPartnerId()
        {
            return partnerId;
        }
        public String getWebKey()
        {
            return (String)getUserObject();
        }
        public String getParentWebKey()
        {
            return parentWebKey;
        }

	public boolean isSelected() {
		return selected;
	}

	public void setSelected(boolean isSelected) {

		selected = isSelected;

	}

	public static final Comparator CASE_INSENSITIVE_ORDER = new Comparator() {

		public int compare(Object o1, Object o2) {

			return o1.toString().compareToIgnoreCase(o2.toString());

		}

	};

	public void add(MutableTreeNode newChild) {

		if (this.children!=null && this.children.contains(newChild)) { return; }

		super.add(newChild);
		Collections.sort(this.children,CASE_INSENSITIVE_ORDER);

	}

}
