package net.yura.swing;

import net.yura.swing.Collapsible;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.BorderLayout;

import javax.swing.Box;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.plaf.metal.MetalIconFactory;
import javax.swing.ImageIcon;

/**
 * This is an implementation of the grendel.widgets.Collapsible interface,
 * which provides the standard Communicator-style collapsing toolbar panel.
 *
 * @author Jeff Galyan
 * @author R.J. Keller
 * @see Collapsible
 */
public class CollapsiblePanel extends JPanel implements Collapsible,ActionListener {

  private JButton collapseButton;
  private boolean collapsed = false;
  private Component curComponent;

  /**
   * Constructor
   */
  public CollapsiblePanel(Component comp,String text) {
    super();

    setLayout(new BorderLayout());
    collapsed = true;



    curComponent = comp;

    removeAll();

    collapseButton = new JButton(text);

    collapseButton.setRolloverEnabled(true);
    collapseButton.setFocusPainted(false);
    collapseButton.setDefaultCapable(false);
    collapseButton.setBorder(null);
    collapseButton.setBorderPainted(false);
    collapseButton.setMargin(new Insets(0,0,0,0));
    collapseButton.setToolTipText("Collapses/Expands the ToolBar");
    collapseButton.addActionListener(this);


    add(collapseButton, BorderLayout.NORTH);
    Dimension dim = collapseButton.getSize();
    collapseButton.setBounds(0,0,dim.width,dim.height);

    //set the new components background to the panel background.
    setBackground(comp.getBackground());

    //add(comp, BorderLayout.CENTER);

    revalidate();



  }



  public Component getComponent() {
    return curComponent;
  }

  /**
   * Collapses the panel.
   */
  public void collapse() {
    removeAll();
    add(collapseButton, BorderLayout.NORTH);
    Dimension dim2 = getSize();
    setSize(new Dimension(dim2.width, 5));

    remove(curComponent);

    revalidate();

    collapsed = true;
  }

  /**
   * Uncollapses the panel.
   */
  public void expand() {
    removeAll();

    add(collapseButton, BorderLayout.NORTH);
    add(curComponent, BorderLayout.CENTER);

    revalidate();

    collapsed = false;
  }

  /**
   * Tells you whether this component is currently collapsed.
   * Useful for checking the component's status.
   * @returns true if this component is collapsed, false if it is not.
   */
  public boolean isCollapsed() {
    return collapsed;
  }


  public void actionPerformed(ActionEvent evt) {
      if (isCollapsed() == true) {
	expand();
      } else {
	collapse();
      }
  }


}